/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.grpc.InternalMetadata;
import com.appoptics.ext.io.grpc.InternalStatus;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.AbstractClientStream;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.appoptics.ext.io.grpc.internal.ReadableBuffer;
import com.appoptics.ext.io.grpc.internal.ReadableBuffers;
import com.appoptics.ext.io.grpc.internal.StatsTraceContext;
import com.appoptics.ext.io.grpc.internal.TransportTracer;
import com.tracelytics.a.d.a.a.b;
import java.nio.charset.Charset;

public abstract class Http2ClientStreamTransportState
extends AbstractClientStream.TransportState {
    private static final InternalMetadata.TrustedAsciiMarshaller<Integer> HTTP_STATUS_MARSHALLER = new InternalMetadata.TrustedAsciiMarshaller<Integer>(){

        @Override
        public byte[] toAsciiString(Integer n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer parseAsciiString(byte[] byArray) {
            if (byArray.length >= 3) {
                return (byArray[0] - 48) * 100 + (byArray[1] - 48) * 10 + (byArray[2] - 48);
            }
            throw new NumberFormatException("Malformed status code " + new String(byArray, InternalMetadata.US_ASCII));
        }
    };
    private static final Metadata.Key<Integer> HTTP2_STATUS = InternalMetadata.keyOf(":status", HTTP_STATUS_MARSHALLER);
    private Status transportError;
    private Metadata transportErrorMetadata;
    private Charset errorCharset = b.b;
    private boolean headersReceived;

    protected Http2ClientStreamTransportState(int n2, StatsTraceContext statsTraceContext, TransportTracer transportTracer) {
        super(n2, statsTraceContext, transportTracer);
    }

    protected abstract void http2ProcessingFailed(Status var1, boolean var2, Metadata var3);

    protected void transportHeadersReceived(Metadata metadata) {
        block13: {
            block11: {
                block12: {
                    block9: {
                        block10: {
                            block7: {
                                block8: {
                                    com.appoptics.ext.io.a.b.a(metadata, (Object)"headers");
                                    if (this.transportError != null) {
                                        this.transportError = this.transportError.augmentDescription("headers: " + metadata);
                                        return;
                                    }
                                    try {
                                        if (!this.headersReceived) break block7;
                                        this.transportError = Status.INTERNAL.withDescription("Received headers twice");
                                        if (this.transportError == null) break block8;
                                        this.transportError = this.transportError.augmentDescription("headers: " + metadata);
                                        this.transportErrorMetadata = metadata;
                                    }
                                    catch (Throwable throwable) {
                                        if (this.transportError != null) {
                                            this.transportError = this.transportError.augmentDescription("headers: " + metadata);
                                            this.transportErrorMetadata = metadata;
                                            this.errorCharset = Http2ClientStreamTransportState.extractCharset(metadata);
                                        }
                                        throw throwable;
                                    }
                                    this.errorCharset = Http2ClientStreamTransportState.extractCharset(metadata);
                                }
                                return;
                            }
                            Integer n2 = metadata.get(HTTP2_STATUS);
                            if (n2 == null || n2 < 100 || n2 >= 200) break block9;
                            if (this.transportError == null) break block10;
                            this.transportError = this.transportError.augmentDescription("headers: " + metadata);
                            this.transportErrorMetadata = metadata;
                            this.errorCharset = Http2ClientStreamTransportState.extractCharset(metadata);
                        }
                        return;
                    }
                    this.headersReceived = true;
                    this.transportError = this.validateInitialMetadata(metadata);
                    if (this.transportError == null) break block11;
                    if (this.transportError == null) break block12;
                    this.transportError = this.transportError.augmentDescription("headers: " + metadata);
                    this.transportErrorMetadata = metadata;
                    this.errorCharset = Http2ClientStreamTransportState.extractCharset(metadata);
                }
                return;
            }
            Http2ClientStreamTransportState.stripTransportDetails(metadata);
            this.inboundHeadersReceived(metadata);
            if (this.transportError == null) break block13;
            this.transportError = this.transportError.augmentDescription("headers: " + metadata);
            this.transportErrorMetadata = metadata;
            this.errorCharset = Http2ClientStreamTransportState.extractCharset(metadata);
            return;
        }
    }

    protected void transportDataReceived(ReadableBuffer readableBuffer, boolean bl) {
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription("DATA-----------------------------\n" + ReadableBuffers.readAsString(readableBuffer, this.errorCharset));
            readableBuffer.close();
            if (this.transportError.getDescription().length() > 1000 || bl) {
                Http2ClientStreamTransportState http2ClientStreamTransportState = this;
                http2ClientStreamTransportState.http2ProcessingFailed(http2ClientStreamTransportState.transportError, false, this.transportErrorMetadata);
                return;
            }
        } else {
            if (!this.headersReceived) {
                this.http2ProcessingFailed(Status.INTERNAL.withDescription("headers not received before payload"), false, new Metadata());
                return;
            }
            this.inboundDataReceived(readableBuffer);
            if (bl) {
                this.transportError = Status.INTERNAL.withDescription("Received unexpected EOS on DATA frame from server.");
                this.transportErrorMetadata = new Metadata();
                Http2ClientStreamTransportState http2ClientStreamTransportState = this;
                http2ClientStreamTransportState.transportReportStatus(http2ClientStreamTransportState.transportError, false, this.transportErrorMetadata);
            }
        }
    }

    protected void transportTrailersReceived(Metadata metadata) {
        com.appoptics.ext.io.a.b.a(metadata, (Object)"trailers");
        if (this.transportError == null && !this.headersReceived) {
            this.transportError = this.validateInitialMetadata(metadata);
            if (this.transportError != null) {
                this.transportErrorMetadata = metadata;
            }
        }
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription("trailers: " + metadata);
            Http2ClientStreamTransportState http2ClientStreamTransportState = this;
            http2ClientStreamTransportState.http2ProcessingFailed(http2ClientStreamTransportState.transportError, false, this.transportErrorMetadata);
            return;
        }
        Status status = this.statusFromTrailers(metadata);
        Http2ClientStreamTransportState.stripTransportDetails(metadata);
        this.inboundTrailersReceived(metadata, status);
    }

    private Status statusFromTrailers(Metadata object) {
        Status status = ((Metadata)object).get(InternalStatus.CODE_KEY);
        if (status != null) {
            return status.withDescription(((Metadata)object).get(InternalStatus.MESSAGE_KEY));
        }
        if (this.headersReceived) {
            return Status.UNKNOWN.withDescription("missing GRPC status in response");
        }
        status = (object = ((Metadata)object).get(HTTP2_STATUS)) != null ? GrpcUtil.httpStatusToGrpcStatus((Integer)object) : Status.INTERNAL.withDescription("missing HTTP status code");
        return status.augmentDescription("missing GRPC status, inferred error from HTTP status code");
    }

    private Status validateInitialMetadata(Metadata object) {
        Integer n2 = ((Metadata)object).get(HTTP2_STATUS);
        if (n2 == null) {
            return Status.INTERNAL.withDescription("Missing HTTP status code");
        }
        if (!GrpcUtil.isGrpcContentType((String)(object = ((Metadata)object).get(GrpcUtil.CONTENT_TYPE_KEY)))) {
            return GrpcUtil.httpStatusToGrpcStatus(n2).augmentDescription("invalid content-type: " + (String)object);
        }
        return null;
    }

    private static Charset extractCharset(Metadata stringArray) {
        if ((stringArray = stringArray.get(GrpcUtil.CONTENT_TYPE_KEY)) != null) {
            stringArray = stringArray.split("charset=", 2);
            try {
                return Charset.forName(stringArray[stringArray.length - 1].trim());
            }
            catch (Exception exception) {}
        }
        return b.b;
    }

    private static void stripTransportDetails(Metadata metadata) {
        metadata.discardAll(HTTP2_STATUS);
        metadata.discardAll(InternalStatus.CODE_KEY);
        metadata.discardAll(InternalStatus.MESSAGE_KEY);
    }
}

