/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.CallOptions;
import com.appoptics.ext.io.grpc.ClientStreamTracer;
import com.appoptics.ext.io.grpc.InternalLogId;
import com.appoptics.ext.io.grpc.InternalMetadata;
import com.appoptics.ext.io.grpc.LoadBalancer;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.MethodDescriptor;
import com.appoptics.ext.io.grpc.ProxiedSocketAddress;
import com.appoptics.ext.io.grpc.ProxyDetector;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.ClientStream;
import com.appoptics.ext.io.grpc.internal.ClientStreamListener;
import com.appoptics.ext.io.grpc.internal.ClientTransport;
import com.appoptics.ext.io.grpc.internal.FailingClientTransport;
import com.appoptics.ext.io.grpc.internal.ProxyDetectorImpl;
import com.appoptics.ext.io.grpc.internal.SharedResourceHolder;
import com.appoptics.ext.io.grpc.internal.StreamListener;
import com.appoptics.ext.io.grpc.internal.TransportProvider;
import com.tracelytics.a.d.a.a.a;
import com.tracelytics.a.d.a.a.k;
import com.tracelytics.a.d.a.a.l;
import com.tracelytics.a.d.a.g.a.m;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GrpcUtil {
    private static final Logger log = Logger.getLogger(GrpcUtil.class.getName());
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Metadata.Key<Long> TIMEOUT_KEY = Metadata.Key.of("grpc-timeout", new TimeoutMarshaller());
    public static final Metadata.Key<String> MESSAGE_ENCODING_KEY = Metadata.Key.of("grpc-encoding", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<byte[]> MESSAGE_ACCEPT_ENCODING_KEY = InternalMetadata.keyOf("grpc-accept-encoding", new AcceptEncodingMarshaller());
    public static final Metadata.Key<String> CONTENT_ENCODING_KEY = Metadata.Key.of("content-encoding", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<byte[]> CONTENT_ACCEPT_ENCODING_KEY = InternalMetadata.keyOf("accept-encoding", new AcceptEncodingMarshaller());
    public static final Metadata.Key<String> CONTENT_TYPE_KEY = Metadata.Key.of("content-type", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> TE_HEADER = Metadata.Key.of("te", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> USER_AGENT_KEY = Metadata.Key.of("user-agent", Metadata.ASCII_STRING_MARSHALLER);
    public static final k ACCEPT_ENCODING_SPLITTER;
    public static final long DEFAULT_KEEPALIVE_TIMEOUT_NANOS;
    public static final long DEFAULT_SERVER_KEEPALIVE_TIME_NANOS;
    public static final long DEFAULT_SERVER_KEEPALIVE_TIMEOUT_NANOS;
    public static final ProxyDetector DEFAULT_PROXY_DETECTOR;
    public static final ProxyDetector NOOP_PROXY_DETECTOR;
    public static final CallOptions.Key<Boolean> CALL_OPTIONS_RPC_OWNED_BY_BALANCER;
    public static final SharedResourceHolder.Resource<Executor> SHARED_CHANNEL_EXECUTOR;
    public static final SharedResourceHolder.Resource<ScheduledExecutorService> TIMER_SERVICE;
    public static final com.tracelytics.a.d.a.a.m<l> STOPWATCH_SUPPLIER;

    public static boolean shouldBeCountedForInUse(CallOptions callOptions) {
        return !Boolean.TRUE.equals(callOptions.getOption(CALL_OPTIONS_RPC_OWNED_BY_BALANCER));
    }

    public static Status httpStatusToGrpcStatus(int n2) {
        return GrpcUtil.httpStatusToGrpcCode(n2).toStatus().withDescription("HTTP status code " + n2);
    }

    private static Status.Code httpStatusToGrpcCode(int n2) {
        if (n2 >= 100 && n2 < 200) {
            return Status.Code.INTERNAL;
        }
        switch (n2) {
            case 400: 
            case 431: {
                return Status.Code.INTERNAL;
            }
            case 401: {
                return Status.Code.UNAUTHENTICATED;
            }
            case 403: {
                return Status.Code.PERMISSION_DENIED;
            }
            case 404: {
                return Status.Code.UNIMPLEMENTED;
            }
            case 429: 
            case 502: 
            case 503: 
            case 504: {
                return Status.Code.UNAVAILABLE;
            }
        }
        return Status.Code.UNKNOWN;
    }

    public static boolean isGrpcContentType(String string) {
        if (string == null) {
            return false;
        }
        if (16 > string.length()) {
            return false;
        }
        if (!(string = string.toLowerCase()).startsWith("application/grpc")) {
            return false;
        }
        if (string.length() == 16) {
            return true;
        }
        char c2 = string.charAt(16);
        return c2 == '+' || c2 == ';';
    }

    public static String getGrpcUserAgent(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append(string2);
            stringBuilder.append(' ');
        }
        stringBuilder.append("grpc-java-");
        stringBuilder.append(string);
        stringBuilder.append('/');
        stringBuilder.append("1.34.1");
        return stringBuilder.toString();
    }

    public static URI authorityToUri(String string) {
        URI uRI;
        b.a(string, (Object)"authority");
        try {
            uRI = new URI(null, string, null, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid authority: " + string, uRISyntaxException);
        }
        return uRI;
    }

    public static String authorityFromHostAndPort(String string, int n2) {
        try {
            return new URI(null, null, string, n2, null, null, null).getAuthority();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid host or port: " + string + " " + n2, uRISyntaxException);
        }
    }

    public static ThreadFactory getThreadFactory(String string, boolean bl) {
        return new m().a(bl).a(string).a();
    }

    public static String getHost(InetSocketAddress inetSocketAddress) {
        try {
            Method method = InetSocketAddress.class.getMethod("getHostString", new Class[0]);
            return (String)method.invoke((Object)inetSocketAddress, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return inetSocketAddress.getHostName();
    }

    static ClientTransport getTransportFromPickResult(LoadBalancer.PickResult object, boolean bl) {
        Object object2 = ((LoadBalancer.PickResult)object).getSubchannel();
        object2 = object2 != null ? ((TransportProvider)((LoadBalancer.Subchannel)object2).getInternalSubchannel()).obtainActiveTransport() : null;
        if (object2 != null) {
            if ((object = ((LoadBalancer.PickResult)object).getStreamTracerFactory()) == null) {
                return object2;
            }
            return new ClientTransport((ClientTransport)object2, (ClientStreamTracer.Factory)object){
                final /* synthetic */ ClientTransport val$transport;
                final /* synthetic */ ClientStreamTracer.Factory val$streamTracerFactory;
                {
                    this.val$transport = clientTransport;
                    this.val$streamTracerFactory = factory;
                }

                @Override
                public ClientStream newStream(MethodDescriptor<?, ?> methodDescriptor, Metadata metadata, CallOptions callOptions) {
                    return this.val$transport.newStream(methodDescriptor, metadata, callOptions.withStreamTracerFactory(this.val$streamTracerFactory));
                }

                @Override
                public void ping(ClientTransport.PingCallback pingCallback, Executor executor) {
                    this.val$transport.ping(pingCallback, executor);
                }

                @Override
                public InternalLogId getLogId() {
                    return this.val$transport.getLogId();
                }
            };
        }
        if (!((LoadBalancer.PickResult)object).getStatus().isOk()) {
            if (((LoadBalancer.PickResult)object).isDrop()) {
                return new FailingClientTransport(((LoadBalancer.PickResult)object).getStatus(), ClientStreamListener.RpcProgress.DROPPED);
            }
            if (!bl) {
                return new FailingClientTransport(((LoadBalancer.PickResult)object).getStatus(), ClientStreamListener.RpcProgress.PROCESSED);
            }
        }
        return null;
    }

    static void closeQuietly(StreamListener.MessageProducer messageProducer) {
        InputStream inputStream;
        while ((inputStream = messageProducer.next()) != null) {
            GrpcUtil.closeQuietly(inputStream);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, "exception caught in closeQuietly", iOException);
            return;
        }
    }

    private GrpcUtil() {
    }

    static {
        int n2 = 44;
        k k2 = k.a(a.a(','));
        ACCEPT_ENCODING_SPLITTER = k2.b(a.a());
        DEFAULT_KEEPALIVE_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(20L);
        DEFAULT_SERVER_KEEPALIVE_TIME_NANOS = TimeUnit.HOURS.toNanos(2L);
        DEFAULT_SERVER_KEEPALIVE_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(20L);
        DEFAULT_PROXY_DETECTOR = new ProxyDetectorImpl();
        NOOP_PROXY_DETECTOR = new ProxyDetector(){

            public ProxiedSocketAddress proxyFor(SocketAddress socketAddress) {
                return null;
            }
        };
        CALL_OPTIONS_RPC_OWNED_BY_BALANCER = CallOptions.Key.create("com.appoptics.ext.io.grpc.internal.CALL_OPTIONS_RPC_OWNED_BY_BALANCER");
        SHARED_CHANNEL_EXECUTOR = new SharedResourceHolder.Resource<Executor>(){

            @Override
            public Executor create() {
                return Executors.newCachedThreadPool(GrpcUtil.getThreadFactory("grpc-default-executor-%d", true));
            }

            @Override
            public void close(Executor executor) {
                ((ExecutorService)executor).shutdown();
            }

            public String toString() {
                return "grpc-default-executor";
            }
        };
        TIMER_SERVICE = new SharedResourceHolder.Resource<ScheduledExecutorService>(){

            @Override
            public ScheduledExecutorService create() {
                ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, GrpcUtil.getThreadFactory("grpc-timer-%d", true));
                try {
                    Method method = scheduledExecutorService.getClass().getMethod("setRemoveOnCancelPolicy", Boolean.TYPE);
                    method.invoke((Object)scheduledExecutorService, Boolean.TRUE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (RuntimeException runtimeException) {
                    RuntimeException runtimeException2 = runtimeException;
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                return Executors.unconfigurableScheduledExecutorService(scheduledExecutorService);
            }

            @Override
            public void close(ScheduledExecutorService scheduledExecutorService) {
                scheduledExecutorService.shutdown();
            }
        };
        STOPWATCH_SUPPLIER = new com.tracelytics.a.d.a.a.m<l>(){

            @Override
            public l get() {
                return l.a();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TimeoutMarshaller
    implements Metadata.AsciiMarshaller<Long> {
        TimeoutMarshaller() {
        }

        @Override
        public String toAsciiString(Long l2) {
            TimeUnit timeUnit = TimeUnit.NANOSECONDS;
            if (l2 < 0L) {
                throw new IllegalArgumentException("Timeout too small");
            }
            if (l2 < 100000000L) {
                return l2 + "n";
            }
            if (l2 < 100000000000L) {
                return timeUnit.toMicros(l2) + "u";
            }
            if (l2 < 100000000000000L) {
                return timeUnit.toMillis(l2) + "m";
            }
            if (l2 < 100000000000000000L) {
                return timeUnit.toSeconds(l2) + "S";
            }
            if (l2 < 6000000000000000000L) {
                return timeUnit.toMinutes(l2) + "M";
            }
            return timeUnit.toHours(l2) + "H";
        }

        @Override
        public Long parseAsciiString(String string) {
            b.a(string.length() > 0, (Object)"empty timeout");
            b.a(string.length() <= 9, (Object)"bad timeout format");
            long l2 = Long.parseLong(string.substring(0, string.length() - 1));
            String string2 = string;
            char c2 = string2.charAt(string2.length() - 1);
            switch (c2) {
                case 'n': {
                    return l2;
                }
                case 'u': {
                    return TimeUnit.MICROSECONDS.toNanos(l2);
                }
                case 'm': {
                    return TimeUnit.MILLISECONDS.toNanos(l2);
                }
                case 'S': {
                    return TimeUnit.SECONDS.toNanos(l2);
                }
                case 'M': {
                    return TimeUnit.MINUTES.toNanos(l2);
                }
                case 'H': {
                    return TimeUnit.HOURS.toNanos(l2);
                }
            }
            throw new IllegalArgumentException(String.format("Invalid timeout unit: %s", Character.valueOf(c2)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Http2Error {
        NO_ERROR(0, Status.UNAVAILABLE),
        PROTOCOL_ERROR(1, Status.INTERNAL),
        INTERNAL_ERROR(2, Status.INTERNAL),
        FLOW_CONTROL_ERROR(3, Status.INTERNAL),
        SETTINGS_TIMEOUT(4, Status.INTERNAL),
        STREAM_CLOSED(5, Status.INTERNAL),
        FRAME_SIZE_ERROR(6, Status.INTERNAL),
        REFUSED_STREAM(7, Status.UNAVAILABLE),
        CANCEL(8, Status.CANCELLED),
        COMPRESSION_ERROR(9, Status.INTERNAL),
        CONNECT_ERROR(10, Status.INTERNAL),
        ENHANCE_YOUR_CALM(11, Status.RESOURCE_EXHAUSTED.withDescription("Bandwidth exhausted")),
        INADEQUATE_SECURITY(12, Status.PERMISSION_DENIED.withDescription("Permission denied as protocol is not secure enough to call")),
        HTTP_1_1_REQUIRED(13, Status.UNKNOWN);

        private static final Http2Error[] codeMap;
        private final int code;
        private final Status status;

        private static Http2Error[] buildHttp2CodeMap() {
            Http2Error[] http2ErrorArray = Http2Error.values();
            int n2 = (int)http2ErrorArray[http2ErrorArray.length - 1].code() + 1;
            Http2Error[] http2ErrorArray2 = new Http2Error[n2];
            for (Http2Error http2Error : http2ErrorArray) {
                int n3 = (int)http2Error.code();
                http2ErrorArray2[n3] = http2Error;
            }
            return http2ErrorArray2;
        }

        private Http2Error(int n3, Status status) {
            this.code = n3;
            string = "HTTP/2 error code: " + this.name();
            if (status.getDescription() != null) {
                string = string + " (" + status.getDescription() + ")";
            }
            this.status = status.withDescription(string);
        }

        public final long code() {
            return this.code;
        }

        public final Status status() {
            return this.status;
        }

        public static Http2Error forCode(long l2) {
            if (l2 >= (long)codeMap.length || l2 < 0L) {
                return null;
            }
            return codeMap[(int)l2];
        }

        public static Status statusForCode(long l2) {
            Enum enum_ = Http2Error.forCode(l2);
            if (enum_ == null) {
                enum_ = INTERNAL_ERROR.status().getCode();
                return Status.fromCodeValue(((Status.Code)enum_).value()).withDescription("Unrecognized HTTP/2 error code: " + l2);
            }
            return ((Http2Error)enum_).status();
        }

        static {
            codeMap = Http2Error.buildHttp2CodeMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AcceptEncodingMarshaller
    implements InternalMetadata.TrustedAsciiMarshaller<byte[]> {
        private AcceptEncodingMarshaller() {
        }

        @Override
        public final byte[] toAsciiString(byte[] byArray) {
            return byArray;
        }

        @Override
        public final byte[] parseAsciiString(byte[] byArray) {
            return byArray;
        }
    }
}

