/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.EquivalentAddressGroup;
import com.appoptics.ext.io.grpc.NameResolver;
import com.appoptics.ext.io.grpc.ProxyDetector;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.SynchronizationContext;
import com.appoptics.ext.io.grpc.internal.JsonParser;
import com.appoptics.ext.io.grpc.internal.JsonUtil;
import com.appoptics.ext.io.grpc.internal.SharedResourceHolder;
import com.tracelytics.a.d.a.a.l;
import com.tracelytics.a.d.a.a.o;
import com.tracelytics.a.d.a.a.q;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnsNameResolver
extends NameResolver {
    private static final Logger logger = Logger.getLogger(DnsNameResolver.class.getName());
    private static final Set<String> SERVICE_CONFIG_CHOICE_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("clientLanguage", "percentage", "clientHostname", "serviceConfig")));
    private static final String JNDI_PROPERTY = System.getProperty("com.appoptics.ext.io.grpc.internal.DnsNameResolverProvider.enable_jndi", "true");
    private static final String JNDI_LOCALHOST_PROPERTY = System.getProperty("com.appoptics.ext.io.grpc.internal.DnsNameResolverProvider.enable_jndi_localhost", "false");
    private static final String JNDI_TXT_PROPERTY = System.getProperty("com.appoptics.ext.io.grpc.internal.DnsNameResolverProvider.enable_service_config", "false");
    static boolean enableJndi = Boolean.parseBoolean(JNDI_PROPERTY);
    static boolean enableJndiLocalhost = Boolean.parseBoolean(JNDI_LOCALHOST_PROPERTY);
    protected static boolean enableTxt = Boolean.parseBoolean(JNDI_TXT_PROPERTY);
    private static final ResourceResolverFactory resourceResolverFactory = DnsNameResolver.getResourceResolverFactory(DnsNameResolver.class.getClassLoader());
    final ProxyDetector proxyDetector;
    private static String localHostname;
    private final Random random = new Random();
    protected volatile AddressResolver addressResolver = JdkAddressResolver.INSTANCE;
    private final AtomicReference<ResourceResolver> resourceResolver = new AtomicReference();
    private final String authority;
    private final String host;
    private final int port;
    private final SharedResourceHolder.Resource<Executor> executorResource;
    private final long cacheTtlNanos;
    private final SynchronizationContext syncContext;
    private final l stopwatch;
    protected boolean resolved;
    private boolean shutdown;
    private Executor executor;
    private final boolean usingExecutorResource;
    private final NameResolver.ServiceConfigParser serviceConfigParser;
    private boolean resolving;
    private NameResolver.Listener2 listener;

    protected DnsNameResolver(String object, String string, NameResolver.Args args, SharedResourceHolder.Resource<Executor> resource, l l2, boolean bl) {
        b.a(args, (Object)"args");
        this.executorResource = resource;
        object = URI.create("//" + b.a(string, (Object)"name"));
        b.a(((URI)object).getHost() != null, "Invalid DNS name: %s", (Object)string);
        this.authority = b.a(((URI)object).getAuthority(), "nameUri (%s) doesn't have an authority", object);
        this.host = ((URI)object).getHost();
        this.port = ((URI)object).getPort() == -1 ? args.getDefaultPort() : ((URI)object).getPort();
        this.proxyDetector = b.a(args.getProxyDetector(), (Object)"proxyDetector");
        this.cacheTtlNanos = DnsNameResolver.getNetworkAddressCacheTtlNanos(bl);
        this.stopwatch = b.a(l2, (Object)"stopwatch");
        this.syncContext = b.a(args.getSynchronizationContext(), (Object)"syncContext");
        this.executor = args.getOffloadExecutor();
        this.usingExecutorResource = this.executor == null;
        this.serviceConfigParser = b.a(args.getServiceConfigParser(), (Object)"serviceConfigParser");
    }

    @Override
    public String getServiceAuthority() {
        return this.authority;
    }

    @Override
    public void start(NameResolver.Listener2 listener2) {
        b.b(this.listener == null, "already started");
        if (this.usingExecutorResource) {
            this.executor = SharedResourceHolder.get(this.executorResource);
        }
        this.listener = b.a(listener2, (Object)"listener");
        this.resolve();
    }

    @Override
    public void refresh() {
        b.b(this.listener != null, "not started");
        this.resolve();
    }

    private List<EquivalentAddressGroup> resolveAddresses() {
        Object object;
        Serializable serializable = null;
        try {
            try {
                object = this.addressResolver.resolveAddress(this.host);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                serializable = exception;
                o.a(exception2);
                throw new RuntimeException(exception2);
            }
        }
        catch (Throwable throwable) {
            if (serializable != null) {
                logger.log(Level.FINE, "Address resolution failure", (Throwable)serializable);
            }
            throw throwable;
        }
        ArrayList<EquivalentAddressGroup> arrayList = new ArrayList<EquivalentAddressGroup>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            serializable = (InetAddress)object.next();
            arrayList.add(new EquivalentAddressGroup(new InetSocketAddress((InetAddress)serializable, this.port)));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private NameResolver.ConfigOrError resolveServiceConfig() {
        Object object = Collections.emptyList();
        Object object2 = this.getResourceResolver();
        if (object2 != null) {
            try {
                object = object2.resolveTxt("_grpc_config." + this.host);
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "ServiceConfig resolution failure", exception);
            }
        }
        if (!object.isEmpty()) {
            object2 = DnsNameResolver.parseServiceConfig(object, this.random, DnsNameResolver.getLocalHostname());
            if (object2 != null) {
                if (((NameResolver.ConfigOrError)object2).getError() != null) {
                    return NameResolver.ConfigOrError.fromError(((NameResolver.ConfigOrError)object2).getError());
                }
                object = (Map)((NameResolver.ConfigOrError)object2).getConfig();
                return this.serviceConfigParser.parseServiceConfig((Map<String, ?>)object);
            }
        } else {
            logger.log(Level.FINE, "No TXT records found for {0}", new Object[]{this.host});
        }
        return null;
    }

    private EquivalentAddressGroup detectProxy() throws IOException {
        SocketAddress socketAddress = InetSocketAddress.createUnresolved(this.host, this.port);
        if ((socketAddress = this.proxyDetector.proxyFor(socketAddress)) != null) {
            return new EquivalentAddressGroup(socketAddress);
        }
        return null;
    }

    protected InternalResolutionResult doResolve(boolean bl) {
        InternalResolutionResult internalResolutionResult;
        block3: {
            internalResolutionResult = new InternalResolutionResult();
            try {
                internalResolutionResult.addresses = this.resolveAddresses();
            }
            catch (Exception exception) {
                if (bl) break block3;
                internalResolutionResult.error = Status.UNAVAILABLE.withDescription("Unable to resolve host " + this.host).withCause(exception);
                return internalResolutionResult;
            }
        }
        if (enableTxt) {
            internalResolutionResult.config = this.resolveServiceConfig();
        }
        return internalResolutionResult;
    }

    static NameResolver.ConfigOrError parseServiceConfig(List<String> object, Random random, String string) {
        try {
            object = DnsNameResolver.parseTxtResults(object);
        }
        catch (IOException | RuntimeException exception) {
            return NameResolver.ConfigOrError.fromError(Status.UNKNOWN.withDescription("failed to parse TXT records").withCause(exception));
        }
        Map<String, ?> map = null;
        object = object.iterator();
        while (object.hasNext()) {
            map = (Map<String, ?>)object.next();
            try {
                map = DnsNameResolver.maybeChooseServiceConfig(map, random, string);
            }
            catch (RuntimeException runtimeException) {
                return NameResolver.ConfigOrError.fromError(Status.UNKNOWN.withDescription("failed to pick service config choice").withCause(runtimeException));
            }
            if (map == null) continue;
        }
        if (map == null) {
            return null;
        }
        return NameResolver.ConfigOrError.fromConfig(map);
    }

    private void resolve() {
        if (this.resolving || this.shutdown || !this.cacheRefreshRequired()) {
            return;
        }
        this.resolving = true;
        DnsNameResolver dnsNameResolver = this;
        this.executor.execute(dnsNameResolver.new Resolve(dnsNameResolver.listener));
    }

    private boolean cacheRefreshRequired() {
        return !this.resolved || this.cacheTtlNanos == 0L || this.cacheTtlNanos > 0L && this.stopwatch.a(TimeUnit.NANOSECONDS) > this.cacheTtlNanos;
    }

    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.executor != null && this.usingExecutorResource) {
            this.executor = SharedResourceHolder.release(this.executorResource, this.executor);
        }
    }

    static List<Map<String, ?>> parseTxtResults(List<String> object) throws IOException {
        ArrayList arrayList = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            if (!((String)object2).startsWith("grpc_config=")) {
                logger.log(Level.FINE, "Ignoring non service config {0}", new Object[]{object2});
                continue;
            }
            if (!((object2 = JsonParser.parse(((String)object2).substring(12))) instanceof List)) {
                throw new ClassCastException("wrong type " + object2);
            }
            object2 = (List)object2;
            arrayList.addAll(JsonUtil.checkObjectList(object2));
        }
        return arrayList;
    }

    private static final Double getPercentageFromChoice(Map<String, ?> map) {
        return JsonUtil.getNumber(map, "percentage");
    }

    private static final List<String> getClientLanguagesFromChoice(Map<String, ?> map) {
        return JsonUtil.getListOfStrings(map, "clientLanguage");
    }

    private static final List<String> getHostnamesFromChoice(Map<String, ?> map) {
        return JsonUtil.getListOfStrings(map, "clientHostname");
    }

    private static long getNetworkAddressCacheTtlNanos(boolean bl) {
        if (bl) {
            return 0L;
        }
        String string = System.getProperty("networkaddress.cache.ttl");
        long l2 = 30L;
        if (string != null) {
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.WARNING, "Property({0}) valid is not valid number format({1}), fall back to default({2})", new Object[]{"networkaddress.cache.ttl", string, 30L});
            }
        }
        if (l2 > 0L) {
            return TimeUnit.SECONDS.toNanos(l2);
        }
        return l2;
    }

    static Map<String, ?> maybeChooseServiceConfig(Map<String, ?> map, Random object, String string) {
        Object object2;
        Double d2;
        Object object3;
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            b.c(SERVICE_CONFIG_CHOICE_KEYS.contains(entry.getKey()), "Bad key: %s", entry);
        }
        Object object4 = DnsNameResolver.getClientLanguagesFromChoice(map);
        if (object4 != null && !object4.isEmpty()) {
            boolean bl = false;
            object4 = object4.iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                if (!"java".equalsIgnoreCase((String)object3)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return null;
            }
        }
        if ((d2 = DnsNameResolver.getPercentageFromChoice(map)) != null) {
            int n2 = d2.intValue();
            b.c(n2 >= 0 && n2 <= 100, "Bad percentage: %s", d2);
            if (((Random)object).nextInt(100) >= n2) {
                return null;
            }
        }
        if ((object2 = DnsNameResolver.getHostnamesFromChoice(map)) != null && !object2.isEmpty()) {
            boolean bl = false;
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (String)object.next();
                if (!((String)object2).equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return null;
            }
        }
        if ((object3 = JsonUtil.getObject(map, "serviceConfig")) == null) {
            throw new q(String.format("key '%s' missing in '%s'", map, "serviceConfig"));
        }
        return object3;
    }

    protected ResourceResolver getResourceResolver() {
        if (!DnsNameResolver.shouldUseJndi(enableJndi, enableJndiLocalhost, this.host)) {
            return null;
        }
        ResourceResolver resourceResolver = this.resourceResolver.get();
        if (resourceResolver == null && resourceResolverFactory != null) {
            assert (resourceResolverFactory.unavailabilityCause() == null);
            resourceResolver = resourceResolverFactory.newResourceResolver();
        }
        return resourceResolver;
    }

    static ResourceResolverFactory getResourceResolverFactory(ClassLoader object) {
        try {
            object = Class.forName("com.appoptics.ext.io.grpc.internal.JndiResourceResolverFactory", true, (ClassLoader)object).asSubclass(ResourceResolverFactory.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.FINE, "Unable to find JndiResourceResolverFactory, skipping.", classNotFoundException);
            return null;
        }
        catch (ClassCastException classCastException) {
            logger.log(Level.FINE, "Unable to cast JndiResourceResolverFactory, skipping.", classCastException);
            return null;
        }
        try {
            object = ((Class)object).getConstructor(new Class[0]);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Can't find JndiResourceResolverFactory ctor, skipping.", exception);
            return null;
        }
        try {
            object = (ResourceResolverFactory)((Constructor)object).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Can't construct JndiResourceResolverFactory, skipping.", exception);
            return null;
        }
        if (object.unavailabilityCause() != null) {
            logger.log(Level.FINE, "JndiResourceResolverFactory not available, skipping.", object.unavailabilityCause());
            return null;
        }
        return object;
    }

    private static String getLocalHostname() {
        if (localHostname == null) {
            try {
                localHostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                throw new RuntimeException(unknownHostException);
            }
        }
        return localHostname;
    }

    protected static boolean shouldUseJndi(boolean bl, boolean n2, String string) {
        if (!bl) {
            return false;
        }
        if ("localhost".equalsIgnoreCase(string)) {
            return n2 != 0;
        }
        if (string.contains(":")) {
            return false;
        }
        bl = true;
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            if (c2 == '.') continue;
            bl &= c2 >= '0' && c2 <= '9';
        }
        return !bl;
    }

    static /* synthetic */ Logger access$400() {
        return logger;
    }

    static /* synthetic */ String access$500(DnsNameResolver dnsNameResolver) {
        return dnsNameResolver.host;
    }

    static /* synthetic */ EquivalentAddressGroup access$600(DnsNameResolver dnsNameResolver) throws IOException {
        return dnsNameResolver.detectProxy();
    }

    static /* synthetic */ SynchronizationContext access$1000(DnsNameResolver dnsNameResolver) {
        return dnsNameResolver.syncContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ResourceResolver {
        public List<String> resolveTxt(String var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JdkAddressResolver implements AddressResolver
    {
        INSTANCE;


        @Override
        public final List<InetAddress> resolveAddress(String string) throws UnknownHostException {
            return Collections.unmodifiableList(Arrays.asList(InetAddress.getAllByName(string)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AddressResolver {
        public List<InetAddress> resolveAddress(String var1) throws Exception;
    }

    static interface ResourceResolverFactory {
        public ResourceResolver newResourceResolver();

        public Throwable unavailabilityCause();
    }

    protected static final class InternalResolutionResult {
        private Status error;
        private List<EquivalentAddressGroup> addresses;
        private NameResolver.ConfigOrError config;
        public Attributes attributes;

        private InternalResolutionResult() {
        }

        static /* synthetic */ Status access$200(InternalResolutionResult internalResolutionResult) {
            return internalResolutionResult.error;
        }

        static /* synthetic */ List access$100(InternalResolutionResult internalResolutionResult) {
            return internalResolutionResult.addresses;
        }

        static /* synthetic */ NameResolver.ConfigOrError access$300(InternalResolutionResult internalResolutionResult) {
            return internalResolutionResult.config;
        }
    }

    private final class Resolve
    implements Runnable {
        private final NameResolver.Listener2 savedListener;

        Resolve(NameResolver.Listener2 listener2) {
            this.savedListener = b.a(listener2, (Object)"savedListener");
        }

        /*
         * Unable to fully structure code
         */
        public final void run() {
            block10: {
                block11: {
                    if (DnsNameResolver.access$400().isLoggable(Level.FINER)) {
                        DnsNameResolver.access$400().finer("Attempting DNS resolution of " + DnsNameResolver.access$500(DnsNameResolver.this));
                    }
                    var1_1 = null;
                    var2_4 = DnsNameResolver.access$600(DnsNameResolver.this);
                    var3_9 = NameResolver.ResolutionResult.newBuilder();
                    if (var2_4 == null) break block11;
                    if (DnsNameResolver.access$400().isLoggable(Level.FINER)) {
                        DnsNameResolver.access$400().finer("Using proxy address " + var2_4);
                    }
                    var3_9.setAddresses(Collections.singletonList(var2_4));
                    ** GOTO lbl31
                }
                var1_1 = DnsNameResolver.this.doResolve(false);
                if (InternalResolutionResult.access$200(var1_1) == null) break block10;
                this.savedListener.onError(InternalResolutionResult.access$200(var1_1));
                var1_2 = var1_1 != null && InternalResolutionResult.access$200(var1_1) == null;
                DnsNameResolver.access$1000(DnsNameResolver.this).execute(new Runnable(var1_2){
                    final /* synthetic */ boolean val$succeed;
                    {
                        this.val$succeed = bl;
                    }

                    public void run() {
                        if (this.val$succeed) {
                            DnsNameResolver.this.resolved = true;
                            if (DnsNameResolver.this.cacheTtlNanos > 0L) {
                                DnsNameResolver.this.stopwatch.c().b();
                            }
                        }
                        DnsNameResolver.this.resolving = false;
                    }
                });
                return;
            }
            try {
                if (InternalResolutionResult.access$100(var1_1) != null) {
                    var3_9.setAddresses(InternalResolutionResult.access$100(var1_1));
                }
                if (InternalResolutionResult.access$300(var1_1) != null) {
                    var3_9.setServiceConfig(InternalResolutionResult.access$300(var1_1));
                }
                if (var1_1.attributes != null) {
                    var3_9.setAttributes(var1_1.attributes);
                }
lbl31:
                // 4 sources

                this.savedListener.onResult(var3_9.build());
            }
            catch (IOException var2_6) {
                try {
                    this.savedListener.onError(Status.UNAVAILABLE.withDescription("Unable to resolve host " + DnsNameResolver.access$500(DnsNameResolver.this)).withCause(var2_6));
                }
                catch (Throwable var2_8) {
                    var1_3 = var1_1 != null && InternalResolutionResult.access$200(var1_1) == null;
                    DnsNameResolver.access$1000(DnsNameResolver.this).execute(new /* invalid duplicate definition of identical inner class */);
                    throw var2_8;
                }
                var2_7 = var1_1 != null && InternalResolutionResult.access$200(var1_1) == null;
                DnsNameResolver.access$1000(DnsNameResolver.this).execute(new /* invalid duplicate definition of identical inner class */);
                return;
            }
            var2_5 = var1_1 != null && InternalResolutionResult.access$200(var1_1) == null;
            DnsNameResolver.access$1000(DnsNameResolver.this).execute(new /* invalid duplicate definition of identical inner class */);
            return;
        }
    }
}

