/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.ClientCall;
import com.appoptics.ext.io.grpc.Context;
import com.appoptics.ext.io.grpc.Deadline;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.ContextRunnable;
import com.tracelytics.a.d.a.a.g;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DelayedClientCall<ReqT, RespT>
extends ClientCall<ReqT, RespT> {
    private static final Logger logger = Logger.getLogger(DelayedClientCall.class.getName());
    private final ScheduledFuture<?> initialDeadlineMonitor;
    private final Executor callExecutor;
    private final Context context;
    private volatile boolean passThrough;
    private ClientCall.Listener<RespT> listener;
    private ClientCall<ReqT, RespT> realCall;
    private Status error;
    private List<Runnable> pendingRunnables = new ArrayList<Runnable>();
    private DelayedListener<RespT> delayedListener;
    private static final ClientCall<Object, Object> NOOP_CALL = new ClientCall<Object, Object>(){

        @Override
        public void start(ClientCall.Listener<Object> listener, Metadata metadata) {
        }

        @Override
        public void request(int n2) {
        }

        @Override
        public void cancel(String string, Throwable throwable) {
        }

        @Override
        public void halfClose() {
        }

        @Override
        public void sendMessage(Object object) {
        }
    };

    DelayedClientCall(Executor executor, ScheduledExecutorService scheduledExecutorService, Deadline deadline) {
        this.callExecutor = b.a(executor, (Object)"callExecutor");
        b.a(scheduledExecutorService, (Object)"scheduler");
        this.context = Context.current();
        this.initialDeadlineMonitor = this.scheduleDeadlineIfNeeded(scheduledExecutorService, deadline);
    }

    private ScheduledFuture<?> scheduleDeadlineIfNeeded(ScheduledExecutorService scheduledExecutorService, Deadline comparable) {
        Deadline deadline = this.context.getDeadline();
        if (comparable == null && deadline == null) {
            return null;
        }
        long l2 = Long.MAX_VALUE;
        if (comparable != null) {
            l2 = Math.min(Long.MAX_VALUE, ((Deadline)comparable).timeRemaining(TimeUnit.NANOSECONDS));
        }
        if (deadline != null && deadline.timeRemaining(TimeUnit.NANOSECONDS) < l2) {
            l2 = deadline.timeRemaining(TimeUnit.NANOSECONDS);
            if (logger.isLoggable(Level.FINE)) {
                StringBuilder stringBuilder = new StringBuilder(String.format("Call timeout set to '%d' ns, due to context deadline.", l2));
                if (comparable == null) {
                    stringBuilder.append(" Explicit call timeout was not set.");
                } else {
                    long l3 = ((Deadline)comparable).timeRemaining(TimeUnit.NANOSECONDS);
                    stringBuilder.append(String.format(" Explicit call timeout was '%d' ns.", l3));
                }
                logger.fine(stringBuilder.toString());
            }
        }
        long l4 = Math.abs(l2) / TimeUnit.SECONDS.toNanos(1L);
        long l5 = Math.abs(l2) % TimeUnit.SECONDS.toNanos(1L);
        comparable = new StringBuilder();
        if (l2 < 0L) {
            ((StringBuilder)comparable).append("ClientCall started after deadline exceeded. Deadline exceeded after -");
        } else {
            ((StringBuilder)comparable).append("Deadline exceeded after ");
        }
        ((StringBuilder)comparable).append(l4);
        ((StringBuilder)comparable).append(String.format(Locale.US, ".%09d", l5));
        ((StringBuilder)comparable).append("s. ");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DeadlineExceededRunnable
        implements Runnable {
            final /* synthetic */ StringBuilder val$buf;

            DeadlineExceededRunnable() {
                this.val$buf = stringBuilder;
            }

            @Override
            public void run() {
                DelayedClientCall.this.cancel(Status.DEADLINE_EXCEEDED.withDescription(this.val$buf.toString()), true);
            }
        }
        return scheduledExecutorService.schedule(new DeadlineExceededRunnable(), l2, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCall(ClientCall<ReqT, RespT> clientCall) {
        DelayedClientCall delayedClientCall = this;
        synchronized (delayedClientCall) {
            if (this.realCall != null) {
                return;
            }
            this.setRealCall(b.a(clientCall, (Object)"call"));
        }
        this.drainPendingCalls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start(ClientCall.Listener<RespT> listener, Metadata metadata) {
        boolean bl;
        Status status;
        b.b(this.listener == null, "already started");
        Object object = this;
        synchronized (object) {
            this.listener = b.a(listener, (Object)"listener");
            status = this.error;
            bl = this.passThrough;
            if (!bl) {
                this.delayedListener = new DelayedListener<RespT>(listener);
                listener = this.delayedListener;
            }
        }
        if (status != null) {
            this.callExecutor.execute(new CloseListenerRunnable(listener, status));
            return;
        }
        if (bl) {
            this.realCall.start(listener, metadata);
            return;
        }
        object = listener;
        this.delayOrExecute(new Runnable((ClientCall.Listener)object, metadata){
            final /* synthetic */ ClientCall.Listener val$finalListener;
            final /* synthetic */ Metadata val$headers;
            {
                this.val$finalListener = listener;
                this.val$headers = metadata;
            }

            public void run() {
                DelayedClientCall.this.realCall.start(this.val$finalListener, this.val$headers);
            }
        });
    }

    @Override
    public final void cancel(String string, Throwable throwable) {
        Status status = Status.CANCELLED;
        status = string != null ? status.withDescription(string) : status.withDescription("Call cancelled without message");
        if (throwable != null) {
            status = status.withCause(throwable);
        }
        this.cancel(status, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(final Status status, boolean bl) {
        boolean bl2 = true;
        ClientCall.Listener<RespT> listener = null;
        DelayedClientCall delayedClientCall = this;
        synchronized (delayedClientCall) {
            if (this.realCall == null) {
                ClientCall<Object, Object> clientCall = NOOP_CALL;
                this.setRealCall(clientCall);
                bl2 = false;
                listener = this.listener;
                this.error = status;
            } else if (bl) {
                return;
            }
        }
        if (bl2) {
            this.delayOrExecute(new Runnable(){

                public void run() {
                    DelayedClientCall.this.realCall.cancel(status.getDescription(), status.getCause());
                }
            });
        } else {
            if (listener != null) {
                this.callExecutor.execute(new CloseListenerRunnable(listener, status));
            }
            this.drainPendingCalls();
        }
        this.callCancelled();
    }

    protected void callCancelled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayOrExecute(Runnable runnable) {
        DelayedClientCall delayedClientCall = this;
        synchronized (delayedClientCall) {
            if (!this.passThrough) {
                this.pendingRunnables.add(runnable);
                return;
            }
        }
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainPendingCalls() {
        Object object;
        assert (this.realCall != null);
        assert (!this.passThrough);
        Object object2 = new ArrayList<Runnable>();
        while (true) {
            Object object3;
            object = this;
            synchronized (object) {
                if (this.pendingRunnables.isEmpty()) {
                    this.pendingRunnables = null;
                    this.passThrough = true;
                    object2 = this.delayedListener;
                    break;
                }
                object3 = object2;
                object2 = this.pendingRunnables;
                this.pendingRunnables = object3;
            }
            object = object2.iterator();
            while (object.hasNext()) {
                object3 = (Runnable)object.next();
                object3.run();
            }
            object2.clear();
        }
        if (object2 != null) {
            object = object2;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class DrainListenerRunnable
            extends ContextRunnable {
                final /* synthetic */ DelayedListener val$listener;

                DrainListenerRunnable() {
                    this.val$listener = delayedListener;
                    super(DelayedClientCall.this.context);
                }

                @Override
                public void runInContext() {
                    this.val$listener.drainPendingCallbacks();
                }
            }
            this.callExecutor.execute(new DrainListenerRunnable());
        }
    }

    private void setRealCall(ClientCall<ReqT, RespT> clientCall) {
        b.b(this.realCall == null, "realCall already set to %s", this.realCall);
        if (this.initialDeadlineMonitor != null) {
            this.initialDeadlineMonitor.cancel(false);
        }
        this.realCall = clientCall;
    }

    @Override
    public final void sendMessage(final ReqT ReqT) {
        if (this.passThrough) {
            this.realCall.sendMessage(ReqT);
            return;
        }
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedClientCall.this.realCall.sendMessage(ReqT);
            }
        });
    }

    @Override
    public final void request(final int n2) {
        if (this.passThrough) {
            this.realCall.request(n2);
            return;
        }
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedClientCall.this.realCall.request(n2);
            }
        });
    }

    @Override
    public final void halfClose() {
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedClientCall.this.realCall.halfClose();
            }
        });
    }

    public String toString() {
        return g.a(this).a("realCall", this.realCall).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DelayedListener<RespT>
    extends ClientCall.Listener<RespT> {
        private final ClientCall.Listener<RespT> realListener;
        private volatile boolean passThrough;
        private List<Runnable> pendingCallbacks = new ArrayList<Runnable>();

        public DelayedListener(ClientCall.Listener<RespT> listener) {
            this.realListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void delayOrExecute(Runnable runnable) {
            DelayedListener delayedListener = this;
            synchronized (delayedListener) {
                if (!this.passThrough) {
                    this.pendingCallbacks.add(runnable);
                    return;
                }
            }
            runnable.run();
        }

        @Override
        public final void onHeaders(final Metadata metadata) {
            if (this.passThrough) {
                this.realListener.onHeaders(metadata);
                return;
            }
            this.delayOrExecute(new Runnable(){

                public void run() {
                    DelayedListener.this.realListener.onHeaders(metadata);
                }
            });
        }

        @Override
        public final void onMessage(final RespT RespT) {
            if (this.passThrough) {
                this.realListener.onMessage(RespT);
                return;
            }
            this.delayOrExecute(new Runnable(){

                public void run() {
                    DelayedListener.this.realListener.onMessage(RespT);
                }
            });
        }

        @Override
        public final void onClose(final Status status, final Metadata metadata) {
            this.delayOrExecute(new Runnable(){

                public void run() {
                    DelayedListener.this.realListener.onClose(status, metadata);
                }
            });
        }

        @Override
        public final void onReady() {
            if (this.passThrough) {
                this.realListener.onReady();
                return;
            }
            this.delayOrExecute(new Runnable(){

                public void run() {
                    DelayedListener.this.realListener.onReady();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void drainPendingCallbacks() {
            assert (!this.passThrough);
            List<Runnable> list = new ArrayList<Runnable>();
            while (true) {
                DelayedListener delayedListener = this;
                synchronized (delayedListener) {
                    if (this.pendingCallbacks.isEmpty()) {
                        this.pendingCallbacks = null;
                        this.passThrough = true;
                        return;
                    }
                    ArrayList<Runnable> arrayList = list;
                    list = this.pendingCallbacks;
                    this.pendingCallbacks = arrayList;
                }
                for (Runnable runnable : list) {
                    runnable.run();
                }
                list.clear();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CloseListenerRunnable
    extends ContextRunnable {
        final ClientCall.Listener<RespT> listener;
        final Status status;

        CloseListenerRunnable(ClientCall.Listener<RespT> listener, Status status) {
            super(DelayedClientCall.this.context);
            this.listener = listener;
            this.status = status;
        }

        @Override
        public final void runInContext() {
            this.listener.onClose(this.status, new Metadata());
        }
    }
}

