/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.grpc.internal.AbstractReadableBuffer;
import com.appoptics.ext.io.grpc.internal.ReadableBuffer;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;

public class CompositeReadableBuffer
extends AbstractReadableBuffer {
    private int readableBytes;
    private final Queue<ReadableBuffer> buffers = new ArrayDeque<ReadableBuffer>();

    public void addBuffer(ReadableBuffer readableBuffer) {
        if (!(readableBuffer instanceof CompositeReadableBuffer)) {
            this.buffers.add(readableBuffer);
            this.readableBytes += readableBuffer.readableBytes();
            return;
        }
        readableBuffer = (CompositeReadableBuffer)readableBuffer;
        while (!((CompositeReadableBuffer)readableBuffer).buffers.isEmpty()) {
            ReadableBuffer readableBuffer2 = ((CompositeReadableBuffer)readableBuffer).buffers.remove();
            this.buffers.add(readableBuffer2);
        }
        this.readableBytes += ((CompositeReadableBuffer)readableBuffer).readableBytes;
        ((CompositeReadableBuffer)readableBuffer).readableBytes = 0;
        ((CompositeReadableBuffer)readableBuffer).close();
    }

    public int readableBytes() {
        return this.readableBytes;
    }

    public int readUnsignedByte() {
        ReadOperation readOperation = new ReadOperation(){

            int readInternal(ReadableBuffer readableBuffer, int n2) {
                return readableBuffer.readUnsignedByte();
            }
        };
        this.execute(readOperation, 1);
        return readOperation.value;
    }

    public void readBytes(final byte[] byArray, final int n2, int n3) {
        this.execute(new ReadOperation(){
            int currentOffset;
            {
                this.currentOffset = n2;
            }

            public int readInternal(ReadableBuffer readableBuffer, int n22) {
                readableBuffer.readBytes(byArray, this.currentOffset, n22);
                this.currentOffset += n22;
                return 0;
            }
        }, n3);
    }

    public CompositeReadableBuffer readBytes(int n2) {
        this.checkReadable(n2);
        this.readableBytes -= n2;
        CompositeReadableBuffer compositeReadableBuffer = new CompositeReadableBuffer();
        while (n2 > 0) {
            ReadableBuffer readableBuffer = this.buffers.peek();
            if (readableBuffer.readableBytes() > n2) {
                compositeReadableBuffer.addBuffer(readableBuffer.readBytes(n2));
                n2 = 0;
                continue;
            }
            compositeReadableBuffer.addBuffer(this.buffers.poll());
            n2 -= readableBuffer.readableBytes();
        }
        return compositeReadableBuffer;
    }

    public void close() {
        while (!this.buffers.isEmpty()) {
            this.buffers.remove().close();
        }
    }

    private void execute(ReadOperation readOperation, int n2) {
        this.checkReadable(n2);
        if (!this.buffers.isEmpty()) {
            this.advanceBufferIfNecessary();
        }
        while (n2 > 0 && !this.buffers.isEmpty()) {
            ReadableBuffer readableBuffer = this.buffers.peek();
            int n3 = Math.min(n2, readableBuffer.readableBytes());
            readOperation.read(readableBuffer, n3);
            if (readOperation.isError()) {
                return;
            }
            n2 -= n3;
            this.readableBytes -= n3;
            this.advanceBufferIfNecessary();
        }
        if (n2 > 0) {
            throw new AssertionError((Object)"Failed executing read operation");
        }
    }

    private void advanceBufferIfNecessary() {
        ReadableBuffer readableBuffer = this.buffers.peek();
        if (readableBuffer.readableBytes() == 0) {
            this.buffers.remove().close();
        }
    }

    private static abstract class ReadOperation {
        int value;
        IOException ex;

        private ReadOperation() {
        }

        final void read(ReadableBuffer readableBuffer, int n2) {
            try {
                this.value = this.readInternal(readableBuffer, n2);
                return;
            }
            catch (IOException iOException) {
                this.ex = iOException;
                return;
            }
        }

        final boolean isError() {
            return this.ex != null;
        }

        abstract int readInternal(ReadableBuffer var1, int var2) throws IOException;
    }
}

