/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.a.c;
import com.appoptics.ext.io.a.d;
import com.appoptics.ext.io.grpc.CallOptions;
import com.appoptics.ext.io.grpc.ClientCall;
import com.appoptics.ext.io.grpc.Codec;
import com.appoptics.ext.io.grpc.Compressor;
import com.appoptics.ext.io.grpc.CompressorRegistry;
import com.appoptics.ext.io.grpc.Context;
import com.appoptics.ext.io.grpc.Contexts;
import com.appoptics.ext.io.grpc.Deadline;
import com.appoptics.ext.io.grpc.DecompressorRegistry;
import com.appoptics.ext.io.grpc.ForwardingClientCallListener;
import com.appoptics.ext.io.grpc.InternalConfigSelector;
import com.appoptics.ext.io.grpc.InternalDecompressorRegistry;
import com.appoptics.ext.io.grpc.LoadBalancer;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.MethodDescriptor;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.CallTracer;
import com.appoptics.ext.io.grpc.internal.ClientStream;
import com.appoptics.ext.io.grpc.internal.ClientStreamListener;
import com.appoptics.ext.io.grpc.internal.ContextRunnable;
import com.appoptics.ext.io.grpc.internal.FailingClientStream;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.appoptics.ext.io.grpc.internal.InsightBuilder;
import com.appoptics.ext.io.grpc.internal.LogExceptionRunnable;
import com.appoptics.ext.io.grpc.internal.ManagedChannelServiceConfig;
import com.appoptics.ext.io.grpc.internal.NoopClientStream;
import com.appoptics.ext.io.grpc.internal.PickSubchannelArgsImpl;
import com.appoptics.ext.io.grpc.internal.RetriableStream;
import com.appoptics.ext.io.grpc.internal.SerializeReentrantCallsDirectExecutor;
import com.appoptics.ext.io.grpc.internal.SerializingExecutor;
import com.appoptics.ext.io.grpc.internal.StreamListener;
import com.tracelytics.a.d.a.a.g;
import com.tracelytics.a.d.a.g.a.k;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClientCallImpl<ReqT, RespT>
extends ClientCall<ReqT, RespT> {
    private static final Logger log = Logger.getLogger(ClientCallImpl.class.getName());
    private static final byte[] FULL_STREAM_DECOMPRESSION_ENCODINGS = "gzip".getBytes(Charset.forName("US-ASCII"));
    private final MethodDescriptor<ReqT, RespT> method;
    private final d tag;
    private final Executor callExecutor;
    private final boolean callExecutorIsDirect;
    private final CallTracer channelCallsTracer;
    private final Context context;
    private volatile ScheduledFuture<?> deadlineCancellationFuture;
    private final boolean unaryRequest;
    private CallOptions callOptions;
    private ClientStream stream;
    private volatile boolean cancelListenersShouldBeRemoved;
    private boolean cancelCalled;
    private boolean halfCloseCalled;
    private final ClientStreamProvider clientStreamProvider;
    private final ContextCancellationListener cancellationListener = new ContextCancellationListener();
    private final ScheduledExecutorService deadlineCancellationExecutor;
    private final InternalConfigSelector configSelector;
    private boolean fullStreamDecompression;
    private DecompressorRegistry decompressorRegistry = DecompressorRegistry.getDefaultInstance();
    private CompressorRegistry compressorRegistry = CompressorRegistry.getDefaultInstance();

    ClientCallImpl(MethodDescriptor<ReqT, RespT> methodDescriptor, Executor executor, CallOptions callOptions, ClientStreamProvider clientStreamProvider, ScheduledExecutorService scheduledExecutorService, CallTracer callTracer, InternalConfigSelector internalConfigSelector) {
        this.method = methodDescriptor;
        this.tag = c.a(methodDescriptor.getFullMethodName(), System.identityHashCode(this));
        if (executor == k.a()) {
            this.callExecutor = new SerializeReentrantCallsDirectExecutor();
            this.callExecutorIsDirect = true;
        } else {
            this.callExecutor = new SerializingExecutor(executor);
            this.callExecutorIsDirect = false;
        }
        this.channelCallsTracer = callTracer;
        this.context = Context.current();
        this.unaryRequest = methodDescriptor.getType() == MethodDescriptor.MethodType.UNARY || methodDescriptor.getType() == MethodDescriptor.MethodType.SERVER_STREAMING;
        this.callOptions = callOptions;
        this.clientStreamProvider = clientStreamProvider;
        this.deadlineCancellationExecutor = scheduledExecutorService;
        this.configSelector = internalConfigSelector;
        c.b("ClientCall.<init>", this.tag);
    }

    final ClientCallImpl<ReqT, RespT> setFullStreamDecompression(boolean bl) {
        this.fullStreamDecompression = bl;
        return this;
    }

    final ClientCallImpl<ReqT, RespT> setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
        this.decompressorRegistry = decompressorRegistry;
        return this;
    }

    final ClientCallImpl<ReqT, RespT> setCompressorRegistry(CompressorRegistry compressorRegistry) {
        this.compressorRegistry = compressorRegistry;
        return this;
    }

    static void prepareHeaders(Metadata metadata, DecompressorRegistry object, Compressor compressor, boolean bl) {
        metadata.discardAll(GrpcUtil.MESSAGE_ENCODING_KEY);
        if (compressor != Codec.Identity.NONE) {
            metadata.put(GrpcUtil.MESSAGE_ENCODING_KEY, compressor.getMessageEncoding());
        }
        metadata.discardAll(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        byte[] byArray = InternalDecompressorRegistry.getRawAdvertisedMessageEncodings((DecompressorRegistry)object);
        object = byArray;
        if (byArray.length != 0) {
            metadata.put(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY, object);
        }
        metadata.discardAll(GrpcUtil.CONTENT_ENCODING_KEY);
        metadata.discardAll(GrpcUtil.CONTENT_ACCEPT_ENCODING_KEY);
        if (bl) {
            metadata.put(GrpcUtil.CONTENT_ACCEPT_ENCODING_KEY, FULL_STREAM_DECOMPRESSION_ENCODINGS);
        }
    }

    @Override
    public final void start(ClientCall.Listener<RespT> listener, Metadata metadata) {
        c.a("ClientCall.start", this.tag);
        try {
            this.startInternal(listener, metadata);
            return;
        }
        finally {
            c.c("ClientCall.start", this.tag);
        }
    }

    private void startInternal(ClientCall.Listener<RespT> committedCallbackListener, Metadata metadata) {
        Object object;
        Object object2;
        Object object3;
        b.b(this.stream == null, "Already started");
        b.b(!this.cancelCalled, "call was cancelled");
        b.a(committedCallbackListener, (Object)"observer");
        b.a(metadata, (Object)"headers");
        if (this.context.isCancelled()) {
            this.stream = NoopClientStream.INSTANCE;
            final CommittedCallbackListener committedCallbackListener2 = committedCallbackListener;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ClosedByContext
            extends ContextRunnable {
                ClosedByContext() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public void runInContext() {
                    ClientCallImpl.this.closeObserver(committedCallbackListener2, Contexts.statusFromCancelled(ClientCallImpl.this.context), new Metadata());
                }
            }
            this.callExecutor.execute(new ClosedByContext());
            return;
        }
        if (this.configSelector != null) {
            object3 = new PickSubchannelArgsImpl(this.method, metadata, this.callOptions);
            object2 = this.configSelector.selectConfig((LoadBalancer.PickSubchannelArgs)object3);
            object = ((InternalConfigSelector.Result)object2).getStatus();
            if (!((Status)object).isOk()) {
                this.executeCloseObserverInContext(committedCallbackListener, (Status)object);
                return;
            }
            this.callOptions = ((InternalConfigSelector.Result)object2).getCallOptions();
            object3 = ((InternalConfigSelector.Result)object2).getCommittedCallback();
            if (object3 != null) {
                committedCallbackListener = new CommittedCallbackListener(committedCallbackListener, (Runnable)object3);
            }
            object3 = (ManagedChannelServiceConfig)((InternalConfigSelector.Result)object2).getConfig();
            object3 = ((ManagedChannelServiceConfig)object3).getMethodConfig(this.method);
            this.applyMethodConfig((ManagedChannelServiceConfig.MethodInfo)object3);
        }
        if ((object3 = this.callOptions.getCompressor()) != null) {
            object2 = this.compressorRegistry.lookupCompressor((String)object3);
            if (object2 == null) {
                this.stream = NoopClientStream.INSTANCE;
                object = committedCallbackListener;
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ClosedByNotFoundCompressor
                extends ContextRunnable {
                    final /* synthetic */ ClientCall.Listener val$finalObserver;
                    final /* synthetic */ String val$compressorName;

                    ClosedByNotFoundCompressor() {
                        this.val$finalObserver = listener;
                        this.val$compressorName = string;
                        super(ClientCallImpl.this.context);
                    }

                    @Override
                    public void runInContext() {
                        ClientCallImpl.this.closeObserver(this.val$finalObserver, Status.INTERNAL.withDescription(String.format("Unable to find compressor by name %s", this.val$compressorName)), new Metadata());
                    }
                }
                this.callExecutor.execute(new ClosedByNotFoundCompressor());
                return;
            }
        } else {
            object2 = Codec.Identity.NONE;
        }
        ClientCallImpl.prepareHeaders(metadata, this.decompressorRegistry, (Compressor)object2, this.fullStreamDecompression);
        object = this.effectiveDeadline();
        boolean bl = object != null && ((Deadline)object).isExpired();
        if (!bl) {
            ClientCallImpl.logIfContextNarrowedTimeout((Deadline)object, this.context.getDeadline(), this.callOptions.getDeadline());
            this.stream = this.clientStreamProvider.newStream(this.method, this.callOptions, metadata, this.context);
        } else {
            this.stream = new FailingClientStream(Status.DEADLINE_EXCEEDED.withDescription("ClientCall started after deadline exceeded: " + object));
        }
        if (this.callExecutorIsDirect) {
            this.stream.optimizeForDirectExecutor();
        }
        if (this.callOptions.getAuthority() != null) {
            this.stream.setAuthority(this.callOptions.getAuthority());
        }
        if (this.callOptions.getMaxInboundMessageSize() != null) {
            this.stream.setMaxInboundMessageSize(this.callOptions.getMaxInboundMessageSize());
        }
        if (this.callOptions.getMaxOutboundMessageSize() != null) {
            this.stream.setMaxOutboundMessageSize(this.callOptions.getMaxOutboundMessageSize());
        }
        if (object != null) {
            this.stream.setDeadline((Deadline)object);
        }
        this.stream.setCompressor((Compressor)object2);
        if (this.fullStreamDecompression) {
            this.stream.setFullStreamDecompression(this.fullStreamDecompression);
        }
        this.stream.setDecompressorRegistry(this.decompressorRegistry);
        this.channelCallsTracer.reportCallStarted();
        this.stream.start(new ClientStreamListenerImpl(committedCallbackListener));
        this.context.addListener(this.cancellationListener, k.a());
        if (object != null && !((Deadline)object).equals(this.context.getDeadline()) && this.deadlineCancellationExecutor != null) {
            this.deadlineCancellationFuture = this.startDeadlineTimer((Deadline)object);
        }
        if (this.cancelListenersShouldBeRemoved) {
            this.removeContextListenerAndCancelDeadlineFuture();
        }
    }

    private void applyMethodConfig(ManagedChannelServiceConfig.MethodInfo methodInfo) {
        Comparable<Deadline> comparable;
        if (methodInfo == null) {
            return;
        }
        this.callOptions = this.callOptions.withOption(ManagedChannelServiceConfig.MethodInfo.KEY, methodInfo);
        if (methodInfo.timeoutNanos != null) {
            comparable = Deadline.after(methodInfo.timeoutNanos, TimeUnit.NANOSECONDS);
            Deadline deadline = this.callOptions.getDeadline();
            if (deadline == null || ((Deadline)comparable).compareTo(deadline) < 0) {
                this.callOptions = this.callOptions.withDeadline((Deadline)comparable);
            }
        }
        if (methodInfo.waitForReady != null) {
            CallOptions callOptions = this.callOptions = methodInfo.waitForReady != false ? this.callOptions.withWaitForReady() : this.callOptions.withoutWaitForReady();
        }
        if (methodInfo.maxInboundMessageSize != null) {
            comparable = this.callOptions.getMaxInboundMessageSize();
            this.callOptions = comparable != null ? this.callOptions.withMaxInboundMessageSize(Math.min((Integer)comparable, methodInfo.maxInboundMessageSize)) : this.callOptions.withMaxInboundMessageSize(methodInfo.maxInboundMessageSize);
        }
        if (methodInfo.maxOutboundMessageSize != null) {
            comparable = this.callOptions.getMaxOutboundMessageSize();
            if (comparable != null) {
                this.callOptions = this.callOptions.withMaxOutboundMessageSize(Math.min((Integer)comparable, methodInfo.maxOutboundMessageSize));
                return;
            }
            this.callOptions = this.callOptions.withMaxOutboundMessageSize(methodInfo.maxOutboundMessageSize);
        }
    }

    private static void logIfContextNarrowedTimeout(Deadline comparable, Deadline deadline, Deadline deadline2) {
        if (!log.isLoggable(Level.FINE) || comparable == null || !((Deadline)comparable).equals(deadline)) {
            return;
        }
        long l2 = Math.max(0L, ((Deadline)comparable).timeRemaining(TimeUnit.NANOSECONDS));
        comparable = new StringBuilder(String.format("Call timeout set to '%d' ns, due to context deadline.", l2));
        if (deadline2 == null) {
            ((StringBuilder)comparable).append(" Explicit call timeout was not set.");
        } else {
            long l3 = deadline2.timeRemaining(TimeUnit.NANOSECONDS);
            ((StringBuilder)comparable).append(String.format(" Explicit call timeout was '%d' ns.", l3));
        }
        log.fine(((StringBuilder)comparable).toString());
    }

    private void removeContextListenerAndCancelDeadlineFuture() {
        this.context.removeListener(this.cancellationListener);
        ScheduledFuture<?> scheduledFuture = this.deadlineCancellationFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
    }

    private ScheduledFuture<?> startDeadlineTimer(Deadline deadline) {
        long l2 = deadline.timeRemaining(TimeUnit.NANOSECONDS);
        return this.deadlineCancellationExecutor.schedule(new LogExceptionRunnable(new DeadlineTimer(l2)), l2, TimeUnit.NANOSECONDS);
    }

    private void executeCloseObserverInContext(final ClientCall.Listener<RespT> listener, final Status status) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CloseInContext
        extends ContextRunnable {
            CloseInContext() {
                super(ClientCallImpl.this.context);
            }

            @Override
            public void runInContext() {
                ClientCallImpl.this.closeObserver(listener, status, new Metadata());
            }
        }
        this.callExecutor.execute(new CloseInContext());
    }

    private Deadline effectiveDeadline() {
        return ClientCallImpl.min(this.callOptions.getDeadline(), this.context.getDeadline());
    }

    private static Deadline min(Deadline deadline, Deadline deadline2) {
        if (deadline == null) {
            return deadline2;
        }
        if (deadline2 == null) {
            return deadline;
        }
        return deadline.minimum(deadline2);
    }

    @Override
    public final void request(int n2) {
        c.a("ClientCall.request", this.tag);
        try {
            b.b(this.stream != null, "Not started");
            b.a(n2 >= 0, (Object)"Number requested must be non-negative");
            this.stream.request(n2);
            return;
        }
        finally {
            c.c("ClientCall.request", this.tag);
        }
    }

    @Override
    public final void cancel(String string, Throwable throwable) {
        c.a("ClientCall.cancel", this.tag);
        try {
            this.cancelInternal(string, throwable);
            return;
        }
        finally {
            c.c("ClientCall.cancel", this.tag);
        }
    }

    private void cancelInternal(String string, Throwable throwable) {
        if (string == null && throwable == null) {
            throwable = new CancellationException("Cancelled without a message or cause");
            log.log(Level.WARNING, "Cancelling without a message or cause is suboptimal", throwable);
        }
        if (this.cancelCalled) {
            return;
        }
        this.cancelCalled = true;
        try {
            if (this.stream != null) {
                Status status = Status.CANCELLED;
                status = string != null ? status.withDescription(string) : status.withDescription("Call cancelled without message");
                if (throwable != null) {
                    status = status.withCause(throwable);
                }
                this.stream.cancel(status);
            }
            return;
        }
        finally {
            this.removeContextListenerAndCancelDeadlineFuture();
        }
    }

    @Override
    public final void halfClose() {
        c.a("ClientCall.halfClose", this.tag);
        try {
            this.halfCloseInternal();
            return;
        }
        finally {
            c.c("ClientCall.halfClose", this.tag);
        }
    }

    private void halfCloseInternal() {
        b.b(this.stream != null, "Not started");
        b.b(!this.cancelCalled, "call was cancelled");
        b.b(!this.halfCloseCalled, "call already half-closed");
        this.halfCloseCalled = true;
        this.stream.halfClose();
    }

    @Override
    public final void sendMessage(ReqT ReqT) {
        c.a("ClientCall.sendMessage", this.tag);
        try {
            this.sendMessageInternal(ReqT);
            return;
        }
        finally {
            c.c("ClientCall.sendMessage", this.tag);
        }
    }

    private void sendMessageInternal(ReqT ReqT) {
        b.b(this.stream != null, "Not started");
        b.b(!this.cancelCalled, "call was cancelled");
        b.b(!this.halfCloseCalled, "call was half-closed");
        try {
            if (this.stream instanceof RetriableStream) {
                RetriableStream retriableStream = (RetriableStream)this.stream;
                retriableStream.sendMessage(ReqT);
            } else {
                this.stream.writeMessage(this.method.streamRequest(ReqT));
            }
        }
        catch (RuntimeException runtimeException) {
            this.stream.cancel(Status.CANCELLED.withCause(runtimeException).withDescription("Failed to stream message"));
            return;
        }
        catch (Error error) {
            this.stream.cancel(Status.CANCELLED.withDescription("Client sendMessage() failed with Error"));
            throw error;
        }
        if (!this.unaryRequest) {
            this.stream.flush();
        }
    }

    private void closeObserver(ClientCall.Listener<RespT> listener, Status status, Metadata metadata) {
        listener.onClose(status, metadata);
    }

    public final String toString() {
        return g.a(this).a("method", this.method).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClientStreamListenerImpl
    implements ClientStreamListener {
        private final ClientCall.Listener<RespT> observer;
        private Status exceptionStatus;

        public ClientStreamListenerImpl(ClientCall.Listener<RespT> listener) {
            this.observer = b.a(listener, (Object)"observer");
        }

        private void exceptionThrown(Status status) {
            this.exceptionStatus = status;
            ClientCallImpl.this.stream.cancel(status);
        }

        @Override
        public void headersRead(final Metadata metadata) {
            c.a("ClientStreamListener.headersRead", ClientCallImpl.this.tag);
            final b b2 = c.b();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                final class HeadersRead
                extends ContextRunnable {
                    HeadersRead() {
                        super(ClientCallImpl.this.context);
                    }

                    @Override
                    public final void runInContext() {
                        c.a("ClientCall$Listener.headersRead", ClientCallImpl.this.tag);
                        c.a(b2);
                        try {
                            this.runInternal();
                            return;
                        }
                        finally {
                            c.c("ClientCall$Listener.headersRead", ClientCallImpl.this.tag);
                        }
                    }

                    private void runInternal() {
                        if (ClientStreamListenerImpl.this.exceptionStatus != null) {
                            return;
                        }
                        try {
                            ClientStreamListenerImpl.this.observer.onHeaders(metadata);
                            return;
                        }
                        catch (Throwable throwable) {
                            ClientStreamListenerImpl.this.exceptionThrown(Status.CANCELLED.withCause(throwable).withDescription("Failed to read headers"));
                            return;
                        }
                    }
                }
                ClientCallImpl.this.callExecutor.execute(new HeadersRead());
                return;
            }
            finally {
                c.c("ClientStreamListener.headersRead", ClientCallImpl.this.tag);
            }
        }

        @Override
        public void messagesAvailable(final StreamListener.MessageProducer messageProducer) {
            c.a("ClientStreamListener.messagesAvailable", ClientCallImpl.this.tag);
            final b b2 = c.b();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                final class MessagesAvailable
                extends ContextRunnable {
                    MessagesAvailable() {
                        super(ClientCallImpl.this.context);
                    }

                    @Override
                    public final void runInContext() {
                        c.a("ClientCall$Listener.messagesAvailable", ClientCallImpl.this.tag);
                        c.a(b2);
                        try {
                            this.runInternal();
                            return;
                        }
                        finally {
                            c.c("ClientCall$Listener.messagesAvailable", ClientCallImpl.this.tag);
                        }
                    }

                    private void runInternal() {
                        if (ClientStreamListenerImpl.this.exceptionStatus != null) {
                            GrpcUtil.closeQuietly(messageProducer);
                            return;
                        }
                        try {
                            InputStream inputStream;
                            while ((inputStream = messageProducer.next()) != null) {
                                try {
                                    ClientStreamListenerImpl.this.observer.onMessage(ClientCallImpl.this.method.parseResponse(inputStream));
                                }
                                catch (Throwable throwable) {
                                    GrpcUtil.closeQuietly(inputStream);
                                    throw throwable;
                                }
                                inputStream.close();
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            GrpcUtil.closeQuietly(messageProducer);
                            ClientStreamListenerImpl.this.exceptionThrown(Status.CANCELLED.withCause(throwable).withDescription("Failed to read message."));
                            return;
                        }
                    }
                }
                ClientCallImpl.this.callExecutor.execute(new MessagesAvailable());
                return;
            }
            finally {
                c.c("ClientStreamListener.messagesAvailable", ClientCallImpl.this.tag);
            }
        }

        @Override
        public void closed(Status status, Metadata metadata) {
            this.closed(status, ClientStreamListener.RpcProgress.PROCESSED, metadata);
        }

        @Override
        public void closed(Status status, ClientStreamListener.RpcProgress rpcProgress, Metadata metadata) {
            c.a("ClientStreamListener.closed", ClientCallImpl.this.tag);
            try {
                this.closedInternal(status, rpcProgress, metadata);
                return;
            }
            finally {
                c.c("ClientStreamListener.closed", ClientCallImpl.this.tag);
            }
        }

        private void closedInternal(Status object, ClientStreamListener.RpcProgress object2, Metadata object3) {
            object2 = ClientCallImpl.this.effectiveDeadline();
            if (((Status)object).getCode() == Status.Code.CANCELLED && object2 != null && ((Deadline)object2).isExpired()) {
                object = new InsightBuilder();
                ClientCallImpl.this.stream.appendTimeoutInsight((InsightBuilder)object);
                object = Status.DEADLINE_EXCEEDED.augmentDescription("ClientCall was cancelled at or after deadline. " + object);
                object3 = new Metadata();
            }
            object2 = object3;
            object3 = c.b();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            final class StreamClosed
            extends ContextRunnable {
                final /* synthetic */ b val$link;
                final /* synthetic */ Status val$savedStatus;
                final /* synthetic */ Metadata val$savedTrailers;

                StreamClosed() {
                    this.val$link = b2;
                    this.val$savedStatus = status;
                    this.val$savedTrailers = metadata;
                    super(ClientCallImpl.this.context);
                }

                @Override
                public final void runInContext() {
                    c.a("ClientCall$Listener.onClose", ClientCallImpl.this.tag);
                    c.a(this.val$link);
                    try {
                        this.runInternal();
                        return;
                    }
                    finally {
                        c.c("ClientCall$Listener.onClose", ClientCallImpl.this.tag);
                    }
                }

                private void runInternal() {
                    Status status = this.val$savedStatus;
                    Metadata metadata = this.val$savedTrailers;
                    if (ClientStreamListenerImpl.this.exceptionStatus != null) {
                        status = ClientStreamListenerImpl.this.exceptionStatus;
                        metadata = new Metadata();
                    }
                    ClientCallImpl.this.cancelListenersShouldBeRemoved = true;
                    try {
                        ClientCallImpl.this.closeObserver(ClientStreamListenerImpl.this.observer, status, metadata);
                        return;
                    }
                    finally {
                        ClientCallImpl.this.removeContextListenerAndCancelDeadlineFuture();
                        ClientCallImpl.this.channelCallsTracer.reportCallEnded(status.isOk());
                    }
                }
            }
            ClientCallImpl.this.callExecutor.execute(new StreamClosed());
        }

        @Override
        public void onReady() {
            if (ClientCallImpl.this.method.getType().clientSendsOneMessage()) {
                return;
            }
            c.a("ClientStreamListener.onReady", ClientCallImpl.this.tag);
            final b b2 = c.b();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                final class StreamOnReady
                extends ContextRunnable {
                    StreamOnReady() {
                        super(ClientCallImpl.this.context);
                    }

                    @Override
                    public final void runInContext() {
                        c.a("ClientCall$Listener.onReady", ClientCallImpl.this.tag);
                        c.a(b2);
                        try {
                            this.runInternal();
                            return;
                        }
                        finally {
                            c.c("ClientCall$Listener.onReady", ClientCallImpl.this.tag);
                        }
                    }

                    private void runInternal() {
                        if (ClientStreamListenerImpl.this.exceptionStatus != null) {
                            return;
                        }
                        try {
                            ClientStreamListenerImpl.this.observer.onReady();
                            return;
                        }
                        catch (Throwable throwable) {
                            ClientStreamListenerImpl.this.exceptionThrown(Status.CANCELLED.withCause(throwable).withDescription("Failed to call onReady."));
                            return;
                        }
                    }
                }
                ClientCallImpl.this.callExecutor.execute(new StreamOnReady());
                return;
            }
            finally {
                c.c("ClientStreamListener.onReady", ClientCallImpl.this.tag);
            }
        }
    }

    private class DeadlineTimer
    implements Runnable {
        private final long remainingNanos;

        DeadlineTimer(long l2) {
            this.remainingNanos = l2;
        }

        public void run() {
            InsightBuilder insightBuilder = new InsightBuilder();
            ClientCallImpl.this.stream.appendTimeoutInsight(insightBuilder);
            long l2 = Math.abs(this.remainingNanos) / TimeUnit.SECONDS.toNanos(1L);
            long l3 = Math.abs(this.remainingNanos) % TimeUnit.SECONDS.toNanos(1L);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("deadline exceeded after ");
            if (this.remainingNanos < 0L) {
                stringBuilder.append('-');
            }
            stringBuilder.append(l2);
            stringBuilder.append(String.format(Locale.US, ".%09d", l3));
            stringBuilder.append("s. ");
            stringBuilder.append(insightBuilder);
            ClientCallImpl.this.stream.cancel(Status.DEADLINE_EXCEEDED.augmentDescription(stringBuilder.toString()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CommittedCallbackListener
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        final Runnable committedCallback;
        boolean committed;

        CommittedCallbackListener(ClientCall.Listener<RespT> listener, Runnable runnable) {
            super(listener);
            this.committedCallback = runnable;
        }

        @Override
        public final void onHeaders(Metadata metadata) {
            this.committed = true;
            this.committedCallback.run();
            this.delegate().onHeaders(metadata);
        }

        @Override
        public final void onClose(Status status, Metadata metadata) {
            if (!this.committed) {
                this.committed = true;
                this.committedCallback.run();
            }
            this.delegate().onClose(status, metadata);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ClientStreamProvider {
        public ClientStream newStream(MethodDescriptor<?, ?> var1, CallOptions var2, Metadata var3, Context var4);
    }

    private final class ContextCancellationListener
    implements Context.CancellationListener {
        private ContextCancellationListener() {
        }

        public final void cancelled(Context context) {
            ClientCallImpl.this.stream.cancel(Contexts.statusFromCancelled(context));
        }
    }
}

