/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.ChannelLogger;
import com.appoptics.ext.io.grpc.InternalChannelz;
import com.appoptics.ext.io.grpc.InternalLogId;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

final class ChannelTracer {
    static final Logger logger = Logger.getLogger(ChannelLogger.class.getName());
    private final Object lock = new Object();
    private final InternalLogId logId;
    private final Collection<InternalChannelz.ChannelTrace.Event> events;
    private final long channelCreationTimeNanos;
    private int eventsLogged;

    ChannelTracer(InternalLogId internalLogId, final int n2, long l2, String string) {
        b.a(string, (Object)"description");
        this.logId = b.a(internalLogId, (Object)"logId");
        this.events = n2 > 0 ? new ArrayDeque<InternalChannelz.ChannelTrace.Event>(){

            @Override
            public boolean add(InternalChannelz.ChannelTrace.Event event) {
                if (this.size() == n2) {
                    this.removeFirst();
                }
                ChannelTracer.this.eventsLogged++;
                return super.add(event);
            }
        } : null;
        this.channelCreationTimeNanos = l2;
        this.reportEvent(new InternalChannelz.ChannelTrace.Event.Builder().setDescription(string + " created").setSeverity(InternalChannelz.ChannelTrace.Event.Severity.CT_INFO).setTimestampNanos(l2).build());
    }

    final void reportEvent(InternalChannelz.ChannelTrace.Event event) {
        Level level;
        switch (event.severity) {
            case CT_ERROR: {
                level = Level.FINE;
                break;
            }
            case CT_WARNING: {
                level = Level.FINER;
                break;
            }
            default: {
                level = Level.FINEST;
            }
        }
        this.traceOnly(event);
        ChannelTracer.logOnly(this.logId, level, event.description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isTraceEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.events != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void traceOnly(InternalChannelz.ChannelTrace.Event event) {
        Object object = this.lock;
        synchronized (object) {
            if (this.events != null) {
                this.events.add(event);
            }
            return;
        }
    }

    static void logOnly(InternalLogId object, Level level, String string) {
        if (logger.isLoggable(level)) {
            object = new LogRecord(level, "[" + object + "] " + string);
            ((LogRecord)object).setLoggerName(logger.getName());
            ((LogRecord)object).setSourceClassName(logger.getName());
            ((LogRecord)object).setSourceMethodName("log");
            logger.log((LogRecord)object);
        }
    }

    final InternalLogId getLogId() {
        return this.logId;
    }
}

