/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.a.b;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class SynchronizationContext
implements Executor {
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicReference<Thread> drainingThread = new AtomicReference();

    public SynchronizationContext(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = b.a(uncaughtExceptionHandler, (Object)"uncaughtExceptionHandler");
    }

    public final void drain() {
        do {
            if (!this.drainingThread.compareAndSet(null, Thread.currentThread())) {
                return;
            }
            try {
                Runnable runnable;
                while ((runnable = this.queue.poll()) != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), throwable);
                    }
                }
            }
            finally {
                this.drainingThread.set(null);
            }
        } while (!this.queue.isEmpty());
    }

    public final void executeLater(Runnable runnable) {
        this.queue.add(b.a(runnable, (Object)"runnable is null"));
    }

    public final void execute(Runnable runnable) {
        this.executeLater(runnable);
        this.drain();
    }

    public final void throwIfNotInThisSynchronizationContext() {
        b.b(Thread.currentThread() == this.drainingThread.get(), "Not called from the SynchronizationContext");
    }

    public final ScheduledHandle schedule(Runnable object, long l2, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        final ManagedRunnable managedRunnable = new ManagedRunnable((Runnable)object);
        object = scheduledExecutorService.schedule(new Runnable((Runnable)object){
            final /* synthetic */ Runnable val$task;
            {
                this.val$task = runnable;
            }

            public void run() {
                SynchronizationContext.this.execute(managedRunnable);
            }

            public String toString() {
                return this.val$task.toString() + "(scheduled in SynchronizationContext)";
            }
        }, l2, timeUnit);
        return new ScheduledHandle(managedRunnable, (ScheduledFuture)object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ScheduledHandle {
        private final ManagedRunnable runnable;
        private final ScheduledFuture<?> future;

        private ScheduledHandle(ManagedRunnable managedRunnable, ScheduledFuture<?> scheduledFuture) {
            this.runnable = b.a(managedRunnable, (Object)"runnable");
            this.future = b.a(scheduledFuture, (Object)"future");
        }

        public final void cancel() {
            this.runnable.isCancelled = true;
            this.future.cancel(false);
        }

        public final boolean isPending() {
            return !this.runnable.hasStarted && !this.runnable.isCancelled;
        }
    }

    private static class ManagedRunnable
    implements Runnable {
        final Runnable task;
        boolean isCancelled;
        boolean hasStarted;

        ManagedRunnable(Runnable runnable) {
            this.task = b.a(runnable, (Object)"task");
        }

        public void run() {
            if (!this.isCancelled) {
                this.hasStarted = true;
                this.task.run();
            }
        }
    }
}

