/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.StatusException;
import com.appoptics.ext.io.grpc.StatusRuntimeException;
import com.tracelytics.a.d.a.a.b;
import com.tracelytics.a.d.a.a.d;
import com.tracelytics.a.d.a.a.g;
import com.tracelytics.a.d.a.a.o;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Status {
    private static final boolean FAIL_ON_EQUALS_FOR_TEST = Boolean.parseBoolean(System.getProperty("com.appoptics.ext.io.grpc.Status.failOnEqualsForTest", "false"));
    private static final List<Status> STATUS_LIST = Status.buildStatusList();
    public static final Status OK = Code.OK.toStatus();
    public static final Status CANCELLED = Code.CANCELLED.toStatus();
    public static final Status UNKNOWN = Code.UNKNOWN.toStatus();
    public static final Status INVALID_ARGUMENT = Code.INVALID_ARGUMENT.toStatus();
    public static final Status DEADLINE_EXCEEDED = Code.DEADLINE_EXCEEDED.toStatus();
    public static final Status NOT_FOUND = Code.NOT_FOUND.toStatus();
    public static final Status ALREADY_EXISTS = Code.ALREADY_EXISTS.toStatus();
    public static final Status PERMISSION_DENIED = Code.PERMISSION_DENIED.toStatus();
    public static final Status UNAUTHENTICATED = Code.UNAUTHENTICATED.toStatus();
    public static final Status RESOURCE_EXHAUSTED = Code.RESOURCE_EXHAUSTED.toStatus();
    public static final Status FAILED_PRECONDITION = Code.FAILED_PRECONDITION.toStatus();
    public static final Status ABORTED = Code.ABORTED.toStatus();
    public static final Status OUT_OF_RANGE = Code.OUT_OF_RANGE.toStatus();
    public static final Status UNIMPLEMENTED = Code.UNIMPLEMENTED.toStatus();
    public static final Status INTERNAL = Code.INTERNAL.toStatus();
    public static final Status UNAVAILABLE = Code.UNAVAILABLE.toStatus();
    public static final Status DATA_LOSS = Code.DATA_LOSS.toStatus();
    static final Metadata.Key<Status> CODE_KEY = Metadata.Key.of("grpc-status", false, new StatusCodeMarshaller());
    private static final Metadata.TrustedAsciiMarshaller<String> STATUS_MESSAGE_MARSHALLER = new StatusMessageMarshaller();
    static final Metadata.Key<String> MESSAGE_KEY = Metadata.Key.of("grpc-message", false, STATUS_MESSAGE_MARSHALLER);
    private final Code code;
    private final String description;
    private final Throwable cause;

    private static List<Status> buildStatusList() {
        TreeMap<Integer, Status> treeMap = new TreeMap<Integer, Status>();
        for (Code code : Code.values()) {
            Status status = treeMap.put(code.value(), new Status(code));
            if (status == null) continue;
            throw new IllegalStateException("Code value duplication between " + status.getCode().name() + " & " + code.name());
        }
        return Collections.unmodifiableList(new ArrayList(treeMap.values()));
    }

    public static Status fromCodeValue(int n2) {
        if (n2 < 0 || n2 > STATUS_LIST.size()) {
            return UNKNOWN.withDescription("Unknown code " + n2);
        }
        return STATUS_LIST.get(n2);
    }

    private static Status fromCodeValue(byte[] byArray) {
        if (byArray.length == 1 && byArray[0] == 48) {
            return OK;
        }
        return Status.fromCodeValueSlow(byArray);
    }

    private static Status fromCodeValueSlow(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        switch (byArray.length) {
            case 2: {
                if (byArray[0] < 48 || byArray[0] > 57) break;
                ++n2;
                n3 = 0 + (byArray[0] - 48) * 10;
            }
            case 1: {
                if (byArray[n2] < 48 || byArray[n2] > 57 || (n3 += byArray[n2] - 48) >= STATUS_LIST.size()) break;
                return STATUS_LIST.get(n3);
            }
        }
        return UNKNOWN.withDescription("Unknown code " + new String(byArray, b.a));
    }

    public static Status fromThrowable(Throwable throwable) {
        for (Throwable throwable2 = com.appoptics.ext.io.a.b.a(throwable, (Object)"t"); throwable2 != null; throwable2 = throwable2.getCause()) {
            if (throwable2 instanceof StatusException) {
                return ((StatusException)throwable2).getStatus();
            }
            if (!(throwable2 instanceof StatusRuntimeException)) continue;
            return ((StatusRuntimeException)throwable2).getStatus();
        }
        return UNKNOWN.withCause(throwable);
    }

    static String formatThrowableMessage(Status status) {
        if (status.description == null) {
            return status.code.toString();
        }
        return (Object)((Object)status.code) + ": " + status.description;
    }

    private Status(Code code) {
        this(code, null, null);
    }

    private Status(Code code, String string, Throwable throwable) {
        this.code = com.appoptics.ext.io.a.b.a(code, (Object)"code");
        this.description = string;
        this.cause = throwable;
    }

    public final Status withCause(Throwable throwable) {
        if (d.a(this.cause, (Object)throwable)) {
            return this;
        }
        return new Status(this.code, this.description, throwable);
    }

    public final Status withDescription(String string) {
        if (d.a((Object)this.description, (Object)string)) {
            return this;
        }
        return new Status(this.code, string, this.cause);
    }

    public final Status augmentDescription(String string) {
        if (string == null) {
            return this;
        }
        if (this.description == null) {
            return new Status(this.code, string, this.cause);
        }
        return new Status(this.code, this.description + "\n" + string, this.cause);
    }

    public final Code getCode() {
        return this.code;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Throwable getCause() {
        return this.cause;
    }

    public final boolean isOk() {
        return Code.OK == this.code;
    }

    public final StatusRuntimeException asRuntimeException() {
        return new StatusRuntimeException(this);
    }

    public final StatusRuntimeException asRuntimeException(Metadata metadata) {
        return new StatusRuntimeException(this, metadata);
    }

    public final StatusException asException() {
        return new StatusException(this);
    }

    public final String toString() {
        return g.a(this).a("code", this.code.name()).a("description", this.description).a("cause", this.cause != null ? o.b(this.cause) : this.cause).toString();
    }

    public final boolean equals(Object object) {
        assert (!FAIL_ON_EQUALS_FOR_TEST) : "Status.equals called; disable this by setting io.grpc.Status.failOnEqualsForTest";
        return super.equals(object);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StatusMessageMarshaller
    implements Metadata.TrustedAsciiMarshaller<String> {
        private static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

        private StatusMessageMarshaller() {
        }

        @Override
        public final byte[] toAsciiString(String object) {
            object = ((String)object).getBytes(b.b);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                Object object2 = object[i2];
                if (!StatusMessageMarshaller.isEscapingChar((byte)object2)) continue;
                return StatusMessageMarshaller.toAsciiStringSlow((byte[])object, i2);
            }
            return object;
        }

        private static boolean isEscapingChar(byte by) {
            return by < 32 || by >= 126 || by == 37;
        }

        private static byte[] toAsciiStringSlow(byte[] byArray, int n2) {
            byte[] byArray2 = new byte[n2 + (byArray.length - n2) * 3];
            if (n2 != 0) {
                System.arraycopy(byArray, 0, byArray2, 0, n2);
            }
            int n3 = n2;
            while (n2 < byArray.length) {
                byte by = byArray[n2];
                if (StatusMessageMarshaller.isEscapingChar(by)) {
                    byArray2[n3] = 37;
                    byArray2[n3 + 1] = HEX[by >> 4 & 0xF];
                    byArray2[n3 + 2] = HEX[by & 0xF];
                    n3 += 3;
                } else {
                    byArray2[n3++] = by;
                }
                ++n2;
            }
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            return byArray3;
        }

        @Override
        public final String parseAsciiString(byte[] byArray) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byte by = byArray[i2];
                if (by >= 32 && by < 126 && (by != 37 || i2 + 2 >= byArray.length)) continue;
                return StatusMessageMarshaller.parseAsciiStringSlow(byArray);
            }
            return new String(byArray, 0);
        }

        private static String parseAsciiStringSlow(byte[] byArray) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
            int n2 = 0;
            while (n2 < byArray.length) {
                if (byArray[n2] == 37 && n2 + 2 < byArray.length) {
                    try {
                        byteBuffer.put((byte)Integer.parseInt(new String(byArray, n2 + 1, 2, b.a), 16));
                        n2 += 3;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                byteBuffer.put(byArray[n2]);
                ++n2;
            }
            return new String(byteBuffer.array(), 0, byteBuffer.position(), b.b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StatusCodeMarshaller
    implements Metadata.TrustedAsciiMarshaller<Status> {
        private StatusCodeMarshaller() {
        }

        @Override
        public final byte[] toAsciiString(Status status) {
            return status.getCode().valueAscii();
        }

        @Override
        public final Status parseAsciiString(byte[] byArray) {
            return Status.fromCodeValue(byArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Code {
        OK(0),
        CANCELLED(1),
        UNKNOWN(2),
        INVALID_ARGUMENT(3),
        DEADLINE_EXCEEDED(4),
        NOT_FOUND(5),
        ALREADY_EXISTS(6),
        PERMISSION_DENIED(7),
        RESOURCE_EXHAUSTED(8),
        FAILED_PRECONDITION(9),
        ABORTED(10),
        OUT_OF_RANGE(11),
        UNIMPLEMENTED(12),
        INTERNAL(13),
        UNAVAILABLE(14),
        DATA_LOSS(15),
        UNAUTHENTICATED(16);

        private final int value;
        private final byte[] valueAscii;

        private Code(int n3) {
            this.value = n3;
            this.valueAscii = Integer.toString(n3).getBytes(b.a);
        }

        public final int value() {
            return this.value;
        }

        public final Status toStatus() {
            return (Status)STATUS_LIST.get(this.value);
        }

        private byte[] valueAscii() {
            return this.valueAscii;
        }
    }
}

