/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.tracelytics.a.d.a.a.b;
import com.tracelytics.a.d.a.a.d;
import com.tracelytics.a.d.a.d.a;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Metadata {
    public static final BinaryMarshaller<byte[]> BINARY_BYTE_MARSHALLER = new BinaryMarshaller<byte[]>(){};
    public static final AsciiMarshaller<String> ASCII_STRING_MARSHALLER = new AsciiMarshaller<String>(){

        @Override
        public String toAsciiString(String string) {
            return string;
        }

        @Override
        public String parseAsciiString(String string) {
            return string;
        }
    };
    static final a BASE64_ENCODING_OMIT_PADDING = a.b().a();
    private Object[] namesAndValues;
    private int size;

    Metadata(byte[] ... byArray) {
        this(byArray.length / 2, byArray);
    }

    Metadata(int n2, byte[] ... byArray) {
        this(n2, (Object[])byArray);
    }

    Metadata(int n2, Object[] objectArray) {
        assert ((objectArray.length & 1) == 0) : "Odd number of key-value pairs " + objectArray.length;
        this.size = n2;
        this.namesAndValues = objectArray;
    }

    private byte[] name(int n2) {
        return (byte[])this.namesAndValues[n2 << 1];
    }

    private void name(int n2, byte[] byArray) {
        this.namesAndValues[n2 << 1] = byArray;
    }

    private Object value(int n2) {
        return this.namesAndValues[(n2 << 1) + 1];
    }

    private void value(int n2, byte[] byArray) {
        this.namesAndValues[(n2 << 1) + 1] = byArray;
    }

    private void value(int n2, Object object) {
        if (this.namesAndValues instanceof byte[][]) {
            Metadata metadata = this;
            metadata.expand(metadata.cap());
        }
        this.namesAndValues[(n2 << 1) + 1] = object;
    }

    private byte[] valueAsBytes(int n2) {
        Object object = this.value(n2);
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        return ((LazyValue)object).toBytes();
    }

    private <T> T valueAsT(int n2, Key<T> key) {
        Object object = this.value(n2);
        if (object instanceof byte[]) {
            return key.parseBytes((byte[])object);
        }
        return ((LazyValue)object).toObject(key);
    }

    private int cap() {
        if (this.namesAndValues != null) {
            return this.namesAndValues.length;
        }
        return 0;
    }

    private int len() {
        return this.size << 1;
    }

    private boolean isEmpty() {
        return this.size == 0;
    }

    public Metadata() {
    }

    public final <T> T get(Key<T> key) {
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            if (!this.bytesEqual(key.asciiName(), this.name(i2))) continue;
            return this.valueAsT(i2, key);
        }
        return null;
    }

    public final <T> void put(Key<T> key, T t2) {
        com.appoptics.ext.io.a.b.a(key, (Object)"key");
        com.appoptics.ext.io.a.b.a(t2, (Object)"value");
        this.maybeExpand();
        Metadata metadata = this;
        metadata.name(metadata.size, key.asciiName());
        if (key.serializesToStreams()) {
            Metadata metadata2 = this;
            metadata2.value(metadata2.size, LazyValue.create(key, t2));
        } else {
            Metadata metadata3 = this;
            metadata3.value(metadata3.size, key.toBytes(t2));
        }
        ++this.size;
    }

    private void maybeExpand() {
        if (this.len() == 0 || this.len() == this.cap()) {
            Metadata metadata = this;
            metadata.expand(Math.max(metadata.len() << 1, 8));
        }
    }

    private void expand(int n2) {
        Object[] objectArray = new Object[n2];
        if (!this.isEmpty()) {
            System.arraycopy(this.namesAndValues, 0, objectArray, 0, this.len());
        }
        this.namesAndValues = objectArray;
    }

    public final <T> void discardAll(Key<T> key) {
        if (this.isEmpty()) {
            return;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.bytesEqual(key.asciiName(), this.name(i2))) continue;
            this.name(n2, this.name(i2));
            this.value(n2, this.value(i2));
            ++n2;
        }
        int n3 = n2;
        Arrays.fill(this.namesAndValues, n2 << 1, this.len(), null);
        this.size = n3;
    }

    final byte[][] serialize() {
        byte[][] byArrayArray = new byte[this.len()][];
        if (this.namesAndValues instanceof byte[][]) {
            System.arraycopy(this.namesAndValues, 0, byArrayArray, 0, this.len());
        } else {
            for (int i2 = 0; i2 < this.size; ++i2) {
                byArrayArray[i2 << 1] = this.name(i2);
                byArrayArray[(i2 << 1) + 1] = this.valueAsBytes(i2);
            }
        }
        return byArrayArray;
    }

    public final void merge(Metadata metadata) {
        if (metadata.isEmpty()) {
            return;
        }
        int n2 = this.cap() - this.len();
        if (this.isEmpty() || n2 < metadata.len()) {
            Metadata metadata2 = this;
            metadata2.expand(metadata2.len() + metadata.len());
        }
        System.arraycopy(metadata.namesAndValues, 0, this.namesAndValues, this.len(), metadata.len());
        this.size += metadata.size;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("Metadata(");
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (i2 != 0) {
                stringBuilder.append(',');
            }
            String string = new String(this.name(i2), b.a);
            stringBuilder.append(string).append('=');
            if (string.endsWith("-bin")) {
                stringBuilder.append(BASE64_ENCODING_OMIT_PADDING.a(this.valueAsBytes(i2)));
                continue;
            }
            string = new String(this.valueAsBytes(i2), b.a);
            stringBuilder.append(string);
        }
        return stringBuilder.append(')').toString();
    }

    private boolean bytesEqual(byte[] byArray, byte[] byArray2) {
        return Arrays.equals(byArray, byArray2);
    }

    private static byte[] streamToBytes(InputStream inputStream) {
        try {
            return com.tracelytics.a.d.a.d.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("failure reading serialized stream", iOException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface TrustedAsciiMarshaller<T> {
        public byte[] toAsciiString(T var1);

        public T parseAsciiString(byte[] var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrustedAsciiKey<T>
    extends Key<T> {
        private final TrustedAsciiMarshaller<T> marshaller;

        private TrustedAsciiKey(String string, boolean bl, TrustedAsciiMarshaller<T> trustedAsciiMarshaller) {
            super(string, bl, trustedAsciiMarshaller);
            com.appoptics.ext.io.a.b.a(!string.endsWith("-bin"), "ASCII header is named %s.  Only binary headers may end with %s", string, (Object)"-bin");
            this.marshaller = com.appoptics.ext.io.a.b.a(trustedAsciiMarshaller, (Object)"marshaller");
        }

        @Override
        final byte[] toBytes(T t2) {
            return this.marshaller.toAsciiString(t2);
        }

        @Override
        final T parseBytes(byte[] byArray) {
            return this.marshaller.parseAsciiString(byArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AsciiKey<T>
    extends Key<T> {
        private final AsciiMarshaller<T> marshaller;

        private AsciiKey(String string, boolean bl, AsciiMarshaller<T> asciiMarshaller) {
            super(string, bl, asciiMarshaller);
            com.appoptics.ext.io.a.b.a(!string.endsWith("-bin"), "ASCII header is named %s.  Only binary headers may end with %s", string, (Object)"-bin");
            this.marshaller = com.appoptics.ext.io.a.b.a(asciiMarshaller, (Object)"marshaller");
        }

        @Override
        byte[] toBytes(T t2) {
            return this.marshaller.toAsciiString(t2).getBytes(b.a);
        }

        @Override
        T parseBytes(byte[] byArray) {
            return this.marshaller.parseAsciiString(new String(byArray, b.a));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LazyValue<T> {
        private final BinaryStreamMarshaller<T> marshaller;
        private final T value;
        private volatile byte[] serialized;

        static <T> LazyValue<T> create(Key<T> key, T t2) {
            return new LazyValue<T>(com.appoptics.ext.io.a.b.a(LazyValue.getBinaryStreamMarshaller(key)), t2);
        }

        LazyValue(BinaryStreamMarshaller<T> binaryStreamMarshaller, T t2) {
            this.marshaller = binaryStreamMarshaller;
            this.value = t2;
        }

        final InputStream toStream() {
            return this.marshaller.toStream(this.value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final byte[] toBytes() {
            if (this.serialized == null) {
                LazyValue lazyValue = this;
                synchronized (lazyValue) {
                    if (this.serialized == null) {
                        this.serialized = Metadata.streamToBytes(this.toStream());
                    }
                }
            }
            return this.serialized;
        }

        final <T2> T2 toObject(Key<T2> key) {
            BinaryStreamMarshaller<T2> binaryStreamMarshaller;
            if (key.serializesToStreams() && (binaryStreamMarshaller = LazyValue.getBinaryStreamMarshaller(key)) != null) {
                return binaryStreamMarshaller.parseStream(this.toStream());
            }
            return key.parseBytes(this.toBytes());
        }

        private static <T> BinaryStreamMarshaller<T> getBinaryStreamMarshaller(Key<T> key) {
            return key.getMarshaller(BinaryStreamMarshaller.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Key<T> {
        private static final BitSet VALID_T_CHARS = Key.generateValidTChars();
        private final String originalName;
        private final String name;
        private final byte[] nameBytes;
        private final Object marshaller;

        public static <T> Key<T> of(String string, AsciiMarshaller<T> asciiMarshaller) {
            return Key.of(string, false, asciiMarshaller);
        }

        static <T> Key<T> of(String string, boolean bl, AsciiMarshaller<T> asciiMarshaller) {
            return new AsciiKey(string, bl, asciiMarshaller);
        }

        static <T> Key<T> of(String string, boolean bl, TrustedAsciiMarshaller<T> trustedAsciiMarshaller) {
            return new TrustedAsciiKey(string, bl, trustedAsciiMarshaller);
        }

        private static BitSet generateValidTChars() {
            int n2;
            BitSet bitSet = new BitSet(127);
            bitSet.set(45);
            bitSet.set(95);
            bitSet.set(46);
            for (n2 = 48; n2 <= 57; n2 = (int)((char)(n2 + 1))) {
                bitSet.set(n2);
            }
            for (n2 = 97; n2 <= 122; n2 = (int)((char)(n2 + 1))) {
                bitSet.set(n2);
            }
            return bitSet;
        }

        private static String validateName(String string, boolean bl) {
            com.appoptics.ext.io.a.b.a(string, (Object)"name");
            com.appoptics.ext.io.a.b.a(!string.isEmpty(), (Object)"token must have at least 1 tchar");
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (bl && c2 == ':' && i2 == 0) continue;
                boolean bl2 = VALID_T_CHARS.get(c2);
                String string2 = string;
                char c3 = c2;
                String string3 = "Invalid character '%s' in key name '%s'";
                c2 = (char)(bl2 ? 1 : 0);
                if (bl2) continue;
                throw new IllegalArgumentException(d.a(string3, Character.valueOf(c3), string2));
            }
            return string;
        }

        private Key(String string, boolean bl, Object object) {
            this.originalName = com.appoptics.ext.io.a.b.a(string, (Object)"name");
            this.name = Key.validateName(this.originalName.toLowerCase(Locale.ROOT), bl);
            this.nameBytes = this.name.getBytes(b.a);
            this.marshaller = object;
        }

        public final String name() {
            return this.name;
        }

        byte[] asciiName() {
            return this.nameBytes;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            object = (Key)object;
            return this.name.equals(((Key)object).name);
        }

        public final int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "Key{name='" + this.name + "'}";
        }

        abstract byte[] toBytes(T var1);

        abstract T parseBytes(byte[] var1);

        boolean serializesToStreams() {
            return false;
        }

        final <M> M getMarshaller(Class<M> clazz) {
            if (clazz.isInstance(this.marshaller)) {
                return clazz.cast(this.marshaller);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BinaryStreamMarshaller<T> {
        public InputStream toStream(T var1);

        public T parseStream(InputStream var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AsciiMarshaller<T> {
        public String toAsciiString(T var1);

        public T parseAsciiString(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BinaryMarshaller<T> {
    }
}

