/*
 * Decompiled with CFR 0.152.
 */
package com.appolica.fragmentcontroller;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.appolica.fragmentcontroller.OnBackPressedListener;
import com.appolica.fragmentcontroller.PushBody;
import com.appolica.fragmentcontroller.R;
import com.appolica.fragmentcontroller.fragment.FragmentProvider;
import com.appolica.fragmentcontroller.fragment.FragmentProviderImpl;
import com.appolica.fragmentcontroller.fragment.animation.TransitionAnimationManager;
import com.appolica.fragmentcontroller.util.FragmentUtil;
import java.io.Serializable;
import java.util.List;

public class FragmentController
extends Fragment
implements PushBody.PushBodyConsumer,
OnBackPressedListener {
    public static final String ARG_ROOT_FRAGMENT = FragmentController.class.getName() + ":ArgRootFragment";
    public static final String ARG_ROOT_TAG = FragmentController.class.getName() + ":ArgRootTAG";
    public static final String ARG_ROOT_BUNDLE = FragmentController.class.getName() + ":ArgRootBundle";

    public static FragmentController instance(FragmentProvider provider) {
        return FragmentController.instance(provider, provider.getInstance().getArguments());
    }

    public static FragmentController instance(FragmentProvider fragmentType, Bundle rootArgs) {
        FragmentController controller = new FragmentController();
        Bundle args = new Bundle();
        args.putSerializable(ARG_ROOT_FRAGMENT, fragmentType.getInstance().getClass());
        args.putString(ARG_ROOT_TAG, fragmentType.getTag());
        args.putBundle(ARG_ROOT_BUNDLE, rootArgs);
        controller.setArguments(args);
        return controller;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FragmentProvider rootType = this.getRootFromArgs();
        this.addRoot(savedInstanceState, rootType);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_container, container, false);
    }

    private void addRoot(Bundle savedInstanceState, FragmentProvider fragmentType) {
        if (savedInstanceState == null) {
            this.pushBody().addToBackStack(true).fragment(fragmentType).push();
        }
    }

    private FragmentProvider getRootFromArgs() {
        Bundle arguments = this.getArguments();
        if (arguments == null || arguments.getSerializable(ARG_ROOT_FRAGMENT) == null || arguments.getString(ARG_ROOT_TAG) == null) {
            throw new IllegalStateException("Root fragment is not defined or tag not provided!");
        }
        Serializable serializedClass = arguments.getSerializable(ARG_ROOT_FRAGMENT);
        String tag = arguments.getString(ARG_ROOT_TAG);
        Bundle rootArgs = arguments.getBundle(ARG_ROOT_BUNDLE);
        if (!(serializedClass instanceof Class)) {
            throw new IllegalStateException("You must provide provide root fragment of type Class<? extends Fragment>.");
        }
        Class rootClass = (Class)serializedClass;
        FragmentProviderImpl fragmentType = new FragmentProviderImpl(rootClass, tag, rootArgs);
        return fragmentType;
    }

    public PushBody.Builder pushBody() {
        return PushBody.Builder.instance(this);
    }

    @Override
    public void push(PushBody body) {
        PushBody.Builder.TransitionAnimationBody animations;
        FragmentManager fragmentManager = this.getChildFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        if (body.addToBackStack()) {
            fragmentTransaction.addToBackStack(body.getTag());
        }
        if ((animations = body.getTransitionAnimations()) != null) {
            fragmentTransaction.setCustomAnimations(animations.getEnter(), animations.getExit(), animations.getPopEnter(), animations.getPopExit());
        }
        fragmentTransaction.replace(R.id.fragmentPlace, body.getFragment(), body.getTag()).commit();
        if (body.immediate()) {
            fragmentManager.executePendingTransactions();
        }
    }

    public boolean pop(boolean withAnimation) {
        FragmentManager fragmentManager = this.getChildFragmentManager();
        this.disableLastEntryAnimation(withAnimation, fragmentManager);
        return fragmentManager.getBackStackEntryCount() != 1 && fragmentManager.popBackStackImmediate();
    }

    public void popAsync(boolean withAnimation) {
        FragmentManager fragmentManager = this.getChildFragmentManager();
        this.disableLastEntryAnimation(withAnimation, fragmentManager);
        if (fragmentManager.getBackStackEntryCount() != 1) {
            fragmentManager.popBackStack();
        }
    }

    public boolean popTo(FragmentProvider provider, boolean inclusive, boolean withAnimation) {
        boolean popped;
        FragmentManager fragmentManager = this.getChildFragmentManager();
        if (!withAnimation) {
            this.disableNextAnimationTo(fragmentManager, provider.getTag(), inclusive);
        }
        if ((popped = fragmentManager.popBackStackImmediate(provider.getTag(), 0)) && inclusive) {
            this.pop(withAnimation);
        }
        return popped;
    }

    public void popToAsync(FragmentProvider provider, boolean inclusive, boolean withAnimation) {
        FragmentManager fragmentManager = this.getChildFragmentManager();
        if (!withAnimation) {
            this.disableNextAnimationTo(fragmentManager, provider.getTag(), inclusive);
        }
        fragmentManager.popBackStack(provider.getTag(), 0);
        if (inclusive) {
            this.popAsync(withAnimation);
        }
    }

    public boolean popToRoot() {
        FragmentManager fragmentManager;
        int lastEntry;
        for (int index = lastEntry = (entryCount = (fragmentManager = this.getChildFragmentManager()).getBackStackEntryCount()) == 0 ? 0 : entryCount - 1; index > 0; --index) {
            fragmentManager.popBackStack();
        }
        fragmentManager.executePendingTransactions();
        return lastEntry > 0;
    }

    public void popToRootAsync() {
        int lastEntry;
        for (int index = lastEntry = (entryCount = (fragmentManager = this.getChildFragmentManager()).getBackStackEntryCount()) == 0 ? 0 : entryCount - 1; index > 0; --index) {
            FragmentManager fragmentManager;
            fragmentManager.popBackStack();
        }
    }

    private String getTagFromEntry(FragmentManager fragmentManager, int entry) {
        return fragmentManager.getBackStackEntryAt(entry).getName();
    }

    private void disableLastEntryAnimation(boolean withAnimation, FragmentManager fragmentManager) {
        if (!withAnimation) {
            int lastEntry = fragmentManager.getBackStackEntryCount() - 1;
            String lastTag = this.getTagFromEntry(fragmentManager, lastEntry);
            this.disableNextAnimationTo(fragmentManager, lastTag, true);
        }
    }

    private void disableNextAnimationTo(FragmentManager fragmentManager, String tag, boolean inclusive) {
        int entry;
        int entryCount = fragmentManager.getBackStackEntryCount();
        int lastEntry = entryCount - 1;
        String entryTag = null;
        for (entry = lastEntry; !tag.equals(entryTag) || entry > 1; --entry) {
            entryTag = this.getTagFromEntry(fragmentManager, entry);
            this.disableAnimationForEntryTag(fragmentManager, entryTag);
        }
        if (inclusive && entry > 1) {
            entryTag = this.getTagFromEntry(fragmentManager, entry);
            this.disableAnimationForEntryTag(fragmentManager, entryTag);
        }
    }

    private void disableAnimationForEntryTag(FragmentManager fragmentManager, String entryTag) {
        Fragment fragment = fragmentManager.findFragmentByTag(entryTag);
        if (fragment instanceof TransitionAnimationManager) {
            ((TransitionAnimationManager)fragment).disableNextAnimation();
        }
    }

    @Override
    public boolean onBackPressed() {
        Fragment topFragment = this.getTopFragment();
        boolean handled = false;
        if (topFragment != null && topFragment instanceof OnBackPressedListener) {
            handled = ((OnBackPressedListener)topFragment).onBackPressed();
        }
        if (!handled) {
            handled = this.pop(true);
        }
        return handled;
    }

    @Nullable
    private Fragment getTopFragment() {
        List<Fragment> fragments = FragmentUtil.getFragments(this.getChildFragmentManager());
        int size = fragments.size();
        if (size > 0) {
            return fragments.get(size - 1);
        }
        return null;
    }
}

