/*
 * Decompiled with CFR 0.152.
 */
package com.appolica.fragmentcontroller;

import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import com.appolica.fragmentcontroller.R;
import com.appolica.fragmentcontroller.fragment.ControllerFragmentType;
import org.jetbrains.annotations.Contract;

public class PushBody {
    private String tag;
    private ControllerFragmentType fragmentType;
    private boolean addToBackStack;
    private boolean immediate;
    private Builder.TransitionAnimationBody transitionAnimations;

    private PushBody() {
    }

    public Fragment getFragment() {
        return this.fragmentType.getInstance();
    }

    public ControllerFragmentType getFragmentType() {
        return this.fragmentType;
    }

    public void setFragmentType(ControllerFragmentType fragmentType) {
        this.fragmentType = fragmentType;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean addToBackStack() {
        return this.addToBackStack;
    }

    public void setAddToBackStack(boolean addToBackStack) {
        this.addToBackStack = addToBackStack;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public boolean immediate() {
        return this.immediate;
    }

    public void setTransitionAnimations(Builder.TransitionAnimationBody transitionAnimations) {
        this.transitionAnimations = transitionAnimations;
    }

    public Builder.TransitionAnimationBody getTransitionAnimations() {
        return this.transitionAnimations;
    }

    public static interface PushBodyConsumer {
        public void push(PushBody var1);
    }

    public static class Builder {
        private String tag;
        private ControllerFragmentType fragmentType;
        private boolean addToBackStack = false;
        private boolean immediate = false;
        private PushBodyConsumer bodyConsumer;
        private TransitionAnimationBody transitionAnimation = null;

        @Contract(value="_ -> !null")
        public static Builder instance(@NonNull PushBodyConsumer bodyConsumer) {
            return new Builder(bodyConsumer);
        }

        public Builder(PushBodyConsumer bodyConsumer) {
            this.bodyConsumer = bodyConsumer;
        }

        public Builder addToBackStack(boolean toBackStack) {
            this.addToBackStack = toBackStack;
            return this;
        }

        public Builder fragment(ControllerFragmentType fragmentType) {
            this.fragment(fragmentType, fragmentType.getTag());
            return this;
        }

        public Builder fragment(ControllerFragmentType fragmentType, String tag) {
            this.fragmentType = fragmentType;
            this.tag = tag;
            return this;
        }

        public Builder withAnimation(boolean withAnimation) {
            this.transitionAnimation = withAnimation ? new TransitionAnimationBody() : null;
            return this;
        }

        public TransitionAnimationBody customAnimation() {
            return new TransitionAnimationBody();
        }

        public Builder immediate(boolean immediate) {
            this.immediate = immediate;
            return this;
        }

        public PushBody build() {
            if (this.fragmentType == null) {
                throw new IllegalStateException("FragmentType must not be null");
            }
            if (this.tag == null) {
                throw new IllegalStateException("Tag must not be null");
            }
            PushBody pushBody = new PushBody();
            pushBody.setFragmentType(this.fragmentType);
            pushBody.setTag(this.tag);
            pushBody.setAddToBackStack(this.addToBackStack);
            pushBody.setTransitionAnimations(this.transitionAnimation);
            pushBody.setImmediate(this.immediate);
            return pushBody;
        }

        public void push() {
            PushBody pushBody = this.build();
            this.bodyConsumer.push(pushBody);
        }

        private void setTransitionAnimation(TransitionAnimationBody transitionAnimation) {
            this.transitionAnimation = transitionAnimation;
        }

        public class TransitionAnimationBody {
            private int enter = R.anim.slide_in_right;
            private int exit = R.anim.slide_out_left;
            private int popEnter = 17432578;
            private int popExit = 17432579;

            public TransitionAnimationBody enter(int enter) {
                this.enter = enter;
                return this;
            }

            public TransitionAnimationBody exit(int exit) {
                this.exit = exit;
                return this;
            }

            public TransitionAnimationBody popEnter(int popEnter) {
                this.popEnter = popEnter;
                return this;
            }

            public TransitionAnimationBody popExit(int popExit) {
                this.popEnter = popExit;
                return this;
            }

            public Builder end() {
                Builder.this.setTransitionAnimation(this);
                return Builder.this;
            }

            public int getEnter() {
                return this.enter;
            }

            public int getExit() {
                return this.exit;
            }

            public int getPopEnter() {
                return this.popEnter;
            }

            public int getPopExit() {
                return this.popExit;
            }
        }
    }
}

