/*
 * Decompiled with CFR 0.152.
 */
package com.appolica.fragmentcontroller;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.appolica.fragmentcontroller.OnBackPressedListener;
import com.appolica.fragmentcontroller.PushBody;
import com.appolica.fragmentcontroller.R;
import com.appolica.fragmentcontroller.fragment.ControllerFragmentType;
import com.appolica.fragmentcontroller.fragment.FragmentTypeImpl;
import com.appolica.fragmentcontroller.fragment.animation.TransitionAnimationManager;
import com.appolica.fragmentcontroller.util.FragmentUtil;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Contract;

public class FragmentController
extends Fragment
implements PushBody.PushBodyConsumer,
OnBackPressedListener {
    public static final String ARG_ROOT_FRAGMENT = FragmentController.class.getName() + ":ArgRootFragment";
    public static final String ARG_ROOT_TAG = FragmentController.class.getName() + ":ArgRootTAG";

    public static FragmentController instance(ControllerFragmentType fragmentType) {
        FragmentController controller = new FragmentController();
        Bundle args = new Bundle();
        args.putSerializable(ARG_ROOT_FRAGMENT, fragmentType.getInstance().getClass());
        args.putString(ARG_ROOT_TAG, fragmentType.getTag());
        controller.setArguments(args);
        return controller;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ControllerFragmentType rootType = this.getRootFromArgs();
        this.addRoot(savedInstanceState, rootType);
        return inflater.inflate(R.layout.fragment_container, container, false);
    }

    private ControllerFragmentType getRootFromArgs() {
        Bundle arguments = this.getArguments();
        if (arguments == null || arguments.getSerializable(ARG_ROOT_FRAGMENT) == null || arguments.getString(ARG_ROOT_TAG) == null) {
            throw new IllegalStateException("Root fragment is not defined or tag not provided!");
        }
        Serializable serializedClass = arguments.getSerializable(ARG_ROOT_FRAGMENT);
        String tag = arguments.getString(ARG_ROOT_TAG);
        if (!(serializedClass instanceof Class)) {
            throw new IllegalStateException("You must provide provide root fragment of type Class<? extends Fragment>.");
        }
        Class rootClass = (Class)serializedClass;
        FragmentTypeImpl fragmentType = new FragmentTypeImpl(rootClass, tag);
        return fragmentType;
    }

    private void addRoot(Bundle savedInstanceState, ControllerFragmentType fragmentType) {
        if (savedInstanceState == null) {
            this.pushBody().addToBackStack(true).fragment(fragmentType).push();
        }
    }

    public PushBody.Builder pushBody() {
        return PushBody.Builder.instance(this);
    }

    @Override
    public void push(PushBody body) {
        PushBody.Builder.TransitionAnimationBody animations;
        FragmentManager fragmentManager = this.getChildFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        if (body.addToBackStack()) {
            fragmentTransaction.addToBackStack(body.getTag());
        }
        if ((animations = body.getTransitionAnimations()) != null) {
            fragmentTransaction.setCustomAnimations(animations.getEnter(), animations.getExit(), animations.getPopEnter(), animations.getPopExit());
        }
        fragmentTransaction.replace(R.id.fragmentPlace, body.getFragment(), body.getTag()).commit();
        if (body.immediate()) {
            fragmentManager.executePendingTransactions();
        }
    }

    public boolean pop(boolean withAnimation) {
        FragmentManager fragmentManager = this.getChildFragmentManager();
        this.disableLastEntryAnimation(withAnimation, fragmentManager);
        return fragmentManager.getBackStackEntryCount() != 1 && fragmentManager.popBackStackImmediate();
    }

    public void popAsync(boolean withAnimation) {
        FragmentManager fragmentManager = this.getChildFragmentManager();
        this.disableLastEntryAnimation(withAnimation, fragmentManager);
        if (fragmentManager.getBackStackEntryCount() != 1) {
            fragmentManager.popBackStack();
        }
    }

    private void disableLastEntryAnimation(boolean withAnimation, FragmentManager fragmentManager) {
        if (!withAnimation) {
            int lastEntry = fragmentManager.getBackStackEntryCount() - 1;
            String lastTag = this.getTagFromEntry(fragmentManager, lastEntry);
            this.disableNextAnimationTo(fragmentManager, lastTag);
        }
    }

    public boolean popTo(ControllerFragmentType fragmentType, boolean inclusive, boolean withAnimation) {
        FragmentManager fragmentManager = this.getChildFragmentManager();
        if (!withAnimation) {
            this.disableNextAnimationTo(fragmentManager, fragmentType.getTag());
        }
        int flag = this.getFlagInclusive(inclusive);
        return fragmentManager.popBackStackImmediate(fragmentType.getTag(), flag);
    }

    public void popToAsync(ControllerFragmentType fragmentType, boolean inclusive, boolean withAnimation) {
        FragmentManager fragmentManager = this.getChildFragmentManager();
        if (!withAnimation) {
            this.disableNextAnimationTo(fragmentManager, fragmentType.getTag());
        }
        int flag = this.getFlagInclusive(inclusive);
        fragmentManager.popBackStack(fragmentType.getTag(), flag);
    }

    @Contract(pure=true)
    private int getFlagInclusive(boolean inclusive) {
        int flag = 0;
        if (inclusive) {
            flag = 1;
        }
        return flag;
    }

    private String getTagFromEntry(FragmentManager fragmentManager, int entry) {
        return fragmentManager.getBackStackEntryAt(entry).getName();
    }

    private void disableNextAnimationTo(FragmentManager fragmentManager, String tag) {
        int entryCount = fragmentManager.getBackStackEntryCount();
        int lastEntry = entryCount - 1;
        String entryTag = null;
        for (int entry = lastEntry; !tag.equals(entryTag) || entry > 0; --entry) {
            entryTag = this.getTagFromEntry(fragmentManager, entry);
            Fragment fragment = fragmentManager.findFragmentByTag(entryTag);
            if (!(fragment instanceof TransitionAnimationManager)) continue;
            ((TransitionAnimationManager)fragment).disableNextAnimation();
        }
    }

    public boolean popToRoot() {
        FragmentManager fragmentManager = this.getChildFragmentManager();
        int entryCount = fragmentManager.getBackStackEntryCount();
        int lastEntry = entryCount == 0 ? 0 : entryCount - 1;
        boolean popped = false;
        for (int index = lastEntry; index > 0; --index) {
            fragmentManager.popBackStack();
        }
        fragmentManager.executePendingTransactions();
        return lastEntry > 0;
    }

    public void popToRootAsync() {
        int lastEntry;
        for (int index = lastEntry = (entryCount = (fragmentManager = this.getChildFragmentManager()).getBackStackEntryCount()) == 0 ? 0 : entryCount - 1; index > 0; --index) {
            FragmentManager fragmentManager;
            fragmentManager.popBackStack();
        }
    }

    @Override
    public boolean onBackPressed() {
        Fragment topFragment = this.getTopFragment();
        boolean handled = false;
        if (topFragment != null && topFragment instanceof OnBackPressedListener) {
            handled = ((OnBackPressedListener)topFragment).onBackPressed();
        }
        if (!handled) {
            handled = this.pop(true);
        }
        return handled;
    }

    @Nullable
    private Fragment getTopFragment() {
        List<Fragment> fragments = FragmentUtil.getFragments(this.getChildFragmentManager());
        int size = fragments.size();
        if (size > 0) {
            return fragments.get(size - 1);
        }
        return null;
    }
}

