/*
 * Decompiled with CFR 0.152.
 */
package com.appmattus.layercache;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import com.appmattus.layercache.Cache;
import com.appmattus.layercache.Encryption;
import com.appmattus.layercache.Fetcher;
import com.appmattus.layercache.OneWayTransform;
import com.appmattus.layercache.TwoWayTransform;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.aead.AesGcmKeyManager;
import com.google.crypto.tink.config.TinkConfig;
import com.google.crypto.tink.daead.AesSivKeyManager;
import com.google.crypto.tink.integration.android.AndroidKeysetManager;
import com.google.crypto.tink.subtle.Base64;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J&\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0018J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J0\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u00020\u00050\u0018\"\b\b\u0000\u0010 *\u00020\u00012\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u00020\u00050\u0018R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/appmattus/layercache/Encryption;", "", "context", "Landroid/content/Context;", "fileName", "", "keystoreAlias", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;)V", "aead", "Lcom/google/crypto/tink/Aead;", "getAead", "()Lcom/google/crypto/tink/Aead;", "aead$delegate", "Lkotlin/Lazy;", "deterministicAead", "Lcom/google/crypto/tink/DeterministicAead;", "getDeterministicAead", "()Lcom/google/crypto/tink/DeterministicAead;", "deterministicAead$delegate", "decryptValue", "encryptedValue", "associatedData", "", "encrypt", "Lcom/appmattus/layercache/Cache;", "cache", "encryptKey", "Lcom/appmattus/layercache/Encryption$EncryptedKey;", "key", "encryptValue", "value", "encryptValues", "Key", "Companion", "EncryptedKey", "layercache-android-encryption_release"})
final class Encryption {
    private final Lazy deterministicAead$delegate;
    private final Lazy aead$delegate;
    private final String fileName;
    @NotNull
    public static final String DEFAULT_MASTER_KEY_ALIAS = "_com_appmattus_layercache_master_key_";
    private static final String KEY_KEYSET_ALIAS = "__com_appmattus_layercache_android_encryption_key_keyset__";
    private static final String VALUE_KEYSET_ALIAS = "__com_appmattus_layercache_android_encryption_value_keyset__";
    public static final Companion Companion = new Companion(null);

    private final DeterministicAead getDeterministicAead() {
        Lazy lazy = this.deterministicAead$delegate;
        Encryption encryption = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DeterministicAead)lazy.getValue();
    }

    private final Aead getAead() {
        Lazy lazy = this.aead$delegate;
        Encryption encryption = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Aead)lazy.getValue();
    }

    private final EncryptedKey encryptKey(String key) {
        EncryptedKey encryptedKey;
        try {
            DeterministicAead deterministicAead2 = this.getDeterministicAead();
            String string = key;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            string = this.fileName;
            charset = Charsets.UTF_8;
            bl = false;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray3 = deterministicAead2.encryptDeterministically(byArray, byArray2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"deterministicAead.encryp\u2026ByteArray()\n            )");
            byte[] encryptedKeyBytes = byArray3;
            encryptedKey = new EncryptedKey(encryptedKeyBytes);
        }
        catch (GeneralSecurityException ex) {
            throw (Throwable)new SecurityException("Could not encrypt key. " + ex.getMessage(), ex);
        }
        return encryptedKey;
    }

    private final String encryptValue(String value, byte[] associatedData) {
        Object object = associatedData;
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = object;
        boolean bl3 = false;
        byte[] data = (byte[])(Build.VERSION.SDK_INT >= 21 ? object : null);
        Aead aead2 = this.getAead();
        object = value;
        Charset charset = Charsets.UTF_8;
        bl2 = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = ((String)object2).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string = Base64.encode((byte[])aead2.encrypt(byArray, data));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Base64.encode(aead.encry\u2026y(Charsets.UTF_8), data))");
        return string;
    }

    private final String decryptValue(String encryptedValue, byte[] associatedData) {
        byte[] byArray = associatedData;
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        byte[] data = (byte[])(Build.VERSION.SDK_INT >= 21 ? byArray : null);
        byte[] byArray2 = this.getAead().decrypt(Base64.decode((String)encryptedValue, (int)0), data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"aead.decrypt(Base64.deco\u2026e, Base64.DEFAULT), data)");
        byArray = byArray2;
        Charset charset = Charsets.UTF_8;
        bl2 = false;
        boolean bl4 = false;
        return new String(byArray, charset);
    }

    @NotNull
    public final Cache<String, String> encrypt(@NotNull Cache<String, String> cache) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        return (Cache)new Cache<String, String>(this, cache){
            final /* synthetic */ Encryption this$0;
            final /* synthetic */ Cache $cache;

            @Nullable
            public Object get(@NotNull String key, @NotNull Continuation<? super String> $completion) {
                return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, key, null){
                    private CoroutineScope p$;
                    Object L$0;
                    Object L$1;
                    int label;
                    final /* synthetic */ encrypt.1 this$0;
                    final /* synthetic */ String $key;

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                $this$withContext = this.p$;
                                encryptedKey = Encryption.access$encryptKey(this.this$0.this$0, this.$key);
                                this.L$0 = $this$withContext;
                                this.L$1 = encryptedKey;
                                this.label = 1;
                                v0 = this.this$0.$cache.get((Object)encryptedKey.getBase64(), (Continuation)this);
                                ** if (v0 != var10_2) goto lbl15
lbl14:
                                // 1 sources

                                return var10_2;
lbl15:
                                // 1 sources

                                ** GOTO lbl23
                            }
                            case 1: {
                                encryptedKey = (EncryptedKey)this.L$1;
                                $this$withContext = (CoroutineScope)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl23:
                                    // 2 sources

                                    v1 = encryptedValue = (String)v0;
                                    if (v1 != null) {
                                        var5_8 = v1;
                                        var6_9 = false;
                                        var7_10 = false;
                                        it = var5_8;
                                        $i$a$-let-Encryption$encrypt$1$get$2$1 = false;
                                        v2 = Encryption.access$decryptValue(this.this$0.this$0, encryptedValue, encryptedKey.getRawBytes());
                                    } else {
                                        v2 = null;
                                    }
                                    var3_5 = v2;
                                }
                                catch (Exception expected) {
                                    expected.printStackTrace();
                                    var3_5 = null;
                                }
                                return var3_5;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$key = string;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super String>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
            }

            @Nullable
            public Object set(@NotNull String key, @NotNull String value, @NotNull Continuation<? super Unit> $completion) {
                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, key, value, null){
                    private CoroutineScope p$;
                    Object L$0;
                    Object L$1;
                    int label;
                    final /* synthetic */ encrypt.1 this$0;
                    final /* synthetic */ String $key;
                    final /* synthetic */ String $value;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                CoroutineScope $this$withContext = this.p$;
                                EncryptedKey encryptedKey = Encryption.access$encryptKey(this.this$0.this$0, this.$key);
                                this.L$0 = $this$withContext;
                                this.L$1 = encryptedKey;
                                this.label = 1;
                                Object object2 = this.this$0.$cache.set((Object)encryptedKey.getBase64(), (Object)Encryption.access$encryptValue(this.this$0.this$0, this.$value, encryptedKey.getRawBytes()), (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                Object object2;
                                EncryptedKey encryptedKey = (EncryptedKey)this.L$1;
                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    object2 = $result;
                                    return Unit.INSTANCE;
                                }
                                catch (Exception expected) {
                                    expected.printStackTrace();
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$key = string;
                        this.$value = string2;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }

            @Nullable
            public Object evict(@NotNull String key, @NotNull Continuation<? super Unit> $completion) {
                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, key, null){
                    private CoroutineScope p$;
                    Object L$0;
                    int label;
                    final /* synthetic */ encrypt.1 this$0;
                    final /* synthetic */ String $key;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                CoroutineScope $this$withContext = this.p$;
                                this.L$0 = $this$withContext;
                                this.label = 1;
                                Object object2 = this.this$0.$cache.evict((Object)Encryption.access$encryptKey(this.this$0.this$0, this.$key).getBase64(), (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                Object object2;
                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    object2 = $result;
                                    return Unit.INSTANCE;
                                }
                                catch (Exception expected) {
                                    expected.printStackTrace();
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$key = string;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }

            @Nullable
            public Object evictAll(@NotNull Continuation<? super Unit> $completion) {
                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    private CoroutineScope p$;
                    Object L$0;
                    int label;
                    final /* synthetic */ encrypt.1 this$0;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                CoroutineScope $this$withContext = this.p$;
                                this.L$0 = $this$withContext;
                                this.label = 1;
                                Object object2 = this.this$0.$cache.evictAll((Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            {
                this.this$0 = this$0;
                this.$cache = $captured_local_variable$1;
            }

            @Nullable
            public Object batchGet(@NotNull List<String> keys, @NotNull Continuation<? super List<String>> continuation) {
                return Cache.DefaultImpls.batchGet((Cache)this, keys, continuation);
            }

            @Nullable
            public Object batchSet(@NotNull Map<String, String> values, @NotNull Continuation<? super Unit> continuation) {
                return Cache.DefaultImpls.batchSet((Cache)this, values, continuation);
            }

            @NotNull
            public Cache<String, String> compose(@NonNull @NotNull Cache<String, String> b) {
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return Cache.DefaultImpls.compose((Cache)this, b);
            }

            @NotNull
            public <MappedKey> Cache<MappedKey, String> keyTransform(@NotNull Function1<? super MappedKey, String> transform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                return Cache.DefaultImpls.keyTransform((Cache)this, transform);
            }

            @NotNull
            public <MappedKey> Cache<MappedKey, String> keyTransform(@NotNull OneWayTransform<MappedKey, String> transform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                return Cache.DefaultImpls.keyTransform((Cache)this, transform);
            }

            @NotNull
            public Cache<String, String> plus(@NotNull Cache<String, String> b) {
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return Cache.DefaultImpls.plus((Cache)this, b);
            }

            @NotNull
            public Cache<String, String> reuseInflight() {
                return Cache.DefaultImpls.reuseInflight((Cache)this);
            }

            @NotNull
            public <MappedValue> Fetcher<String, MappedValue> valueTransform(@NotNull Function1<? super String, ? extends MappedValue> transform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                return Cache.DefaultImpls.valueTransform((Cache)this, transform);
            }

            @NotNull
            public <MappedValue> Cache<String, MappedValue> valueTransform(@NotNull Function1<? super String, ? extends MappedValue> transform, @NotNull Function1<? super MappedValue, String> inverseTransform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                Intrinsics.checkNotNullParameter(inverseTransform, (String)"inverseTransform");
                return Cache.DefaultImpls.valueTransform((Cache)this, transform, inverseTransform);
            }

            @NotNull
            public <MappedValue> Fetcher<String, MappedValue> valueTransform(@NotNull OneWayTransform<String, MappedValue> transform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                return Cache.DefaultImpls.valueTransform((Cache)this, transform);
            }

            @NotNull
            public <MappedValue> Cache<String, MappedValue> valueTransform(@NotNull TwoWayTransform<String, MappedValue> transform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                return Cache.DefaultImpls.valueTransform((Cache)this, transform);
            }
        };
    }

    @NotNull
    public final <Key> Cache<Key, String> encryptValues(@NotNull Cache<Key, String> cache) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        return new Cache<Key, String>(this, cache){
            final /* synthetic */ Encryption this$0;
            final /* synthetic */ Cache $cache;

            @Nullable
            public Object get(@NotNull Key key, @NotNull Continuation<? super String> $completion) {
                return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, key, null){
                    private CoroutineScope p$;
                    Object L$0;
                    int label;
                    final /* synthetic */ encryptValues.1 this$0;
                    final /* synthetic */ Object $key;

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                $this$withContext = this.p$;
                                this.L$0 = $this$withContext;
                                this.label = 1;
                                v0 = this.this$0.$cache.get(this.$key, (Continuation)this);
                                ** if (v0 != var13_2) goto lbl13
lbl12:
                                // 1 sources

                                return var13_2;
lbl13:
                                // 1 sources

                                ** GOTO lbl20
                            }
                            case 1: {
                                $this$withContext = (CoroutineScope)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl20:
                                    // 2 sources

                                    v1 = (String)v0;
                                    if (v1 != null) {
                                        var3_5 = v1;
                                        var4_6 = false;
                                        var5_8 = false;
                                        it = var3_5;
                                        $i$a$-let-Encryption$encryptValues$1$get$2$1 = false;
                                        var9_12 = var8_11 = StringsKt.split$default((CharSequence)it, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                                        var10_13 = false;
                                        var11_14 = (String)var9_12.get(0);
                                        var9_12 = var8_11;
                                        var10_13 = false;
                                        salt = (String)var9_12.get(1);
                                        v2 = this.this$0.this$0;
                                        v3 = Base64.decode((String)salt);
                                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"Base64.decode(salt)");
                                        v4 = Encryption.access$decryptValue(v2, (String)encryptedValue, v3);
                                    } else {
                                        v4 = null;
                                    }
                                    var3_5 = v4;
                                }
                                catch (Exception expected) {
                                    expected.printStackTrace();
                                    var3_5 = null;
                                }
                                return var3_5;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$key = object;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super String>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
            }

            @Nullable
            public Object set(@NotNull Key key, @NotNull String value, @NotNull Continuation<? super Unit> $completion) {
                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, key, value, null){
                    private CoroutineScope p$;
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int label;
                    final /* synthetic */ encryptValues.1 this$0;
                    final /* synthetic */ Object $key;
                    final /* synthetic */ String $value;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                CoroutineScope $this$withContext = this.p$;
                                SecureRandom secureRandom = new SecureRandom();
                                byte[] salt = new byte[16];
                                secureRandom.nextBytes(salt);
                                this.L$0 = $this$withContext;
                                this.L$1 = secureRandom;
                                this.L$2 = salt;
                                this.label = 1;
                                Object object2 = this.this$0.$cache.set(this.$key, (Object)(Encryption.access$encryptValue(this.this$0.this$0, this.$value, salt) + ":" + Base64.encode((byte[])salt)), (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                Object object2;
                                byte[] salt = (byte[])this.L$2;
                                SecureRandom secureRandom = (SecureRandom)this.L$1;
                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    object2 = $result;
                                    return Unit.INSTANCE;
                                }
                                catch (Exception expected) {
                                    expected.printStackTrace();
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$key = object;
                        this.$value = string;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }

            @Nullable
            public Object evict(@NotNull Key key, @NotNull Continuation<? super Unit> $completion) {
                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, key, null){
                    private CoroutineScope p$;
                    Object L$0;
                    int label;
                    final /* synthetic */ encryptValues.1 this$0;
                    final /* synthetic */ Object $key;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                CoroutineScope $this$withContext = this.p$;
                                this.L$0 = $this$withContext;
                                this.label = 1;
                                Object object2 = this.this$0.$cache.evict(this.$key, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$key = object;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }

            @Nullable
            public Object evictAll(@NotNull Continuation<? super Unit> $completion) {
                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    private CoroutineScope p$;
                    Object L$0;
                    int label;
                    final /* synthetic */ encryptValues.1 this$0;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                CoroutineScope $this$withContext = this.p$;
                                this.L$0 = $this$withContext;
                                this.label = 1;
                                Object object2 = this.this$0.$cache.evictAll((Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            {
                this.this$0 = this$0;
                this.$cache = $captured_local_variable$1;
            }

            @Nullable
            public Object batchGet(@NotNull List<? extends Key> keys, @NotNull Continuation<? super List<String>> continuation) {
                return Cache.DefaultImpls.batchGet((Cache)this, keys, continuation);
            }

            @Nullable
            public Object batchSet(@NotNull Map<Key, String> values, @NotNull Continuation<? super Unit> continuation) {
                return Cache.DefaultImpls.batchSet((Cache)this, values, continuation);
            }

            @NotNull
            public Cache<Key, String> compose(@NonNull @NotNull Cache<Key, String> b) {
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return Cache.DefaultImpls.compose((Cache)this, b);
            }

            @NotNull
            public <MappedKey> Cache<MappedKey, String> keyTransform(@NotNull Function1<? super MappedKey, ? extends Key> transform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                return Cache.DefaultImpls.keyTransform((Cache)this, transform);
            }

            @NotNull
            public <MappedKey> Cache<MappedKey, String> keyTransform(@NotNull OneWayTransform<MappedKey, Key> transform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                return Cache.DefaultImpls.keyTransform((Cache)this, transform);
            }

            @NotNull
            public Cache<Key, String> plus(@NotNull Cache<Key, String> b) {
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return Cache.DefaultImpls.plus((Cache)this, b);
            }

            @NotNull
            public Cache<Key, String> reuseInflight() {
                return Cache.DefaultImpls.reuseInflight((Cache)this);
            }

            @NotNull
            public <MappedValue> Fetcher<Key, MappedValue> valueTransform(@NotNull Function1<? super String, ? extends MappedValue> transform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                return Cache.DefaultImpls.valueTransform((Cache)this, transform);
            }

            @NotNull
            public <MappedValue> Cache<Key, MappedValue> valueTransform(@NotNull Function1<? super String, ? extends MappedValue> transform, @NotNull Function1<? super MappedValue, String> inverseTransform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                Intrinsics.checkNotNullParameter(inverseTransform, (String)"inverseTransform");
                return Cache.DefaultImpls.valueTransform((Cache)this, transform, inverseTransform);
            }

            @NotNull
            public <MappedValue> Fetcher<Key, MappedValue> valueTransform(@NotNull OneWayTransform<String, MappedValue> transform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                return Cache.DefaultImpls.valueTransform((Cache)this, transform);
            }

            @NotNull
            public <MappedValue> Cache<Key, MappedValue> valueTransform(@NotNull TwoWayTransform<String, MappedValue> transform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                return Cache.DefaultImpls.valueTransform((Cache)this, transform);
            }
        };
    }

    public Encryption(@NotNull Context context, @NotNull String fileName, @NotNull String keystoreAlias) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)keystoreAlias, (String)"keystoreAlias");
        this.fileName = fileName;
        this.deterministicAead$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DeterministicAead>(this, context, keystoreAlias){
            final /* synthetic */ Encryption this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $keystoreAlias;

            public final DeterministicAead invoke() {
                AndroidKeysetManager androidKeysetManager = new AndroidKeysetManager.Builder().withKeyTemplate(AesSivKeyManager.aes256SivTemplate()).withSharedPref(this.$context, "__com_appmattus_layercache_android_encryption_key_keyset__", Encryption.access$getFileName$p(this.this$0)).withMasterKeyUri("android-keystore://" + this.$keystoreAlias).build();
                Intrinsics.checkNotNullExpressionValue((Object)androidKeysetManager, (String)"AndroidKeysetManager.Bui\u2026ias)\n            .build()");
                KeysetHandle keysetHandle = androidKeysetManager.getKeysetHandle();
                Intrinsics.checkNotNullExpressionValue((Object)keysetHandle, (String)"AndroidKeysetManager.Bui\u2026    .build().keysetHandle");
                KeysetHandle daeadKeysetHandle = keysetHandle;
                return (DeterministicAead)daeadKeysetHandle.getPrimitive(DeterministicAead.class);
            }
            {
                this.this$0 = encryption;
                this.$context = context;
                this.$keystoreAlias = string;
                super(0);
            }
        }));
        this.aead$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Aead>(this, context, keystoreAlias){
            final /* synthetic */ Encryption this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $keystoreAlias;

            public final Aead invoke() {
                AndroidKeysetManager androidKeysetManager = new AndroidKeysetManager.Builder().withKeyTemplate(AesGcmKeyManager.aes256GcmTemplate()).withSharedPref(this.$context, "__com_appmattus_layercache_android_encryption_value_keyset__", Encryption.access$getFileName$p(this.this$0)).withMasterKeyUri("android-keystore://" + this.$keystoreAlias).build();
                Intrinsics.checkNotNullExpressionValue((Object)androidKeysetManager, (String)"AndroidKeysetManager.Bui\u2026ias)\n            .build()");
                KeysetHandle keysetHandle = androidKeysetManager.getKeysetHandle();
                Intrinsics.checkNotNullExpressionValue((Object)keysetHandle, (String)"AndroidKeysetManager.Bui\u2026    .build().keysetHandle");
                KeysetHandle aeadKeysetHandle = keysetHandle;
                return (Aead)aeadKeysetHandle.getPrimitive(Aead.class);
            }
            {
                this.this$0 = encryption;
                this.$context = context;
                this.$keystoreAlias = string;
                super(0);
            }
        }));
        TinkConfig.register();
    }

    public static final /* synthetic */ EncryptedKey access$encryptKey(Encryption $this, String key) {
        return $this.encryptKey(key);
    }

    public static final /* synthetic */ String access$decryptValue(Encryption $this, String encryptedValue, byte[] associatedData) {
        return $this.decryptValue(encryptedValue, associatedData);
    }

    public static final /* synthetic */ String access$encryptValue(Encryption $this, String value, byte[] associatedData) {
        return $this.encryptValue(value, associatedData);
    }

    public static final /* synthetic */ String access$getFileName$p(Encryption $this) {
        return $this.fileName;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/appmattus/layercache/Encryption$EncryptedKey;", "", "rawBytes", "", "([B)V", "base64", "", "getBase64", "()Ljava/lang/String;", "getRawBytes", "()[B", "layercache-android-encryption_release"})
    public static final class EncryptedKey {
        @NotNull
        private final byte[] rawBytes;

        @NotNull
        public final String getBase64() {
            String string = Base64.encode((byte[])this.rawBytes);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Base64.encode(rawBytes)");
            return string;
        }

        @NotNull
        public final byte[] getRawBytes() {
            return this.rawBytes;
        }

        public EncryptedKey(@NotNull byte[] rawBytes) {
            Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
            this.rawBytes = rawBytes;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/appmattus/layercache/Encryption$Companion;", "", "()V", "DEFAULT_MASTER_KEY_ALIAS", "", "KEY_KEYSET_ALIAS", "VALUE_KEYSET_ALIAS", "layercache-android-encryption_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

