/*
 * Decompiled with CFR 0.152.
 */
package com.appmattus.layercache.encryption;

import android.content.Context;
import android.os.Build;
import android.preference.PreferenceManager;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.RequiresApi;
import com.appmattus.layercache.encryption.AesKeyCompat;
import com.appmattus.layercache.encryption.Base64ExtKt;
import com.appmattus.layercache.encryption.BlockMode;
import com.appmattus.layercache.encryption.EncryptionPadding;
import com.appmattus.layercache.encryption.IntegrityCheck;
import com.appmattus.layercache.encryption.KeyProperties;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0001\u0018\u0000  2\u00020\u0001:\u0004\u001d\u001e\u001f B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/appmattus/layercache/encryption/AesKeyCompat;", "", "context", "Landroid/content/Context;", "blockMode", "Lcom/appmattus/layercache/encryption/BlockMode;", "encryptionPadding", "Lcom/appmattus/layercache/encryption/EncryptionPadding;", "providesIv", "", "integrityCheck", "Lcom/appmattus/layercache/encryption/IntegrityCheck;", "(Landroid/content/Context;Lcom/appmattus/layercache/encryption/BlockMode;Lcom/appmattus/layercache/encryption/EncryptionPadding;ZLcom/appmattus/layercache/encryption/IntegrityCheck;)V", "keyStore", "Ljava/security/KeyStore;", "kotlin.jvm.PlatformType", "getKeyStore", "()Ljava/security/KeyStore;", "keyStore$delegate", "Lkotlin/Lazy;", "mImpl", "Lcom/appmattus/layercache/encryption/AesKeyCompat$AESKey;", "retrieveConfidentialityKey", "Ljavax/crypto/SecretKey;", "keystoreAlias", "", "retrieveConfidentialityKey$layercache_android_encryption_release", "retrieveIntegrityKey", "retrieveIntegrityKey$layercache_android_encryption_release", "AESKey", "AESKeyApi23", "AesKeyBase", "Companion", "layercache-android-encryption_release"})
@RequiresApi(value=18)
public final class AesKeyCompat {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private AESKey mImpl;
    private final Lazy keyStore$delegate;
    private final Context context;
    private final BlockMode blockMode;
    private final EncryptionPadding encryptionPadding;
    private final boolean providesIv;
    private final IntegrityCheck integrityCheck;
    @NotNull
    private static final String RSA_MODE = "RSA/ECB/PKCS1Padding";
    @NotNull
    private static final String ANDROID_KEYSTORE_PROVIDER = "AndroidKeyStore";
    @NotNull
    private static final String ANDROID_OPEN_SSL_PROVIDER = "AndroidOpenSSL";
    @NotNull
    private static final String AES_ALGORITHM = "AES";
    @Deprecated
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AesKeyCompat.class), "keyStore", "getKeyStore()Ljava/security/KeyStore;"))};
        Companion = new Companion(null);
        RSA_MODE = RSA_MODE;
        ANDROID_KEYSTORE_PROVIDER = ANDROID_KEYSTORE_PROVIDER;
        ANDROID_OPEN_SSL_PROVIDER = ANDROID_OPEN_SSL_PROVIDER;
        AES_ALGORITHM = AES_ALGORITHM;
    }

    private final KeyStore getKeyStore() {
        Lazy lazy = this.keyStore$delegate;
        AesKeyCompat aesKeyCompat = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (KeyStore)lazy.getValue();
    }

    @NotNull
    public final SecretKey retrieveConfidentialityKey$layercache_android_encryption_release(@NotNull String keystoreAlias) {
        Intrinsics.checkParameterIsNotNull((Object)keystoreAlias, (String)"keystoreAlias");
        return this.mImpl.retrieveConfidentialityKey(keystoreAlias);
    }

    @NotNull
    public final SecretKey retrieveIntegrityKey$layercache_android_encryption_release(@NotNull String keystoreAlias) {
        Intrinsics.checkParameterIsNotNull((Object)keystoreAlias, (String)"keystoreAlias");
        return this.mImpl.retrieveIntegrityKey(keystoreAlias);
    }

    public AesKeyCompat(@NotNull Context context, @NotNull BlockMode blockMode, @NotNull EncryptionPadding encryptionPadding, boolean providesIv, @NotNull IntegrityCheck integrityCheck) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)blockMode), (String)"blockMode");
        Intrinsics.checkParameterIsNotNull((Object)((Object)encryptionPadding), (String)"encryptionPadding");
        Intrinsics.checkParameterIsNotNull((Object)((Object)integrityCheck), (String)"integrityCheck");
        this.context = context;
        this.blockMode = blockMode;
        this.encryptionPadding = encryptionPadding;
        this.providesIv = providesIv;
        this.integrityCheck = integrityCheck;
        this.keyStore$delegate = LazyKt.lazy((Function0)keyStore.2.INSTANCE);
        if (Build.VERSION.SDK_INT >= 23) {
            this.mImpl = new AESKeyApi23();
        } else if (Build.VERSION.SDK_INT >= 18) {
            this.mImpl = new AesKeyBase();
        } else {
            throw (Throwable)new IllegalStateException("Requires API 18 or higher");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/appmattus/layercache/encryption/AesKeyCompat$AESKey;", "", "retrieveConfidentialityKey", "Ljavax/crypto/SecretKey;", "keystoreAlias", "", "retrieveIntegrityKey", "layercache-android-encryption_release"})
    private static interface AESKey {
        @NotNull
        public SecretKey retrieveConfidentialityKey(@NotNull String var1);

        @NotNull
        public SecretKey retrieveIntegrityKey(@NotNull String var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/appmattus/layercache/encryption/AesKeyCompat$AesKeyBase;", "Lcom/appmattus/layercache/encryption/AesKeyCompat$AESKey;", "(Lcom/appmattus/layercache/encryption/AesKeyCompat;)V", "generateConfidentialityKey", "Ljavax/crypto/SecretKey;", "alias", "", "generateIntegrityKey", "generateRSAKeys", "Ljava/security/KeyPair;", "keystoreAlias", "loadConfidentialityKey", "loadIntegrityKey", "loadRSAKeys", "retrieveConfidentialityKey", "retrieveIntegrityKey", "retrieveRSAKeys", "rsaDecrypt", "", "encrypted", "rsaEncrypt", "secret", "layercache-android-encryption_release"})
    @RequiresApi(value=18)
    private final class AesKeyBase
    implements AESKey {
        private final KeyPair retrieveRSAKeys(String keystoreAlias) {
            String rsaKeyAlias = keystoreAlias + ":rsa";
            KeyPair keyPair = this.loadRSAKeys(rsaKeyAlias);
            if (keyPair == null) {
                keyPair = this.generateRSAKeys(rsaKeyAlias);
            }
            return keyPair;
        }

        private final KeyPair loadRSAKeys(String keystoreAlias) {
            KeyPair keyPair;
            KeyStore.Entry entry = AesKeyCompat.this.getKeyStore().getEntry(keystoreAlias, null);
            if (!(entry instanceof KeyStore.PrivateKeyEntry)) {
                entry = null;
            }
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
            if (privateKeyEntry != null) {
                KeyStore.PrivateKeyEntry privateKeyEntry2;
                KeyStore.PrivateKeyEntry it = privateKeyEntry2 = privateKeyEntry;
                Certificate certificate = it.getCertificate();
                Intrinsics.checkExpressionValueIsNotNull((Object)certificate, (String)"it.certificate");
                keyPair = new KeyPair(certificate.getPublicKey(), it.getPrivateKey());
            } else {
                keyPair = null;
            }
            return keyPair;
        }

        private final KeyPair generateRSAKeys(String keystoreAlias) {
            KeyPairGenerator keyPairGenerator;
            Calendar calendar;
            Calendar start = Calendar.getInstance();
            Calendar $receiver = calendar = Calendar.getInstance();
            $receiver.add(1, 50);
            Calendar end = calendar;
            KeyPairGeneratorSpec.Builder specBuilder = new KeyPairGeneratorSpec.Builder(AesKeyCompat.this.context).setAlias(keystoreAlias).setEndDate(end.getTime()).setStartDate(start.getTime()).setSerialNumber(BigInteger.ONE).setSubject(new X500Principal("CN=" + keystoreAlias));
            if (Build.VERSION.SDK_INT >= 19) {
                specBuilder.setKeySize(2048).setKeyType(KeyProperties.INSTANCE.getKEY_ALGORITHM_RSA());
            }
            KeyPairGenerator $receiver2 = keyPairGenerator = KeyPairGenerator.getInstance(KeyProperties.INSTANCE.getKEY_ALGORITHM_RSA(), Companion.getANDROID_KEYSTORE_PROVIDER());
            $receiver2.initialize((AlgorithmParameterSpec)specBuilder.build());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Intrinsics.checkExpressionValueIsNotNull((Object)keyPair, (String)"KeyPairGenerator.getInst\u2026      }.generateKeyPair()");
            return keyPair;
        }

        private final byte[] rsaEncrypt(String keystoreAlias, byte[] secret) throws Exception {
            KeyPair secretKey = this.retrieveRSAKeys(keystoreAlias);
            Cipher cipher = Cipher.getInstance(Companion.getRSA_MODE(), Companion.getANDROID_OPEN_SSL_PROVIDER());
            cipher.init(1, secretKey.getPublic());
            byte[] byArray = cipher.doFinal(secret);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(secret)");
            return byArray;
        }

        private final byte[] rsaDecrypt(String keystoreAlias, byte[] encrypted) {
            KeyPair secretKey = this.retrieveRSAKeys(keystoreAlias);
            Cipher cipher = Cipher.getInstance(Companion.getRSA_MODE(), Companion.getANDROID_OPEN_SSL_PROVIDER());
            cipher.init(2, secretKey.getPrivate());
            byte[] byArray = cipher.doFinal(encrypted);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(encrypted)");
            return byArray;
        }

        private final SecretKey generateConfidentialityKey(String alias) {
            Object object;
            Object $receiver = object = KeyGenerator.getInstance(Companion.getAES_ALGORITHM());
            ((KeyGenerator)$receiver).init(256, new SecureRandom());
            Object object2 = $receiver = (object = ((KeyGenerator)object).generateKey());
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"this");
            byte[] byArray = object2.getEncoded();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"this.encoded");
            String encryptedKey = Base64ExtKt.encodeBase64(this.rsaEncrypt(alias, byArray));
            PreferenceManager.getDefaultSharedPreferences((Context)AesKeyCompat.this.context).edit().putString(alias + ":confidentiality", encryptedKey).apply();
            Object object3 = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"KeyGenerator.getInstance\u2026ey).apply()\n            }");
            return object3;
        }

        private final SecretKey loadConfidentialityKey(String alias) {
            SecretKeySpec secretKeySpec;
            KeyStore.Entry entry = AesKeyCompat.this.getKeyStore().getEntry(alias + ":rsa", null);
            if (entry != null) {
                KeyStore.Entry entry2;
                KeyStore.Entry it = entry2 = entry;
                String string = PreferenceManager.getDefaultSharedPreferences((Context)AesKeyCompat.this.context).getString(alias + ":confidentiality", null);
                if (string != null) {
                    String string2;
                    String it2 = string2 = string;
                    secretKeySpec = new SecretKeySpec(this.rsaDecrypt(alias, Base64ExtKt.decodeBase64(it2)), Companion.getAES_ALGORITHM());
                } else {
                    secretKeySpec = null;
                }
            } else {
                secretKeySpec = null;
            }
            return secretKeySpec;
        }

        @Override
        @NotNull
        public SecretKey retrieveConfidentialityKey(@NotNull String keystoreAlias) {
            Intrinsics.checkParameterIsNotNull((Object)keystoreAlias, (String)"keystoreAlias");
            SecretKey secretKey = this.loadConfidentialityKey(keystoreAlias);
            if (secretKey == null) {
                secretKey = this.generateConfidentialityKey(keystoreAlias);
            }
            return secretKey;
        }

        @Override
        @NotNull
        public SecretKey retrieveIntegrityKey(@NotNull String keystoreAlias) {
            Intrinsics.checkParameterIsNotNull((Object)keystoreAlias, (String)"keystoreAlias");
            SecretKey secretKey = this.loadIntegrityKey(keystoreAlias);
            if (secretKey == null) {
                secretKey = this.generateIntegrityKey(keystoreAlias);
            }
            return secretKey;
        }

        private final SecretKey loadIntegrityKey(String alias) {
            SecretKeySpec secretKeySpec;
            KeyStore.Entry entry = AesKeyCompat.this.getKeyStore().getEntry(alias + ":rsa", null);
            if (entry != null) {
                KeyStore.Entry entry2;
                KeyStore.Entry it = entry2 = entry;
                String string = PreferenceManager.getDefaultSharedPreferences((Context)AesKeyCompat.this.context).getString(alias + ":integrity", null);
                if (string != null) {
                    String string2;
                    String it2 = string2 = string;
                    secretKeySpec = new SecretKeySpec(this.rsaDecrypt(alias, Base64ExtKt.decodeBase64(it2)), Companion.getAES_ALGORITHM());
                } else {
                    secretKeySpec = null;
                }
            } else {
                secretKeySpec = null;
            }
            return secretKeySpec;
        }

        private final SecretKey generateIntegrityKey(String alias) {
            SecretKey secretKey;
            SecretKey $receiver;
            SecretKey secretKey2 = $receiver = (secretKey = KeyGenerator.getInstance(AesKeyCompat.this.integrityCheck.getAlgorithm()).generateKey());
            Intrinsics.checkExpressionValueIsNotNull((Object)secretKey2, (String)"this");
            byte[] byArray = secretKey2.getEncoded();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"this.encoded");
            String encryptedKey = Base64ExtKt.encodeBase64(this.rsaEncrypt(alias, byArray));
            PreferenceManager.getDefaultSharedPreferences((Context)AesKeyCompat.this.context).edit().putString(alias + ":integrity", encryptedKey).apply();
            SecretKey secretKey3 = secretKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)secretKey3, (String)"KeyGenerator.getInstance\u2026ey).apply()\n            }");
            return secretKey3;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/appmattus/layercache/encryption/AesKeyCompat$AESKeyApi23;", "Lcom/appmattus/layercache/encryption/AesKeyCompat$AESKey;", "(Lcom/appmattus/layercache/encryption/AesKeyCompat;)V", "generateConfidentialityKey", "Ljavax/crypto/SecretKey;", "alias", "", "generateIntegrityKey", "loadSecretKey", "keystoreAlias", "retrieveConfidentialityKey", "retrieveIntegrityKey", "layercache-android-encryption_release"})
    @RequiresApi(value=23)
    private final class AESKeyApi23
    implements AESKey {
        @Override
        @NotNull
        public SecretKey retrieveConfidentialityKey(@NotNull String keystoreAlias) {
            Intrinsics.checkParameterIsNotNull((Object)keystoreAlias, (String)"keystoreAlias");
            String confidentialityKeyAlias = keystoreAlias + ":confidentiality";
            SecretKey secretKey = this.loadSecretKey(confidentialityKeyAlias);
            if (secretKey == null) {
                secretKey = this.generateConfidentialityKey(confidentialityKeyAlias);
            }
            return secretKey;
        }

        private final SecretKey generateConfidentialityKey(String alias) {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(AesKeyCompat.AES_ALGORITHM, Companion.getANDROID_KEYSTORE_PROVIDER());
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(alias, 3).setBlockModes(new String[]{AesKeyCompat.this.blockMode.getMode()}).setEncryptionPaddings(new String[]{AesKeyCompat.this.encryptionPadding.getPadding()}).setRandomizedEncryptionRequired(!AesKeyCompat.this.providesIv);
            if (Build.VERSION.SDK_INT > 24) {
                builder.setInvalidatedByBiometricEnrollment(false);
            }
            keyGenerator.init((AlgorithmParameterSpec)builder.build());
            SecretKey secretKey = keyGenerator.generateKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)secretKey, (String)"keyGenerator.generateKey()");
            return secretKey;
        }

        private final SecretKey loadSecretKey(String keystoreAlias) {
            KeyStore.Entry entry = AesKeyCompat.this.getKeyStore().getEntry(keystoreAlias, null);
            if (entry instanceof KeyStore.SecretKeyEntry) {
                return ((KeyStore.SecretKeyEntry)entry).getSecretKey();
            }
            return null;
        }

        @Override
        @NotNull
        public SecretKey retrieveIntegrityKey(@NotNull String keystoreAlias) {
            Intrinsics.checkParameterIsNotNull((Object)keystoreAlias, (String)"keystoreAlias");
            String integrityKeyAlias = keystoreAlias + ":integrity";
            SecretKey secretKey = this.loadSecretKey(integrityKeyAlias);
            if (secretKey == null) {
                secretKey = this.generateIntegrityKey(integrityKeyAlias);
            }
            return secretKey;
        }

        private final SecretKey generateIntegrityKey(String alias) {
            KeyGenerator keyGen = KeyGenerator.getInstance(AesKeyCompat.this.integrityCheck.getAlgorithm(), Companion.getANDROID_KEYSTORE_PROVIDER());
            keyGen.init((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(alias, 4).build());
            SecretKey secretKey = keyGen.generateKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)secretKey, (String)"keyGen.generateKey()");
            return secretKey;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/appmattus/layercache/encryption/AesKeyCompat$Companion;", "", "()V", "AES_ALGORITHM", "", "getAES_ALGORITHM", "()Ljava/lang/String;", "ANDROID_KEYSTORE_PROVIDER", "getANDROID_KEYSTORE_PROVIDER", "ANDROID_OPEN_SSL_PROVIDER", "getANDROID_OPEN_SSL_PROVIDER", "RSA_MODE", "getRSA_MODE", "layercache-android-encryption_release"})
    private static final class Companion {
        @NotNull
        public final String getRSA_MODE() {
            return RSA_MODE;
        }

        @NotNull
        public final String getANDROID_KEYSTORE_PROVIDER() {
            return ANDROID_KEYSTORE_PROVIDER;
        }

        @NotNull
        public final String getANDROID_OPEN_SSL_PROVIDER() {
            return ANDROID_OPEN_SSL_PROVIDER;
        }

        @NotNull
        public final String getAES_ALGORITHM() {
            return AES_ALGORITHM;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

