/*
 * Decompiled with CFR 0.152.
 */
package com.appmattus.layercache.encryption;

import android.content.Context;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.appmattus.layercache.encryption.BlockMode;
import com.appmattus.layercache.encryption.EncryptionBase;
import com.appmattus.layercache.encryption.EncryptionPadding;
import com.appmattus.layercache.encryption.IntegrityCheck;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/appmattus/layercache/encryption/AesCbcPkcs7PaddingWithHmacSha256;", "Lcom/appmattus/layercache/encryption/EncryptionBase;", "context", "Landroid/content/Context;", "keystoreAlias", "", "(Landroid/content/Context;Ljava/lang/String;)V", "blockMode", "Lcom/appmattus/layercache/encryption/BlockMode;", "getBlockMode", "()Lcom/appmattus/layercache/encryption/BlockMode;", "encryptionPadding", "Lcom/appmattus/layercache/encryption/EncryptionPadding;", "getEncryptionPadding", "()Lcom/appmattus/layercache/encryption/EncryptionPadding;", "integrityCheck", "Lcom/appmattus/layercache/encryption/IntegrityCheck;", "getIntegrityCheck", "()Lcom/appmattus/layercache/encryption/IntegrityCheck;", "generateIv", "Ljava/security/spec/AlgorithmParameterSpec;", "generateSpec", "injectionVector", "", "providesIv", "", "layercache-android-encryption_release"})
@RequiresApi(value=18)
public final class AesCbcPkcs7PaddingWithHmacSha256
extends EncryptionBase {
    @NotNull
    private final IntegrityCheck integrityCheck;
    @NotNull
    private final BlockMode blockMode;
    @NotNull
    private final EncryptionPadding encryptionPadding;

    @Override
    @NotNull
    protected IntegrityCheck getIntegrityCheck() {
        return this.integrityCheck;
    }

    @Override
    @NotNull
    protected BlockMode getBlockMode() {
        return this.blockMode;
    }

    @Override
    @NotNull
    protected EncryptionPadding getEncryptionPadding() {
        return this.encryptionPadding;
    }

    @Override
    protected boolean providesIv() {
        return true;
    }

    @Override
    @NotNull
    protected AlgorithmParameterSpec generateIv() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] randomBytes = new byte[16];
        secureRandom.nextBytes(randomBytes);
        return new IvParameterSpec(randomBytes);
    }

    @Override
    @NotNull
    protected AlgorithmParameterSpec generateSpec(@NotNull byte[] injectionVector) {
        Intrinsics.checkParameterIsNotNull((Object)injectionVector, (String)"injectionVector");
        return new IvParameterSpec(injectionVector);
    }

    public AesCbcPkcs7PaddingWithHmacSha256(@NotNull Context context, @NotNull String keystoreAlias) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)keystoreAlias, (String)"keystoreAlias");
        super(context, keystoreAlias);
        if (Build.VERSION.SDK_INT < 18) {
            throw (Throwable)new IllegalStateException("CBC requires API 18 or higher");
        }
        this.integrityCheck = IntegrityCheck.HMAC_SHA256;
        this.blockMode = BlockMode.CBC;
        this.encryptionPadding = EncryptionPadding.PKCS7;
    }
}

