/*
 * Decompiled with CFR 0.152.
 */
package com.appmattus.layercache.encryption;

import android.content.Context;
import android.support.annotation.RequiresApi;
import com.appmattus.layercache.encryption.AesKeyCompat;
import com.appmattus.layercache.encryption.Base64ExtKt;
import com.appmattus.layercache.encryption.BlockMode;
import com.appmattus.layercache.encryption.Encryption;
import com.appmattus.layercache.encryption.EncryptionPadding;
import com.appmattus.layercache.encryption.IntegrityCheck;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b!\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005J\b\u0010\"\u001a\u00020#H$J\u0010\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\u001cH$J\b\u0010&\u001a\u00020\u0005H\u0002J\b\u0010'\u001a\u00020\u001aH$R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0012\u0010\r\u001a\u00020\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/appmattus/layercache/encryption/EncryptionBase;", "Lcom/appmattus/layercache/encryption/Encryption;", "context", "Landroid/content/Context;", "keystoreAlias", "", "(Landroid/content/Context;Ljava/lang/String;)V", "aesKey", "Lcom/appmattus/layercache/encryption/AesKeyCompat;", "getAesKey", "()Lcom/appmattus/layercache/encryption/AesKeyCompat;", "aesKey$delegate", "Lkotlin/Lazy;", "blockMode", "Lcom/appmattus/layercache/encryption/BlockMode;", "getBlockMode", "()Lcom/appmattus/layercache/encryption/BlockMode;", "encryptionPadding", "Lcom/appmattus/layercache/encryption/EncryptionPadding;", "getEncryptionPadding", "()Lcom/appmattus/layercache/encryption/EncryptionPadding;", "integrityCheck", "Lcom/appmattus/layercache/encryption/IntegrityCheck;", "getIntegrityCheck", "()Lcom/appmattus/layercache/encryption/IntegrityCheck;", "constantTimeEquals", "", "a", "", "b", "decrypt", "mappedValue", "encrypt", "value", "generateIv", "Ljava/security/spec/AlgorithmParameterSpec;", "generateSpec", "injectionVector", "getTransformation", "providesIv", "layercache-android-encryption_release"})
@RequiresApi(value=18)
public abstract class EncryptionBase
implements Encryption {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy aesKey$delegate;
    private final Context context;
    private final String keystoreAlias;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EncryptionBase.class), "aesKey", "getAesKey()Lcom/appmattus/layercache/encryption/AesKeyCompat;"))};
    }

    @NotNull
    protected abstract AlgorithmParameterSpec generateSpec(@NotNull byte[] var1);

    @NotNull
    protected abstract AlgorithmParameterSpec generateIv();

    protected abstract boolean providesIv();

    @NotNull
    protected abstract BlockMode getBlockMode();

    @NotNull
    protected abstract EncryptionPadding getEncryptionPadding();

    @NotNull
    protected abstract IntegrityCheck getIntegrityCheck();

    private final AesKeyCompat getAesKey() {
        Lazy lazy = this.aesKey$delegate;
        EncryptionBase encryptionBase = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (AesKeyCompat)lazy.getValue();
    }

    private final String getTransformation() {
        return "AES/" + (Object)((Object)this.getBlockMode()) + '/' + (Object)((Object)this.getEncryptionPadding());
    }

    @Override
    @NotNull
    public final String encrypt(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        SecretKey secretKey = this.getAesKey().retrieveConfidentialityKey$layercache_android_encryption_release(this.keystoreAlias);
        Cipher cipher = Cipher.getInstance(this.getTransformation());
        if (this.providesIv()) {
            cipher.init(1, (Key)secretKey, this.generateIv());
        } else {
            cipher.init(1, secretKey);
        }
        String string = value;
        Cipher cipher2 = cipher;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] cipherText = cipher2.doFinal(byArray2);
        if (this.getIntegrityCheck().getRequired()) {
            Mac mac = Mac.getInstance(this.getIntegrityCheck().getAlgorithm());
            mac.init(this.getAesKey().retrieveIntegrityKey$layercache_android_encryption_release(this.keystoreAlias));
            byte[] byArray3 = cipher.getIV();
            Intrinsics.checkExpressionValueIsNotNull((Object)cipherText, (String)"cipherText");
            byte[] bytes = mac.doFinal(ArraysKt.plus((byte[])byArray3, (byte[])cipherText));
            return Base64ExtKt.encodeBase64(cipherText) + ":" + Base64ExtKt.encodeBase64(cipher.getIV()) + ":" + Base64ExtKt.encodeBase64(bytes);
        }
        return Base64ExtKt.encodeBase64(cipherText) + ":" + Base64ExtKt.encodeBase64(cipher.getIV());
    }

    @Override
    @NotNull
    public final String decrypt(@NotNull String mappedValue) {
        Intrinsics.checkParameterIsNotNull((Object)mappedValue, (String)"mappedValue");
        List parts = StringsKt.split$default((CharSequence)mappedValue, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        byte[] injectionVector = Base64ExtKt.decodeBase64((String)parts.get(1));
        byte[] cipherText = Base64ExtKt.decodeBase64((String)parts.get(0));
        if (this.getIntegrityCheck().getRequired()) {
            if (parts.size() != 3) {
                throw (Throwable)new IllegalArgumentException("Cannot parse iv:ciphertext:mac");
            }
        } else if (parts.size() != 2) {
            throw (Throwable)new IllegalArgumentException("Cannot parse iv:ciphertext");
        }
        if (this.getIntegrityCheck().getRequired()) {
            byte[] calculatedMac = Base64ExtKt.decodeBase64((String)parts.get(2));
            if (this.getIntegrityCheck().getBits() / 8 != calculatedMac.length) {
                throw (Throwable)new GeneralSecurityException("MAC wrong size");
            }
            Mac mac = Mac.getInstance(this.getIntegrityCheck().getAlgorithm());
            mac.init(this.getAesKey().retrieveIntegrityKey$layercache_android_encryption_release(this.keystoreAlias));
            byte[] computedMac = mac.doFinal(ArraysKt.plus((byte[])injectionVector, (byte[])cipherText));
            Intrinsics.checkExpressionValueIsNotNull((Object)computedMac, (String)"computedMac");
            if (!this.constantTimeEquals(computedMac, calculatedMac)) {
                throw (Throwable)new GeneralSecurityException("MAC stored in civ does not match computed MAC.");
            }
        }
        SecretKey secretKey = this.getAesKey().retrieveConfidentialityKey$layercache_android_encryption_release(this.keystoreAlias);
        Cipher cipher = Cipher.getInstance(this.getTransformation());
        AlgorithmParameterSpec spec = this.generateSpec(injectionVector);
        cipher.init(2, (Key)secretKey, spec);
        byte[] byArray = cipher.doFinal(cipherText);
        Charset charset = Charset.forName("UTF8");
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"UTF8\")");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean constantTimeEquals(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int result = 0;
        int n = 0;
        int n2 = a.length;
        while (n < n2) {
            void i;
            byte by = a[i];
            byte by2 = b[i];
            int n3 = result;
            byte by3 = (byte)(by ^ by2);
            result = n3 | by3;
            ++i;
        }
        return result == 0;
    }

    public EncryptionBase(@NotNull Context context, @NotNull String keystoreAlias) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)keystoreAlias, (String)"keystoreAlias");
        this.context = context;
        this.keystoreAlias = keystoreAlias;
        this.aesKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AesKeyCompat>(this){
            final /* synthetic */ EncryptionBase this$0;

            @NotNull
            public final AesKeyCompat invoke() {
                return new AesKeyCompat(EncryptionBase.access$getContext$p(this.this$0), this.this$0.getBlockMode(), this.this$0.getEncryptionPadding(), this.this$0.providesIv(), this.this$0.getIntegrityCheck());
            }
            {
                this.this$0 = encryptionBase;
                super(0);
            }
        }));
    }

    @NotNull
    public static final /* synthetic */ Context access$getContext$p(EncryptionBase $this) {
        return $this.context;
    }
}

