/*
 * Decompiled with CFR 0.152.
 */
package com.appmattus.certificatetransparency.cache;

import android.content.Context;
import android.content.SharedPreferences;
import com.appmattus.certificatetransparency.cache.AndroidDiskCache;
import com.appmattus.certificatetransparency.cache.DefaultDiskCachePolicy;
import com.appmattus.certificatetransparency.cache.DiskCache;
import com.appmattus.certificatetransparency.cache.DiskCachePolicy;
import com.appmattus.certificatetransparency.datasource.DataSource;
import com.appmattus.certificatetransparency.loglist.RawLogListResult;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\f\u001a\u0004\u0018\u00010\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0019\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lcom/appmattus/certificatetransparency/cache/AndroidDiskCache;", "Lcom/appmattus/certificatetransparency/cache/DiskCache;", "context", "Landroid/content/Context;", "diskCachePolicy", "Lcom/appmattus/certificatetransparency/cache/DiskCachePolicy;", "(Landroid/content/Context;Lcom/appmattus/certificatetransparency/cache/DiskCachePolicy;)V", "cacheDirPath", "", "prefs", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "get", "Lcom/appmattus/certificatetransparency/loglist/RawLogListResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isValid", "", "value", "(Lcom/appmattus/certificatetransparency/loglist/RawLogListResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "set", "", "Companion", "certificatetransparency-android_release"})
public final class AndroidDiskCache
implements DiskCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiskCachePolicy diskCachePolicy;
    @NotNull
    private final String cacheDirPath;
    private final SharedPreferences prefs;
    @NotNull
    private static final String LOG_LIST_FILE = "loglist.json";
    @NotNull
    private static final String SIG_FILE = "loglist.sig";
    @NotNull
    private static final String PREF_KEY_LAST_WRITE = "last_write";

    @JvmOverloads
    public AndroidDiskCache(@NotNull Context context, @NotNull DiskCachePolicy diskCachePolicy) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)diskCachePolicy, (String)"diskCachePolicy");
        this.diskCachePolicy = diskCachePolicy;
        this.cacheDirPath = context.getCacheDir().getPath() + "/certificate-transparency-android";
        this.prefs = context.getApplicationContext().getSharedPreferences("certificate-transparency", 0);
    }

    public /* synthetic */ AndroidDiskCache(Context context, DiskCachePolicy diskCachePolicy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            diskCachePolicy = new DefaultDiskCachePolicy();
        }
        this(context, diskCachePolicy);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object get(@NotNull Continuation<? super RawLogListResult> var1_1) {
        if (!(var1_1 instanceof get.1)) ** GOTO lbl-1000
        var8_2 = var1_1;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ AndroidDiskCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.get((Continuation<? super RawLogListResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                jsonFile = new File(this.cacheDirPath, "loglist.json");
                sigFile = new File(this.cacheDirPath, "loglist.sig");
                logList = FilesKt.readBytes((File)jsonFile);
                signature = FilesKt.readBytes((File)sigFile);
                result = new RawLogListResult.Success(logList, signature);
                $continuation.L$0 = this;
                $continuation.L$1 = jsonFile;
                $continuation.L$2 = sigFile;
                $continuation.L$3 = result;
                $continuation.label = 1;
                v0 = this.isValid((RawLogListResult)result, (Continuation<? super Boolean>)$continuation);
                ** if (v0 != var9_4) goto lbl27
lbl26:
                // 1 sources

                return var9_4;
lbl27:
                // 1 sources

                ** GOTO lbl37
            }
            case 1: {
                result = (RawLogListResult.Success)$continuation.L$3;
                sigFile = (File)$continuation.L$2;
                jsonFile = (File)$continuation.L$1;
                this = (AndroidDiskCache)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl37:
                    // 2 sources

                    if (((Boolean)v0).booleanValue()) {
                        v1 = result;
                    } else {
                        this.prefs.edit().clear().apply();
                        jsonFile.delete();
                        sigFile.delete();
                        v1 = null;
                    }
                    var2_5 = (RawLogListResult)v1;
                }
                catch (IOException var3_7) {
                    var2_5 = null;
                }
                return var2_5;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object set(@NotNull RawLogListResult value, @NotNull Continuation<? super Unit> $completion) {
        if (value instanceof RawLogListResult.Success) {
            try {
                new File(this.cacheDirPath).mkdirs();
                FilesKt.writeBytes((File)new File(this.cacheDirPath, LOG_LIST_FILE), (byte[])((RawLogListResult.Success)value).getLogList());
                FilesKt.writeBytes((File)new File(this.cacheDirPath, SIG_FILE), (byte[])((RawLogListResult.Success)value).getSignature());
                this.prefs.edit().putLong(PREF_KEY_LAST_WRITE, System.currentTimeMillis()).apply();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object isValid(@Nullable RawLogListResult value, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((value instanceof RawLogListResult.Success && !this.diskCachePolicy.isExpired(new Date(this.prefs.getLong(PREF_KEY_LAST_WRITE, System.currentTimeMillis())), new Date()) ? 1 : 0) != 0);
    }

    @NotNull
    public DataSource<RawLogListResult> compose(@NotNull DataSource<RawLogListResult> b) {
        return DiskCache.DefaultImpls.compose((DiskCache)this, b);
    }

    @NotNull
    public <MappedValue> DataSource<MappedValue> oneWayTransform(@NotNull Function1<? super RawLogListResult, ? extends MappedValue> transform) {
        return DiskCache.DefaultImpls.oneWayTransform((DiskCache)this, transform);
    }

    @NotNull
    public DataSource<RawLogListResult> plus(@NotNull DataSource<RawLogListResult> b) {
        return DiskCache.DefaultImpls.plus((DiskCache)this, b);
    }

    @NotNull
    public DataSource<RawLogListResult> reuseInflight() {
        return DiskCache.DefaultImpls.reuseInflight((DiskCache)this);
    }

    @JvmOverloads
    public AndroidDiskCache(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/appmattus/certificatetransparency/cache/AndroidDiskCache$Companion;", "", "()V", "LOG_LIST_FILE", "", "PREF_KEY_LAST_WRITE", "SIG_FILE", "certificatetransparency-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

