/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.uikit.adapters;

import android.content.Context;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.uikit.AlMessageProperties;
import com.applozic.mobicomkit.uiwidgets.uikit.AlUIService;
import com.applozic.mobicomkit.uiwidgets.uikit.adapters.AlFooterAdapter;
import com.applozic.mobicommons.people.channel.Channel;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.List;

public class AlConversationAdapter
extends AlFooterAdapter
implements AdapterView.OnItemClickListener {
    public Context context;
    private AlMessageProperties messageProperties;

    public AlConversationAdapter(Context context, List<Message> mList) {
        super(context, mList);
        this.context = context;
        this.messageProperties = new AlMessageProperties(context);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.messageProperties.handleConversationClick((Message)this.mItems.get(position));
    }

    @Override
    public RecyclerView.ViewHolder getConversationViewHolder(ViewGroup parent) {
        return new ConversationViewHolder(this.mInflater.inflate(R.layout.al_conversation_item_layout, parent, false));
    }

    @Override
    public void bindConversationViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof ConversationViewHolder) {
            Message message = (Message)this.mItems.get(position);
            this.messageProperties.setMessage(message);
            ConversationViewHolder mHolder = (ConversationViewHolder)holder;
            mHolder.receiverName.setText((CharSequence)this.messageProperties.getReceiver());
            mHolder.createdAtTime.setText((CharSequence)this.messageProperties.getCreatedAtTime());
            this.messageProperties.setMessageAndAttchmentIcon(mHolder.messageTv, mHolder.attachmentIcon);
            this.messageProperties.setUnreadCount(mHolder.unreadCount);
            this.messageProperties.loadProfileImage(mHolder.profileImage, mHolder.alphabeticImage);
        }
    }

    public class ConversationViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener,
    View.OnCreateContextMenuListener {
        TextView alphabeticImage;
        CircleImageView profileImage;
        TextView receiverName;
        TextView messageTv;
        TextView unreadCount;
        TextView createdAtTime;
        ImageView attachmentIcon;
        AlMessageProperties properties;
        AlUIService uiService;
        private final MenuItem.OnMenuItemClickListener onEditMenu;

        public ConversationViewHolder(View view) {
            super(view);
            this.onEditMenu = new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    switch (item.getItemId()) {
                        case 0: {
                            if (ConversationViewHolder.this.properties.getChannel() != null && ConversationViewHolder.this.properties.getChannel().isDeleted()) {
                                ConversationViewHolder.this.uiService.deleteGroupConversation(ConversationViewHolder.this.properties.getChannel());
                                break;
                            }
                            ConversationViewHolder.this.uiService.deleteConversationThread(ConversationViewHolder.this.properties.getContact(), ConversationViewHolder.this.properties.getChannel());
                            break;
                        }
                        case 1: {
                            ConversationViewHolder.this.uiService.deleteGroupConversation(ConversationViewHolder.this.properties.getChannel());
                            break;
                        }
                        case 2: {
                            ConversationViewHolder.this.uiService.channelLeaveProcess(ConversationViewHolder.this.properties.getChannel());
                            break;
                        }
                    }
                    return true;
                }
            };
            this.alphabeticImage = (TextView)view.findViewById(R.id.alphabeticImage);
            this.profileImage = (CircleImageView)view.findViewById(R.id.contactImage);
            this.receiverName = (TextView)view.findViewById(R.id.smReceivers);
            this.messageTv = (TextView)view.findViewById(R.id.message);
            this.unreadCount = (TextView)view.findViewById(R.id.unreadSmsCount);
            this.createdAtTime = (TextView)view.findViewById(R.id.createdAtTime);
            this.attachmentIcon = (ImageView)view.findViewById(R.id.attachmentIcon);
            this.properties = new AlMessageProperties(AlConversationAdapter.this.context);
            this.uiService = new AlUIService(AlConversationAdapter.this.context);
            view.setOnClickListener((View.OnClickListener)this);
            view.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
        }

        public void onClick(View v) {
            Message message;
            int itemPosition = this.getLayoutPosition();
            if (itemPosition != -1 && !AlConversationAdapter.this.mItems.isEmpty() && (message = (Message)AlConversationAdapter.this.mItems.get(itemPosition)) != null) {
                AlConversationAdapter.this.messageProperties.handleConversationClick(message);
            }
        }

        public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
            int position = this.getLayoutPosition();
            if (AlConversationAdapter.this.mItems.size() <= position) {
                return;
            }
            Message message = (Message)AlConversationAdapter.this.mItems.get(position);
            menu2.setHeaderTitle(R.string.conversation_options);
            String[] menuItems = AlConversationAdapter.this.context.getResources().getStringArray(R.array.conversation_options_menu);
            this.properties.setMessage(message);
            boolean isChannelDeleted = this.properties.getChannel() != null && this.properties.getChannel().isDeleted();
            boolean isUserPresentInGroup = this.properties.getChannel() != null && ChannelService.getInstance((Context)AlConversationAdapter.this.context).processIsUserPresentInChannel(this.properties.getChannel().getKey());
            for (int i = 0; i < menuItems.length; ++i) {
                if ((message.getGroupId() == null || this.properties.getChannel() != null && (Channel.GroupType.GROUPOFTWO.getValue().equals(this.properties.getChannel().getType()) || Channel.GroupType.SUPPORT_GROUP.getValue().equals(this.properties.getChannel().getType()))) && (menuItems[i].equals(AlConversationAdapter.this.context.getResources().getString(R.string.delete_group)) || menuItems[i].equals(AlConversationAdapter.this.context.getResources().getString(R.string.exit_group))) || menuItems[i].equals(AlConversationAdapter.this.context.getResources().getString(R.string.exit_group)) && (isChannelDeleted || !isUserPresentInGroup) || menuItems[i].equals(AlConversationAdapter.this.context.getResources().getString(R.string.delete_group)) && (isUserPresentInGroup || !isChannelDeleted) || menuItems[i].equals(AlConversationAdapter.this.context.getResources().getString(R.string.delete_conversation))) continue;
                MenuItem item = menu2.add(0, i, i, (CharSequence)menuItems[i]);
                item.setOnMenuItemClickListener(this.onEditMenu);
            }
        }
    }
}

