/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.uikit;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUtils;
import com.applozic.mobicommons.people.contact.Contact;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.Serializable;

public class AlMessageProperties {
    private Context context;
    private BaseContactService contactService;
    private ChannelDatabaseService channelService;
    private MessageDatabaseService messageDatabase;
    private AlCustomizationSettings alCustomizationSettings;
    private Message message;
    private Contact contact;
    private Channel channel;

    public AlMessageProperties(Context context) {
        this.context = context;
        this.contactService = new AppContactService(context);
        this.messageDatabase = new MessageDatabaseService(context);
        this.channelService = ChannelDatabaseService.getInstance((Context)context);
        String jsonString = FileUtils.loadSettingsJsonFile((Context)ApplozicService.getContext((Context)context));
        this.alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
    }

    public AlMessageProperties setMessage(Message message) {
        this.message = message;
        if (message.getGroupId() == null) {
            this.contact = this.contactService.getContactById(message.getContactIds());
            this.channel = null;
        } else {
            this.channel = this.channelService.getChannelByChannelKey(message.getGroupId());
            this.contact = null;
        }
        return this;
    }

    public String getReceiver() {
        if (this.message.getGroupId() == null) {
            return this.contact.getDisplayName();
        }
        if (this.channel != null) {
            if (Channel.GroupType.GROUPOFTWO.getValue().equals(this.channel.getType())) {
                Contact withUserContact = this.contactService.getContactById(ChannelService.getInstance((Context)this.context).getGroupOfTwoReceiverUserId(this.channel.getKey()));
                if (withUserContact != null) {
                    return withUserContact.getDisplayName();
                }
            } else {
                return ChannelUtils.getChannelTitleName((Channel)this.channel, (String)MobiComUserPreference.getInstance((Context)this.context).getUserId());
            }
        }
        return null;
    }

    public void setMessageAndAttchmentIcon(TextView messageTv, ImageView attachmentIcon) {
        if (this.message.hasAttachment() && !Message.ContentType.TEXT_URL.getValue().equals(this.message.getContentType())) {
            messageTv.setText((CharSequence)(this.message.getFileMetas() == null && this.message.getFilePaths() != null ? ((String)this.message.getFilePaths().get(0)).substring(((String)this.message.getFilePaths().get(0)).lastIndexOf("/") + 1) : (this.message.getFileMetas() != null ? this.message.getFileMetas().getName() : "")));
            if (attachmentIcon != null) {
                attachmentIcon.setVisibility(0);
                attachmentIcon.setImageResource(R.drawable.applozic_ic_action_attachment);
            }
        } else if (Message.ContentType.LOCATION.getValue().equals(this.message.getContentType())) {
            messageTv.setText((CharSequence)this.context.getString(R.string.Location));
            if (attachmentIcon != null) {
                attachmentIcon.setVisibility(0);
                attachmentIcon.setImageResource(R.drawable.mobicom_notification_location_icon);
            }
        } else if (Message.ContentType.TEXT_HTML.getValue().equals(this.message.getContentType())) {
            messageTv.setText((CharSequence)this.message.getMessage());
            if (attachmentIcon != null) {
                attachmentIcon.setVisibility(8);
            }
        } else if (Message.ContentType.PRICE.getValue().equals(this.message.getContentType())) {
            if (attachmentIcon != null) {
                attachmentIcon.setVisibility(8);
            }
        } else {
            messageTv.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)this.message.getMessage()) ? this.message.getMessage().substring(0, Math.min(this.message.getMessage().length(), 50)) : ""));
            if (attachmentIcon != null) {
                attachmentIcon.setVisibility(8);
            }
        }
    }

    public void setUnreadCount(TextView textView) {
        int unreadCount = 0;
        unreadCount = this.message.getGroupId() == null ? this.messageDatabase.getUnreadMessageCountForContact(this.message.getContactIds()) : this.messageDatabase.getUnreadMessageCountForChannel(this.message.getGroupId());
        if (unreadCount > 0) {
            textView.setVisibility(0);
            textView.setText((CharSequence)String.valueOf(unreadCount));
        } else {
            textView.setVisibility(8);
        }
    }

    public String getCreatedAtTime() {
        return DateUtils.getFormattedDateAndTime((Context)this.context, (Long)this.message.getCreatedAtTime(), (String)this.alCustomizationSettings.getDateFormatCustomization().getSameDayTimeTemplate(), (String)this.alCustomizationSettings.getDateFormatCustomization().getOtherDayDateTemplate(), (int)R.string.JUST_NOW, (int)R.plurals.MINUTES, (int)R.plurals.HOURS);
    }

    public void loadContactImage(CircleImageView imageView, TextView textView, Contact contact) {
        try {
            textView.setVisibility(0);
            imageView.setVisibility(8);
            String contactNumber = "";
            char firstLetter = '\u0000';
            contactNumber = contact.getDisplayName().toUpperCase();
            firstLetter = contact.getDisplayName().toUpperCase().charAt(0);
            if (firstLetter != '+') {
                textView.setText((CharSequence)String.valueOf(firstLetter));
            } else if (contactNumber.length() >= 2) {
                textView.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
            }
            Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
            GradientDrawable bgShape = (GradientDrawable)textView.getBackground();
            bgShape.setColor(this.context.getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
            if (contact.isDrawableResources()) {
                textView.setVisibility(8);
                imageView.setVisibility(0);
                int drawableResourceId = this.context.getResources().getIdentifier(contact.getrDrawableName(), "drawable", this.context.getPackageName());
                imageView.setImageResource(drawableResourceId);
            } else if (contact.getImageURL() != null) {
                this.loadImage(imageView, textView, contact.getImageURL(), 0);
            } else {
                textView.setVisibility(0);
                imageView.setVisibility(8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Contact getContact() {
        return this.contact;
    }

    public void loadChannelImage(CircleImageView imageView, TextView textView, Channel channel) {
        textView.setVisibility(8);
        imageView.setVisibility(0);
        if (channel.getImageUrl() != null) {
            this.loadImage(imageView, textView, channel.getImageUrl(), R.drawable.applozic_group_icon);
        } else {
            imageView.setImageResource(R.drawable.applozic_group_icon);
        }
    }

    public void loadProfileImage(CircleImageView imageView, TextView textView) {
        if (this.channel != null) {
            this.loadChannelImage(imageView, textView, this.channel);
        } else if (this.contact != null) {
            this.loadContactImage(imageView, textView, this.contact);
        }
    }

    private void loadImage(final CircleImageView imageView, final TextView textImage, String imageUrl, int placeholderImage) {
        RequestOptions options = (RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().centerCrop()).placeholder(placeholderImage)).error(placeholderImage);
        Glide.with((Context)this.context).load(imageUrl).apply((BaseRequestOptions)options).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                if (textImage != null) {
                    textImage.setVisibility(8);
                }
                imageView.setVisibility(0);
                return false;
            }
        }).into((ImageView)imageView);
    }

    public void handleConversationClick(Message message) {
        Intent intent = new Intent(this.context, ConversationActivity.class);
        intent.putExtra("takeOrder", true);
        if (message.getGroupId() == null) {
            intent.putExtra("userId", message.getContactIds());
        } else {
            intent.putExtra("groupId", (Serializable)message.getGroupId());
        }
        this.context.startActivity(intent);
    }
}

