/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.views;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.URLUtil;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.listners.AlCallback;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.async.AlMessageMetadataUpdateTask;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.models.AlLinkPreviewModel;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.task.AlAsyncTask;
import com.applozic.mobicommons.task.AlTask;
import com.applozic.mobicommons.task.BaseAsyncTask;
import com.bumptech.glide.Glide;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class AlLinkPreview {
    private static final String TAG = "AlLinkPreview";
    public static final String LINK_PREVIEW_META_KEY = "KM_LINK_PREVIEW_META_KEY";
    private Context context;
    private Message message;
    private RelativeLayout urlLoadLayout;
    private AlCustomizationSettings alCustomizationSettings;
    private ImageView imageView;
    private TextView titleText;
    private TextView descriptionText;
    private ImageView imageOnlyView;

    public AlLinkPreview(Context context, Message message, RelativeLayout urlLoadLayout, AlCustomizationSettings alCustomizationSettings) {
        this.context = context;
        this.message = message;
        this.urlLoadLayout = urlLoadLayout;
        this.alCustomizationSettings = alCustomizationSettings;
        this.imageView = (ImageView)urlLoadLayout.findViewById(R.id.url_image);
        this.titleText = (TextView)urlLoadLayout.findViewById(R.id.url_header);
        this.descriptionText = (TextView)urlLoadLayout.findViewById(R.id.url_body);
        this.imageOnlyView = (ImageView)urlLoadLayout.findViewById(R.id.image_only_view);
    }

    public void createView() {
        AlLinkPreviewModel existingLinkModel = this.getUrlMetaModel();
        if (existingLinkModel != null) {
            this.updateViews(existingLinkModel);
        } else {
            this.urlLoadLayout.setVisibility(8);
            AlTask.execute((BaseAsyncTask)new UrlLoader(this.context, this.message, new AlCallback(){

                public void onSuccess(Object response) {
                    AlLinkPreview.this.updateViews((AlLinkPreviewModel)((Object)response));
                }

                public void onError(Object error) {
                }
            }));
        }
    }

    public void updateViews(AlLinkPreviewModel linkPreviewModel) {
        if (linkPreviewModel != null && linkPreviewModel.hasLinkData()) {
            this.urlLoadLayout.setVisibility(0);
            if (linkPreviewModel.hasImageOnly()) {
                this.toggleImageOnlyVisibility(true);
                Glide.with((Context)this.context).load(linkPreviewModel.getImageLink()).into(this.imageOnlyView);
            } else {
                this.toggleImageOnlyVisibility(false);
                this.titleText.setText((CharSequence)linkPreviewModel.getTitle());
                this.descriptionText.setText((CharSequence)linkPreviewModel.getDescription());
                if (!TextUtils.isEmpty((CharSequence)linkPreviewModel.getImageLink())) {
                    this.imageView.setVisibility(0);
                    Glide.with((Context)this.context).load(linkPreviewModel.getImageLink()).into(this.imageView);
                } else {
                    this.imageView.setVisibility(8);
                }
            }
        } else {
            this.urlLoadLayout.setVisibility(8);
        }
        this.urlLoadLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlLinkPreview.this.openUrl(AlLinkPreview.getValidUrl(AlLinkPreview.this.message));
            }
        });
    }

    public void openUrl(String url) {
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.context.startActivity(browserIntent);
    }

    private void toggleImageOnlyVisibility(boolean showImageOnly) {
        this.imageOnlyView.setVisibility(showImageOnly ? 0 : 8);
        this.imageView.setVisibility(showImageOnly ? 8 : 0);
        this.titleText.setVisibility(showImageOnly ? 8 : 0);
        this.descriptionText.setVisibility(showImageOnly ? 8 : 0);
    }

    public AlLinkPreviewModel getUrlMetaModel() {
        try {
            if (this.message.getMetadata() != null && this.message.getMetadata().containsKey(LINK_PREVIEW_META_KEY)) {
                return (AlLinkPreviewModel)((Object)GsonUtils.getObjectFromJson((String)((String)this.message.getMetadata().get(LINK_PREVIEW_META_KEY)), AlLinkPreviewModel.class));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static AlLinkPreviewModel getMetaTags(Document doc, Message message) {
        AlLinkPreviewModel linkPreviewModel;
        block21: {
            linkPreviewModel = new AlLinkPreviewModel();
            String url = AlLinkPreview.getValidUrl(message);
            try {
                String src;
                String image;
                Elements elements = doc.getElementsByTag("meta");
                String title = doc.select("meta[property=og:title]").attr("content");
                Utils.printLog((Context)ApplozicService.getAppContext(), (String)"LinkTest", (String)("Title : " + title));
                if (!TextUtils.isEmpty((CharSequence)title)) {
                    linkPreviewModel.setTitle(title);
                } else {
                    linkPreviewModel.setTitle(doc.title());
                }
                String description = doc.select("meta[name=description]").attr("content");
                if (description.isEmpty() || description == null) {
                    description = doc.select("meta[name=Description]").attr("content");
                }
                if (description.isEmpty() || description == null) {
                    description = doc.select("meta[property=og:description]").attr("content");
                }
                if (description.isEmpty() || description == null) {
                    description = "";
                }
                linkPreviewModel.setDescription(description);
                Elements imageElements = doc.select("meta[property=og:image]");
                if (imageElements.size() > 0 && !TextUtils.isEmpty((CharSequence)(image = imageElements.attr("content")))) {
                    linkPreviewModel.setImageLink(AlLinkPreview.resolveURL(url, image));
                }
                if (TextUtils.isEmpty((CharSequence)linkPreviewModel.getImageLink())) {
                    src = doc.select("link[rel=image_src]").attr("href");
                    if (!TextUtils.isEmpty((CharSequence)src)) {
                        linkPreviewModel.setImageLink(AlLinkPreview.resolveURL(url, src));
                    } else {
                        src = doc.select("link[rel=apple-touch-icon]").attr("href");
                        if (!TextUtils.isEmpty((CharSequence)src)) {
                            linkPreviewModel.setImageLink(AlLinkPreview.resolveURL(url, src));
                        } else {
                            src = doc.select("link[rel=icon]").attr("href");
                            if (!TextUtils.isEmpty((CharSequence)src)) {
                                linkPreviewModel.setImageLink(AlLinkPreview.resolveURL(url, src));
                            }
                        }
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)(src = doc.select("link[rel=apple-touch-icon]").attr("href"))) && TextUtils.isEmpty((CharSequence)linkPreviewModel.getImageLink())) {
                    linkPreviewModel.setImageLink(AlLinkPreview.resolveURL(url, src));
                } else {
                    src = doc.select("link[rel=icon]").attr("href");
                    if (!TextUtils.isEmpty((CharSequence)src) && TextUtils.isEmpty((CharSequence)linkPreviewModel.getImageLink())) {
                        linkPreviewModel.setImageLink(AlLinkPreview.resolveURL(url, src));
                    }
                }
                for (Element element : elements) {
                    if (!element.hasAttr("property")) continue;
                    String strProperty = element.attr("property").toString().trim();
                    if (strProperty.equals("og:url")) {
                        linkPreviewModel.setUrl(element.attr("content").toString());
                    }
                    if (!strProperty.equals("og:site_name") || !TextUtils.isEmpty((CharSequence)linkPreviewModel.getTitle())) continue;
                    linkPreviewModel.setTitle(element.attr("content").toString());
                }
                if (!TextUtils.isEmpty((CharSequence)linkPreviewModel.getUrl())) break block21;
                URI uri = null;
                try {
                    uri = new URI(url);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                linkPreviewModel.setUrl(uri == null ? url : uri.getHost());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return linkPreviewModel;
    }

    public static String getExpandedURLIfShortened(String url) {
        String LOCATION_HEADER_KEY = "Location";
        URLConnection urlConn = AlLinkPreview.connectURL(url);
        if (urlConn != null) {
            urlConn.getHeaderFields();
            String locationHeaderURL = urlConn.getHeaderField("Location");
            if (!TextUtils.isEmpty((CharSequence)locationHeaderURL)) {
                return locationHeaderURL;
            }
            String connectionURL = urlConn.getURL().toString();
            if (!TextUtils.isEmpty((CharSequence)connectionURL)) {
                return connectionURL;
            }
        }
        return url;
    }

    public static URLConnection connectURL(String strURL) {
        URLConnection conn = null;
        try {
            URL inputURL = new URL(strURL);
            conn = inputURL.openConnection(Proxy.NO_PROXY);
        }
        catch (MalformedURLException e) {
            Log.d((String)TAG, (String)"URL not valid for showing link preview.");
        }
        catch (IOException ioe) {
            Log.d((String)TAG, (String)"Can not connect to the URL for showing link preview.");
        }
        return conn;
    }

    private static String getValidUrl(Message message) {
        String url = message.getFirstUrl();
        if (!(TextUtils.isEmpty((CharSequence)url) || url.regionMatches(true, 0, "http://", 0, "http://".length()) || url.regionMatches(true, 0, "https://", 0, "https://".length()))) {
            url = "http://" + url;
        }
        url = AlLinkPreview.getExpandedURLIfShortened(url);
        return url;
    }

    private static String resolveURL(String url, String part) {
        if (URLUtil.isValidUrl((String)part)) {
            return part;
        }
        URI baseUri = null;
        try {
            baseUri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (baseUri != null) {
            baseUri = baseUri.resolve(part);
            return baseUri.toString();
        }
        return null;
    }

    public static class UrlLoader
    extends AlAsyncTask<Void, AlLinkPreviewModel> {
        private WeakReference<Context> context;
        private Message message;
        private AlCallback callback;

        public UrlLoader(Context context, Message message, AlCallback callback) {
            this.context = new WeakReference<Context>(context);
            this.message = message;
            this.callback = callback;
        }

        protected AlLinkPreviewModel doInBackground() {
            String validUrl = AlLinkPreview.getValidUrl(this.message);
            AlLinkPreviewModel linkPreviewModel = null;
            try {
                if (!TextUtils.isEmpty((CharSequence)validUrl) && Pattern.compile("(.+?)\\.(jpg|png|gif|bmp)$").matcher(validUrl).matches()) {
                    linkPreviewModel = new AlLinkPreviewModel();
                    linkPreviewModel.setImageLink(validUrl);
                } else {
                    Document document = Jsoup.connect((String)validUrl).get();
                    linkPreviewModel = AlLinkPreview.getMetaTags(document, this.message);
                    if (TextUtils.isEmpty((CharSequence)linkPreviewModel.getTitle())) {
                        linkPreviewModel.setTitle(document.title());
                    }
                    if (!(TextUtils.isEmpty((CharSequence)linkPreviewModel.getImageLink()) || linkPreviewModel.getImageLink().startsWith("http://") || linkPreviewModel.getImageLink().startsWith("https://"))) {
                        linkPreviewModel.setImageLink(AlLinkPreview.getValidUrl(this.message) + linkPreviewModel.getImageLink());
                    }
                }
                return linkPreviewModel;
            }
            catch (HttpStatusException e) {
                if (linkPreviewModel == null) {
                    linkPreviewModel = new AlLinkPreviewModel();
                }
                linkPreviewModel.setInvalidUrl(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return linkPreviewModel;
        }

        protected void onPostExecute(final AlLinkPreviewModel urlMetaModel) {
            if (this.callback != null) {
                if (urlMetaModel != null) {
                    if (urlMetaModel.hasLinkData()) {
                        HashMap<String, String> metadata = this.message.getMetadata();
                        if (metadata == null) {
                            metadata = new HashMap<String, String>();
                        }
                        metadata.put(AlLinkPreview.LINK_PREVIEW_META_KEY, GsonUtils.getJsonFromObject((Object)((Object)urlMetaModel), AlLinkPreviewModel.class));
                        AlTask.execute((BaseAsyncTask)new AlMessageMetadataUpdateTask((Context)this.context.get(), this.message.getKeyString(), metadata, new AlMessageMetadataUpdateTask.MessageMetadataListener(){

                            @Override
                            public void onSuccess(Context context, String message) {
                                UrlLoader.this.callback.onSuccess((Object)urlMetaModel);
                            }

                            @Override
                            public void onFailure(Context context, String error) {
                                UrlLoader.this.callback.onError((Object)error);
                            }
                        }));
                    }
                    this.callback.onSuccess((Object)urlMetaModel);
                } else {
                    this.callback.onError(null);
                }
            }
            super.onPostExecute((Object)urlMetaModel);
        }
    }
}

