/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.people.contact;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.AlphabetIndexer;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.SectionIndexer;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.cursoradapter.widget.CursorAdapter;
import androidx.fragment.app.ListFragment;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.Loader;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.RegisteredUsersAsyncTask;
import com.applozic.mobicomkit.api.account.user.UserBlockTask;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.RegisteredUsersApiResponse;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicomkit.uiwidgets.async.AlGetMembersFromContactGroupListTask;
import com.applozic.mobicomkit.uiwidgets.async.ApplozicGetMemberFromContactGroupTask;
import com.applozic.mobicomkit.uiwidgets.people.activity.MobiComKitPeopleActivity;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.people.OnContactsInteractionListener;
import com.applozic.mobicommons.people.SearchListFragment;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.task.AlTask;
import com.applozic.mobicommons.task.BaseAsyncTask;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@SuppressLint(value={"ValidFragment"})
public class AppContactFragment
extends ListFragment
implements SearchListFragment,
AdapterView.OnItemClickListener,
LoaderManager.LoaderCallbacks<Cursor> {
    static final String AL_CUSTOMIZATION_SETTINGS = "alCustomizationSettings";
    private static final String TAG = "AppContactFragment";
    private static final String SHARE_TEXT = "share_text";
    private static final String STATE_PREVIOUSLY_SELECTED_KEY = "net.mobitexter.mobiframework.contact.ui.SELECTED_ITEM";
    private static String inviteMessage;
    AlCustomizationSettings alCustomizationSettings;
    RefreshContactsScreenBroadcast refreshContactsScreenBroadcast;
    private ContactsAdapter mAdapter;
    private ImageLoader mImageLoader;
    private String mSearchTerm;
    private OnContactsInteractionListener mOnContactSelectedListener;
    private int mPreviouslySelectedSearchItem = 0;
    private BaseContactService contactService;
    private Button shareButton;
    private TextView resultTextView;
    private String[] userIdArray;
    private MobiComUserPreference userPreference;
    private ContactDatabase contactDatabase;
    private boolean isFragmentDetached = true;
    View footerView;
    static int CONSTANT_TIME;

    public AppContactFragment() {
    }

    public AppContactFragment(String[] userIdArray) {
        this.userIdArray = userIdArray;
    }

    public void setAlCustomizationSettings(AlCustomizationSettings alCustomizationSettings) {
        this.alCustomizationSettings = alCustomizationSettings;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.contactDatabase = new ContactDatabase(this.getContext());
        this.contactService = new AppContactService((Context)this.getActivity());
        this.mAdapter = new ContactsAdapter(this.getActivity().getApplicationContext());
        this.userPreference = MobiComUserPreference.getInstance((Context)this.getContext());
        inviteMessage = Utils.getMetaDataValue((Context)this.getActivity().getApplicationContext(), (String)SHARE_TEXT);
        if (savedInstanceState != null) {
            this.mSearchTerm = savedInstanceState.getString("query");
            this.mPreviouslySelectedSearchItem = savedInstanceState.getInt(STATE_PREVIOUSLY_SELECTED_KEY, 0);
            this.alCustomizationSettings = (AlCustomizationSettings)((Object)savedInstanceState.getSerializable(AL_CUSTOMIZATION_SETTINGS));
        }
        this.refreshContactsScreenBroadcast = new RefreshContactsScreenBroadcast();
        final Context context = this.getActivity().getApplicationContext();
        this.mImageLoader = new ImageLoader(context, this.getListPreferredItemHeight()){

            protected Bitmap processBitmap(Object data) {
                return AppContactFragment.this.contactService.downloadContactImage(context, (Contact)data);
            }
        };
        this.mImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
        this.mImageLoader.addImageCache(this.getActivity().getSupportFragmentManager(), 0.1f);
        this.mImageLoader.setImageFadeIn(false);
        if (!TextUtils.isEmpty((CharSequence)MobiComUserPreference.getInstance((Context)context).getContactsGroupId())) {
            ChannelDatabaseService channelDatabaseService = ChannelDatabaseService.getInstance((Context)context);
            this.userIdArray = channelDatabaseService.getChannelMemberByName(MobiComUserPreference.getInstance((Context)context).getContactsGroupId(), String.valueOf(Channel.GroupType.CONTACT_GROUP.getValue()));
            if (Utils.isInternetAvailable((Context)this.getContext())) {
                ApplozicGetMemberFromContactGroupTask.GroupMemberListener eventMemberListener = new ApplozicGetMemberFromContactGroupTask.GroupMemberListener(){

                    @Override
                    public void onSuccess(String[] userIdArrays, Context context) {
                        if (AppContactFragment.this.isAdded()) {
                            AppContactFragment.access$202(AppContactFragment.this, new String[userIdArrays.length]);
                            AppContactFragment.access$202(AppContactFragment.this, userIdArrays);
                            AppContactFragment.this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)AppContactFragment.this);
                        }
                    }

                    @Override
                    public void onFailure(String response, Context context) {
                    }
                };
                ApplozicGetMemberFromContactGroupTask applozicGetMemberFromContactGroupTask = new ApplozicGetMemberFromContactGroupTask((Context)this.getActivity(), MobiComUserPreference.getInstance((Context)context).getContactsGroupId(), String.valueOf(Channel.GroupType.CONTACT_GROUP.getValue()), eventMemberListener);
                AlTask.execute((BaseAsyncTask)applozicGetMemberFromContactGroupTask);
            } else if (this.userIdArray != null) {
                this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)this);
            }
        } else if (MobiComUserPreference.getInstance((Context)this.getContext()).getContactGroupIdList() != null && !MobiComUserPreference.getInstance((Context)this.getContext()).getContactGroupIdList().isEmpty()) {
            ArrayList<String> groupList = new ArrayList<String>();
            groupList.addAll(MobiComUserPreference.getInstance((Context)this.getContext()).getContactGroupIdList());
            final ProgressDialog progressBar = new ProgressDialog(this.getContext());
            progressBar.setMessage((CharSequence)this.getContext().getResources().getString(R.string.processing_please_wait));
            progressBar.show();
            AlGetMembersFromContactGroupListTask.GetMembersFromGroupIdListListener listener = new AlGetMembersFromContactGroupListTask.GetMembersFromGroupIdListListener(){

                @Override
                public void onSuccess(Context context, String response, String[] contactList) {
                    progressBar.dismiss();
                    AppContactFragment.access$202(AppContactFragment.this, contactList);
                    AppContactFragment.this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)AppContactFragment.this);
                }

                @Override
                public void onFailure(Context context, String response, Exception e) {
                    progressBar.dismiss();
                    Toast.makeText((Context)AppContactFragment.this.getContext(), (CharSequence)(R.string.failed_to_load_contact + response + "\nException : " + e), (int)0).show();
                }
            };
            if (MobiComUserPreference.getInstance((Context)this.getContext()).isContactGroupNameList()) {
                AlTask.execute((BaseAsyncTask)new AlGetMembersFromContactGroupListTask(this.getContext(), listener, null, groupList, "9"));
            } else {
                AlTask.execute((BaseAsyncTask)new AlGetMembersFromContactGroupListTask(this.getContext(), listener, groupList, null, "9"));
            }
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.contact_list_fragment, container, false);
        this.shareButton = (Button)view.findViewById(R.id.actionButton);
        this.shareButton.setVisibility(this.alCustomizationSettings.isInviteFriendsInContactActivity() ? 0 : 8);
        this.resultTextView = (TextView)view.findViewById(R.id.result);
        this.footerView = inflater.inflate(R.layout.mobicom_message_list_header_footer, null, false);
        if (this.footerView != null) {
            this.footerView.setVisibility(8);
        }
        return view;
    }

    public void openInvite() {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", inviteMessage);
        ArrayList<Intent> targetedShareIntents = new ArrayList<Intent>();
        List resInfo = this.getActivity().getPackageManager().queryIntentActivities(intent, 0);
        if (!resInfo.isEmpty()) {
            for (ResolveInfo resolveInfo : resInfo) {
                String packageName = resolveInfo.activityInfo.packageName;
                Intent targetedShareIntent = new Intent("android.intent.action.SEND");
                targetedShareIntent.setType("text/plain").setAction("android.intent.action.SEND").putExtra("android.intent.extra.TEXT", inviteMessage).setPackage(packageName);
                targetedShareIntents.add(targetedShareIntent);
            }
            Intent chooserIntent = Intent.createChooser((Intent)((Intent)targetedShareIntents.remove(0)), (CharSequence)"Share Via");
            chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", targetedShareIntents.toArray(new Parcelable[0]));
            this.startActivity(chooserIntent);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.shareButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppContactFragment.this.openInvite();
            }
        });
        this.setListAdapter((ListAdapter)this.mAdapter);
        this.getListView().setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.getListView().setFastScrollEnabled(true);
        if (this.footerView != null) {
            this.getListView().addFooterView(this.footerView);
        }
        this.getListView().setOnScrollListener((AbsListView.OnScrollListener)new EndlessScrollListener());
        if (this.mPreviouslySelectedSearchItem == 0 && TextUtils.isEmpty((CharSequence)this.userPreference.getContactsGroupId()) && this.userPreference.getContactGroupIdList() == null) {
            this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.isFragmentDetached = false;
        try {
            this.mOnContactSelectedListener = (OnContactsInteractionListener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context.toString() + " must implement OnContactsInteractionListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.isFragmentDetached = true;
    }

    public void onPause() {
        super.onPause();
        this.mImageLoader.setPauseWork(false);
    }

    public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
        Cursor cursor = this.mAdapter.getCursor();
        cursor.moveToPosition(position);
        Contact contact = this.contactDatabase.getContact(cursor, "_id");
        if (contact.isBlocked()) {
            this.userUnBlockDialog(contact);
            return;
        }
        this.mOnContactSelectedListener.onCustomContactSelected(contact);
    }

    @SuppressLint(value={"NewApi"})
    private void onSelectionCleared() {
        this.mOnContactSelectedListener.onSelectionCleared();
        this.getListView().clearChoices();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (!TextUtils.isEmpty((CharSequence)this.mSearchTerm)) {
            outState.putString("query", this.mSearchTerm);
        }
        if (this.alCustomizationSettings != null) {
            outState.putSerializable(AL_CUSTOMIZATION_SETTINGS, (Serializable)((Object)this.alCustomizationSettings));
        }
    }

    public boolean onQueryTextChange(String newText) {
        String newFilter;
        this.mSearchTerm = newFilter = !TextUtils.isEmpty((CharSequence)newText) ? newText : null;
        this.mAdapter.indexOfSearchQuery(newFilter);
        if (this.isFragmentDetached || this.getContext() == null) {
            return true;
        }
        this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)this);
        return true;
    }

    private int getListPreferredItemHeight() {
        TypedValue typedValue = new TypedValue();
        this.getActivity().getTheme().resolveAttribute(16842829, typedValue, true);
        DisplayMetrics metrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return (int)typedValue.getDimension(metrics);
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        return this.contactDatabase.getSearchCursorLoader(this.mSearchTerm, this.userIdArray, MobiComUserPreference.getInstance((Context)this.getActivity()).getParentGroupKey());
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        if (loader.getId() == 1) {
            this.mAdapter.swapCursor(data);
        }
    }

    public void onLoaderReset(Loader<Cursor> loader) {
        if (loader.getId() == 1) {
            this.mAdapter.swapCursor(null);
        }
    }

    public void processLoadRegisteredUsers() {
        if (this.footerView != null) {
            this.footerView.setVisibility(0);
        }
        RegisteredUsersAsyncTask.TaskListener usersAsyncTaskTaskListener = new RegisteredUsersAsyncTask.TaskListener(){

            public void onSuccess(RegisteredUsersApiResponse registeredUsersApiResponse, String[] userIdArray) {
                if (AppContactFragment.this.footerView != null) {
                    AppContactFragment.this.footerView.setVisibility(8);
                }
                try {
                    if (registeredUsersApiResponse != null) {
                        AppContactFragment.this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)AppContactFragment.this);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onFailure(RegisteredUsersApiResponse registeredUsersApiResponse, String[] userIdArray, Exception exception) {
                if (AppContactFragment.this.footerView != null) {
                    AppContactFragment.this.footerView.setVisibility(8);
                }
                String error = AppContactFragment.this.getString(Utils.isInternetAvailable((Context)AppContactFragment.this.getActivity()) ? R.string.applozic_server_error : R.string.you_need_network_access_for_block_or_unblock);
                Toast toast = Toast.makeText((Context)AppContactFragment.this.getActivity(), (CharSequence)error, (int)1);
                toast.setGravity(17, 0, 0);
                toast.show();
            }

            public void onCompletion() {
            }
        };
        RegisteredUsersAsyncTask usersAsyncTask = new RegisteredUsersAsyncTask((Context)this.getActivity(), usersAsyncTaskTaskListener, this.alCustomizationSettings.getTotalRegisteredUserToFetch(), this.userPreference.getRegisteredUsersLastFetchTime(), null, null, true);
        AlTask.execute((BaseAsyncTask)usersAsyncTask);
    }

    public void onResume() {
        super.onResume();
        try {
            if (this.refreshContactsScreenBroadcast != null) {
                LocalBroadcastManager.getInstance((Context)this.getActivity()).registerReceiver((BroadcastReceiver)this.refreshContactsScreenBroadcast, new IntentFilter(BroadcastService.INTENT_ACTIONS.UPDATE_USER_DETAIL.toString()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.refreshContactsScreenBroadcast != null) {
            LocalBroadcastManager.getInstance((Context)this.getActivity()).unregisterReceiver((BroadcastReceiver)this.refreshContactsScreenBroadcast);
        }
    }

    public void restartLoader() {
        if (this.getLoaderManager() != null) {
            this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void blockUserProcess(Contact contact, boolean block) {
        final ProgressDialog progressDialog = ProgressDialog.show((Context)this.getActivity(), (CharSequence)"", (CharSequence)this.getActivity().getString(R.string.please_wait_info), (boolean)true);
        UserBlockTask.TaskListener listener = new UserBlockTask.TaskListener(){

            public void onSuccess(ApiResponse apiResponse) {
                AppContactFragment.this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)AppContactFragment.this);
            }

            public void onFailure(ApiResponse apiResponse, Exception exception) {
                String error = AppContactFragment.this.getString(Utils.isInternetAvailable((Context)AppContactFragment.this.getActivity()) ? R.string.applozic_server_error : R.string.you_need_network_access_for_block_or_unblock);
                Toast toast = Toast.makeText((Context)AppContactFragment.this.getActivity(), (CharSequence)error, (int)1);
                toast.setGravity(17, 0, 0);
                toast.show();
            }

            public void onCompletion() {
                if (progressDialog != null && progressDialog.isShowing()) {
                    progressDialog.dismiss();
                }
            }
        };
        AlTask.execute((BaseAsyncTask)new UserBlockTask((Context)this.getActivity(), listener, contact.getUserId(), block));
    }

    public void userUnBlockDialog(final Contact contact) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.getActivity()).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                AppContactFragment.this.blockUserProcess(contact, false);
            }
        });
        alertDialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        String name = contact.getDisplayName();
        alertDialog.setMessage((CharSequence)this.getString(R.string.user_un_block_info).replace("[name]", name));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    static /* synthetic */ String[] access$202(AppContactFragment x0, String[] x1) {
        x0.userIdArray = x1;
        return x1;
    }

    static {
        CONSTANT_TIME = 60000;
    }

    private final class RefreshContactsScreenBroadcast
    extends BroadcastReceiver {
        private RefreshContactsScreenBroadcast() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent != null && BroadcastService.INTENT_ACTIONS.UPDATE_USER_DETAIL.toString().equals(intent.getAction())) {
                try {
                    if (AppContactFragment.this.getLoaderManager() != null && AppContactFragment.this.userIdArray == null) {
                        AppContactFragment.this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)AppContactFragment.this);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class ContactsAdapter
    extends CursorAdapter
    implements SectionIndexer {
        Context context;
        private LayoutInflater mInflater;
        private AlphabetIndexer mAlphabetIndexer;
        private TextAppearanceSpan highlightTextSpan;

        public ContactsAdapter(Context context) {
            super(context, null, 0);
            this.context = context;
            this.mInflater = LayoutInflater.from((Context)context);
            String alphabet = context.getString(R.string.alphabet);
            this.mAlphabetIndexer = new AlphabetIndexer(null, 1, (CharSequence)alphabet);
            this.highlightTextSpan = new TextAppearanceSpan((Context)AppContactFragment.this.getActivity(), R.style.searchTextHiglight);
        }

        private int indexOfSearchQuery(String displayName) {
            if (!TextUtils.isEmpty((CharSequence)AppContactFragment.this.mSearchTerm)) {
                return displayName.toLowerCase(Locale.getDefault()).indexOf(AppContactFragment.this.mSearchTerm.toLowerCase(Locale.getDefault()));
            }
            return -1;
        }

        public View newView(Context context, Cursor cursor, ViewGroup parent) {
            View itemLayout = this.mInflater.inflate(R.layout.contact_list_item, parent, false);
            ViewHolder holder = new ViewHolder();
            holder.text1 = (TextView)itemLayout.findViewById(R.id.text1);
            holder.text2 = (TextView)itemLayout.findViewById(R.id.text2);
            holder.contactNumberTextView = (TextView)itemLayout.findViewById(R.id.contactNumberTextView);
            holder.icon = (CircleImageView)itemLayout.findViewById(R.id.contactImage);
            holder.contactIcon = (TextView)itemLayout.findViewById(R.id.contactIcon);
            holder.invite = (TextView)itemLayout.findViewById(R.id.invite);
            holder.unBlock = (TextView)itemLayout.findViewById(R.id.unblock);
            itemLayout.setTag((Object)holder);
            return itemLayout;
        }

        public void bindView(View view, Context context, Cursor cursor) {
            char firstLetter = '\u0000';
            ViewHolder holder = (ViewHolder)view.getTag();
            Contact contact = AppContactFragment.this.contactDatabase.getContact(cursor, "_id");
            holder.text1.setText((CharSequence)contact.getDisplayName());
            holder.text2.setText((CharSequence)contact.getUserId());
            holder.unBlock.setVisibility(8);
            holder.invite.setVisibility(8);
            if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getDisplayName())) {
                String contactNumber = contact.getDisplayName().toUpperCase();
                firstLetter = contact.getDisplayName().toUpperCase().charAt(0);
                if (firstLetter != '+') {
                    holder.contactIcon.setText((CharSequence)String.valueOf(firstLetter));
                } else if (contactNumber.length() >= 2) {
                    holder.contactIcon.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
                }
                Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
                GradientDrawable bgShape = (GradientDrawable)holder.contactIcon.getBackground();
                bgShape.setColor(context.getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
            }
            holder.contactIcon.setVisibility(8);
            holder.icon.setVisibility(0);
            if (contact != null) {
                if (contact.isDrawableResources()) {
                    int drawableResourceId = context.getResources().getIdentifier(contact.getrDrawableName(), "drawable", context.getPackageName());
                    holder.icon.setImageResource(drawableResourceId);
                } else {
                    AppContactFragment.this.mImageLoader.loadImage((Object)contact, (ImageView)holder.icon, holder.contactIcon);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)contact.getContactNumber())) {
                holder.contactNumberTextView.setVisibility(0);
                holder.contactNumberTextView.setText((CharSequence)contact.getContactNumber());
            } else {
                holder.text2.setVisibility(8);
                holder.contactNumberTextView.setVisibility(8);
            }
            int startIndex = this.indexOfSearchQuery(contact.getDisplayName());
            if (startIndex == -1) {
                holder.text1.setText((CharSequence)contact.getDisplayName());
                if (TextUtils.isEmpty((CharSequence)AppContactFragment.this.mSearchTerm)) {
                    holder.text2.setVisibility(8);
                } else {
                    holder.text2.setVisibility(0);
                }
            } else {
                SpannableString highlightedName = new SpannableString((CharSequence)contact.getDisplayName());
                highlightedName.setSpan((Object)this.highlightTextSpan, startIndex, startIndex + AppContactFragment.this.mSearchTerm.length(), 0);
                holder.text1.setText((CharSequence)highlightedName);
                holder.text2.setVisibility(8);
            }
        }

        public Cursor swapCursor(Cursor newCursor) {
            this.mAlphabetIndexer.setCursor(newCursor);
            return super.swapCursor(newCursor);
        }

        public int getCount() {
            if (this.getCursor() == null) {
                return 0;
            }
            return super.getCount();
        }

        public Object[] getSections() {
            return this.mAlphabetIndexer.getSections();
        }

        public int getPositionForSection(int i) {
            if (this.getCursor() == null) {
                return 0;
            }
            return this.mAlphabetIndexer.getPositionForSection(i);
        }

        public int getSectionForPosition(int i) {
            if (this.getCursor() == null) {
                return 0;
            }
            return this.mAlphabetIndexer.getSectionForPosition(i);
        }

        private class ViewHolder {
            TextView text1;
            TextView text2;
            CircleImageView icon;
            TextView contactIcon;
            TextView contactNumberTextView;
            TextView invite;
            TextView unBlock;

            private ViewHolder() {
            }
        }
    }

    public static interface ContactsQuery {
        public static final int QUERY_ID = 1;
    }

    public class EndlessScrollListener
    implements AbsListView.OnScrollListener {
        private int visibleThreshold = 5;
        private int currentPage = 0;
        private int previousTotal = 0;
        private boolean loading = true;

        public EndlessScrollListener() {
        }

        public EndlessScrollListener(int visibleThreshold) {
            this.visibleThreshold = visibleThreshold;
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (this.loading && (AppContactFragment.this.alCustomizationSettings.isRegisteredUserContactListCall() || ApplozicSetting.getInstance((Context)AppContactFragment.this.getActivity()).isRegisteredUsersContactCall()) && Utils.isInternetAvailable((Context)AppContactFragment.this.getActivity().getApplicationContext()) && TextUtils.isEmpty((CharSequence)AppContactFragment.this.userPreference.getContactsGroupId()) && totalItemCount > this.previousTotal) {
                this.loading = false;
                this.previousTotal = totalItemCount;
                ++this.currentPage;
            }
            if (!this.loading && totalItemCount - visibleItemCount <= firstVisibleItem + this.visibleThreshold && !MobiComKitPeopleActivity.isSearching) {
                AppContactFragment.this.processLoadRegisteredUsers();
                this.loading = true;
            }
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
        }
    }
}

