/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.webview;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.webview.AlWebViewJsInterface;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AlWebViewActivity
extends AppCompatActivity {
    WebView webView;
    Toolbar toolbar;
    private Map<String, String> txnData;
    private boolean isPaymentRequest = false;
    private ProgressBar loadingProgressBar;
    private static final String JS_INTERFACE_NAME = "AlWebViewScreen";
    public static final String SURL = "surl";
    public static final String FURL = "furl";
    public static final String DEFAULT_REQUEST_TYPE = "application/x-www-form-urlencoded";
    public static final String KM_HELPCENTER_URL = "KM_HELPCENTER_URL";
    public static final String REQUEST_TYPE_JSON = "json";
    public static final String Al_WEB_VIEW_BUNDLE = "alWebViewBundle";

    protected void onCreate(Bundle savedInstanceState) {
        Bundle alWebViewBundle;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.al_activity_payment);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(this.toolbar);
        this.webView = (WebView)this.findViewById(R.id.paymentWebView);
        this.loadingProgressBar = (ProgressBar)this.findViewById(R.id.loadingProgress);
        if (this.getIntent() != null && (alWebViewBundle = this.getIntent().getBundleExtra(Al_WEB_VIEW_BUNDLE)) != null) {
            boolean isLinkType = alWebViewBundle.getBoolean("link", false);
            this.txnData = new HashMap<String, String>();
            this.setWebViewClient();
            String helpCenterUrl = alWebViewBundle.getString(KM_HELPCENTER_URL);
            if (!TextUtils.isEmpty((CharSequence)helpCenterUrl)) {
                this.loadUrl(helpCenterUrl);
            } else if (isLinkType) {
                String linkUrl = alWebViewBundle.getString("linkUrl");
                if (linkUrl != null && !TextUtils.isEmpty((CharSequence)linkUrl)) {
                    this.loadUrl(linkUrl.startsWith("http") ? linkUrl : "http://" + linkUrl);
                }
            } else {
                String formDataJson = alWebViewBundle.getString("formData");
                String baseUrl = alWebViewBundle.getString("formAction");
                if (formDataJson != null) {
                    try {
                        JSONObject jsonObject = new JSONObject(formDataJson);
                        Iterator iter = jsonObject.keys();
                        while (iter.hasNext()) {
                            String key = (String)iter.next();
                            if (jsonObject.getString(key) == null) continue;
                            this.txnData.put(key, jsonObject.getString(key));
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    this.isPaymentRequest = true;
                    this.webViewClientPost(this.webView, baseUrl, this.txnData.entrySet());
                }
            }
        }
    }

    public void webViewClientPost(WebView webView, String url, Collection<Map.Entry<String, String>> postData) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head></head>");
        sb.append("<body onload='form1.submit()'>");
        sb.append(String.format("<form id='form1' action='%s' method='%s'>", url, "post"));
        for (Map.Entry<String, String> item : postData) {
            sb.append(String.format("<input name='%s' type='hidden' value='%s' />", item.getKey(), item.getValue()));
        }
        sb.append("</form></body></html>");
        webView.loadData(sb.toString(), "text/html", "utf-8");
    }

    public void onBackPressed() {
        if (this.webView != null && this.webView.canGoBack()) {
            this.webView.goBack();
        } else {
            AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this);
            alertDialog.setTitle((CharSequence)this.getString(R.string.warning));
            alertDialog.setMessage((CharSequence)this.getString(this.isPaymentRequest ? R.string.cancel_transaction : R.string.go_back));
            alertDialog.setPositiveButton((CharSequence)this.getString(R.string.yes_alert), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    AlWebViewActivity.this.finish();
                }
            });
            alertDialog.setNegativeButton((CharSequence)this.getString(R.string.no_alert), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            alertDialog.show();
        }
    }

    public void loadUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.webView.getSettings().setJavaScriptEnabled(true);
            this.webView.getSettings().setLoadWithOverviewMode(true);
            this.webView.getSettings().setUseWideViewPort(true);
            this.webView.setWebViewClient(new WebViewClient(){

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if (AlWebViewActivity.this.loadingProgressBar != null) {
                        AlWebViewActivity.this.loadingProgressBar.setVisibility(0);
                    }
                    view.loadUrl(url);
                    return true;
                }

                public void onPageFinished(WebView view, String url) {
                    AlWebViewActivity.this.webView.setVisibility(0);
                    if (AlWebViewActivity.this.loadingProgressBar != null) {
                        AlWebViewActivity.this.loadingProgressBar.setVisibility(8);
                    }
                }
            });
            this.webView.loadUrl(url);
        }
    }

    public void setWebViewClient() {
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (AlWebViewActivity.this.loadingProgressBar != null) {
                    AlWebViewActivity.this.loadingProgressBar.setVisibility(0);
                }
                return super.shouldOverrideUrlLoading(view, url);
            }

            public void onPageFinished(WebView view, String url) {
                AlWebViewActivity.this.webView.setVisibility(0);
                if (AlWebViewActivity.this.loadingProgressBar != null) {
                    AlWebViewActivity.this.loadingProgressBar.setVisibility(8);
                }
                if (!AlWebViewActivity.this.txnData.isEmpty() && AlWebViewActivity.this.txnData.containsKey(AlWebViewActivity.SURL) && url.equals(AlWebViewActivity.this.txnData.get(AlWebViewActivity.FURL))) {
                    AlWebViewActivity.this.finish();
                } else if (!AlWebViewActivity.this.txnData.isEmpty() && AlWebViewActivity.this.txnData.containsKey(AlWebViewActivity.FURL) && url.equals(AlWebViewActivity.this.txnData.get(AlWebViewActivity.FURL))) {
                    AlWebViewActivity.this.finish();
                }
                super.onPageFinished(view, url);
            }
        });
        this.webView.setVisibility(0);
        this.webView.getSettings().setBuiltInZoomControls(true);
        this.webView.getSettings().setCacheMode(2);
        this.webView.getSettings().setDomStorageEnabled(true);
        this.webView.clearHistory();
        this.webView.clearCache(true);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setSupportZoom(true);
        this.webView.getSettings().setUseWideViewPort(false);
        this.webView.getSettings().setLoadWithOverviewMode(false);
        this.webView.addJavascriptInterface((Object)new AlWebViewJsInterface((Context)this), JS_INTERFACE_NAME);
    }
}

