/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.richmessaging;

import android.content.Context;
import android.os.Build;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.adapters.ALRichMessageAdapter;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.adapters.AlImageAdapter;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.adapters.AlRichListsAdapter;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.callbacks.ALRichMessageListener;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.models.ALRichMessageModel;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.views.AlFlowLayout;
import com.applozic.mobicommons.json.GsonUtils;
import com.bumptech.glide.Glide;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AlRichMessage {
    public static final String SEND_GUEST_LIST = "sendGuestList";
    public static final String SEND_HOTEL_RATING = "sendHotelRating";
    public static final String SEND_HOTEL_DETAILS = "sendHotelDetails";
    public static final String SEND_ROOM_DETAILS_MESSAGE = "sendRoomDetailsMessage";
    public static final String SEND_BOOKING_DETAILS = "sendBookingDetails";
    public static final String MAKE_PAYMENT = "makePayment";
    public static final String TEMPLATE_ID = "templateId_";
    public static final String LINK_URL = "linkUrl";
    public static final String WEB_LINK = "link";
    public static final String QUICK_REPLY = "quickReply";
    public static final String QUICK_REPLY_OLD = "quick_reply";
    public static final String SUBMIT_BUTTON = "submit";
    public static final String AL_FAQ_ID = "KM_FAQ_ID";
    public static final String AL_SOURCE = "source";
    public static final String AL_FORM_DATA = "formData";
    public static final String AL_FORM_ACTION = "formAction";
    public static final String SEND_MESSAGE = "sendMessage";
    public static final String OPEN_WEB_VIEW_ACTIVITY = "openWebViewActivity";
    public static final String IS_DEEP_LINK = "isDeepLink";
    private Context context;
    private Message message;
    private ALRichMessageListener listener;
    private LinearLayout containerView;
    private AlCustomizationSettings alCustomizationSettings;

    public AlRichMessage(Context context, LinearLayout containerView, Message message, ALRichMessageListener listener, AlCustomizationSettings alCustomizationSettings) {
        this.context = context;
        this.message = message;
        this.listener = listener;
        this.containerView = containerView;
        this.alCustomizationSettings = alCustomizationSettings;
    }

    public void createRichMessage() {
        ALRichMessageModel model = (ALRichMessageModel)((Object)GsonUtils.getObjectFromJson((String)GsonUtils.getJsonFromObject((Object)this.message.getMetadata(), Map.class), ALRichMessageModel.class));
        LinearLayout listItemlayout = (LinearLayout)this.containerView.findViewById(R.id.alListMessageLayout);
        LinearLayout faqReplyLayout = (LinearLayout)this.containerView.findViewById(R.id.alFaqReplyLayout);
        LinearLayout faqLayout = (LinearLayout)this.containerView.findViewById(R.id.alFaqLayout);
        RecyclerView genericCardRecycler = (RecyclerView)this.containerView.findViewById(R.id.alGenericCardContainer);
        RecyclerView imageListRecycler = (RecyclerView)this.containerView.findViewById(R.id.alImageListContainer);
        AlFlowLayout flowLayout = (AlFlowLayout)this.containerView.findViewById(R.id.alFlowLayout);
        listItemlayout.setVisibility(model.getTemplateId() == 7 ? 0 : 8);
        genericCardRecycler.setVisibility(model.getTemplateId() == 10 ? 0 : 8);
        faqLayout.setVisibility(model.getTemplateId() == 8 ? 0 : 8);
        faqReplyLayout.setVisibility(model.getTemplateId() == 8 ? 0 : 8);
        imageListRecycler.setVisibility(model.getTemplateId() == 9 ? 0 : 8);
        flowLayout.setVisibility(model.getTemplateId() == 3 || model.getTemplateId() == 6 || model.getTemplateId() == 11 ? 0 : 8);
        switch (model.getTemplateId()) {
            case 3: 
            case 6: 
            case 11: {
                this.setUpGridView(flowLayout, model);
                break;
            }
            case 7: {
                this.setupListItemView(listItemlayout, model);
                break;
            }
            case 8: {
                this.setupFaqItemView(faqLayout, faqReplyLayout, model);
                break;
            }
            case 9: {
                LinearLayoutManager layoutManager = new LinearLayoutManager(this.context, 1, false);
                imageListRecycler.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
                AlImageAdapter imageAdapter = new AlImageAdapter(this.context, model, this.listener, this.message, this.alCustomizationSettings);
                imageListRecycler.setAdapter((RecyclerView.Adapter)imageAdapter);
                break;
            }
            case 10: {
                LinearLayoutManager genericCardsLayoutManager = new LinearLayoutManager(this.context, 0, false);
                genericCardRecycler.setLayoutManager((RecyclerView.LayoutManager)genericCardsLayoutManager);
                ALRichMessageAdapter adapter = new ALRichMessageAdapter(this.context, model, this.listener, this.message);
                genericCardRecycler.setAdapter((RecyclerView.Adapter)adapter);
                break;
            }
            default: {
                this.containerView.setVisibility(8);
            }
        }
    }

    private void setupFaqItemView(LinearLayout faqLayout, LinearLayout faqReplyLayout, ALRichMessageModel model) {
        if (model != null) {
            ALRichMessageModel.ALPayloadModel payload;
            TextView headerText = (TextView)faqLayout.findViewById(R.id.headerText);
            TextView titleText = (TextView)faqLayout.findViewById(R.id.questionText);
            TextView descriptionText = (TextView)faqLayout.findViewById(R.id.bodyText);
            TextView buttonLabel = (TextView)faqReplyLayout.findViewById(R.id.buttonLabel);
            TextView actionYes = (TextView)faqReplyLayout.findViewById(R.id.actionYes);
            TextView actionNo = (TextView)faqReplyLayout.findViewById(R.id.actionNo);
            if (model.getPayload() != null && (payload = (ALRichMessageModel.ALPayloadModel)((Object)GsonUtils.getObjectFromJson((String)model.getPayload(), ALRichMessageModel.ALPayloadModel.class))) != null) {
                if (!TextUtils.isEmpty((CharSequence)payload.getTitle())) {
                    titleText.setVisibility(0);
                    titleText.setText((CharSequence)AlRichMessage.getHtmlText(payload.getTitle()));
                } else {
                    titleText.setVisibility(8);
                }
                if (!TextUtils.isEmpty((CharSequence)payload.getDescription())) {
                    descriptionText.setVisibility(0);
                    descriptionText.setText((CharSequence)AlRichMessage.getHtmlText(payload.getDescription()));
                } else {
                    descriptionText.setVisibility(8);
                }
                List<ALRichMessageModel.AlButtonModel> actionModel = payload.getButtons();
                if (actionModel != null) {
                    faqReplyLayout.setVisibility(0);
                    if (!TextUtils.isEmpty((CharSequence)payload.getButtonLabel())) {
                        buttonLabel.setVisibility(0);
                        buttonLabel.setText((CharSequence)payload.getButtonLabel());
                    } else {
                        buttonLabel.setVisibility(8);
                    }
                    if (actionModel.size() > 0 && actionModel.get(0) != null) {
                        if (!TextUtils.isEmpty((CharSequence)actionModel.get(0).getName())) {
                            actionYes.setVisibility(0);
                            actionYes.setText((CharSequence)actionModel.get(0).getName());
                            this.setActionListener((View)actionYes, model, actionModel.get(0), payload);
                        } else {
                            actionYes.setVisibility(8);
                        }
                    }
                    if (actionModel.size() > 1 && actionModel.get(1) != null) {
                        if (!TextUtils.isEmpty((CharSequence)actionModel.get(1).getName())) {
                            actionNo.setVisibility(0);
                            actionNo.setText((CharSequence)actionModel.get(1).getName());
                            this.setActionListener((View)actionNo, model, actionModel.get(1), payload);
                        } else {
                            actionNo.setVisibility(8);
                        }
                    }
                } else {
                    faqReplyLayout.setVisibility(8);
                }
            }
        }
    }

    private void setActionListener(View view, final ALRichMessageModel model, final ALRichMessageModel.AlButtonModel buttonModel, final ALRichMessageModel.ALPayloadModel payloadModel) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AlRichMessage.this.context.getApplicationContext() instanceof ALRichMessageListener) {
                    ((ALRichMessageListener)AlRichMessage.this.context.getApplicationContext()).onAction(AlRichMessage.this.context, AlRichMessage.this.getActionType(model, buttonModel), AlRichMessage.this.message, (Object)buttonModel, payloadModel != null ? payloadModel.getReplyMetadata() : null);
                } else if (AlRichMessage.this.listener != null) {
                    AlRichMessage.this.listener.onAction(AlRichMessage.this.context, AlRichMessage.this.getActionType(model, buttonModel), AlRichMessage.this.message, (Object)buttonModel, payloadModel != null ? payloadModel.getReplyMetadata() : null);
                }
            }
        });
    }

    private String getActionType(ALRichMessageModel model, ALRichMessageModel.AlButtonModel buttonModel) {
        if (buttonModel != null) {
            if (!TextUtils.isEmpty((CharSequence)buttonModel.getType())) {
                return buttonModel.getType();
            }
            if (buttonModel.getAction() != null && !TextUtils.isEmpty((CharSequence)buttonModel.getAction().getType())) {
                return buttonModel.getAction().getType();
            }
        }
        return TEMPLATE_ID + model.getTemplateId();
    }

    private void setupListItemView(LinearLayout listItemLayout, ALRichMessageModel model) {
        if (model != null && model.getPayload() != null) {
            TextView headerText = (TextView)listItemLayout.findViewById(R.id.headerText);
            ImageView headerImage = (ImageView)listItemLayout.findViewById(R.id.headerImage);
            ALRichMessageModel.ALPayloadModel payload = (ALRichMessageModel.ALPayloadModel)((Object)GsonUtils.getObjectFromJson((String)model.getPayload(), ALRichMessageModel.ALPayloadModel.class));
            if (payload != null) {
                RecyclerView listRecycler = (RecyclerView)listItemLayout.findViewById(R.id.alListItemRecycler);
                LinearLayoutManager layoutManager = new LinearLayoutManager(this.context, 1, false);
                listRecycler.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
                AlRichListsAdapter adapter = new AlRichListsAdapter(this.context, this.message, payload.getElements(), payload.getReplyMetadata(), this.listener);
                listRecycler.setAdapter((RecyclerView.Adapter)adapter);
                if (!TextUtils.isEmpty((CharSequence)payload.getHeaderText())) {
                    headerText.setVisibility(0);
                    headerText.setText((CharSequence)AlRichMessage.getHtmlText(payload.getHeaderText()));
                } else {
                    headerText.setVisibility(8);
                }
                if (!TextUtils.isEmpty((CharSequence)payload.getHeaderImgSrc())) {
                    headerImage.setVisibility(0);
                    Glide.with((Context)this.context).load(payload.getHeaderImgSrc()).into(headerImage);
                } else {
                    headerImage.setVisibility(8);
                }
                if (payload.getButtons() != null) {
                    List<ALRichMessageModel.AlButtonModel> action = payload.getButtons();
                    if (action.get(0) != null) {
                        TextView actionText1 = (TextView)listItemLayout.findViewById(R.id.actionButton1);
                        actionText1.setVisibility(0);
                        actionText1.setText((CharSequence)action.get(0).getName());
                        this.setActionListener((View)actionText1, model, action.get(0), payload);
                    }
                    if (action.size() > 1 && action.get(1) != null) {
                        TextView actionText2 = (TextView)listItemLayout.findViewById(R.id.actionButton2);
                        View actionDivider2 = listItemLayout.findViewById(R.id.actionDivider2);
                        actionDivider2.setVisibility(0);
                        actionText2.setVisibility(0);
                        actionText2.setText((CharSequence)action.get(1).getName());
                        this.setActionListener((View)actionText2, model, action.get(1), payload);
                    }
                    if (action.size() > 2 && action.get(2) != null) {
                        TextView actionText3 = (TextView)listItemLayout.findViewById(R.id.actionButton3);
                        View actionDivider3 = listItemLayout.findViewById(R.id.actionDivider3);
                        actionDivider3.setVisibility(0);
                        actionText3.setVisibility(0);
                        actionText3.setText((CharSequence)action.get(2).getName());
                        this.setActionListener((View)actionText3, model, action.get(2), payload);
                    }
                }
            }
        }
    }

    private void setUpGridView(AlFlowLayout flowLayout, final ALRichMessageModel model) {
        List<ALRichMessageModel.ALPayloadModel> payloadList = Arrays.asList((ALRichMessageModel.ALPayloadModel[])GsonUtils.getObjectFromJson((String)model.getPayload(), ALRichMessageModel.ALPayloadModel[].class));
        flowLayout.removeAllViews();
        for (final ALRichMessageModel.ALPayloadModel payloadModel : payloadList) {
            View view = LayoutInflater.from((Context)this.context).inflate(R.layout.al_rich_message_single_text_item, null);
            TextView itemTextView = (TextView)view.findViewById(R.id.singleTextItem);
            if (model.getTemplateId() == 3 || model.getTemplateId() == 11) {
                if (!TextUtils.isEmpty((CharSequence)payloadModel.getName())) {
                    itemTextView.setText((CharSequence)payloadModel.getName().trim());
                } else {
                    itemTextView.setText((CharSequence)"");
                }
            } else if (payloadModel.getTitle() != null) {
                itemTextView.setText((CharSequence)payloadModel.getTitle().trim());
            } else {
                itemTextView.setText((CharSequence)"");
            }
            itemTextView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AlRichMessage.this.context.getApplicationContext() instanceof ALRichMessageListener) {
                        ((ALRichMessageListener)AlRichMessage.this.context.getApplicationContext()).onAction(AlRichMessage.this.context, AlRichMessage.TEMPLATE_ID + model.getTemplateId(), AlRichMessage.this.message, (Object)payloadModel, payloadModel.getReplyMetadata());
                    } else {
                        String actionType;
                        String string2 = actionType = payloadModel.getAction() != null && !TextUtils.isEmpty((CharSequence)payloadModel.getAction().getType()) ? payloadModel.getAction().getType() : payloadModel.getType();
                        if (payloadModel.getAction() != null && !TextUtils.isEmpty((CharSequence)payloadModel.getAction().getType()) || !TextUtils.isEmpty((CharSequence)payloadModel.getType())) {
                            AlRichMessage.this.listener.onAction(AlRichMessage.this.context, actionType, AlRichMessage.this.message, (Object)payloadModel, payloadModel.getReplyMetadata());
                        } else {
                            AlRichMessage.this.listener.onAction(AlRichMessage.this.context, model.getTemplateId() == 6 ? AlRichMessage.QUICK_REPLY : AlRichMessage.SUBMIT_BUTTON, AlRichMessage.this.message, model.getTemplateId() == 6 ? payloadModel : model, payloadModel.getReplyMetadata());
                        }
                    }
                }
            });
            flowLayout.addView(view);
        }
    }

    public static Spanned getHtmlText(String message) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.fromHtml((String)message, (int)63);
        }
        return Html.fromHtml((String)message);
    }
}

