/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.async;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.listners.AlCallback;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.encryption.EncryptionUtils;
import com.applozic.mobicommons.task.AlAsyncTask;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;

public class ALFormDataAsyncTask
extends AlAsyncTask<Void, String> {
    private WeakReference<Context> context;
    private AlCallback callback;
    private String contentType;
    private String data;
    private String accept;
    private String url;
    private Exception exception = null;
    private static final String TAG = "ALFormDataPost";

    public ALFormDataAsyncTask(Context context, String url, String accept, String contentType, String data, AlCallback callback) {
        this.context = new WeakReference<Context>(context);
        this.callback = callback;
        this.url = url;
        this.contentType = contentType;
        this.data = data;
        this.accept = accept;
    }

    protected String doInBackground() {
        try {
            return this.getPostResponse(this.url, this.contentType, this.accept, this.data);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exception = e;
            return null;
        }
    }

    protected void onPostExecute(String response) {
        if (this.callback != null) {
            if (response != null) {
                this.callback.onSuccess((Object)response);
            } else {
                this.callback.onError((Object)this.exception);
            }
        }
        super.onPostExecute((Object)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPostResponse(String urlString, String contentType, String accept, String data) throws Exception {
        Utils.printLog((Context)((Context)this.context.get()), (String)TAG, (String)("Calling url: " + urlString));
        try {
            if (!TextUtils.isEmpty((CharSequence)MobiComUserPreference.getInstance((Context)((Context)this.context.get())).getEncryptionKey())) {
                data = EncryptionUtils.encrypt((String)MobiComUserPreference.getInstance((Context)((Context)this.context.get())).getEncryptionKey(), (byte[])MobiComUserPreference.getInstance((Context)((Context)this.context.get())).getEncryptionIVString().getBytes(), (String)data);
            }
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            if (!TextUtils.isEmpty((CharSequence)contentType)) {
                connection.setRequestProperty("Content-Type", contentType);
            }
            if (!TextUtils.isEmpty((CharSequence)accept)) {
                connection.setRequestProperty("Accept", accept);
            }
            connection.connect();
            if (data != null) {
                byte[] dataBytes = data.getBytes("UTF-8");
                DataOutputStream os = new DataOutputStream(connection.getOutputStream());
                os.write(dataBytes);
                os.flush();
                os.close();
            }
            BufferedReader br = null;
            if (connection.getResponseCode() == 200 || connection.getResponseCode() == 201) {
                InputStream inputStream = connection.getInputStream();
                br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            }
            StringBuilder sb = new StringBuilder();
            try {
                if (br != null) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
            Utils.printLog((Context)((Context)this.context.get()), (String)TAG, (String)("Response : " + sb.toString()));
            if (!TextUtils.isEmpty((CharSequence)sb.toString()) && !TextUtils.isEmpty((CharSequence)MobiComUserPreference.getInstance((Context)((Context)this.context.get())).getEncryptionKey())) {
                return EncryptionUtils.decrypt((String)MobiComUserPreference.getInstance((Context)((Context)this.context.get())).getEncryptionKey(), (byte[])MobiComUserPreference.getInstance((Context)((Context)this.context.get())).getEncryptionIVString().getBytes(), (String)sb.toString());
            }
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Utils.printLog((Context)((Context)this.context.get()), (String)TAG, (String)"Http call failed");
        return null;
    }
}

