/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.richmessaging;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.listners.AlCallback;
import com.applozic.mobicomkit.uiwidgets.async.ALFormDataAsyncTask;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.FullScreenImageActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.callbacks.ALRichMessageListener;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.models.ALBookingDetailsModel;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.models.ALGuestCountModel;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.models.ALRichMessageModel;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.models.AlHotelBookingModel;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.task.AlTask;
import com.applozic.mobicommons.task.BaseAsyncTask;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RichMessageActionProcessor
implements ALRichMessageListener {
    private ALRichMessageListener richMessageListener;
    private static final String TAG = "AlRichMessageAction";

    public RichMessageActionProcessor(ALRichMessageListener richMessageListener) {
        this.richMessageListener = richMessageListener;
    }

    public ALRichMessageListener getRichMessageListener() {
        return this;
    }

    @Override
    public void onAction(Context context, String action, Message message, Object object, Map<String, Object> replyMetadata) {
        switch (action) {
            case "sendGuestList": {
                List guestCountModels = (List)object;
                this.sendGuestListMessage(guestCountModels, this.getStringMap(replyMetadata));
                break;
            }
            case "sendHotelRating": {
                this.sendMessage((String)object, this.getStringMap(replyMetadata));
                break;
            }
            case "sendHotelDetails": {
                this.sendHotelDetailMessage((AlHotelBookingModel)((Object)object), this.getStringMap(replyMetadata));
                break;
            }
            case "sendRoomDetailsMessage": {
                this.sendRoomDetailsMessage((AlHotelBookingModel)((Object)object), this.getStringMap(replyMetadata));
                break;
            }
            case "sendBookingDetails": {
                this.sendBookingDetailsMessage((ALBookingDetailsModel)((Object)object), this.getStringMap(replyMetadata));
                break;
            }
            case "makePayment": 
            case "submit": {
                this.handleSubmitButton(context, object);
                break;
            }
            case "quick_reply": 
            case "quickReply": {
                if (object instanceof String) {
                    this.sendMessage((String)object, this.getStringMap(replyMetadata));
                    break;
                }
                this.handleQuickReplies(object, replyMetadata);
                break;
            }
            case "templateId_9": {
                this.loadImageOnFullScreen(context, action, (ALRichMessageModel.ALPayloadModel)((Object)object));
                break;
            }
            case "link": {
                this.handleWebLinks(object);
            }
        }
    }

    public void handleWebLinks(Object object) {
        ALRichMessageModel.ALPayloadModel payloadModel;
        ALRichMessageModel.AlAction alAction = null;
        if (object instanceof ALRichMessageModel.AlButtonModel) {
            alAction = ((ALRichMessageModel.AlButtonModel)((Object)object)).getAction();
        } else if (object instanceof ALRichMessageModel.AlElementModel) {
            alAction = ((ALRichMessageModel.AlElementModel)((Object)object)).getAction();
        } else if (object instanceof ALRichMessageModel.AlAction) {
            alAction = (ALRichMessageModel.AlAction)((Object)object);
        } else if (object instanceof ALRichMessageModel.ALPayloadModel) {
            alAction = ((ALRichMessageModel.ALPayloadModel)((Object)object)).getAction();
        }
        if (alAction != null) {
            if (!TextUtils.isEmpty((CharSequence)alAction.getUrl())) {
                this.openWebLink(alAction.getUrl(), alAction.isDeepLink());
            } else if (alAction.getPayload() != null && !TextUtils.isEmpty((CharSequence)alAction.getPayload().getUrl())) {
                this.openWebLink(alAction.getPayload().getUrl(), alAction.getPayload().isDeepLink());
            }
        }
        if (object instanceof ALRichMessageModel.ALPayloadModel && !TextUtils.isEmpty((CharSequence)(payloadModel = (ALRichMessageModel.ALPayloadModel)((Object)object)).getUrl())) {
            this.openWebLink(payloadModel.getUrl(), payloadModel.isDeepLink());
        }
    }

    public void handleQuickReplies(Object object, Map<String, Object> replyMetadata) {
        String message = null;
        if (object instanceof ALRichMessageModel.ALPayloadModel) {
            ALRichMessageModel.ALPayloadModel payloadModel = (ALRichMessageModel.ALPayloadModel)((Object)object);
            if (payloadModel.getAction() != null && !TextUtils.isEmpty((CharSequence)payloadModel.getAction().getMessage())) {
                this.handleQuickReplies((Object)payloadModel.getAction(), payloadModel.getReplyMetadata());
            } else {
                message = !TextUtils.isEmpty((CharSequence)payloadModel.getMessage()) ? payloadModel.getMessage() : payloadModel.getName();
            }
        } else if (object instanceof ALRichMessageModel.AlButtonModel) {
            ALRichMessageModel.AlButtonModel buttonModel = (ALRichMessageModel.AlButtonModel)((Object)object);
            if (this.isValidAction(buttonModel.getAction())) {
                this.handleQuickReplies((Object)buttonModel.getAction(), replyMetadata);
            } else {
                message = buttonModel.getName();
            }
        } else if (object instanceof ALRichMessageModel.AlAction) {
            ALRichMessageModel.AlAction action = (ALRichMessageModel.AlAction)((Object)object);
            if (action.getPayload() != null) {
                if (!TextUtils.isEmpty((CharSequence)action.getPayload().getMessage())) {
                    message = action.getPayload().getMessage();
                } else if (!TextUtils.isEmpty((CharSequence)action.getPayload().getTitle())) {
                    message = action.getPayload().getTitle();
                }
            } else {
                message = !TextUtils.isEmpty((CharSequence)action.getMessage()) ? action.getMessage() : (!TextUtils.isEmpty((CharSequence)action.getText()) ? action.getText() : (!TextUtils.isEmpty((CharSequence)action.getTitle()) ? action.getTitle() : action.getName()));
            }
        } else if (object instanceof ALRichMessageModel.AlElementModel) {
            ALRichMessageModel.AlElementModel elementModel = (ALRichMessageModel.AlElementModel)((Object)object);
            if (replyMetadata == null) {
                replyMetadata = new HashMap<String, Object>();
            }
            if (elementModel.getArticleId() != null) {
                replyMetadata.put("KM_FAQ_ID", elementModel.getArticleId());
            }
            if (!TextUtils.isEmpty((CharSequence)elementModel.getSource())) {
                replyMetadata.put("source", elementModel.getSource());
            }
            if (this.isValidAction(elementModel.getAction())) {
                this.handleQuickReplies((Object)elementModel.getAction(), replyMetadata);
            } else {
                message = elementModel.getTitle();
            }
        }
        if (!TextUtils.isEmpty(message)) {
            this.sendMessage(message, this.getStringMap(replyMetadata));
        }
    }

    public boolean isValidAction(ALRichMessageModel.AlAction action) {
        return action != null && (action.getPayload() != null || !TextUtils.isEmpty((CharSequence)action.getText()));
    }

    public void handleSubmitButton(Context context, Object object) {
        if (object instanceof ALRichMessageModel.AlButtonModel) {
            ALRichMessageModel.AlButtonModel buttonModel = (ALRichMessageModel.AlButtonModel)((Object)object);
            if (buttonModel.getAction() != null && buttonModel.getAction().getPayload() != null) {
                this.openWebLink(GsonUtils.getJsonFromObject((Object)((Object)buttonModel.getAction().getPayload().getFormData()), ALRichMessageModel.AlFormDataModel.class), buttonModel.getAction().getPayload().getFormAction());
            }
        } else if (object instanceof ALRichMessageModel) {
            ALRichMessageModel model = (ALRichMessageModel)((Object)object);
            this.openWebLink(model.getFormData(), model.getFormAction());
        } else if (object instanceof ALRichMessageModel.ALPayloadModel) {
            this.makeFormRequest(context, (ALRichMessageModel.ALPayloadModel)((Object)object));
        }
    }

    public Map<String, String> getStringMap(Map<String, Object> objectMap) {
        if (objectMap == null) {
            return null;
        }
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
            newMap.put(entry.getKey(), entry.getValue() instanceof String ? (String)entry.getValue() : entry.getValue().toString());
        }
        return newMap;
    }

    public void sendMessage(String message, Map<String, String> replyMetadata) {
        this.sendMessage(message, replyMetadata, Message.ContentType.DEFAULT.getValue());
    }

    public void openWebLink(String url, boolean isDeepLink) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("link", true);
        bundle.putString("linkUrl", url);
        bundle.putBoolean("isDeepLink", isDeepLink);
        if (this.richMessageListener != null) {
            this.richMessageListener.onAction(null, "openWebViewActivity", null, bundle, null);
        }
    }

    public void makeFormRequest(final Context context, ALRichMessageModel.ALPayloadModel payloadModel) {
        if (payloadModel != null && payloadModel.getAction() != null) {
            if (!TextUtils.isEmpty((CharSequence)payloadModel.getAction().getMessage())) {
                this.sendMessage(payloadModel.getAction().getMessage(), this.getStringMap(payloadModel.getReplyMetadata()));
            } else if (!TextUtils.isEmpty((CharSequence)payloadModel.getAction().getName())) {
                this.sendMessage(payloadModel.getAction().getName(), this.getStringMap(payloadModel.getReplyMetadata()));
            }
            if (payloadModel.getAction().getFormData() != null && !TextUtils.isEmpty((CharSequence)payloadModel.getAction().getFormAction())) {
                if ("json".equals(payloadModel.getAction().getRequestType())) {
                    AlTask.execute((BaseAsyncTask)new ALFormDataAsyncTask(context, payloadModel.getAction().getFormAction(), null, GsonUtils.getJsonFromObject((Object)((Object)payloadModel.getFormData()), ALRichMessageModel.AlFormDataModel.class), "application/json", new AlCallback(){

                        public void onSuccess(Object message) {
                            Utils.printLog((Context)context, (String)RichMessageActionProcessor.TAG, (String)("Submit post success : " + message));
                        }

                        public void onError(Object error) {
                            Utils.printLog((Context)context, (String)RichMessageActionProcessor.TAG, (String)("Submit post error : " + error));
                        }
                    }));
                } else {
                    this.openWebLink(GsonUtils.getJsonFromObject((Object)((Object)payloadModel.getAction().getFormData()), ALRichMessageModel.AlFormDataModel.class), payloadModel.getFormAction());
                }
            }
        }
    }

    public void openWebLink(String formData, String formAction) {
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)formData)) {
            bundle.putString("formData", formData);
        }
        if (!TextUtils.isEmpty((CharSequence)formAction)) {
            bundle.putString("formAction", formAction);
        }
        if (this.richMessageListener != null) {
            this.richMessageListener.onAction(null, "openWebViewActivity", null, bundle, null);
        }
    }

    public void sendGuestListMessage(List<ALGuestCountModel> guestList, Map<String, String> replyMetadata) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("guestTypeId", "ADULTS");
        metadata.put("isRoomGuestJSON", "true");
        metadata.put("roomGuestJson", GsonUtils.getJsonFromObject(guestList, List.class));
        StringBuilder message = new StringBuilder("");
        int count = 0;
        for (ALGuestCountModel guestModel : guestList) {
            message.append("Room ");
            message.append(count + 1);
            message.append(" Guest ");
            message.append(guestModel.getNoOfAdults());
            message.append(" Children ");
            message.append(guestModel.getNoOfChild());
            message.append(", ");
        }
        if (replyMetadata != null) {
            metadata.putAll(replyMetadata);
        }
        this.sendMessage(message.toString(), metadata, Message.ContentType.DEFAULT.getValue());
    }

    public void sendHotelDetailMessage(AlHotelBookingModel hotel, Map<String, String> replyMetadata) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("hotelSelected", "true");
        metadata.put("resultIndex", String.valueOf(hotel.getResultIndex()));
        metadata.put("sessionId", hotel.getSessionId());
        metadata.put("skipBot", "true");
        String message = "Get room detail of " + hotel.getHotelName();
        if (replyMetadata != null) {
            metadata.putAll(replyMetadata);
        }
        this.sendMessage(message, metadata, Message.ContentType.DEFAULT.getValue());
    }

    public void sendRoomDetailsMessage(AlHotelBookingModel hotel, Map<String, String> replyMetadata) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("HotelResultIndex", String.valueOf(hotel.getHotelResultIndex()));
        metadata.put("NoOfRooms", String.valueOf(hotel.getNoOfRooms()));
        metadata.put("RoomIndex", String.valueOf(hotel.getRoomIndex()));
        metadata.put("blockHotelRoom", "true");
        metadata.put("sessionId", hotel.getSessionId());
        metadata.put("skipBot", "true");
        if (replyMetadata != null) {
            metadata.putAll(replyMetadata);
        }
        String message = "Book Hotel " + hotel.getHotelName() + ", Room " + hotel.getRoomTypeName();
        this.sendMessage(message, metadata, Message.ContentType.DEFAULT.getValue());
    }

    public void sendBookingDetailsMessage(ALBookingDetailsModel model, Map<String, String> replyMetadata) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("guestDetail", "true");
        metadata.put("personInfo", GsonUtils.getJsonFromObject((Object)((Object)model.getPersonInfo()), ALBookingDetailsModel.ALBookingDetails.class));
        metadata.put("sessionId", model.getSessionId());
        metadata.put("skipBot", "true");
        if (replyMetadata != null) {
            metadata.putAll(replyMetadata);
        }
        this.sendMessage("Your details have been submitted", metadata, Message.ContentType.DEFAULT.getValue());
    }

    public void loadImageOnFullScreen(Context context, String action, ALRichMessageModel.ALPayloadModel payloadModel) {
        Intent intent = new Intent(context, FullScreenImageActivity.class);
        intent.putExtra(action, GsonUtils.getJsonFromObject((Object)((Object)payloadModel), ALRichMessageModel.ALPayloadModel.class));
        ((MobiComKitActivityInterface)context).startActivityForResult(intent, 301);
    }

    public void sendMessage(String message, Map<String, String> messageMetaData, Short contentType) {
        if (this.richMessageListener != null) {
            Message messageToSend = new Message();
            messageToSend.setMessage(message);
            messageToSend.setMetadata(messageMetaData);
            messageToSend.setContentType(contentType.shortValue());
            this.richMessageListener.onAction(null, "sendMessage", messageToSend, null, null);
        }
    }
}

