/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.uikit;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.MobicomMultimediaPopupAdapter;
import com.applozic.mobicomkit.uiwidgets.uikit.AlAttachmentOptions;
import com.applozic.mobicomkit.uiwidgets.uikit.ApplozicComponents;
import java.util.Arrays;

public class AlAttachmentView
extends ApplozicComponents
implements AdapterView.OnItemClickListener {
    Activity activity;

    public AlAttachmentView(Context context) {
        super(context);
    }

    public AlAttachmentView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public AlAttachmentView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void createView() {
        this.removeAllViews();
        GridView gridView = new GridView(this.getContext());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        gridView.setLayoutParams((ViewGroup.LayoutParams)params);
        gridView.setNumColumns(3);
        gridView.setHorizontalSpacing(1);
        gridView.setVerticalSpacing(1);
        gridView.setStretchMode(2);
        this.prepareAttachmentData(gridView);
        gridView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.addView((View)gridView);
    }

    public void prepareAttachmentData(GridView gridView) {
        String[] allValues = this.getResources().getStringArray(R.array.multimediaOptions_without_price_text);
        String[] allIcons = this.getResources().getStringArray(R.array.multimediaOptionIcons_without_price);
        MobicomMultimediaPopupAdapter adapter = new MobicomMultimediaPopupAdapter(this.getContext(), Arrays.asList(allIcons), Arrays.asList(allValues));
        gridView.setAdapter((ListAdapter)adapter);
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        switch (position) {
            case 0: {
                AlAttachmentOptions.processLocationAction(this.getActivity(), null);
                break;
            }
            case 1: {
                AlAttachmentOptions.processCameraAction(this.getActivity(), null);
                break;
            }
            case 2: {
                AlAttachmentOptions.processFileAction(this.getActivity(), null);
                break;
            }
            case 3: {
                AlAttachmentOptions.processAudioAction(this.getAppComaptActivity(), null);
                break;
            }
            case 4: {
                AlAttachmentOptions.processVideoAction(this.getActivity(), null);
            }
        }
    }

    @Override
    public Activity getActivity() {
        if (this.activity != null) {
            return this.activity;
        }
        return super.getActivity();
    }

    public AppCompatActivity getAppComaptActivity() {
        if (this.activity instanceof AppCompatActivity) {
            return (AppCompatActivity)this.activity;
        }
        return super.getAppCompatActivity();
    }
}

