/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.file.FileUtils;
import java.util.ArrayList;

public class MobiComAttachmentGridViewAdapter
extends BaseAdapter {
    public static final int REQUEST_CODE = 100;
    ImageButton deleteButton;
    ImageView galleryImageView;
    TextView fileSize;
    ImageView attachmentImageView;
    TextView fileName;
    AlCustomizationSettings alCustomizationSettings;
    boolean disableNewAttachment;
    private Context context;
    private ArrayList<Uri> uris;
    private FileUtils.GalleryFilterOptions filterOptions;

    public MobiComAttachmentGridViewAdapter(Context context, ArrayList<Uri> uris, AlCustomizationSettings alCustomizationSettings, boolean disableNewAttachment, FileUtils.GalleryFilterOptions filterOptions) {
        this.context = context;
        this.alCustomizationSettings = alCustomizationSettings;
        this.uris = uris;
        this.disableNewAttachment = disableNewAttachment;
        this.filterOptions = filterOptions;
    }

    public int getCount() {
        return this.uris.size() + (this.disableNewAttachment ? 0 : 1);
    }

    public Object getItem(int i) {
        return this.uris.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(final int position, View view, ViewGroup viewGroup) {
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        if (view == null) {
            view = inflater.inflate(R.layout.mobicom_attachment_gridview_item, viewGroup, false);
        }
        this.deleteButton = (ImageButton)view.findViewById(R.id.mobicom_attachment_delete_btn);
        this.galleryImageView = (ImageView)view.findViewById(R.id.galleryImageView);
        this.fileSize = (TextView)view.findViewById(R.id.mobicom_attachment_file_size);
        this.attachmentImageView = (ImageView)view.findViewById(R.id.mobicom_attachment_image);
        this.fileName = (TextView)view.findViewById(R.id.mobicom_attachment_file_name);
        this.galleryImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (position < MobiComAttachmentGridViewAdapter.this.getCount() - 1) {
                    return;
                }
                if (MobiComAttachmentGridViewAdapter.this.getCount() > MobiComAttachmentGridViewAdapter.this.alCustomizationSettings.getMaxAttachmentAllowed()) {
                    Toast.makeText((Context)MobiComAttachmentGridViewAdapter.this.context, (int)R.string.mobicom_max_attachment_warning, (int)1).show();
                    return;
                }
                try {
                    ImageView galleryImageView = (ImageView)v;
                    galleryImageView.setEnabled(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Intent getContentIntent = FileUtils.createGetContentIntent((FileUtils.GalleryFilterOptions)MobiComAttachmentGridViewAdapter.this.filterOptions, (PackageManager)MobiComAttachmentGridViewAdapter.this.context.getPackageManager());
                getContentIntent.putExtra("android.intent.extra.LOCAL_ONLY", true);
                Intent intentPick = Intent.createChooser((Intent)getContentIntent, (CharSequence)MobiComAttachmentGridViewAdapter.this.context.getString(R.string.select_file));
                ((Activity)MobiComAttachmentGridViewAdapter.this.context).startActivityForResult(intentPick, 100);
            }
        });
        if (this.disableNewAttachment) {
            this.deleteButton.setVisibility(8);
        }
        this.deleteButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MobiComAttachmentGridViewAdapter.this.uris.remove(position);
                MobiComAttachmentGridViewAdapter.this.notifyDataSetChanged();
            }
        });
        if (position == this.getCount() - 1) {
            if (!this.disableNewAttachment) {
                this.setNewAttachmentView();
                return view;
            }
        } else if (!this.disableNewAttachment) {
            this.deleteButton.setVisibility(0);
        }
        try {
            Uri uri = (Uri)this.getItem(position);
            Bitmap previewBitmap = ImageUtils.getPreview((Context)this.context, (Uri)uri);
            if (previewBitmap != null) {
                this.setGalleryView(previewBitmap);
            } else {
                this.setAttachmentView(uri);
            }
            this.fileSize.setText((CharSequence)FileUtils.getSize((Context)this.context, (Uri)uri));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return view;
    }

    private void setAttachmentView(Uri uri) {
        this.attachmentImageView.setVisibility(0);
        this.fileName.setVisibility(0);
        this.fileName.setText((CharSequence)FileUtils.getFileName((Uri)uri));
        this.galleryImageView.setImageBitmap(null);
    }

    private void setGalleryView(Bitmap previewBitmap) {
        this.galleryImageView.setImageBitmap(previewBitmap);
        this.fileName.setVisibility(8);
        this.attachmentImageView.setVisibility(8);
    }

    private void setNewAttachmentView() {
        this.deleteButton.setVisibility(8);
        this.galleryImageView.setImageResource(R.drawable.applozic_ic_action_add);
        this.galleryImageView.setEnabled(true);
        this.fileName.setVisibility(8);
        this.attachmentImageView.setVisibility(8);
        this.fileSize.setText(R.string.New_Attachment);
    }
}

