/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.attachmentview;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class AlAudioSampler {
    private static final long SAMPLE_RATE = 44100L;
    private static final int RECORDER_BPP = 16;
    private static final int CHANNELS = 1;
    private static final long BYTE_RATE = 882000L;

    public static void copyWaveFile(String inFilename, String outFilename, int bufferSize) {
        FileInputStream in = null;
        FileOutputStream out = null;
        long totalAudioLen = 0L;
        long totalDataLen = totalAudioLen + 36L;
        byte[] data = new byte[bufferSize];
        try {
            in = new FileInputStream(inFilename);
            out = new FileOutputStream(outFilename);
            totalAudioLen = in.getChannel().size();
            totalDataLen = totalAudioLen + 36L;
            AlAudioSampler.writeWaveFileHeader(out, totalAudioLen, totalDataLen, 44100L, 1, 882000L);
            while (in.read(data) != -1) {
                out.write(data);
            }
            in.close();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeWaveFileHeader(FileOutputStream out, long totalAudioLen, long totalDataLen, long longSampleRate, int channels, long byteRate) throws IOException {
        byte[] header = new byte[]{82, 73, 70, 70, (byte)(totalDataLen & 0xFFL), (byte)(totalDataLen >> 8 & 0xFFL), (byte)(totalDataLen >> 16 & 0xFFL), (byte)(totalDataLen >> 24 & 0xFFL), 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, (byte)channels, 0, (byte)(longSampleRate & 0xFFL), (byte)(longSampleRate >> 8 & 0xFFL), (byte)(longSampleRate >> 16 & 0xFFL), (byte)(longSampleRate >> 24 & 0xFFL), (byte)(byteRate & 0xFFL), (byte)(byteRate >> 8 & 0xFFL), (byte)(byteRate >> 16 & 0xFFL), (byte)(byteRate >> 24 & 0xFFL), 4, 0, 16, 0, 100, 97, 116, 97, (byte)(totalAudioLen & 0xFFL), (byte)(totalAudioLen >> 8 & 0xFFL), (byte)(totalAudioLen >> 16 & 0xFFL), (byte)(totalAudioLen >> 24 & 0xFFL)};
        out.write(header, 0, 44);
    }
}

