/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.views;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.view.View;
import android.webkit.URLUtil;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.listners.AlCallback;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.async.AlMessageMetadataUpdateTask;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.models.KmLinkPreviewModel;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.bumptech.glide.Glide;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class KmLinkPreview {
    public static final String LINK_PREVIEW_META_KEY = "KM_LINK_PREVIEW_META_KEY";
    private Context context;
    private Message message;
    private RelativeLayout urlLoadLayout;
    private AlCustomizationSettings alCustomizationSettings;
    private ImageView imageView;
    private TextView titleText;
    private TextView descriptionText;
    private ImageView imageOnlyView;

    public KmLinkPreview(Context context, Message message, RelativeLayout urlLoadLayout, AlCustomizationSettings alCustomizationSettings) {
        this.context = context;
        this.message = message;
        this.urlLoadLayout = urlLoadLayout;
        this.alCustomizationSettings = alCustomizationSettings;
        this.imageView = (ImageView)urlLoadLayout.findViewById(R.id.url_image);
        this.titleText = (TextView)urlLoadLayout.findViewById(R.id.url_header);
        this.descriptionText = (TextView)urlLoadLayout.findViewById(R.id.url_body);
        this.imageOnlyView = (ImageView)urlLoadLayout.findViewById(R.id.image_only_view);
    }

    public void createView() {
        KmLinkPreviewModel existingLinkModel = this.getUrlMetaModel();
        if (existingLinkModel != null) {
            this.updateViews(existingLinkModel);
        } else {
            this.urlLoadLayout.setVisibility(8);
            new UrlLoader(this.context, this.message, new AlCallback(){

                public void onSuccess(Object response) {
                    KmLinkPreview.this.updateViews((KmLinkPreviewModel)((Object)response));
                }

                public void onError(Object error) {
                }
            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }
    }

    public void updateViews(KmLinkPreviewModel linkPreviewModel) {
        if (linkPreviewModel != null && linkPreviewModel.hasLinkData()) {
            this.urlLoadLayout.setVisibility(0);
            if (linkPreviewModel.hasImageOnly()) {
                this.toggleImageOnlyVisibility(true);
                Glide.with((Context)this.context).load(linkPreviewModel.getImageLink()).into(this.imageOnlyView);
            } else {
                this.toggleImageOnlyVisibility(false);
                this.titleText.setText((CharSequence)linkPreviewModel.getTitle());
                this.descriptionText.setText((CharSequence)linkPreviewModel.getDescription());
                if (!TextUtils.isEmpty((CharSequence)linkPreviewModel.getImageLink())) {
                    this.imageView.setVisibility(0);
                    Glide.with((Context)this.context).load(linkPreviewModel.getImageLink()).into(this.imageView);
                } else {
                    this.imageView.setVisibility(8);
                }
            }
        } else {
            this.urlLoadLayout.setVisibility(8);
        }
        this.urlLoadLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                KmLinkPreview.this.openUrl(KmLinkPreview.getValidUrl(KmLinkPreview.this.message));
            }
        });
    }

    public void openUrl(String url) {
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.context.startActivity(browserIntent);
    }

    private void toggleImageOnlyVisibility(boolean showImageOnly) {
        this.imageOnlyView.setVisibility(showImageOnly ? 0 : 8);
        this.imageView.setVisibility(showImageOnly ? 8 : 0);
        this.titleText.setVisibility(showImageOnly ? 8 : 0);
        this.descriptionText.setVisibility(showImageOnly ? 8 : 0);
    }

    public KmLinkPreviewModel getUrlMetaModel() {
        try {
            if (this.message.getMetadata() != null && this.message.getMetadata().containsKey(LINK_PREVIEW_META_KEY)) {
                return (KmLinkPreviewModel)((Object)GsonUtils.getObjectFromJson((String)((String)this.message.getMetadata().get(LINK_PREVIEW_META_KEY)), KmLinkPreviewModel.class));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static KmLinkPreviewModel getMetaTags(Document doc, Message message) {
        KmLinkPreviewModel linkPreviewModel;
        block21: {
            linkPreviewModel = new KmLinkPreviewModel();
            String url = KmLinkPreview.getValidUrl(message);
            try {
                String src;
                String image;
                Elements elements = doc.getElementsByTag("meta");
                String title = doc.select("meta[property=og:title]").attr("content");
                Utils.printLog((Context)ApplozicService.getAppContext(), (String)"LinkTest", (String)("Title : " + title));
                if (!TextUtils.isEmpty((CharSequence)title)) {
                    linkPreviewModel.setTitle(title);
                } else {
                    linkPreviewModel.setTitle(doc.title());
                }
                String description = doc.select("meta[name=description]").attr("content");
                if (description.isEmpty() || description == null) {
                    description = doc.select("meta[name=Description]").attr("content");
                }
                if (description.isEmpty() || description == null) {
                    description = doc.select("meta[property=og:description]").attr("content");
                }
                if (description.isEmpty() || description == null) {
                    description = "";
                }
                linkPreviewModel.setDescription(description);
                Elements imageElements = doc.select("meta[property=og:image]");
                if (imageElements.size() > 0 && !TextUtils.isEmpty((CharSequence)(image = imageElements.attr("content")))) {
                    linkPreviewModel.setImageLink(KmLinkPreview.resolveURL(url, image));
                }
                if (TextUtils.isEmpty((CharSequence)linkPreviewModel.getImageLink())) {
                    src = doc.select("link[rel=image_src]").attr("href");
                    if (!TextUtils.isEmpty((CharSequence)src)) {
                        linkPreviewModel.setImageLink(KmLinkPreview.resolveURL(url, src));
                    } else {
                        src = doc.select("link[rel=apple-touch-icon]").attr("href");
                        if (!TextUtils.isEmpty((CharSequence)src)) {
                            linkPreviewModel.setImageLink(KmLinkPreview.resolveURL(url, src));
                        } else {
                            src = doc.select("link[rel=icon]").attr("href");
                            if (!TextUtils.isEmpty((CharSequence)src)) {
                                linkPreviewModel.setImageLink(KmLinkPreview.resolveURL(url, src));
                            }
                        }
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)(src = doc.select("link[rel=apple-touch-icon]").attr("href"))) && TextUtils.isEmpty((CharSequence)linkPreviewModel.getImageLink())) {
                    linkPreviewModel.setImageLink(KmLinkPreview.resolveURL(url, src));
                } else {
                    src = doc.select("link[rel=icon]").attr("href");
                    if (!TextUtils.isEmpty((CharSequence)src) && TextUtils.isEmpty((CharSequence)linkPreviewModel.getImageLink())) {
                        linkPreviewModel.setImageLink(KmLinkPreview.resolveURL(url, src));
                    }
                }
                for (Element element : elements) {
                    if (!element.hasAttr("property")) continue;
                    String strProperty = element.attr("property").toString().trim();
                    if (strProperty.equals("og:url")) {
                        linkPreviewModel.setUrl(element.attr("content").toString());
                    }
                    if (!strProperty.equals("og:site_name") || !TextUtils.isEmpty((CharSequence)linkPreviewModel.getTitle())) continue;
                    linkPreviewModel.setTitle(element.attr("content").toString());
                }
                if (!TextUtils.isEmpty((CharSequence)linkPreviewModel.getUrl())) break block21;
                URI uri = null;
                try {
                    uri = new URI(url);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                linkPreviewModel.setUrl(uri == null ? url : uri.getHost());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return linkPreviewModel;
    }

    private static String getValidUrl(Message message) {
        String url = message.getFirstUrl();
        if (!(TextUtils.isEmpty((CharSequence)url) || url.startsWith("http://") || url.startsWith("https://"))) {
            return "http://" + url;
        }
        return url;
    }

    private static String resolveURL(String url, String part) {
        if (URLUtil.isValidUrl((String)part)) {
            return part;
        }
        URI baseUri = null;
        try {
            baseUri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (baseUri != null) {
            baseUri = baseUri.resolve(part);
            return baseUri.toString();
        }
        return null;
    }

    public static class UrlLoader
    extends AsyncTask<Void, Void, KmLinkPreviewModel> {
        private WeakReference<Context> context;
        private Message message;
        private AlCallback callback;

        public UrlLoader(Context context, Message message, AlCallback callback) {
            this.context = new WeakReference<Context>(context);
            this.message = message;
            this.callback = callback;
        }

        protected KmLinkPreviewModel doInBackground(Void ... voids) {
            String validUrl = KmLinkPreview.getValidUrl(this.message);
            KmLinkPreviewModel linkPreviewModel = null;
            try {
                if (!TextUtils.isEmpty((CharSequence)validUrl) && Pattern.compile("(.+?)\\.(jpg|png|gif|bmp)$").matcher(validUrl).matches()) {
                    linkPreviewModel = new KmLinkPreviewModel();
                    linkPreviewModel.setImageLink(validUrl);
                } else {
                    Document document = Jsoup.connect((String)validUrl).get();
                    linkPreviewModel = KmLinkPreview.getMetaTags(document, this.message);
                    if (TextUtils.isEmpty((CharSequence)linkPreviewModel.getTitle())) {
                        linkPreviewModel.setTitle(document.title());
                    }
                    if (!(TextUtils.isEmpty((CharSequence)linkPreviewModel.getImageLink()) || linkPreviewModel.getImageLink().startsWith("http://") || linkPreviewModel.getImageLink().startsWith("https://"))) {
                        linkPreviewModel.setImageLink(KmLinkPreview.getValidUrl(this.message) + linkPreviewModel.getImageLink());
                    }
                }
                return linkPreviewModel;
            }
            catch (HttpStatusException e) {
                if (linkPreviewModel == null) {
                    linkPreviewModel = new KmLinkPreviewModel();
                }
                linkPreviewModel.setInvalidUrl(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return linkPreviewModel;
        }

        protected void onPostExecute(final KmLinkPreviewModel urlMetaModel) {
            if (this.callback != null) {
                if (urlMetaModel != null) {
                    if (urlMetaModel.hasLinkData()) {
                        HashMap<String, String> metadata = this.message.getMetadata();
                        if (metadata == null) {
                            metadata = new HashMap<String, String>();
                        }
                        metadata.put(KmLinkPreview.LINK_PREVIEW_META_KEY, GsonUtils.getJsonFromObject((Object)((Object)urlMetaModel), KmLinkPreviewModel.class));
                        new AlMessageMetadataUpdateTask((Context)this.context.get(), this.message.getKeyString(), metadata, new AlMessageMetadataUpdateTask.MessageMetadataListener(){

                            @Override
                            public void onSuccess(Context context, String message) {
                                UrlLoader.this.callback.onSuccess((Object)urlMetaModel);
                            }

                            @Override
                            public void onFailure(Context context, String error) {
                                UrlLoader.this.callback.onError((Object)error);
                            }
                        }).executeOnExecutor(THREAD_POOL_EXECUTOR, new Void[0]);
                    }
                    this.callback.onSuccess((Object)urlMetaModel);
                } else {
                    this.callback.onError(null);
                }
            }
            super.onPostExecute((Object)urlMetaModel);
        }
    }
}

