/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Build;
import android.text.Html;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.RecyclerView;
import com.applozic.mobicomkit.Applozic;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.AttachmentManager;
import com.applozic.mobicomkit.api.attachment.AttachmentView;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.notification.VideoCallNotificationHelper;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.MobiComVCFParser;
import com.applozic.mobicomkit.contact.VCFContactData;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicomkit.uiwidgets.attachmentview.ApplozicDocumentView;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ALSendMessageInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.FullScreenImageActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.OnClickReplyInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.AlRichMessage;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.callbacks.ALRichMessageListener;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.views.KmLinkPreview;
import com.applozic.mobicomkit.uiwidgets.uilistener.ALProfileClickListener;
import com.applozic.mobicomkit.uiwidgets.uilistener.ALStoragePermission;
import com.applozic.mobicomkit.uiwidgets.uilistener.ALStoragePermissionListener;
import com.applozic.mobicomkit.uiwidgets.uilistener.ContextMenuClickListener;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.core.utils.LocationUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageCache;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.emoticon.EmojiconHandler;
import com.applozic.mobicommons.emoticon.EmoticonUtils;
import com.applozic.mobicommons.file.ALFileProvider;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import com.bumptech.glide.Glide;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DetailedConversationAdapter
extends RecyclerView.Adapter
implements Filterable {
    private static final String TAG = "DetailedConversation";
    private static final int FILE_THRESOLD_SIZE = 400;
    public ImageLoader contactImageLoader;
    public ImageLoader loadImage;
    public String searchString;
    private AlCustomizationSettings alCustomizationSettings;
    private Context context;
    private Context activityContext;
    private Contact contact;
    private Channel channel;
    private boolean individual;
    private Drawable sentIcon;
    private Drawable deliveredIcon;
    private Drawable pendingIcon;
    private Drawable scheduledIcon;
    private ImageLoader imageThumbnailLoader;
    private EmojiconHandler emojiconHandler;
    private FileClientService fileClientService;
    private MessageDatabaseService messageDatabaseService;
    private BaseContactService contactService;
    private Class<?> messageIntentClass;
    private List<Message> messageList;
    private List<Message> originalList;
    private ImageCache imageCache;
    private View view;
    private ContextMenuClickListener contextMenuClickListener;
    private ALStoragePermissionListener storagePermissionListener;
    private ALSendMessageInterface sendMessageInterfaceCallBack;
    private ALRichMessageListener listener;
    private String geoApiKey;

    public void setAlCustomizationSettings(AlCustomizationSettings alCustomizationSettings) {
        this.alCustomizationSettings = alCustomizationSettings;
    }

    public void setContextMenuClickListener(ContextMenuClickListener contextMenuClickListener) {
        this.contextMenuClickListener = contextMenuClickListener;
    }

    public void setSendMessageInterfaceCallBack(ALSendMessageInterface sendMessageInterfaceCallBack) {
        this.sendMessageInterfaceCallBack = sendMessageInterfaceCallBack;
    }

    public void setRichMessageCallbackListener(ALRichMessageListener listener) {
        this.listener = listener;
    }

    public void setStoragePermissionListener(ALStoragePermissionListener storagePermissionListener) {
        this.storagePermissionListener = storagePermissionListener;
    }

    public DetailedConversationAdapter(Context context, List<Message> messageList, Channel channel, Class messageIntentClass, EmojiconHandler emojiconHandler) {
        this(context, messageList, null, channel, messageIntentClass, emojiconHandler);
    }

    public DetailedConversationAdapter(Context context, List<Message> messageList, Contact contact, Class messageIntentClass, EmojiconHandler emojiconHandler) {
        this(context, messageList, contact, null, messageIntentClass, emojiconHandler);
    }

    public DetailedConversationAdapter(final Context context, List<Message> messageList, Contact contact, Channel channel, Class messageIntentClass, EmojiconHandler emojiconHandler) {
        this.messageIntentClass = messageIntentClass;
        this.context = ApplozicService.getContext((Context)context);
        this.activityContext = context;
        this.contact = contact;
        this.channel = channel;
        this.emojiconHandler = emojiconHandler;
        this.individual = contact != null || channel != null;
        this.fileClientService = new FileClientService(context);
        this.messageDatabaseService = new MessageDatabaseService(context);
        this.contactService = new AppContactService(context);
        this.messageList = messageList;
        this.geoApiKey = Applozic.getInstance((Context)context).getGeoApiKey();
        this.contactImageLoader = new ImageLoader(context, ImageUtils.getLargestScreenDimension((Activity)((Activity)context))){

            protected Bitmap processBitmap(Object data) {
                return DetailedConversationAdapter.this.contactService.downloadContactImage(context, (Contact)data);
            }
        };
        this.contactImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_180_holo_light);
        this.contactImageLoader.setImageFadeIn(false);
        this.loadImage = new ImageLoader(context, ImageUtils.getLargestScreenDimension((Activity)((Activity)context))){

            protected Bitmap processBitmap(Object data) {
                return DetailedConversationAdapter.this.fileClientService.loadMessageImage(context, (String)data);
            }
        };
        this.loadImage.setImageFadeIn(false);
        this.imageThumbnailLoader = new ImageLoader(context, ImageUtils.getLargestScreenDimension((Activity)((Activity)context))){

            protected Bitmap processBitmap(Object data) {
                return DetailedConversationAdapter.this.fileClientService.loadThumbnailImage(context, (Message)data, DetailedConversationAdapter.this.getImageLayoutParam((boolean)false).width, DetailedConversationAdapter.this.getImageLayoutParam((boolean)false).height);
            }
        };
        if (context != null) {
            this.imageCache = ImageCache.getInstance((FragmentManager)((FragmentActivity)context).getSupportFragmentManager(), (float)0.1f);
            this.contactImageLoader.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
            this.loadImage.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
            this.imageThumbnailLoader.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
        }
        this.imageThumbnailLoader.setImageFadeIn(false);
        this.sentIcon = context.getResources().getDrawable(R.drawable.applozic_ic_action_message_sent);
        this.deliveredIcon = context.getResources().getDrawable(R.drawable.applozic_ic_action_message_delivered);
        this.pendingIcon = context.getResources().getDrawable(R.drawable.applozic_ic_action_message_pending);
        this.scheduledIcon = context.getResources().getDrawable(R.drawable.applozic_ic_action_message_schedule);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater layoutInflater = (LayoutInflater)this.activityContext.getSystemService("layout_inflater");
        if (layoutInflater == null) {
            return null;
        }
        if (viewType == 2) {
            View v2 = layoutInflater.inflate(R.layout.mobicom_date_layout, parent, false);
            return new MyViewHolder2(v2);
        }
        if (viewType == 3) {
            View v3 = layoutInflater.inflate(R.layout.applozic_custom_message_layout, parent, false);
            return new MyViewHolder3(v3);
        }
        if (viewType == 4) {
            View v4 = layoutInflater.inflate(R.layout.applozic_channel_custom_message_layout, parent, false);
            return new MyViewHolder4(v4);
        }
        if (viewType == 5) {
            View v5 = layoutInflater.inflate(R.layout.applozic_call_layout, parent, false);
            return new MyViewHolder5(v5);
        }
        if (viewType == 0) {
            View v0 = layoutInflater.inflate(R.layout.mobicom_received_message_list_view, parent, false);
            return new MyViewHolder(v0);
        }
        this.view = layoutInflater.inflate(R.layout.mobicom_sent_message_list_view, parent, false);
        return new MyViewHolder(this.view);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        block138: {
            int type = this.getItemViewType(position);
            final Message message = this.getItem(position);
            try {
                if (type == 2) {
                    MyViewHolder2 myViewHolder2 = (MyViewHolder2)holder;
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy");
                    SimpleDateFormat simpleDateFormatDay = new SimpleDateFormat("EEEE");
                    Date date = new Date(message.getCreatedAtTime());
                    myViewHolder2.dateView.setTextColor(Color.parseColor((String)this.alCustomizationSettings.getConversationDateTextColor().trim()));
                    myViewHolder2.dayTextView.setTextColor(Color.parseColor((String)this.alCustomizationSettings.getConversationDayTextColor().trim()));
                    if (DateUtils.isSameDay((Long)message.getCreatedAtTime())) {
                        myViewHolder2.dayTextView.setVisibility(0);
                        myViewHolder2.dateView.setVisibility(8);
                        myViewHolder2.dayTextView.setText(R.string.today);
                    } else {
                        myViewHolder2.dayTextView.setVisibility(0);
                        myViewHolder2.dateView.setVisibility(0);
                        myViewHolder2.dayTextView.setText((CharSequence)simpleDateFormatDay.format(date));
                        myViewHolder2.dateView.setText((CharSequence)simpleDateFormat.format(date));
                    }
                    return;
                }
                if (type == 3) {
                    MyViewHolder3 myViewHolder3 = (MyViewHolder3)holder;
                    myViewHolder3.customContentTextView.setText((CharSequence)message.getMessage());
                    myViewHolder3.customContentTextView.setVisibility(0);
                    return;
                }
                if (type == 4) {
                    MyViewHolder4 myViewHolder4 = (MyViewHolder4)holder;
                    GradientDrawable bgGradientDrawable = (GradientDrawable)myViewHolder4.channelMessageTextView.getBackground();
                    bgGradientDrawable.setColor(Color.parseColor((String)this.alCustomizationSettings.getChannelCustomMessageBgColor()));
                    bgGradientDrawable.setStroke(3, Color.parseColor((String)this.alCustomizationSettings.getChannelCustomMessageBorderColor()));
                    myViewHolder4.channelMessageTextView.setTextColor(Color.parseColor((String)this.alCustomizationSettings.getChannelCustomMessageTextColor()));
                    myViewHolder4.channelMessageTextView.setText((CharSequence)message.getMessage());
                    return;
                }
                if (type == 5) {
                    MyViewHolder5 myViewHolder5 = (MyViewHolder5)holder;
                    if (message == null) break block138;
                    myViewHolder5.timeTextView.setText((CharSequence)DateUtils.getFormattedDate((Long)message.getCreatedAtTime()));
                    if (message.getMetadata() != null) {
                        myViewHolder5.statusTextView.setText((CharSequence)VideoCallNotificationHelper.getStatus((Map)message.getMetadata()));
                    }
                    if (VideoCallNotificationHelper.isMissedCall((Message)message)) {
                        myViewHolder5.imageView.setImageResource(R.drawable.ic_communication_call_missed);
                    }
                    if (VideoCallNotificationHelper.isAudioCall((Message)message)) {
                        myViewHolder5.imageView.setImageResource(R.drawable.applozic_ic_action_call);
                    } else {
                        myViewHolder5.imageView.setImageResource(R.drawable.ic_videocam_white_24px);
                    }
                    if (message.getMetadata() == null) break block138;
                    if (((String)message.getMetadata().get("MSG_TYPE")).equals("CALL_END")) {
                        String duration = (String)message.getMetadata().get("CALL_DURATION");
                        if (!TextUtils.isEmpty((CharSequence)duration)) {
                            myViewHolder5.durationTextView.setVisibility(0);
                            duration = Utils.getTimeDurationInFormat((Long)Long.parseLong(duration));
                            myViewHolder5.durationTextView.setText((CharSequence)duration);
                        }
                    } else {
                        myViewHolder5.durationTextView.setVisibility(8);
                    }
                    break block138;
                }
                final MyViewHolder myHolder = (MyViewHolder)holder;
                if (message == null) break block138;
                Contact receiverContact = null;
                Contact contactDisplayName = null;
                if (message.getGroupId() == null) {
                    List<String> items = Arrays.asList(message.getContactIds().split("\\s*,\\s*"));
                    List<String> userIds = null;
                    if (!TextUtils.isEmpty((CharSequence)message.getContactIds())) {
                        userIds = Arrays.asList(message.getContactIds().split("\\s*,\\s*"));
                    }
                    if (this.individual) {
                        receiverContact = this.contact;
                        this.contact.setContactNumber(items.get(0));
                        if (userIds != null) {
                            this.contact.setUserId(userIds.get(0));
                        }
                    } else {
                        receiverContact = this.contactService.getContactReceiver(items, userIds);
                    }
                } else if (!TextUtils.isEmpty((CharSequence)message.getContactIds())) {
                    contactDisplayName = this.contactService.getContactById(message.getContactIds());
                }
                Configuration config = this.context.getResources().getConfiguration();
                if (message.isCall() || message.isDummyEmptyMessage()) {
                    myHolder.createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
                } else if (!message.isSentToServer() && message.isTypeOutbox() && (this.contact != null || this.channel != null && !Channel.GroupType.OPEN.getValue().equals(this.channel.getType()))) {
                    myHolder.createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, message.getScheduledAt() != null ? this.scheduledIcon : this.pendingIcon, null);
                } else if (message.getKeyString() != null && message.isTypeOutbox() && message.isSentToServer() && (this.contact != null || this.channel != null && !Channel.GroupType.OPEN.getValue().equals(this.channel.getType()))) {
                    Drawable statusIcon = message.isDeliveredAndRead() ? this.context.getResources().getDrawable(R.drawable.applozic_ic_action_message_read) : (message.getDelivered() != false ? this.deliveredIcon : (message.getScheduledAt() != null ? this.scheduledIcon : this.sentIcon));
                    myHolder.createdAtTime.setCompoundDrawablesWithIntrinsicBounds(null, null, statusIcon, null);
                }
                if (message.isCall()) {
                    myHolder.deliveryStatus.setText((CharSequence)"");
                }
                if (message.isDeletedForAll()) {
                    myHolder.messageTextView.setCompoundDrawablesWithIntrinsicBounds(this.context.getResources().getDrawable(R.drawable.round_not_interested_black_24), null, null, null);
                    if (Build.VERSION.SDK_INT >= 21) {
                        myHolder.messageTextView.getCompoundDrawables()[0].setTint(Color.parseColor((String)(message.isTypeOutbox() ? this.alCustomizationSettings.getSentMessageTextColor() : this.alCustomizationSettings.getReceivedMessageTextColor())));
                    }
                    myHolder.messageTextView.setText(R.string.deleted_message_text);
                    myHolder.messageTextView.setTypeface(null, 2);
                    myHolder.messageTextView.setVisibility(0);
                    myHolder.createdAtTime.setText((CharSequence)DateUtils.getFormattedDate((Long)message.getCreatedAtTime()));
                    myHolder.replyRelativeLayout.setVisibility(8);
                    myHolder.attachmentIcon.setVisibility(8);
                    myHolder.richMessageLayout.setVisibility(8);
                    myHolder.preview.setVisibility(8);
                    myHolder.attachedFile.setVisibility(8);
                    myHolder.mainAttachmentLayout.setVisibility(8);
                    myHolder.attachmentView.setVisibility(8);
                    myHolder.videoIcon.setVisibility(8);
                    myHolder.mainContactShareLayout.setVisibility(8);
                    break block138;
                }
                myHolder.messageTextView.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
                myHolder.messageTextView.setTypeface(null, 0);
                if (message.getMetadata() != null && !message.getMetadata().isEmpty() && message.getMetadata().containsKey(Message.MetaDataType.AL_REPLY.getValue())) {
                    String keyString = message.getMetaDataValueForKey(Message.MetaDataType.AL_REPLY.getValue());
                    Message messageToBeReplied = new Message();
                    messageToBeReplied.setKeyString(keyString);
                    int indexOfObject = this.messageList.indexOf(messageToBeReplied);
                    messageToBeReplied = indexOfObject != -1 ? this.messageList.get(indexOfObject) : this.messageDatabaseService.getMessage(message.getMetaDataValueForKey(Message.MetaDataType.AL_REPLY.getValue()));
                    final Message msg = messageToBeReplied;
                    if (msg != null) {
                        myHolder.replyRelativeLayout.setBackgroundColor(message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getReplyMessageLayoutSentMessageBackground()) : Color.parseColor((String)this.alCustomizationSettings.getReplyMessageLayoutReceivedMessageBackground()));
                        myHolder.replyNameTextView.setTextColor(message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageTextColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageTextColor()));
                        myHolder.replyMessageTextView.setTextColor(message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageTextColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageTextColor()));
                        String displayName = msg.getGroupId() != null ? (MobiComUserPreference.getInstance((Context)this.context).getUserId().equals(msg.getContactIds()) || TextUtils.isEmpty((CharSequence)msg.getContactIds()) ? this.context.getString(R.string.you_string) : this.contactService.getContactById(msg.getContactIds()).getDisplayName()) : (msg.isTypeOutbox() ? this.context.getString(R.string.you_string) : this.contactService.getContactById(msg.getContactIds()).getDisplayName());
                        myHolder.replyNameTextView.setText((CharSequence)displayName);
                        if (msg.hasAttachment()) {
                            FileMeta fileMeta = msg.getFileMetas();
                            myHolder.imageViewForAttachmentType.setVisibility(0);
                            if (fileMeta.getContentType().contains("image")) {
                                myHolder.imageViewForAttachmentType.setImageResource(R.drawable.applozic_ic_image_camera_alt);
                                if (TextUtils.isEmpty((CharSequence)msg.getMessage())) {
                                    myHolder.replyMessageTextView.setText((CharSequence)this.context.getString(R.string.photo_string));
                                } else {
                                    myHolder.replyMessageTextView.setText((CharSequence)msg.getMessage());
                                }
                                myHolder.imageViewPhoto.setVisibility(0);
                                myHolder.imageViewRLayout.setVisibility(0);
                                this.imageThumbnailLoader.loadImage((Object)msg, myHolder.imageViewPhoto);
                            } else if (fileMeta.getContentType().contains("video")) {
                                myHolder.imageViewForAttachmentType.setImageResource(R.drawable.applozic_ic_action_video);
                                if (Build.VERSION.SDK_INT >= 17 && config.getLayoutDirection() == 1) {
                                    myHolder.imageViewForAttachmentType.setScaleX(-1.0f);
                                }
                                if (TextUtils.isEmpty((CharSequence)msg.getMessage())) {
                                    myHolder.replyMessageTextView.setText((CharSequence)this.context.getString(R.string.video_string));
                                } else {
                                    myHolder.replyMessageTextView.setText((CharSequence)msg.getMessage());
                                }
                                myHolder.imageViewPhoto.setVisibility(0);
                                myHolder.imageViewRLayout.setVisibility(0);
                                if (msg.getFilePaths() != null && msg.getFilePaths().size() > 0) {
                                    if (this.imageCache != null && this.imageCache.getBitmapFromMemCache(msg.getKeyString()) != null) {
                                        myHolder.imageViewPhoto.setImageBitmap(this.imageCache.getBitmapFromMemCache(msg.getKeyString()));
                                    } else {
                                        if (this.imageCache != null) {
                                            this.imageCache.addBitmapToCache(message.getKeyString(), this.fileClientService.createAndSaveVideoThumbnail((String)msg.getFilePaths().get(0)));
                                        }
                                        myHolder.imageViewPhoto.setImageBitmap(this.fileClientService.createAndSaveVideoThumbnail((String)msg.getFilePaths().get(0)));
                                    }
                                }
                            } else if (fileMeta.getContentType().contains("audio")) {
                                myHolder.imageViewForAttachmentType.setImageResource(R.drawable.applozic_ic_music_note);
                                if (TextUtils.isEmpty((CharSequence)msg.getMessage())) {
                                    myHolder.replyMessageTextView.setText((CharSequence)this.context.getString(R.string.audio_string));
                                } else {
                                    myHolder.replyMessageTextView.setText((CharSequence)msg.getMessage());
                                }
                                myHolder.imageViewPhoto.setVisibility(8);
                                myHolder.imageViewRLayout.setVisibility(8);
                            } else if (msg.isContactMessage()) {
                                MobiComVCFParser parser = new MobiComVCFParser();
                                try {
                                    VCFContactData data = parser.parseCVFContactData((String)msg.getFilePaths().get(0));
                                    if (data != null) {
                                        myHolder.imageViewForAttachmentType.setImageResource(R.drawable.applozic_ic_person_white);
                                        myHolder.replyMessageTextView.setText((CharSequence)this.context.getString(R.string.contact_string));
                                        myHolder.replyMessageTextView.append((CharSequence)(" " + data.getName()));
                                    }
                                }
                                catch (Exception e) {
                                    myHolder.imageViewForAttachmentType.setImageResource(R.drawable.applozic_ic_person_white);
                                    myHolder.replyMessageTextView.setText((CharSequence)this.context.getString(R.string.contact_string));
                                }
                                myHolder.imageViewPhoto.setVisibility(8);
                                myHolder.imageViewRLayout.setVisibility(8);
                            } else {
                                myHolder.imageViewForAttachmentType.setImageResource(R.drawable.applozic_ic_action_attachment);
                                if (TextUtils.isEmpty((CharSequence)msg.getMessage())) {
                                    myHolder.replyMessageTextView.setText((CharSequence)this.context.getString(R.string.attachment_string));
                                } else {
                                    myHolder.replyMessageTextView.setText((CharSequence)msg.getMessage());
                                }
                                myHolder.imageViewPhoto.setVisibility(8);
                                myHolder.imageViewRLayout.setVisibility(8);
                            }
                            myHolder.imageViewForAttachmentType.setColorFilter(Color.parseColor((String)(message.isTypeOutbox() ? this.alCustomizationSettings.getSentMessageTextColor() : this.alCustomizationSettings.getReceivedMessageTextColor())));
                        } else if (msg.getContentType() == Message.ContentType.LOCATION.getValue().shortValue()) {
                            myHolder.imageViewForAttachmentType.setVisibility(0);
                            myHolder.imageViewPhoto.setVisibility(0);
                            myHolder.imageViewRLayout.setVisibility(0);
                            myHolder.replyMessageTextView.setText((CharSequence)this.context.getString(R.string.al_location_string));
                            myHolder.imageViewForAttachmentType.setColorFilter(Color.parseColor((String)(message.isTypeOutbox() ? this.alCustomizationSettings.getSentMessageTextColor() : this.alCustomizationSettings.getReceivedMessageTextColor())));
                            myHolder.imageViewForAttachmentType.setImageResource(R.drawable.applozic_ic_location_on_white_24dp);
                            this.loadImage.setLoadingImage(R.drawable.applozic_map_offline_thumbnail);
                            this.loadImage.loadImage((Object)LocationUtils.loadStaticMap((String)msg.getMessage(), (String)this.geoApiKey), myHolder.imageViewPhoto);
                        } else {
                            myHolder.imageViewForAttachmentType.setVisibility(8);
                            myHolder.imageViewRLayout.setVisibility(8);
                            myHolder.imageViewPhoto.setVisibility(8);
                            myHolder.replyMessageTextView.setText((CharSequence)msg.getMessage());
                        }
                        myHolder.replyRelativeLayout.setVisibility(0);
                        myHolder.replyRelativeLayout.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                ((OnClickReplyInterface)DetailedConversationAdapter.this.activityContext).onClickOnMessageReply(msg);
                            }
                        });
                    }
                } else {
                    myHolder.replyRelativeLayout.setVisibility(8);
                }
                if (TextUtils.isEmpty((CharSequence)message.getMessage())) {
                    myHolder.messageTextView.setVisibility(8);
                }
                if (this.channel != null && !message.hasAttachment() && TextUtils.isEmpty((CharSequence)message.getMessage()) && message.getMetadata() == null) {
                    myHolder.messageTextView.setText((CharSequence)"");
                }
                if (myHolder.chatLocation != null) {
                    myHolder.chatLocation.setVisibility(8);
                }
                if (myHolder.attachedFile != null) {
                    myHolder.attachedFile.setVisibility(8);
                }
                if (myHolder.attachmentIcon != null) {
                    myHolder.attachmentIcon.setVisibility(8);
                }
                if (this.channel != null && myHolder.nameTextView != null && contactDisplayName != null) {
                    myHolder.nameTextView.setVisibility(Channel.GroupType.GROUPOFTWO.getValue().equals(this.channel.getType()) ? 8 : 0);
                    if (this.alCustomizationSettings.isLaunchChatFromProfilePicOrName()) {
                        myHolder.nameTextView.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View view) {
                                Intent intent = new Intent(DetailedConversationAdapter.this.activityContext, ConversationActivity.class);
                                intent.putExtra("userId", message.getContactIds());
                                if (message.getConversationId() != null) {
                                    intent.putExtra("CONVERSATION_ID", (Serializable)message.getConversationId());
                                }
                                DetailedConversationAdapter.this.activityContext.startActivity(intent);
                            }
                        });
                    }
                    String userId = contactDisplayName.getDisplayName();
                    char firstLetter = contactDisplayName.getDisplayName().charAt(0);
                    if (userId.length() > 0) {
                        myHolder.nameTextView.setText((CharSequence)String.valueOf(userId));
                    }
                    Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
                    myHolder.nameTextView.setTextColor(this.context.getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
                }
                myHolder.createdAtTime.setTextColor(Color.parseColor((String)this.alCustomizationSettings.getMessageTimeTextColor()));
                if (message.isTypeOutbox() && !message.isCanceled()) {
                    myHolder.mediaUploadProgressBar.setVisibility(message.isAttachmentUploadInProgress() ? 0 : 8);
                } else {
                    myHolder.mediaUploadProgressBar.setVisibility(8);
                }
                if (myHolder.attachedFile != null) {
                    myHolder.attachedFile.setVisibility(message.hasAttachment() ? 0 : 8);
                }
                if (this.individual && message.getTimeToLive() != null) {
                    myHolder.selfDestruct.setText((CharSequence)("Self destruct in " + message.getTimeToLive() + " mins"));
                    myHolder.selfDestruct.setVisibility(0);
                } else {
                    myHolder.selfDestruct.setText((CharSequence)"");
                    myHolder.selfDestruct.setVisibility(8);
                }
                if (myHolder.sentOrReceived != null) {
                    if (!message.isCall() || message.isDummyEmptyMessage()) {
                        myHolder.sentOrReceived.setVisibility(8);
                    } else if (message.isCall()) {
                        myHolder.sentOrReceived.setImageResource(R.drawable.applozic_ic_action_call_holo_light);
                    } else if (this.getItemViewType(position) == 0) {
                        myHolder.sentOrReceived.setImageResource(R.drawable.mobicom_social_forward);
                    } else {
                        myHolder.sentOrReceived.setImageResource(R.drawable.mobicom_social_reply);
                    }
                    if (message.isCall()) {
                        myHolder.messageTextView.setTextColor(this.context.getResources().getColor(message.isIncomingCall() ? R.color.incoming_call : R.color.outgoing_call));
                    }
                }
                if (myHolder.nameTextLayout != null && this.contact != null) {
                    myHolder.nameTextLayout.setVisibility(8);
                }
                if (contactDisplayName != null && myHolder.contactImage != null && this.alCustomizationSettings.isLaunchChatFromProfilePicOrName()) {
                    myHolder.contactImage.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Intent intent = new Intent(DetailedConversationAdapter.this.activityContext, ConversationActivity.class);
                            intent.putExtra("userId", message.getContactIds());
                            if (message.getConversationId() != null) {
                                intent.putExtra("CONVERSATION_ID", (Serializable)message.getConversationId());
                            }
                            DetailedConversationAdapter.this.activityContext.startActivity(intent);
                        }
                    });
                    myHolder.alphabeticTextView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Intent intent = new Intent(DetailedConversationAdapter.this.activityContext, ConversationActivity.class);
                            intent.putExtra("userId", message.getContactIds());
                            if (message.getConversationId() != null) {
                                intent.putExtra("CONVERSATION_ID", (Serializable)message.getConversationId());
                            }
                            DetailedConversationAdapter.this.activityContext.startActivity(intent);
                        }
                    });
                }
                if (!message.isTypeOutbox()) {
                    this.loadContactImage(receiverContact, contactDisplayName, message, (ImageView)myHolder.contactImage, myHolder.alphabeticTextView, myHolder.onlineTextView);
                }
                ApplozicDocumentView audioView = new ApplozicDocumentView(this.activityContext, this.storagePermissionListener);
                audioView.inflateViewWithMessage(myHolder.view, message);
                audioView.hideView(true);
                if (message.hasAttachment() && myHolder.attachedFile != null & message.getContentType() != Message.ContentType.TEXT_URL.getValue().shortValue()) {
                    int i;
                    myHolder.mainAttachmentLayout.setLayoutParams(this.getImageLayoutParam(false));
                    myHolder.mainAttachmentLayout.setVisibility(0);
                    if (message.getFileMetas() != null && (message.getFileMetas().getContentType().contains("image") || message.getFileMetas().getContentType().contains("video"))) {
                        myHolder.attachedFile.setVisibility(8);
                    }
                    if (message.isAttachmentDownloaded()) {
                        myHolder.mapImageView.setVisibility(8);
                        String[] filePaths = new String[message.getFilePaths().size()];
                        i = 0;
                        for (String filePath : message.getFilePaths()) {
                            filePaths[i++] = filePath;
                            String mimeType = FileUtils.getMimeType((String)filePath);
                            if (mimeType != null && mimeType.startsWith("image")) {
                                myHolder.attachmentView.setVisibility(8);
                                myHolder.videoIcon.setVisibility(8);
                                myHolder.preview.setVisibility(0);
                                myHolder.preview.setImageBitmap(null);
                                myHolder.attachmentDownloadLayout.setVisibility(8);
                                myHolder.attachmentDownloadProgressLayout.setVisibility(8);
                                Glide.with((Context)this.context).load(new File(filePath)).into(myHolder.preview);
                                myHolder.attachmentView.setMessage(message);
                                myHolder.mediaDownloadProgressBar.setVisibility(8);
                                myHolder.attachedFile.setVisibility(8);
                                myHolder.attachmentView.setProressBar(myHolder.mediaDownloadProgressBar);
                                myHolder.attachmentView.setDownloadProgressLayout(myHolder.attachmentDownloadProgressLayout);
                                continue;
                            }
                            if (mimeType != null && mimeType.startsWith("video")) {
                                myHolder.preview.setVisibility(0);
                                myHolder.videoIcon.setVisibility(0);
                                myHolder.mediaDownloadProgressBar.setVisibility(8);
                                myHolder.attachmentDownloadLayout.setVisibility(8);
                                myHolder.attachmentDownloadProgressLayout.setVisibility(8);
                                myHolder.attachedFile.setVisibility(8);
                                if (this.imageCache.getBitmapFromMemCache(message.getKeyString()) != null) {
                                    myHolder.preview.setImageBitmap(this.imageCache.getBitmapFromMemCache(message.getKeyString()));
                                    continue;
                                }
                                this.imageCache.addBitmapToCache(message.getKeyString(), this.fileClientService.createAndSaveVideoThumbnail(filePath));
                                myHolder.preview.setImageBitmap(this.fileClientService.createAndSaveVideoThumbnail(filePath));
                                continue;
                            }
                            myHolder.preview.setVisibility(8);
                            myHolder.mediaDownloadProgressBar.setVisibility(8);
                            myHolder.attachmentDownloadLayout.setVisibility(8);
                            myHolder.attachmentDownloadProgressLayout.setVisibility(8);
                            this.showAttachmentIconAndText(myHolder.attachedFile, message, mimeType);
                        }
                    } else if (message.isAttachmentUploadInProgress()) {
                        myHolder.preview.setImageDrawable(null);
                        myHolder.preview.setImageBitmap(null);
                        myHolder.attachmentDownloadProgressLayout.setVisibility(0);
                        myHolder.mediaDownloadProgressBar.setVisibility(0);
                        myHolder.videoIcon.setVisibility(8);
                        myHolder.attachmentView.setProressBar(myHolder.mediaDownloadProgressBar);
                        myHolder.attachmentView.setDownloadProgressLayout(myHolder.attachmentDownloadProgressLayout);
                        myHolder.attachmentView.setMessage(message);
                        myHolder.attachmentView.setVisibility(0);
                        myHolder.attachedFile.setVisibility(8);
                        myHolder.attachmentIcon.setVisibility(8);
                    } else if (AttachmentManager.isAttachmentInProgress((String)message.getKeyString())) {
                        myHolder.preview.setImageDrawable(null);
                        myHolder.preview.setImageBitmap(null);
                        myHolder.attachmentView.setMessage(message);
                        myHolder.attachmentView.setVisibility(0);
                        myHolder.mediaDownloadProgressBar.setVisibility(0);
                        myHolder.attachmentView.setProressBar(myHolder.mediaDownloadProgressBar);
                        myHolder.attachmentView.setDownloadProgressLayout(myHolder.attachmentDownloadProgressLayout);
                        myHolder.preview.setVisibility(0);
                        this.showPreview(message, myHolder.preview, myHolder.attachmentDownloadLayout);
                        FileMeta fileMeta = message.getFileMetas();
                        String mimeType = FileUtils.getMimeType((String)fileMeta.getName());
                        if (!fileMeta.getContentType().contains("image") && !fileMeta.getContentType().contains("video")) {
                            this.showAttachmentIconAndText(myHolder.attachedFile, message, mimeType);
                        }
                        myHolder.downloadSizeTextView.setText((CharSequence)fileMeta.getSizeInReadableFormat());
                        myHolder.attachmentView.setDownloadProgressLayout(myHolder.attachmentDownloadProgressLayout);
                        myHolder.attachmentDownloadProgressLayout.setVisibility(0);
                    } else {
                        String fileKeys = message.getFileMetaKeyStrings();
                        i = 0;
                        myHolder.preview.setVisibility(8);
                        this.showPreview(message, myHolder.preview, myHolder.attachmentDownloadLayout);
                        myHolder.preview.setVisibility(0);
                        myHolder.videoIcon.setVisibility(8);
                        if (message.getFileMetas() != null) {
                            FileMeta fileMeta = message.getFileMetas();
                            myHolder.attachmentDownloadLayout.setVisibility(0);
                            myHolder.attachmentDownloadProgressLayout.setVisibility(8);
                            myHolder.downloadSizeTextView.setText((CharSequence)fileMeta.getSizeInReadableFormat());
                            String mimeType = FileUtils.getMimeType((String)fileMeta.getName());
                            if (!fileMeta.getContentType().contains("image") && !fileMeta.getContentType().contains("video")) {
                                this.showAttachmentIconAndText(myHolder.attachedFile, message, mimeType);
                            }
                        }
                    }
                    if (this.isNormalAttachment(message)) {
                        myHolder.videoIcon.setVisibility(8);
                        myHolder.attachedFile.setVisibility(8);
                        myHolder.mainAttachmentLayout.setVisibility(8);
                        myHolder.mainContactShareLayout.setVisibility(8);
                        myHolder.chatLocation.setVisibility(8);
                        myHolder.preview.setVisibility(8);
                        audioView.hideView(false);
                        myHolder.createdAtTime.setText((CharSequence)DateUtils.getFormattedDate((Long)message.getCreatedAtTime()));
                    }
                }
                if (message.isCanceled()) {
                    myHolder.attachmentRetry.setVisibility(0);
                } else {
                    myHolder.attachmentRetry.setVisibility(8);
                }
                myHolder.attachmentRetry.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (Utils.isInternetAvailable((Context)DetailedConversationAdapter.this.context)) {
                            File file = null;
                            if (message != null && message.getFilePaths() != null) {
                                file = new File((String)message.getFilePaths().get(0));
                            }
                            if (file != null && !file.exists()) {
                                Toast.makeText((Context)DetailedConversationAdapter.this.context, (CharSequence)DetailedConversationAdapter.this.context.getString(R.string.file_does_not_exist), (int)0).show();
                                return;
                            }
                            Toast.makeText((Context)DetailedConversationAdapter.this.context, (CharSequence)DetailedConversationAdapter.this.context.getString(R.string.applozic_resending_attachment), (int)1).show();
                            myHolder.mediaUploadProgressBar.setVisibility(0);
                            myHolder.attachmentRetry.setVisibility(8);
                            message.setCanceled(false);
                            DetailedConversationAdapter.this.messageDatabaseService.updateCanceledFlag(message.getMessageId().longValue(), 0);
                            if (DetailedConversationAdapter.this.sendMessageInterfaceCallBack != null) {
                                DetailedConversationAdapter.this.sendMessageInterfaceCallBack.sendMessage(message);
                            }
                        } else {
                            Toast.makeText((Context)DetailedConversationAdapter.this.context, (CharSequence)DetailedConversationAdapter.this.context.getString(R.string.internet_connection_not_available), (int)0).show();
                        }
                    }
                });
                myHolder.attachmentDownloadProgressLayout.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        myHolder.attachmentView.setVisibility(8);
                        myHolder.attachmentView.cancelDownload();
                        myHolder.attachmentDownloadProgressLayout.setVisibility(8);
                        message.setAttDownloadInProgress(false);
                    }
                });
                myHolder.preview.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (message.getContentType() == Message.ContentType.TEXT_URL.getValue().shortValue()) {
                            return;
                        }
                        if (message.isAttachmentDownloaded()) {
                            if (DetailedConversationAdapter.this.storagePermissionListener.isPermissionGranted()) {
                                DetailedConversationAdapter.this.showFullView(message);
                            } else {
                                DetailedConversationAdapter.this.storagePermissionListener.checkPermission(new ALStoragePermission(){

                                    @Override
                                    public void onAction(boolean didGrant) {
                                        if (didGrant) {
                                            DetailedConversationAdapter.this.showFullView(message);
                                        }
                                    }
                                });
                            }
                        } else if (DetailedConversationAdapter.this.storagePermissionListener.isPermissionGranted()) {
                            myHolder.attachmentDownloadLayout.setVisibility(8);
                            myHolder.mediaDownloadProgressBar.setVisibility(0);
                            myHolder.attachmentView.setProressBar(myHolder.mediaDownloadProgressBar);
                            myHolder.attachmentView.setDownloadProgressLayout(myHolder.attachmentDownloadProgressLayout);
                            myHolder.attachmentView.setMessage(message);
                            myHolder.attachmentView.setVisibility(0);
                            myHolder.attachmentDownloadProgressLayout.setVisibility(0);
                        } else {
                            DetailedConversationAdapter.this.storagePermissionListener.checkPermission(new ALStoragePermission(){

                                @Override
                                public void onAction(boolean didGrant) {
                                    if (didGrant) {
                                        myHolder.attachmentDownloadLayout.setVisibility(8);
                                        myHolder.mediaDownloadProgressBar.setVisibility(0);
                                        myHolder.attachmentView.setProressBar(myHolder.mediaDownloadProgressBar);
                                        myHolder.attachmentView.setDownloadProgressLayout(myHolder.attachmentDownloadProgressLayout);
                                        myHolder.attachmentView.setMessage(message);
                                        myHolder.attachmentView.setVisibility(0);
                                        myHolder.attachmentDownloadProgressLayout.setVisibility(0);
                                    }
                                }
                            });
                        }
                    }
                });
                myHolder.preview.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        return false;
                    }
                });
                myHolder.attachmentView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (DetailedConversationAdapter.this.storagePermissionListener.isPermissionGranted()) {
                            DetailedConversationAdapter.this.showFullView(message);
                        } else {
                            DetailedConversationAdapter.this.storagePermissionListener.checkPermission(new ALStoragePermission(){

                                @Override
                                public void onAction(boolean didGrant) {
                                    if (didGrant) {
                                        DetailedConversationAdapter.this.showFullView(message);
                                    }
                                }
                            });
                        }
                    }
                });
                myHolder.attachmentView.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        return false;
                    }
                });
                if (myHolder.attachedFile != null) {
                    myHolder.attachedFile.setOnLongClickListener(new View.OnLongClickListener(){

                        public boolean onLongClick(View v) {
                            return false;
                        }
                    });
                }
                if (message.getScheduledAt() != null) {
                    myHolder.createdAtTime.setText((CharSequence)DateUtils.getFormattedDate((Long)message.getScheduledAt()));
                } else if (myHolder.createdAtTime != null && message.isDummyEmptyMessage()) {
                    myHolder.createdAtTime.setText((CharSequence)"");
                } else if (myHolder.createdAtTime != null) {
                    myHolder.createdAtTime.setText((CharSequence)DateUtils.getFormattedDate((Long)message.getCreatedAtTime()));
                }
                String mimeType = "";
                if (TextUtils.isEmpty((CharSequence)message.getMessage())) {
                    myHolder.messageTextView.setVisibility(message.hasAttachment() ? 8 : 8);
                } else {
                    myHolder.messageTextView.setVisibility(message.getContentType() == Message.ContentType.LOCATION.getValue().shortValue() ? 8 : 0);
                }
                if (myHolder.messageTextView != null) {
                    myHolder.messageTextView.setTextColor(message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageTextColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageTextColor()));
                    myHolder.messageTextView.setLinkTextColor(message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageLinkTextColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageLinkTextColor()));
                    if (message.getContentType() == Message.ContentType.TEXT_URL.getValue().shortValue()) {
                        try {
                            myHolder.mapImageView.setVisibility(8);
                            myHolder.attachedFile.setVisibility(8);
                            myHolder.preview.setVisibility(0);
                            this.setMessageText(myHolder.messageTextView, message);
                            this.loadImage.setImageFadeIn(false);
                            this.loadImage.loadImage((Object)message.getFileMetas().getBlobKeyString(), myHolder.preview);
                            myHolder.attachmentDownloadLayout.setVisibility(8);
                        }
                        catch (Exception i) {}
                    } else if (message.getContentType() == Message.ContentType.LOCATION.getValue().shortValue()) {
                        myHolder.chatLocation.setLayoutParams(this.getImageLayoutParam(false));
                        myHolder.chatLocation.setVisibility(0);
                        this.loadImage.setImageFadeIn(false);
                        myHolder.mapImageView.setVisibility(0);
                        this.loadImage.setLoadingImage(R.drawable.applozic_map_offline_thumbnail);
                        this.loadImage.loadImage((Object)LocationUtils.loadStaticMap((String)message.getMessage(), (String)this.geoApiKey), myHolder.mapImageView);
                        myHolder.messageTextView.setVisibility(8);
                        myHolder.preview.setVisibility(8);
                        myHolder.mapImageView.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                String uri = String.format(Locale.ENGLISH, "http://maps.google.com/maps?q=" + LocationUtils.getLocationFromMessage((String)message.getMessage()), new Object[0]);
                                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
                                DetailedConversationAdapter.this.activityContext.startActivity(intent);
                            }
                        });
                    } else if (message.getContentType() == Message.ContentType.PRICE.getValue().shortValue()) {
                        myHolder.mapImageView.setVisibility(8);
                        myHolder.messageTextView.setText((CharSequence)("Final agreed price " + message.getMessage()));
                    } else if (message.getContentType() == Message.ContentType.VIDEO_MSG.getValue().shortValue() && !message.isAttachmentDownloaded()) {
                        myHolder.preview.setVisibility(0);
                        myHolder.mapImageView.setVisibility(8);
                        myHolder.preview.setImageResource(R.drawable.applozic_video_default_thumbnail);
                    } else if (message.getContentType() == Message.ContentType.TEXT_HTML.getValue().shortValue()) {
                        myHolder.mapImageView.setVisibility(8);
                        this.setMessageText(myHolder.messageTextView, message);
                    } else {
                        myHolder.mapImageView.setVisibility(8);
                        myHolder.chatLocation.setVisibility(8);
                        myHolder.messageTextView.setText((CharSequence)EmoticonUtils.getSmiledText((Context)this.activityContext, (CharSequence)message.getMessage(), (EmojiconHandler)this.emojiconHandler));
                    }
                    if (myHolder.messageTextLayout != null) {
                        GradientDrawable bgShape = (GradientDrawable)myHolder.messageTextLayout.getBackground();
                        bgShape.setColor(message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageBackgroundColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageBackgroundColor()));
                        bgShape.setStroke(3, message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageBorderColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageBackgroundColor()));
                    }
                }
                if (!message.hasAttachment()) {
                    myHolder.preview.setVisibility(8);
                    myHolder.mainAttachmentLayout.setVisibility(8);
                    myHolder.mediaDownloadProgressBar.setVisibility(0);
                    myHolder.attachmentView.setVisibility(8);
                    myHolder.videoIcon.setVisibility(8);
                    myHolder.attachedFile.setVisibility(8);
                    myHolder.mainContactShareLayout.setVisibility(8);
                }
                if (message.isTypeUrl()) {
                    new KmLinkPreview(this.activityContext, message, myHolder.urlLoadLayout, this.alCustomizationSettings).createView();
                } else {
                    myHolder.urlLoadLayout.setVisibility(8);
                }
                if (message.getMetadata() != null && "300".equals(message.getMetadata().get("contentType"))) {
                    myHolder.richMessageLayout.setVisibility(0);
                    if (!TextUtils.isEmpty((CharSequence)message.getMessage())) {
                        myHolder.messageTextLayout.setVisibility(0);
                    } else {
                        myHolder.messageTextLayout.setVisibility(8);
                    }
                    try {
                        new AlRichMessage(this.activityContext, myHolder.richMessageLayout, message, this.listener, this.alCustomizationSettings).createRichMessage();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        myHolder.richMessageLayout.setVisibility(8);
                    }
                } else {
                    myHolder.richMessageLayout.setVisibility(8);
                    myHolder.messageTextLayout.setVisibility(0);
                }
                if (message.isContactMessage()) {
                    myHolder.attachedFile.setVisibility(8);
                    myHolder.mainAttachmentLayout.setVisibility(8);
                    this.setupContactShareView(message, myHolder);
                } else {
                    myHolder.mainContactShareLayout.setVisibility(8);
                }
                int startIndex = this.indexOfSearchQuery(message.getMessage());
                if (startIndex != -1) {
                    SpannableString highlightedName = new SpannableString((CharSequence)message.getMessage());
                    highlightedName.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)this.alCustomizationSettings.getMessageSearchTextColor())), startIndex, startIndex + this.searchString.toString().length(), 33);
                    myHolder.messageTextView.setText((CharSequence)highlightedName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setupContactShareView(final Message message, MyViewHolder myViewHolder) {
        myViewHolder.mainContactShareLayout.setVisibility(0);
        myViewHolder.mainContactShareLayout.setLayoutParams(this.getImageLayoutParam(false));
        MobiComVCFParser parser = new MobiComVCFParser();
        try {
            VCFContactData data = parser.parseCVFContactData((String)message.getFilePaths().get(0));
            myViewHolder.shareContactName.setText((CharSequence)data.getName());
            int resId = message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageTextColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageTextColor());
            myViewHolder.shareContactName.setTextColor(resId);
            myViewHolder.shareContactNo.setTextColor(resId);
            myViewHolder.shareEmailContact.setTextColor(resId);
            myViewHolder.addContactButton.setTextColor(resId);
            if (data.getProfilePic() != null) {
                if (this.imageCache.getBitmapFromMemCache(message.getKeyString()) == null) {
                    this.imageCache.addBitmapToCache(message.getKeyString(), data.getProfilePic());
                }
                myViewHolder.shareContactImage.setImageBitmap(this.imageCache.getBitmapFromMemCache(message.getKeyString()));
            }
            if (!TextUtils.isEmpty((CharSequence)data.getTelephoneNumber())) {
                myViewHolder.shareContactNo.setText((CharSequence)data.getTelephoneNumber());
            } else {
                myViewHolder.shareContactNo.setVisibility(8);
            }
            if (data.getEmail() != null) {
                myViewHolder.shareEmailContact.setText((CharSequence)data.getEmail());
            } else {
                myViewHolder.shareEmailContact.setVisibility(8);
            }
            myViewHolder.addContactButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (DetailedConversationAdapter.this.storagePermissionListener.isPermissionGranted()) {
                        Intent intent = new Intent();
                        intent.setAction("android.intent.action.VIEW");
                        Uri outputUri = null;
                        intent.addFlags(1);
                        outputUri = Utils.hasNougat() ? ALFileProvider.getUriForFile((Context)DetailedConversationAdapter.this.context, (String)(Utils.getMetaDataValue((Context)DetailedConversationAdapter.this.context, (String)"com.package.name") + ".applozic.provider"), (File)new File((String)message.getFilePaths().get(0))) : Uri.fromFile((File)new File((String)message.getFilePaths().get(0)));
                        if (intent.resolveActivity(DetailedConversationAdapter.this.context.getPackageManager()) != null) {
                            intent.setDataAndType(outputUri, "text/x-vcard");
                            DetailedConversationAdapter.this.activityContext.startActivity(intent);
                        } else {
                            Toast.makeText((Context)DetailedConversationAdapter.this.context, (int)R.string.info_app_not_found_to_open_file, (int)1).show();
                        }
                    } else {
                        DetailedConversationAdapter.this.storagePermissionListener.checkPermission(new ALStoragePermission(){

                            @Override
                            public void onAction(boolean didGrant) {
                                Intent intent = new Intent();
                                intent.setAction("android.intent.action.VIEW");
                                Uri outputUri = null;
                                intent.addFlags(1);
                                outputUri = Utils.hasNougat() ? ALFileProvider.getUriForFile((Context)DetailedConversationAdapter.this.context, (String)(Utils.getMetaDataValue((Context)DetailedConversationAdapter.this.context, (String)"com.package.name") + ".applozic.provider"), (File)new File((String)message.getFilePaths().get(0))) : Uri.fromFile((File)new File((String)message.getFilePaths().get(0)));
                                if (intent.resolveActivity(DetailedConversationAdapter.this.context.getPackageManager()) != null) {
                                    intent.setDataAndType(outputUri, "text/x-vcard");
                                    DetailedConversationAdapter.this.activityContext.startActivity(intent);
                                } else {
                                    Toast.makeText((Context)DetailedConversationAdapter.this.context, (int)R.string.info_app_not_found_to_open_file, (int)1).show();
                                }
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            Utils.printLog((Context)this.context, (String)"DetailedConvAdapter", (String)"Exception in parsing");
        }
    }

    public void setMessageText(TextView messageTextView, Message message) {
        if (Build.VERSION.SDK_INT >= 24) {
            messageTextView.setText((CharSequence)Html.fromHtml((String)message.getMessage(), (int)63));
        } else {
            messageTextView.setText((CharSequence)Html.fromHtml((String)message.getMessage()));
        }
    }

    private void loadContactImage(Contact contact, Contact contactDisplayName, Message messageObj, ImageView contactImage, TextView alphabeticTextView, TextView onlineTextView) {
        if (alphabeticTextView != null) {
            String contactNumber = "";
            char firstLetter = '\u0000';
            if (contact != null) {
                contactNumber = contact.getDisplayName().toUpperCase();
                firstLetter = contact.getDisplayName().toUpperCase().charAt(0);
            } else if (this.channel != null && contactDisplayName != null) {
                firstLetter = contactDisplayName.getDisplayName().toUpperCase().charAt(0);
                contactNumber = contactDisplayName.getDisplayName().toUpperCase();
            }
            if (firstLetter != '+') {
                alphabeticTextView.setText((CharSequence)String.valueOf(firstLetter));
            } else if (!TextUtils.isEmpty((CharSequence)contactNumber) && contactNumber.length() >= 2) {
                alphabeticTextView.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
            }
            Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
            GradientDrawable bgShape = (GradientDrawable)alphabeticTextView.getBackground();
            bgShape.setColor(this.context.getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
        }
        if (contact != null && contact.isDrawableResources() && contactImage != null) {
            int drawableResourceId = this.context.getResources().getIdentifier(contact.getrDrawableName(), "drawable", this.context.getPackageName());
            contactImage.setImageResource(drawableResourceId);
            contactImage.setVisibility(0);
            alphabeticTextView.setVisibility(8);
        } else if (contact != null && contactImage != null) {
            if (TextUtils.isEmpty((CharSequence)contact.getImageURL())) {
                contactImage.setVisibility(8);
                alphabeticTextView.setVisibility(0);
            } else {
                this.contactImageLoader.loadImage((Object)contact, contactImage, alphabeticTextView);
            }
        }
        if (contactDisplayName != null && contactDisplayName.isDrawableResources() && contactImage != null) {
            int drawableResourceId = this.context.getResources().getIdentifier(contactDisplayName.getrDrawableName(), "drawable", this.context.getPackageName());
            contactImage.setImageResource(drawableResourceId);
            contactImage.setVisibility(0);
            alphabeticTextView.setVisibility(8);
        } else if (contactDisplayName != null && contactImage != null) {
            if (this.alCustomizationSettings.isGroupUsersOnlineStatus() && onlineTextView != null) {
                if (contactDisplayName.isConnected()) {
                    onlineTextView.setVisibility(0);
                } else {
                    onlineTextView.setVisibility(8);
                }
            }
            if (TextUtils.isEmpty((CharSequence)contactDisplayName.getImageURL())) {
                contactImage.setVisibility(8);
                alphabeticTextView.setVisibility(0);
            } else {
                this.contactImageLoader.loadImage((Object)contactDisplayName, contactImage, alphabeticTextView);
            }
        }
    }

    private void showAttachmentIconAndText(TextView attachedFile, final Message message, final String mimeType) {
        String fileName = "";
        if (message.getFileMetas() == null && message.getFilePaths() != null) {
            fileName = ((String)message.getFilePaths().get(0)).substring(((String)message.getFilePaths().get(0)).lastIndexOf("/") + 1);
        } else if (message.getFileMetas() != null) {
            fileName = message.getFileMetas().getName();
        }
        attachedFile.setTextColor(message.isTypeOutbox() ? Color.parseColor((String)this.alCustomizationSettings.getSentMessageTextColor()) : Color.parseColor((String)this.alCustomizationSettings.getReceivedMessageTextColor()));
        attachedFile.setText((CharSequence)fileName);
        attachedFile.setVisibility(0);
        attachedFile.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    if (message.isAttachmentDownloaded()) {
                        Intent intent = new Intent();
                        intent.setAction("android.intent.action.VIEW");
                        Uri outputUri = Utils.hasNougat() ? ALFileProvider.getUriForFile((Context)DetailedConversationAdapter.this.context, (String)(Utils.getMetaDataValue((Context)DetailedConversationAdapter.this.context, (String)"com.package.name") + ".applozic.provider"), (File)new File((String)message.getFilePaths().get(0))) : Uri.fromFile((File)new File((String)message.getFilePaths().get(0)));
                        intent.addFlags(1);
                        if (intent.resolveActivity(DetailedConversationAdapter.this.context.getPackageManager()) != null) {
                            intent.setDataAndType(outputUri, mimeType);
                            DetailedConversationAdapter.this.activityContext.startActivity(intent);
                        } else {
                            Toast.makeText((Context)DetailedConversationAdapter.this.context, (int)R.string.info_app_not_found_to_open_file, (int)1).show();
                        }
                    }
                }
                catch (Exception e) {
                    Utils.printLog((Context)DetailedConversationAdapter.this.context, (String)DetailedConversationAdapter.TAG, (String)"No application found to open this file");
                }
            }
        });
    }

    private void showPreview(Message message, ImageView preview, LinearLayout attachmentDownloadLayout) {
        this.imageThumbnailLoader.setImageFadeIn(false);
        this.imageThumbnailLoader.setLoadingImage(R.id.media_upload_progress_bar);
        this.imageThumbnailLoader.loadImage((Object)message, preview);
        attachmentDownloadLayout.setVisibility(8);
    }

    private void showFullView(Message smListItem) {
        try {
            String mimeType = FileUtils.getMimeType((String)((String)smListItem.getFilePaths().get(0)));
            if (mimeType != null) {
                if (mimeType.startsWith("image")) {
                    Intent intent = new Intent(this.activityContext, FullScreenImageActivity.class);
                    intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)smListItem, Message.class));
                    ((MobiComKitActivityInterface)this.activityContext).startActivityForResult(intent, 301);
                }
                if (mimeType.startsWith("video") && smListItem.isAttachmentDownloaded()) {
                    Intent intentVideo = new Intent();
                    intentVideo.setAction("android.intent.action.VIEW");
                    Uri outputUri = Utils.hasNougat() ? ALFileProvider.getUriForFile((Context)this.context, (String)(Utils.getMetaDataValue((Context)this.context, (String)"com.package.name") + ".applozic.provider"), (File)new File((String)smListItem.getFilePaths().get(0))) : Uri.fromFile((File)new File((String)smListItem.getFilePaths().get(0)));
                    intentVideo.addFlags(1);
                    if (intentVideo.resolveActivity(this.context.getPackageManager()) != null) {
                        intentVideo.setDataAndType(outputUri, "video/*");
                        this.activityContext.startActivity(intentVideo);
                    } else {
                        Toast.makeText((Context)this.context, (int)R.string.info_app_not_found_to_open_file, (int)1).show();
                    }
                }
            }
        }
        catch (Exception e) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"No application found to open this file");
        }
    }

    public int getItemViewType(int position) {
        Message message = this.getItem(position);
        if (message == null) {
            return 0;
        }
        if (message.isTempDateType()) {
            return 2;
        }
        if (message.isCustom()) {
            return 3;
        }
        if (message.isChannelCustomMessage()) {
            return 4;
        }
        if (message.isVideoCallMessage()) {
            return 5;
        }
        return message.isTypeOutbox() ? 1 : 0;
    }

    private Message getItem(int position) {
        return this.messageList.get(position);
    }

    public int getItemCount() {
        return this.messageList.size();
    }

    public long getItemId(int position) {
        return position;
    }

    public ViewGroup.LayoutParams getImageLayoutParam(boolean outBoxType) {
        RelativeLayout.LayoutParams params;
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        float wt_px = TypedValue.applyDimension((int)1, (float)60.0f, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
        if (outBoxType) {
            params = new RelativeLayout.LayoutParams(metrics.widthPixels + (int)wt_px * 2, -2);
            params.setMargins((int)wt_px, 0, (int)wt_px, 0);
        } else {
            params = new LinearLayout.LayoutParams(metrics.widthPixels - (int)wt_px * 2, -2);
            params.setMargins(0, 0, 0, 0);
        }
        return params;
    }

    public Filter getFilter() {
        return new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                Filter.FilterResults oReturn = new Filter.FilterResults();
                ArrayList<Message> results = new ArrayList<Message>();
                if (DetailedConversationAdapter.this.originalList == null) {
                    DetailedConversationAdapter.this.originalList = DetailedConversationAdapter.this.messageList;
                }
                if (constraint != null) {
                    DetailedConversationAdapter.this.searchString = constraint.toString();
                    if (DetailedConversationAdapter.this.originalList != null && DetailedConversationAdapter.this.originalList.size() > 0) {
                        for (Message message : DetailedConversationAdapter.this.originalList) {
                            if (!message.getMessage().toLowerCase().contains(constraint.toString())) continue;
                            results.add(message);
                        }
                    }
                    oReturn.values = results;
                } else {
                    oReturn.values = DetailedConversationAdapter.this.originalList;
                }
                return oReturn;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                DetailedConversationAdapter.this.messageList = (ArrayList)results.values;
                DetailedConversationAdapter.this.notifyDataSetChanged();
            }
        };
    }

    private int indexOfSearchQuery(String message) {
        if (!TextUtils.isEmpty((CharSequence)this.searchString)) {
            return message.toLowerCase(Locale.getDefault()).indexOf(this.searchString.toString().toLowerCase(Locale.getDefault()));
        }
        return -1;
    }

    public void refreshContactData() {
        if (this.contact != null) {
            this.contact = this.contactService.getContactById(this.contact.getContactIds());
        }
    }

    private boolean isNormalAttachment(Message message) {
        String filePath;
        String mimeType;
        if (message.getFileMetas() != null) {
            return !message.getFileMetas().getContentType().contains("image") && !message.getFileMetas().getContentType().contains("video") && !message.isContactMessage();
        }
        if (message.getFilePaths() != null && (mimeType = FileUtils.getMimeType((String)(filePath = (String)message.getFilePaths().get(0)))) != null) {
            return !mimeType.contains("image") && !mimeType.contains("video") && !message.isContactMessage();
        }
        return false;
    }

    public void sendCallback(List<Message> messageList, int pos) {
        Message message = messageList.get(pos);
        if (message != null && this.context instanceof ALProfileClickListener) {
            ((ALProfileClickListener)this.context).onClick(this.activityContext, message.getTo(), this.channel, false);
        }
    }

    class MyViewHolder5
    extends RecyclerView.ViewHolder {
        TextView statusTextView;
        TextView timeTextView;
        TextView durationTextView;
        ImageView imageView;

        public MyViewHolder5(View itemView) {
            super(itemView);
            this.statusTextView = (TextView)itemView.findViewById(R.id.applozic_call_status);
            this.timeTextView = (TextView)itemView.findViewById(R.id.applozic_call_timing);
            this.durationTextView = (TextView)itemView.findViewById(R.id.applozic_call_duration);
            this.imageView = (ImageView)itemView.findViewById(R.id.applozic_call_image_type);
        }
    }

    class MyViewHolder4
    extends RecyclerView.ViewHolder {
        TextView channelMessageTextView;

        public MyViewHolder4(View itemView) {
            super(itemView);
            this.channelMessageTextView = (TextView)itemView.findViewById(R.id.channel_message);
        }
    }

    class MyViewHolder3
    extends RecyclerView.ViewHolder {
        TextView customContentTextView;

        public MyViewHolder3(View itemView) {
            super(itemView);
            this.customContentTextView = (TextView)itemView.findViewById(R.id.applozic_custom_message_layout_content);
        }
    }

    class MyViewHolder2
    extends RecyclerView.ViewHolder {
        TextView dateView;
        TextView dayTextView;

        public MyViewHolder2(View itemView) {
            super(itemView);
            this.dateView = (TextView)itemView.findViewById(R.id.chat_screen_date);
            this.dayTextView = (TextView)itemView.findViewById(R.id.chat_screen_day);
        }
    }

    class MyViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnCreateContextMenuListener {
        ImageView mapImageView;
        RelativeLayout chatLocation;
        TextView downloadSizeTextView;
        AttachmentView attachmentView;
        LinearLayout attachmentDownloadLayout;
        ImageView preview;
        LinearLayout attachmentRetry;
        RelativeLayout attachmentDownloadProgressLayout;
        RelativeLayout mainAttachmentLayout;
        LinearLayout mainContactShareLayout;
        ImageView videoIcon;
        ProgressBar mediaDownloadProgressBar;
        ProgressBar mediaUploadProgressBar;
        ImageView attachmentIcon;
        ImageView shareContactImage;
        TextView alphabeticTextView;
        CircleImageView contactImage;
        View messageTextLayout;
        TextView nameTextView;
        TextView attachedFile;
        ImageView sentOrReceived;
        TextView messageTextView;
        TextView createdAtTime;
        TextView onlineTextView;
        TextView selfDestruct;
        TextView deliveryStatus;
        TextView shareContactName;
        TextView shareContactNo;
        TextView shareEmailContact;
        LinearLayout nameTextLayout;
        View view;
        RelativeLayout replyRelativeLayout;
        RelativeLayout imageViewRLayout;
        TextView replyMessageTextView;
        ImageView imageViewPhoto;
        TextView replyNameTextView;
        ImageView imageViewForAttachmentType;
        Button addContactButton;
        int position;
        LinearLayout richMessageLayout;
        RelativeLayout urlLoadLayout;
        private final MenuItem.OnMenuItemClickListener onEditMenu;

        public MyViewHolder(View customView) {
            super(customView);
            this.onEditMenu = new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    int position = MyViewHolder.this.getLayoutPosition();
                    if (position < 0 || DetailedConversationAdapter.this.messageList.isEmpty()) {
                        return true;
                    }
                    return DetailedConversationAdapter.this.contextMenuClickListener == null || DetailedConversationAdapter.this.contextMenuClickListener.onItemClick(position, item);
                }
            };
            this.position = this.getLayoutPosition();
            this.view = customView;
            this.mapImageView = (ImageView)customView.findViewById(R.id.static_mapview);
            this.chatLocation = (RelativeLayout)customView.findViewById(R.id.chat_location);
            this.preview = (ImageView)customView.findViewById(R.id.preview);
            this.attachmentView = (AttachmentView)customView.findViewById(R.id.main_attachment_view);
            this.attachmentIcon = (ImageView)customView.findViewById(R.id.attachmentIcon);
            this.downloadSizeTextView = (TextView)customView.findViewById(R.id.attachment_size_text);
            this.attachmentDownloadLayout = (LinearLayout)customView.findViewById(R.id.attachment_download_layout);
            this.attachmentRetry = (LinearLayout)customView.findViewById(R.id.attachment_retry_layout);
            this.attachmentDownloadProgressLayout = (RelativeLayout)customView.findViewById(R.id.attachment_download_progress_layout);
            this.mainAttachmentLayout = (RelativeLayout)customView.findViewById(R.id.attachment_preview_layout);
            this.mainContactShareLayout = (LinearLayout)customView.findViewById(R.id.contact_share_layout);
            this.videoIcon = (ImageView)customView.findViewById(R.id.video_icon);
            this.mediaDownloadProgressBar = (ProgressBar)customView.findViewById(R.id.media_download_progress_bar);
            this.mediaUploadProgressBar = (ProgressBar)customView.findViewById(R.id.media_upload_progress_bar);
            this.messageTextLayout = customView.findViewById(R.id.messageTextLayout);
            this.createdAtTime = (TextView)customView.findViewById(R.id.createdAtTime);
            this.messageTextView = (TextView)customView.findViewById(R.id.message);
            this.contactImage = (CircleImageView)customView.findViewById(R.id.contactImage);
            this.alphabeticTextView = (TextView)customView.findViewById(R.id.alphabeticImage);
            this.deliveryStatus = (TextView)customView.findViewById(R.id.status);
            this.selfDestruct = (TextView)customView.findViewById(R.id.selfDestruct);
            this.nameTextView = (TextView)customView.findViewById(R.id.name_textView);
            this.attachedFile = (TextView)customView.findViewById(R.id.attached_file);
            this.onlineTextView = (TextView)customView.findViewById(R.id.onlineTextView);
            this.nameTextLayout = (LinearLayout)customView.findViewById(R.id.nameTextLayout);
            this.replyRelativeLayout = (RelativeLayout)customView.findViewById(R.id.reply_message_layout);
            this.imageViewRLayout = (RelativeLayout)customView.findViewById(R.id.imageViewRLayout);
            this.replyMessageTextView = (TextView)customView.findViewById(R.id.messageTextView);
            this.imageViewPhoto = (ImageView)customView.findViewById(R.id.imageViewForPhoto);
            this.replyNameTextView = (TextView)customView.findViewById(R.id.replyNameTextView);
            this.imageViewForAttachmentType = (ImageView)customView.findViewById(R.id.imageViewForAttachmentType);
            this.urlLoadLayout = (RelativeLayout)customView.findViewById(R.id.url_load_layout);
            this.shareContactImage = (ImageView)this.mainContactShareLayout.findViewById(R.id.contact_share_image);
            this.shareContactName = (TextView)this.mainContactShareLayout.findViewById(R.id.contact_share_tv_name);
            this.shareContactNo = (TextView)this.mainContactShareLayout.findViewById(R.id.contact_share_tv_no);
            this.shareEmailContact = (TextView)this.mainContactShareLayout.findViewById(R.id.contact_share_emailId);
            this.addContactButton = (Button)this.mainContactShareLayout.findViewById(R.id.contact_share_add_btn);
            this.richMessageLayout = (LinearLayout)customView.findViewById(R.id.alRichMessageView);
            customView.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
            this.mapImageView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return false;
                }
            });
            this.preview.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return false;
                }
            });
            if (this.contactImage != null) {
                this.contactImage.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        DetailedConversationAdapter.this.sendCallback(DetailedConversationAdapter.this.messageList, MyViewHolder.this.getLayoutPosition());
                    }
                });
            }
            if (this.alphabeticTextView != null) {
                this.alphabeticTextView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        DetailedConversationAdapter.this.sendCallback(DetailedConversationAdapter.this.messageList, MyViewHolder.this.getLayoutPosition());
                    }
                });
            }
            this.attachmentView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return false;
                }
            });
        }

        public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
            menu2.setHeaderTitle(R.string.messageOptions);
            int positionInSmsList = this.getLayoutPosition();
            if (positionInSmsList < 0 || DetailedConversationAdapter.this.messageList.isEmpty()) {
                return;
            }
            Message message = (Message)DetailedConversationAdapter.this.messageList.get(positionInSmsList);
            if (message.isTempDateType() || message.isCustom() || message.isChannelCustomMessage()) {
                return;
            }
            String[] menuItems = DetailedConversationAdapter.this.context.getResources().getStringArray(R.array.menu);
            for (int i = 0; i < menuItems.length; ++i) {
                if ((!message.isGroupMessage() || !message.isTypeOutbox() || !message.isSentToServer()) && menuItems[i].equals(DetailedConversationAdapter.this.context.getResources().getString(R.string.info)) || (message.isDeletedForAll() || message.hasAttachment() || message.getContentType() == Message.ContentType.LOCATION.getValue().shortValue() || message.isVideoOrAudioCallMessage()) && menuItems[i].equals(DetailedConversationAdapter.this.context.getResources().getString(R.string.copy)) || menuItems[i].equals(DetailedConversationAdapter.this.context.getResources().getString(R.string.forward)) && (!DetailedConversationAdapter.this.alCustomizationSettings.isForwardOption() || message.isDeletedForAll()) || (DetailedConversationAdapter.this.channel != null && Channel.GroupType.OPEN.getValue().equals(DetailedConversationAdapter.this.channel.getType()) || message.isCall() || message.hasAttachment() && !message.isAttachmentDownloaded() || message.isVideoOrAudioCallMessage() || message.isDeletedForAll()) && (menuItems[i].equals(DetailedConversationAdapter.this.context.getResources().getString(R.string.forward)) || menuItems[i].equals(DetailedConversationAdapter.this.context.getResources().getString(R.string.resend))) || menuItems[i].equals(DetailedConversationAdapter.this.context.getResources().getString(R.string.resend)) && (!message.isSentViaApp() || message.isSentToServer() || message.isVideoOrAudioCallMessage() || message.isDeletedForAll()) || menuItems[i].equals(DetailedConversationAdapter.this.context.getResources().getString(R.string.reply)) && (!DetailedConversationAdapter.this.alCustomizationSettings.isReplyOption() || message.isAttachmentUploadInProgress() || TextUtils.isEmpty((CharSequence)message.getKeyString()) || !message.isSentToServer() || message.hasAttachment() && !message.isAttachmentDownloaded() || message.isDeletedForAll() || DetailedConversationAdapter.this.channel != null && !Channel.GroupType.OPEN.getValue().equals(DetailedConversationAdapter.this.channel.getType()) && !ChannelService.getInstance((Context)DetailedConversationAdapter.this.context).processIsUserPresentInChannel(DetailedConversationAdapter.this.channel.getKey()) || message.isVideoOrAudioCallMessage() || DetailedConversationAdapter.this.contact != null && DetailedConversationAdapter.this.contact.isDeleted()) || menuItems[i].equals(DetailedConversationAdapter.this.context.getResources().getString(R.string.share)) && (message.isAttachmentUploadInProgress() || message.getFilePaths() == null || message.isDeletedForAll() || !new File((String)message.getFilePaths().get(0)).exists()) || menuItems[i].equals(ApplozicService.getContext((Context)DetailedConversationAdapter.this.context).getString(R.string.report)) && (!DetailedConversationAdapter.this.alCustomizationSettings.isMessageReportEnabled() || message.isTypeOutbox() || message.isDeletedForAll()) || !DetailedConversationAdapter.this.alCustomizationSettings.isDeleteMessageOption() && menuItems[i].equals(DetailedConversationAdapter.this.context.getResources().getString(R.string.delete)) || TextUtils.isEmpty((CharSequence)message.getKeyString()) || DetailedConversationAdapter.this.channel != null && Channel.GroupType.OPEN.getValue().equals(DetailedConversationAdapter.this.channel.getType()) || menuItems[i].equals(DetailedConversationAdapter.this.context.getResources().getString(R.string.info)) && (TextUtils.isEmpty((CharSequence)message.getKeyString()) || DetailedConversationAdapter.this.channel != null && Channel.GroupType.OPEN.getValue().equals(DetailedConversationAdapter.this.channel.getType()) || message.isVideoOrAudioCallMessage() || DetailedConversationAdapter.this.channel != null && Channel.GroupType.OPEN.getValue().equals(DetailedConversationAdapter.this.channel.getType())) || menuItems[i].equals(Utils.getString((Context)DetailedConversationAdapter.this.context, (int)R.string.delete_for_all)) && (!DetailedConversationAdapter.this.alCustomizationSettings.isDeleteForAllMessageOption() && !ApplozicSetting.getInstance(DetailedConversationAdapter.this.context).isMessageDeleteForAllOption() || DetailedConversationAdapter.this.channel != null && Channel.GroupType.OPEN.getValue().equals(DetailedConversationAdapter.this.channel.getType()) || DetailedConversationAdapter.this.contact != null || !message.isTypeOutbox() || message.isDeletedForAll())) continue;
                MenuItem item = menu2.add(0, i, i, (CharSequence)menuItems[i]);
                item.setOnMenuItemClickListener(this.onEditMenu);
            }
        }
    }
}

