/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.people.contact;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.drawable.GradientDrawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.AlphabetIndexer;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.SectionIndexer;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.core.content.ContextCompat;
import androidx.cursoradapter.widget.CursorAdapter;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.ListFragment;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.Loader;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.RegisteredUsersAsyncTask;
import com.applozic.mobicomkit.api.people.ChannelInfo;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.applozic.mobicomkit.feed.ChannelFeedApiResponse;
import com.applozic.mobicomkit.feed.ErrorResponseFeed;
import com.applozic.mobicomkit.feed.RegisteredUsersApiResponse;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicomkit.uiwidgets.async.AlChannelCreateAsyncTask;
import com.applozic.mobicomkit.uiwidgets.async.AlGetMembersFromContactGroupListTask;
import com.applozic.mobicomkit.uiwidgets.async.ApplozicGetMemberFromContactGroupTask;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ContactSelectionActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.SearchListFragment;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ContactSelectionFragment
extends ListFragment
implements SearchListFragment,
AdapterView.OnItemClickListener,
LoaderManager.LoaderCallbacks<Cursor> {
    public static final String CHANNEL = "CHANNEL_NAME";
    public static final String CHANNEL_OBJECT = "CHANNEL";
    public static final String CHECK_BOX = "CHECK_BOX";
    public static final String IMAGE_LINK = "IMAGE_LINK";
    public static final String GROUP_TYPE = "GROUP_TYPE";
    private static final String STATE_PREVIOUSLY_SELECTED_KEY = "SELECTED_ITEM";
    ContactDatabase contactDatabase;
    boolean disableCheckBox;
    boolean isUserPresnt;
    AppContactService appContactService;
    Channel channel;
    MobiComUserPreference userPreference;
    AlCustomizationSettings alCustomizationSettings;
    String contactsGroupId;
    private String mSearchTerm;
    private ContactsAdapter mAdapter;
    private ImageLoader mImageLoader;
    private int mPreviouslySelectedSearchItem = 0;
    private String imageUrl;
    private String channelName;
    private int groupType;
    private String[] groupContacts;
    private Bundle bundle;
    private List<String> userIdList;
    private View footerView;
    RefreshContactsScreenBroadcast refreshContactsScreenBroadcast;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.bundle = this.getArguments();
        String jsonString = FileUtils.loadSettingsJsonFile((Context)this.getActivity().getApplicationContext());
        this.alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
        this.userPreference = MobiComUserPreference.getInstance((Context)this.getActivity());
        if (this.bundle != null) {
            this.channel = (Channel)this.bundle.getSerializable(CHANNEL_OBJECT);
            this.disableCheckBox = this.bundle.getBoolean(CHECK_BOX, false);
            this.channelName = this.bundle.getString(CHANNEL);
            this.imageUrl = this.bundle.getString(IMAGE_LINK);
            this.groupType = this.bundle.getInt(GROUP_TYPE);
            this.contactsGroupId = this.userPreference.getContactsGroupId();
        }
        this.setHasOptionsMenu(true);
        this.refreshContactsScreenBroadcast = new RefreshContactsScreenBroadcast();
        if (savedInstanceState != null) {
            this.mSearchTerm = savedInstanceState.getString("query");
            this.mPreviouslySelectedSearchItem = savedInstanceState.getInt(STATE_PREVIOUSLY_SELECTED_KEY, 0);
        }
        this.contactDatabase = new ContactDatabase(this.getContext());
        this.appContactService = new AppContactService((Context)this.getActivity());
        this.mAdapter = new ContactsAdapter((Context)this.getActivity());
        final Context context = this.getActivity().getApplicationContext();
        this.mImageLoader = new ImageLoader(context, this.getListPreferredItemHeight()){

            protected Bitmap processBitmap(Object data) {
                return ContactSelectionFragment.this.appContactService.downloadContactImage(context, (Contact)data);
            }
        };
        this.mImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
        this.mImageLoader.addImageCache(this.getActivity().getSupportFragmentManager(), 0.1f);
        this.mImageLoader.setImageFadeIn(false);
        if (this.contactsGroupId != null) {
            ChannelDatabaseService channelDatabaseService = ChannelDatabaseService.getInstance((Context)context);
            this.groupContacts = channelDatabaseService.getChannelMemberByName(this.contactsGroupId, String.valueOf(Channel.GroupType.CONTACT_GROUP.getValue()));
            if (Utils.isInternetAvailable((Context)this.getContext())) {
                ApplozicGetMemberFromContactGroupTask.GroupMemberListener eventMemberListener = new ApplozicGetMemberFromContactGroupTask.GroupMemberListener(){

                    @Override
                    public void onSuccess(String[] userIdArray, Context context) {
                        if (ContactSelectionFragment.this.isAdded()) {
                            ContactSelectionFragment.access$102(ContactSelectionFragment.this, new String[userIdArray.length]);
                            ContactSelectionFragment.access$102(ContactSelectionFragment.this, userIdArray);
                            ContactSelectionFragment.this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)ContactSelectionFragment.this);
                        }
                    }

                    @Override
                    public void onFailure(String response, Context context) {
                    }
                };
                ApplozicGetMemberFromContactGroupTask applozicGetMemberFromContactGroupTask = new ApplozicGetMemberFromContactGroupTask((Context)this.getActivity(), this.contactsGroupId, String.valueOf(Channel.GroupType.CONTACT_GROUP.getValue()), eventMemberListener);
                applozicGetMemberFromContactGroupTask.execute(new Void[0]);
            } else if (this.groupContacts != null) {
                this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)this);
            }
        } else if (MobiComUserPreference.getInstance((Context)this.getContext()).getContactGroupIdList() != null && !MobiComUserPreference.getInstance((Context)this.getContext()).getContactGroupIdList().isEmpty()) {
            ArrayList<String> groupList = new ArrayList<String>();
            groupList.addAll(MobiComUserPreference.getInstance((Context)this.getContext()).getContactGroupIdList());
            final ProgressDialog progressBar = new ProgressDialog(this.getContext());
            progressBar.setMessage((CharSequence)this.getContext().getResources().getString(R.string.processing_please_wait));
            progressBar.show();
            AlGetMembersFromContactGroupListTask.GetMembersFromGroupIdListListener listener = new AlGetMembersFromContactGroupListTask.GetMembersFromGroupIdListListener(){

                @Override
                public void onSuccess(Context context, String response, String[] contactList) {
                    progressBar.dismiss();
                    ContactSelectionFragment.access$102(ContactSelectionFragment.this, contactList);
                    ContactSelectionFragment.this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)ContactSelectionFragment.this);
                }

                @Override
                public void onFailure(Context context, String response, Exception e) {
                    progressBar.dismiss();
                    Toast.makeText((Context)ContactSelectionFragment.this.getContext(), (CharSequence)("Failed to load contacts : Response : " + response + "\nException : " + e), (int)0).show();
                }
            };
            if (MobiComUserPreference.getInstance((Context)this.getContext()).isContactGroupNameList()) {
                new AlGetMembersFromContactGroupListTask(this.getContext(), listener, null, groupList, "9").execute(new Void[0]);
            } else {
                new AlGetMembersFromContactGroupListTask(this.getContext(), listener, groupList, null, "9").execute(new Void[0]);
            }
        }
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
        Cursor cursor = this.mAdapter.getCursor();
        cursor.moveToPosition(position);
        Contact contact = this.contactDatabase.getContact(cursor, "_id");
        if (this.disableCheckBox) {
            this.isUserPresnt = ChannelService.getInstance((Context)this.getActivity()).isUserAlreadyPresentInChannel(this.channel.getKey(), contact.getContactIds());
            if (!this.isUserPresnt) {
                Intent intent = new Intent();
                intent.putExtra("USERID", contact.getUserId());
                FragmentActivity fragmentActivity = this.getActivity();
                this.getActivity();
                fragmentActivity.setResult(-1, intent);
                this.getActivity().finish();
            }
        } else {
            AppCompatCheckBox checkBox = (AppCompatCheckBox)view.findViewById(R.id.checkbox);
            checkBox.toggle();
            if (checkBox.isChecked()) {
                this.userIdList.add(contact.getContactIds());
            } else if (!checkBox.isChecked()) {
                this.userIdList.remove(contact.getContactIds());
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.setListAdapter((ListAdapter)this.mAdapter);
        this.getListView().setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.getListView().setFastScrollEnabled(true);
        this.getListView().setOnScrollListener((AbsListView.OnScrollListener)new EndlessScrollListener());
        if (this.footerView != null) {
            this.getListView().addFooterView(this.footerView);
        }
        if (this.mPreviouslySelectedSearchItem == 0 && this.contactsGroupId == null && this.userPreference.getContactGroupIdList() == null) {
            this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void onPause() {
        super.onPause();
        this.mImageLoader.setPauseWork(false);
    }

    public void processDownloadRegisteredUsers() {
        if (this.footerView != null) {
            this.footerView.setVisibility(0);
        }
        RegisteredUsersAsyncTask.TaskListener usersAsyncTaskTaskListener = new RegisteredUsersAsyncTask.TaskListener(){

            public void onSuccess(RegisteredUsersApiResponse registeredUsersApiResponse, String[] userIdArray) {
                if (ContactSelectionFragment.this.footerView != null) {
                    ContactSelectionFragment.this.footerView.setVisibility(8);
                }
                if (registeredUsersApiResponse != null) {
                    try {
                        if (!Utils.isInternetAvailable((Context)ContactSelectionFragment.this.getActivity())) {
                            Toast toast = Toast.makeText((Context)ContactSelectionFragment.this.getActivity(), (CharSequence)ContactSelectionFragment.this.getActivity().getString(R.string.applozic_contacts_loading_error), (int)0);
                            toast.setGravity(17, 0, 0);
                            toast.show();
                        }
                        if (registeredUsersApiResponse != null && ContactSelectionFragment.this.contactsGroupId == null) {
                            ContactSelectionFragment.this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)ContactSelectionFragment.this);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            public void onFailure(RegisteredUsersApiResponse registeredUsersApiResponse, String[] userIdArray, Exception exception) {
                if (ContactSelectionFragment.this.footerView != null) {
                    ContactSelectionFragment.this.footerView.setVisibility(8);
                }
                String error = ContactSelectionFragment.this.getString(Utils.isInternetAvailable((Context)ContactSelectionFragment.this.getActivity()) ? R.string.applozic_server_error : R.string.you_need_network_access_for_block_or_unblock);
                Toast toast = Toast.makeText((Context)ContactSelectionFragment.this.getActivity(), (CharSequence)error, (int)1);
                toast.setGravity(17, 0, 0);
                toast.show();
            }

            public void onCompletion() {
            }
        };
        RegisteredUsersAsyncTask usersAsyncTask = new RegisteredUsersAsyncTask((Context)this.getActivity(), usersAsyncTaskTaskListener, this.alCustomizationSettings.getTotalRegisteredUserToFetch(), this.userPreference.getRegisteredUsersLastFetchTime(), null, null, true);
        usersAsyncTask.execute((Object[])new Void[]{null});
    }

    private int getListPreferredItemHeight() {
        TypedValue typedValue = new TypedValue();
        this.getActivity().getTheme().resolveAttribute(16842829, typedValue, true);
        DisplayMetrics metrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return (int)typedValue.getDimension(metrics);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.contact_list_fragment, container, false);
        Button shareButton = (Button)view.findViewById(R.id.actionButton);
        shareButton.setVisibility(this.alCustomizationSettings.isInviteFriendsInContactActivity() ? 0 : 8);
        TextView resultTextView = (TextView)view.findViewById(R.id.result);
        this.footerView = inflater.inflate(R.layout.mobicom_message_list_header_footer, null, false);
        if (this.footerView != null) {
            this.footerView.setVisibility(8);
        }
        return view;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.Done) {
            if (this.userIdList != null && this.userIdList.size() == 0) {
                Toast.makeText((Context)this.getActivity(), (int)R.string.select_at_least, (int)0).show();
            } else {
                final ProgressDialog progressDialog = ProgressDialog.show((Context)this.getActivity(), (CharSequence)"", (CharSequence)this.getActivity().getString(TextUtils.isEmpty((CharSequence)this.channelName) ? R.string.broadcast_creating_info : R.string.group_creating_info), (boolean)true);
                AlChannelCreateAsyncTask.TaskListenerInterface taskListenerInterface = new AlChannelCreateAsyncTask.TaskListenerInterface(){

                    @Override
                    public void onSuccess(Channel channel, Context context) {
                        if (progressDialog != null && progressDialog.isShowing()) {
                            progressDialog.dismiss();
                        }
                        if (channel != null) {
                            Intent intent = new Intent((Context)ContactSelectionFragment.this.getActivity(), ConversationActivity.class);
                            if (ApplozicClient.getInstance((Context)ContactSelectionFragment.this.getActivity().getApplicationContext()).isContextBasedChat()) {
                                intent.putExtra("contextBasedChat", true);
                            }
                            intent.putExtra("groupId", (Serializable)channel.getKey());
                            intent.putExtra("groupName", channel.getName());
                            ContactSelectionFragment.this.getActivity().startActivity(intent);
                        }
                        if (ContactSelectionFragment.this.bundle != null && ContactSelectionFragment.this.bundle.getString(ContactSelectionFragment.CHANNEL) != null) {
                            ContactSelectionFragment.this.getActivity().sendBroadcast(new Intent("channelCreateActivity.ACTION_FINISH"));
                        }
                        if (ContactSelectionFragment.this.getActivity() != null) {
                            ContactSelectionFragment.this.getActivity().finish();
                        }
                    }

                    @Override
                    public void onFailure(ChannelFeedApiResponse channelFeedApiResponse, Context context) {
                        if (progressDialog != null && progressDialog.isShowing()) {
                            progressDialog.dismiss();
                        }
                        if (channelFeedApiResponse != null) {
                            ErrorResponseFeed errorResponseFeed;
                            String errorDescription;
                            List error = channelFeedApiResponse.getErrorResponse();
                            if (error != null && error.size() > 0 && !TextUtils.isEmpty((CharSequence)(errorDescription = (errorResponseFeed = (ErrorResponseFeed)error.get(0)).getDescription()))) {
                                if ("GROUP_USER_LIMIT_EXCEED".equalsIgnoreCase(errorDescription)) {
                                    Toast.makeText((Context)context, (int)R.string.group_members_limit_exceeds, (int)0).show();
                                } else {
                                    Toast.makeText((Context)context, (int)R.string.applozic_server_error, (int)0).show();
                                }
                            }
                        } else {
                            Toast.makeText((Context)context, (int)(Utils.isInternetAvailable((Context)context) ? R.string.applozic_server_error : R.string.you_dont_have_any_network_access_info), (int)0).show();
                        }
                    }
                };
                if (this.userIdList != null && this.userIdList.size() > 0) {
                    if (TextUtils.isEmpty((CharSequence)this.channelName)) {
                        StringBuffer stringBuffer = new StringBuffer();
                        int i = 0;
                        for (String userId : this.userIdList) {
                            if (++i > 10) break;
                            Contact contactDisplayName = this.appContactService.getContactById(userId);
                            stringBuffer.append(contactDisplayName.getDisplayName()).append(",");
                        }
                        int lastIndex = stringBuffer.lastIndexOf(",");
                        this.channelName = stringBuffer.replace(lastIndex, lastIndex + 1, "").toString();
                    }
                    ChannelInfo channelInfo = new ChannelInfo(this.channelName, this.userIdList);
                    if (!TextUtils.isEmpty((CharSequence)this.imageUrl)) {
                        channelInfo.setImageUrl(this.imageUrl);
                    }
                    if (this.groupType == Channel.GroupType.BROADCAST.getValue()) {
                        channelInfo.setType(this.groupType);
                    } else if (this.alCustomizationSettings != null) {
                        channelInfo.setType(this.alCustomizationSettings.getDefaultGroupType());
                    } else {
                        channelInfo.setType(this.groupType);
                    }
                    if (MobiComUserPreference.getInstance((Context)this.getActivity()).getParentGroupKey() != null && MobiComUserPreference.getInstance((Context)this.getActivity()).getParentGroupKey() != 0) {
                        channelInfo.setParentKey(MobiComUserPreference.getInstance((Context)this.getActivity()).getParentGroupKey());
                    }
                    AlChannelCreateAsyncTask alChannelCreateAsyncTask = new AlChannelCreateAsyncTask((Context)this.getActivity(), channelInfo, taskListenerInterface);
                    alChannelCreateAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
                }
            }
            return true;
        }
        return false;
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        return this.contactDatabase.getSearchCursorLoader(this.mSearchTerm, this.groupContacts, MobiComUserPreference.getInstance((Context)this.getActivity()).getParentGroupKey());
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        if (loader.getId() == 1) {
            this.mAdapter.swapCursor(data);
        }
    }

    public void onLoaderReset(Loader<Cursor> loader) {
        if (loader.getId() == 1) {
            this.mAdapter.swapCursor(null);
        }
    }

    public boolean onQueryTextChange(String newText) {
        String newFilter;
        this.mSearchTerm = newFilter = !TextUtils.isEmpty((CharSequence)newText) ? newText : null;
        this.mAdapter.indexOfSearchQuery(newFilter);
        this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)this);
        return true;
    }

    public void restartLoader() {
        if (this.getLoaderManager() != null) {
            this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.refreshContactsScreenBroadcast != null) {
            LocalBroadcastManager.getInstance((Context)this.getActivity()).registerReceiver((BroadcastReceiver)this.refreshContactsScreenBroadcast, new IntentFilter(BroadcastService.INTENT_ACTIONS.UPDATE_USER_DETAIL.toString()));
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.refreshContactsScreenBroadcast != null) {
            LocalBroadcastManager.getInstance((Context)this.getActivity()).unregisterReceiver((BroadcastReceiver)this.refreshContactsScreenBroadcast);
        }
    }

    static /* synthetic */ String[] access$102(ContactSelectionFragment x0, String[] x1) {
        x0.groupContacts = x1;
        return x1;
    }

    private final class RefreshContactsScreenBroadcast
    extends BroadcastReceiver {
        private RefreshContactsScreenBroadcast() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent != null && BroadcastService.INTENT_ACTIONS.UPDATE_USER_DETAIL.toString().equals(intent.getAction()) && ContactSelectionFragment.this.getLoaderManager() != null) {
                try {
                    if (TextUtils.isEmpty((CharSequence)ContactSelectionFragment.this.contactsGroupId)) {
                        ContactSelectionFragment.this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)ContactSelectionFragment.this);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class ContactViewHolder {
        AppCompatCheckBox checkBox;
        TextView textView1;
        TextView contactNumberTextView;
        TextView alphabeticImage;
        CircleImageView circleImageView;
        TextView textView2;

        private ContactViewHolder() {
        }
    }

    private class ContactsAdapter
    extends CursorAdapter
    implements SectionIndexer {
        private Context context;
        private LayoutInflater mInflater;
        private AlphabetIndexer mAlphabetIndexer;
        private TextAppearanceSpan highlightTextSpan;

        public ContactsAdapter(Context context) {
            super(context, null, 0);
            this.context = context;
            ContactSelectionFragment.this.userIdList = new ArrayList();
            this.mInflater = LayoutInflater.from((Context)context);
            String alphabet = context.getString(R.string.alphabet);
            this.mAlphabetIndexer = new AlphabetIndexer(null, 1, (CharSequence)alphabet);
            this.highlightTextSpan = new TextAppearanceSpan(context, R.style.searchTextHiglight);
        }

        private int indexOfSearchQuery(String displayName) {
            if (!TextUtils.isEmpty((CharSequence)ContactSelectionFragment.this.mSearchTerm)) {
                return displayName.toLowerCase(Locale.getDefault()).indexOf(ContactSelectionFragment.this.mSearchTerm.toLowerCase(Locale.getDefault()));
            }
            return -1;
        }

        public View newView(Context context, Cursor cursor, ViewGroup parent) {
            View itemLayout = this.mInflater.inflate(R.layout.contact_select_list_item, parent, false);
            ContactViewHolder holder = new ContactViewHolder();
            holder.textView1 = (TextView)itemLayout.findViewById(R.id.applozic_group_member_info);
            holder.textView2 = (TextView)itemLayout.findViewById(R.id.displayName);
            holder.contactNumberTextView = (TextView)itemLayout.findViewById(R.id.contactNumberTextView);
            holder.checkBox = (AppCompatCheckBox)itemLayout.findViewById(R.id.checkbox);
            holder.checkBox.setVisibility(0);
            holder.alphabeticImage = (TextView)itemLayout.findViewById(R.id.alphabeticImage);
            holder.circleImageView = (CircleImageView)itemLayout.findViewById(R.id.contactImage);
            itemLayout.setTag((Object)holder);
            return itemLayout;
        }

        public void bindView(View view, Context context, Cursor cursor) {
            ContactViewHolder holder = (ContactViewHolder)view.getTag();
            char firstLetter = '\u0000';
            final Contact contact = ContactSelectionFragment.this.contactDatabase.getContact(cursor, "_id");
            if (ContactSelectionFragment.this.disableCheckBox) {
                ContactSelectionFragment.this.isUserPresnt = ChannelService.getInstance((Context)context).isUserAlreadyPresentInChannel(ContactSelectionFragment.this.channel.getKey(), contact.getContactIds());
                if (ContactSelectionFragment.this.isUserPresnt) {
                    holder.textView1.setVisibility(0);
                    holder.textView1.setText((CharSequence)ContactSelectionFragment.this.getString(R.string.applozic_user_already_in_a_group).replace(ContactSelectionFragment.this.getString(R.string.groupType_info), Channel.GroupType.BROADCAST.getValue().equals(ContactSelectionFragment.this.channel.getType()) ? ContactSelectionFragment.this.getString(R.string.broadcast_string) : ContactSelectionFragment.this.getString(R.string.group_string)));
                    holder.contactNumberTextView.setVisibility(8);
                    holder.textView1.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.applozic_lite_black_color));
                    holder.textView2.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.applozic_lite_black_color));
                } else {
                    holder.textView1.setVisibility(8);
                    holder.contactNumberTextView.setVisibility(0);
                    holder.textView2.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.black));
                }
                holder.checkBox.setVisibility(8);
            } else {
                holder.checkBox.setVisibility(0);
                holder.contactNumberTextView.setVisibility(0);
                holder.textView2.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.black));
            }
            if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getDisplayName())) {
                String contactNumber = contact.getDisplayName().toUpperCase();
                firstLetter = contact.getDisplayName().toUpperCase().charAt(0);
                if (firstLetter != '+') {
                    holder.alphabeticImage.setText((CharSequence)String.valueOf(firstLetter));
                } else if (contactNumber.length() >= 2) {
                    holder.alphabeticImage.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
                }
                Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
                GradientDrawable bgShape = (GradientDrawable)holder.alphabeticImage.getBackground();
                bgShape.setColor(context.getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
            }
            holder.alphabeticImage.setVisibility(8);
            holder.circleImageView.setVisibility(0);
            if (contact != null) {
                if (contact.isDrawableResources()) {
                    int drawableResourceId = context.getResources().getIdentifier(contact.getrDrawableName(), "drawable", context.getPackageName());
                    holder.circleImageView.setImageResource(drawableResourceId);
                } else {
                    ContactSelectionFragment.this.mImageLoader.loadImage((Object)contact, (ImageView)holder.circleImageView, holder.alphabeticImage);
                }
            }
            holder.textView2.setText((CharSequence)contact.getDisplayName());
            if (!TextUtils.isEmpty((CharSequence)contact.getContactNumber())) {
                holder.contactNumberTextView.setText((CharSequence)contact.getContactNumber());
            } else {
                holder.contactNumberTextView.setText((CharSequence)"");
            }
            holder.checkBox.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AppCompatCheckBox checkBox = (AppCompatCheckBox)v;
                    if (checkBox.isChecked()) {
                        ContactSelectionFragment.this.userIdList.add(contact.getContactIds());
                    } else if (!checkBox.isChecked()) {
                        ContactSelectionFragment.this.userIdList.remove(contact.getContactIds());
                    }
                }
            });
            holder.checkBox.setChecked(ContactSelectionFragment.this.userIdList.contains(contact.getContactIds()));
            int startIndex = this.indexOfSearchQuery(contact.getDisplayName());
            if (startIndex == -1) {
                holder.textView2.setText((CharSequence)contact.getDisplayName());
            } else {
                SpannableString highlightedName = new SpannableString((CharSequence)contact.getDisplayName());
                highlightedName.setSpan((Object)this.highlightTextSpan, startIndex, startIndex + ContactSelectionFragment.this.mSearchTerm.length(), 0);
                holder.textView2.setText((CharSequence)highlightedName);
            }
        }

        public Cursor swapCursor(Cursor newCursor) {
            this.mAlphabetIndexer.setCursor(newCursor);
            return super.swapCursor(newCursor);
        }

        public int getCount() {
            if (this.getCursor() == null) {
                return 0;
            }
            return super.getCount();
        }

        public Object[] getSections() {
            return this.mAlphabetIndexer.getSections();
        }

        public int getPositionForSection(int i) {
            if (this.getCursor() == null) {
                return 0;
            }
            return this.mAlphabetIndexer.getPositionForSection(i);
        }

        public int getSectionForPosition(int i) {
            if (this.getCursor() == null) {
                return 0;
            }
            return this.mAlphabetIndexer.getSectionForPosition(i);
        }
    }

    public static interface ContactsQuery {
        public static final int QUERY_ID = 1;
    }

    public class EndlessScrollListener
    implements AbsListView.OnScrollListener {
        private int visibleThreshold = 5;
        private int currentPage = 0;
        private int previousTotal = 0;
        private boolean loading = true;

        public EndlessScrollListener() {
        }

        public EndlessScrollListener(int visibleThreshold) {
            this.visibleThreshold = visibleThreshold;
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (this.loading && (ContactSelectionFragment.this.alCustomizationSettings.isRegisteredUserContactListCall() || ApplozicSetting.getInstance((Context)ContactSelectionFragment.this.getActivity()).isRegisteredUsersContactCall()) && Utils.isInternetAvailable((Context)ContactSelectionFragment.this.getActivity().getApplicationContext()) && TextUtils.isEmpty((CharSequence)ContactSelectionFragment.this.userPreference.getContactsGroupId()) && totalItemCount > this.previousTotal) {
                this.loading = false;
                this.previousTotal = totalItemCount;
                ++this.currentPage;
            }
            if (!this.loading && totalItemCount - visibleItemCount <= firstVisibleItem + this.visibleThreshold && !ContactSelectionActivity.isSearching) {
                ContactSelectionFragment.this.processDownloadRegisteredUsers();
                this.loading = true;
            }
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
        }
    }
}

