/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.attachmentview;

import android.content.Context;
import android.media.AudioRecord;
import android.media.MediaRecorder;
import android.widget.Toast;
import androidx.fragment.app.FragmentActivity;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.attachmentview.AlAudioSampler;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ApplozicAudioRecordManager
implements MediaRecorder.OnInfoListener,
MediaRecorder.OnErrorListener {
    private static final String TAG = "ApplozicAudioRecordManager";
    public static final int SAMPLING_RATE = 44100;
    public static final int AUDIO_SOURCE = 1;
    public static final int CHANNEL_IN_CONFIG = 16;
    public static final int AUDIO_FORMAT = 2;
    public static final int BUFFER_SIZE = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)2);
    FragmentActivity context;
    String audioFileName;
    String timeStamp;
    ConversationUIService conversationUIService;
    private AudioRecord audioRecorder;
    private String outputFile = null;
    private boolean isRecording;
    byte[] audioData = null;
    private Thread recordingThread = null;
    int bufferElements2Rec = 1024;
    int bytesPerElement = 2;
    private static final String AUDIO_TAG = "AUD";
    private RecordingMode recordingMode = RecordingMode.IDLE;
    private String FILE_FORMAT = ".pcm";

    public ApplozicAudioRecordManager(FragmentActivity context) {
        this.conversationUIService = new ConversationUIService(context);
        this.context = context;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setAudioFileName(String audioFileName) {
        this.audioFileName = audioFileName;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void prepareDefaultFileData() {
        String audioFileName = AUDIO_TAG + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + this.FILE_FORMAT;
        this.setOutputFile(FileClientService.getFilePath((String)audioFileName, (Context)this.context.getApplicationContext(), (String)"audio/m4a").getAbsolutePath());
    }

    public void recordAudio() {
        try {
            if (this.audioRecorder != null) {
                return;
            }
            if (this.isRecording) {
                this.stopRecording();
            }
            this.prepareDefaultFileData();
            this.audioRecorder = new AudioRecord(1, 44100, 16, 2, this.bufferElements2Rec * this.bytesPerElement);
            this.audioData = new byte[BUFFER_SIZE];
            this.audioRecorder.startRecording();
            this.isRecording = true;
            this.createRecordingThread();
            this.recordingThread.start();
            this.recordingMode = RecordingMode.RECORDING;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] short2byte(short[] sData) {
        int shortArrsize = sData.length;
        byte[] bytes = new byte[shortArrsize * 2];
        for (int i = 0; i < shortArrsize; ++i) {
            bytes[i * 2] = (byte)(sData[i] & 0xFF);
            bytes[i * 2 + 1] = (byte)(sData[i] >> 8);
            sData[i] = 0;
        }
        return bytes;
    }

    private void createRecordingThread() {
        this.recordingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                short[] audioData = new short[ApplozicAudioRecordManager.this.bufferElements2Rec];
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(ApplozicAudioRecordManager.this.outputFile);
                }
                catch (FileNotFoundException e) {
                    Utils.printLog((Context)ApplozicAudioRecordManager.this.context, (String)ApplozicAudioRecordManager.TAG, (String)("File not found for recording " + e.getLocalizedMessage()));
                }
                while (ApplozicAudioRecordManager.this.isRecording) {
                    int status = ApplozicAudioRecordManager.this.audioRecorder.read(audioData, 0, ApplozicAudioRecordManager.this.bufferElements2Rec);
                    if (status == -3 || status == -2) {
                        Utils.printLog((Context)ApplozicAudioRecordManager.this.context, (String)ApplozicAudioRecordManager.TAG, (String)"Error reading audio data!");
                        return;
                    }
                    try {
                        byte[] byteData = ApplozicAudioRecordManager.this.short2byte(audioData);
                        outputStream.write(byteData, 0, ApplozicAudioRecordManager.this.bufferElements2Rec * ApplozicAudioRecordManager.this.bytesPerElement);
                    }
                    catch (IOException e) {
                        Utils.printLog((Context)ApplozicAudioRecordManager.this.context, (String)ApplozicAudioRecordManager.TAG, (String)("Error saving recording " + e.getLocalizedMessage()));
                        return;
                    }
                }
                try {
                    outputStream.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    public void cancelAudio() {
        File file;
        if (this.isRecording) {
            this.stopRecording();
        }
        if (this.outputFile != null && (file = new File(this.outputFile)) != null && file.exists()) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"File deleted...");
            file.delete();
        }
    }

    public void sendAudio() {
        if (this.isRecording) {
            this.stopRecording();
        }
        if (this.outputFile != null) {
            if (!new File(this.outputFile).exists()) {
                Toast.makeText((Context)this.context, (int)R.string.tap_on_mic_button_to_record_audio, (int)0).show();
                return;
            }
            String destFilePath = this.outputFile.replace("pcm", "wav");
            AlAudioSampler.copyWaveFile(this.outputFile, destFilePath, BUFFER_SIZE);
            File file = new File(this.outputFile);
            if (file.exists()) {
                file.delete();
            }
            this.recordingMode = RecordingMode.IDLE;
            this.conversationUIService.sendAudioMessage(destFilePath);
        }
    }

    public void stopRecording() {
        if (this.audioRecorder != null) {
            try {
                this.audioRecorder.stop();
                this.recordingThread = null;
            }
            catch (RuntimeException stopException) {
                Utils.printLog((Context)this.context, (String)TAG, (String)"Runtime exception.This is thrown intentionally if stop is called just after start");
            }
            finally {
                this.audioRecorder.release();
                this.audioRecorder = null;
                this.isRecording = false;
            }
        }
    }

    public void onInfo(MediaRecorder mr, int what, int extra) {
    }

    public void onError(MediaRecorder mr, int what, int extra) {
    }

    public static enum RecordingMode {
        IDLE,
        RECORDING;

    }
}

