/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.instruction;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Handler;
import android.widget.Toast;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import java.util.HashMap;
import java.util.Map;

public class InstructionUtil {
    public static final String SHARED_PREFERENCE_INSTRUCTION_KEY = "mck.instruction";
    private static final Map<Integer, Toast> toastMap = new HashMap<Integer, Toast>();
    private static final String info_message_sync = "info_message_sync";
    private static final String instruction_open_conversation_thread = "instruction_open_conversation_thread";
    private static final String instruction_go_back_to_recent_conversation_list = "instruction_go_back_to_recent_conversation_list";
    private static final String instruction_long_press_message = "instruction_long_press_message";
    public static boolean enabled = true;

    public static void init(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(MobiComKitClientService.getApplicationKey((Context)context), 0);
        sharedPreferences.edit().putBoolean("mck.instruction.info_message_sync", true).commit();
        sharedPreferences.edit().putBoolean("mck.instruction.instruction_open_conversation_thread", true).commit();
        sharedPreferences.edit().putBoolean("mck.instruction.instruction_go_back_to_recent_conversation_list", true).commit();
        sharedPreferences.edit().putBoolean("mck.instruction.instruction_long_press_message", true).commit();
    }

    public static void showInstruction(Context context, int resId, int delay, String action) {
        InstructionUtil.showInstruction(context, resId, delay, true, action);
    }

    public static void showInstruction(final Context context, final int resId, int delay, final boolean actionable, final String action) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                Intent intentUpdate = new Intent();
                intentUpdate.setAction(action);
                intentUpdate.addCategory("android.intent.category.DEFAULT");
                intentUpdate.putExtra("resId", resId);
                intentUpdate.putExtra("actionable", actionable);
                BroadcastService.sendBroadcast((Context)context, (Intent)intentUpdate);
            }
        }, (long)delay);
    }

    public static void showToast(Context context, int resId, int colorId) {
        Toast toast = Toast.makeText((Context)context, (CharSequence)context.getString(resId), (int)1);
        toast.setGravity(17, 0, 0);
        toast.getView().setBackgroundColor(context.getResources().getColor(colorId));
        toast.show();
    }

    public static void showInstruction(Context context, int resId, boolean actionable, int colorId) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(MobiComKitClientService.getApplicationKey((Context)context), 0);
        if (!sharedPreferences.contains("mck.instruction." + resId)) {
            return;
        }
        Toast toast = Toast.makeText((Context)context, (CharSequence)context.getString(resId), (int)1);
        if (actionable) {
            toast.getView().setBackgroundColor(context.getResources().getColor(colorId));
        }
        toast.setGravity(17, 0, 0);
        if (!enabled) {
            return;
        }
        toast.show();
        sharedPreferences.edit().remove("mck.instruction." + resId).commit();
        toastMap.put(resId, toast);
    }

    public static void showInfo(Context context, int resId, String action) {
        InstructionUtil.showInstruction(context, resId, 0, false, action);
    }

    public static void hideInstruction(Context context, int resId) {
        if (toastMap.get(resId) != null) {
            toastMap.get(resId).cancel();
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences(MobiComKitClientService.getApplicationKey((Context)context), 0);
        sharedPreferences.edit().remove("mck.instruction." + resId).commit();
    }
}

