/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.feed.TopicDetail;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Conversation;
import com.bumptech.glide.Glide;
import java.util.List;

public class ApplozicContextSpinnerAdapter
extends BaseAdapter {
    private LayoutInflater mInflater;
    private List<Conversation> conversationList;
    private ImageLoader productImageLoader;
    private FileClientService fileClientService;
    private Context context;

    public ApplozicContextSpinnerAdapter(final Context context, List<Conversation> conversations) {
        if (context == null) {
            return;
        }
        this.mInflater = LayoutInflater.from((Context)context);
        this.conversationList = conversations;
        this.fileClientService = new FileClientService(context);
        this.context = context;
        this.productImageLoader = new ImageLoader(context, ImageUtils.getLargestScreenDimension((Activity)((Activity)context))){

            protected Bitmap processBitmap(Object data) {
                return ApplozicContextSpinnerAdapter.this.fileClientService.loadMessageImage(context, (Conversation)data);
            }
        };
        this.productImageLoader.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
        this.productImageLoader.setImageFadeIn(false);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.getCustomView(position, convertView, parent);
    }

    public View getCustomView(int position, View convertView, ViewGroup parent) {
        ApplozicProductViewHolder viewHolder;
        Conversation conversation = (Conversation)this.getItem(position);
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.applozic_context_based_layout, parent, false);
            viewHolder = new ApplozicProductViewHolder();
            viewHolder.productImage = (ImageView)convertView.findViewById(R.id.productImage);
            viewHolder.titleTextView = (TextView)convertView.findViewById(R.id.title);
            viewHolder.subTitleTextView = (TextView)convertView.findViewById(R.id.subTitle);
            viewHolder.key1TextView = (TextView)convertView.findViewById(R.id.qtyTitleTextView);
            viewHolder.value1TextView = (TextView)convertView.findViewById(R.id.qtyValueTextView);
            viewHolder.key2TextView = (TextView)convertView.findViewById(R.id.priceTitleTextView);
            viewHolder.value2TextView = (TextView)convertView.findViewById(R.id.priceValueTextview);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ApplozicProductViewHolder)convertView.getTag();
        }
        try {
            if (conversation != null) {
                String topicId = conversation.getTopicId();
                String topicDetailJson = conversation.getTopicDetail();
                if (!TextUtils.isEmpty((CharSequence)topicDetailJson)) {
                    TopicDetail topicDetail = (TopicDetail)GsonUtils.getObjectFromJson((String)topicDetailJson, TopicDetail.class);
                    if (!TextUtils.isEmpty((CharSequence)topicDetail.getLink())) {
                        Glide.with((Context)this.context).load(topicDetail.getLink()).into(viewHolder.productImage);
                    }
                    if (!TextUtils.isEmpty((CharSequence)topicDetail.getTitle())) {
                        viewHolder.titleTextView.setText((CharSequence)topicDetail.getTitle());
                    }
                    if (!TextUtils.isEmpty((CharSequence)topicDetail.getSubtitle())) {
                        viewHolder.subTitleTextView.setText((CharSequence)topicDetail.getSubtitle());
                    }
                    if (!TextUtils.isEmpty((CharSequence)topicDetail.getKey1())) {
                        viewHolder.key1TextView.setText((CharSequence)topicDetail.getKey1());
                    }
                    if (!TextUtils.isEmpty((CharSequence)topicDetail.getValue1())) {
                        viewHolder.value1TextView.setText((CharSequence)(":" + topicDetail.getValue1()));
                    }
                    if (!TextUtils.isEmpty((CharSequence)topicDetail.getKey2())) {
                        viewHolder.key2TextView.setText((CharSequence)topicDetail.getKey2());
                    }
                    if (!TextUtils.isEmpty((CharSequence)topicDetail.getValue2())) {
                        viewHolder.value2TextView.setText((CharSequence)(":" + topicDetail.getValue2()));
                    }
                } else {
                    viewHolder.productImage.setVisibility(8);
                    viewHolder.titleTextView.setVisibility(8);
                    viewHolder.subTitleTextView.setVisibility(8);
                    viewHolder.key1TextView.setVisibility(8);
                    viewHolder.value1TextView.setVisibility(8);
                    viewHolder.key2TextView.setVisibility(8);
                    viewHolder.value2TextView.setVisibility(8);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return convertView;
    }

    public int getCount() {
        if (this.context == null) {
            return 0;
        }
        return this.conversationList.size();
    }

    public Object getItem(int position) {
        if (this.context == null) {
            return null;
        }
        return this.conversationList.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.getCustomView(position, convertView, parent);
    }

    private static class ApplozicProductViewHolder {
        TextView titleTextView;
        TextView subTitleTextView;
        TextView key1TextView;
        TextView value1TextView;
        TextView key2TextView;
        TextView value2TextView;
        ImageView productImage;

        ApplozicProductViewHolder() {
        }
    }
}

