/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.GradientDrawable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AlphabetIndexer;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.notification.VideoCallNotificationHelper;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.emoticon.EmojiconHandler;
import com.applozic.mobicommons.emoticon.EmoticonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUtils;
import com.applozic.mobicommons.people.contact.Contact;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class QuickConversationAdapter
extends RecyclerView.Adapter
implements Filterable {
    private static Map<Short, Integer> messageTypeColorMap = new HashMap<Short, Integer>();
    public ImageLoader contactImageLoader;
    public ImageLoader channelImageLoader;
    public String searchString = null;
    TextView messageTextView;
    ImageView attachmentIcon;
    TextView alphabeticTextView;
    CircleImageView contactImage;
    private Context context;
    private MessageDatabaseService messageDatabaseService;
    private List<Message> messageList;
    private BaseContactService contactService;
    private EmojiconHandler emojiconHandler;
    private long deviceTimeOffset = 0L;
    private List<Message> originalList;
    private AlphabetIndexer mAlphabetIndexer;
    private TextAppearanceSpan highlightTextSpan;
    private AlCustomizationSettings alCustomizationSettings;
    private View view;
    private ConversationUIService conversationUIService;

    public void setAlCustomizationSettings(AlCustomizationSettings alCustomizationSettings) {
        this.alCustomizationSettings = alCustomizationSettings;
    }

    public QuickConversationAdapter(final Context context, List<Message> messageList, EmojiconHandler emojiconHandler) {
        this.context = context;
        this.emojiconHandler = emojiconHandler;
        this.contactService = new AppContactService(context);
        this.messageDatabaseService = new MessageDatabaseService(context);
        this.messageList = messageList;
        this.conversationUIService = new ConversationUIService((FragmentActivity)context);
        this.contactImageLoader = new ImageLoader(context, ImageUtils.getLargestScreenDimension((Activity)((Activity)context))){

            protected Bitmap processBitmap(Object data) {
                return QuickConversationAdapter.this.contactService.downloadContactImage((Context)((Activity)context), (Contact)data);
            }
        };
        this.contactImageLoader.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
        this.contactImageLoader.setImageFadeIn(false);
        this.channelImageLoader = new ImageLoader(context, ImageUtils.getLargestScreenDimension((Activity)((Activity)context))){

            protected Bitmap processBitmap(Object data) {
                return QuickConversationAdapter.this.contactService.downloadGroupImage((Context)((Activity)context), (Channel)data);
            }
        };
        this.channelImageLoader.addImageCache(((FragmentActivity)context).getSupportFragmentManager(), 0.1f);
        this.channelImageLoader.setImageFadeIn(false);
        String alphabet = context.getString(R.string.alphabet);
        this.mAlphabetIndexer = new AlphabetIndexer(null, 1, (CharSequence)alphabet);
        this.highlightTextSpan = new TextAppearanceSpan(context, R.style.searchTextHiglight);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        if (viewType == 2) {
            View v2 = inflater.inflate(R.layout.mobicom_message_list_header_footer, parent, false);
            return new FooterViewHolder(v2);
        }
        this.deviceTimeOffset = MobiComUserPreference.getInstance((Context)this.context).getDeviceTimeOffset();
        this.view = inflater.inflate(R.layout.mobicom_message_row_view, parent, false);
        return new Myholder(this.view);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.getItemViewType(position) == 2) {
            FooterViewHolder myHolder = (FooterViewHolder)holder;
            myHolder.infoBroadCast.setVisibility(8);
        } else {
            Myholder myholder = (Myholder)holder;
            Message message = this.getItem(position);
            myholder.smTime.setVisibility(8);
            if (message != null) {
                List<String> items = null;
                List<String> userIds = null;
                Channel channel = ChannelDatabaseService.getInstance((Context)this.context).getChannelByChannelKey(message.getGroupId());
                if (channel == null && message.getGroupId() == null) {
                    items = Arrays.asList(message.getTo().split("\\s*,\\s*"));
                    if (!TextUtils.isEmpty((CharSequence)message.getContactIds())) {
                        userIds = Arrays.asList(message.getContactIds().split("\\s*,\\s*"));
                    }
                }
                Contact contactReceiver = this.contactService.getContactReceiver(items, userIds);
                myholder.contactImage.setVisibility(8);
                myholder.alphabeticTextView.setVisibility(8);
                if (contactReceiver != null) {
                    String contactInfo = contactReceiver.getDisplayName();
                    if (items != null && items.size() > 1) {
                        Contact contact2 = this.contactService.getContactById(items.get(1));
                        contactInfo = TextUtils.isEmpty((CharSequence)contactReceiver.getFirstName()) ? contactReceiver.getContactNumber() : contactReceiver.getFirstName() + ", " + (TextUtils.isEmpty((CharSequence)contact2.getFirstName()) ? contact2.getContactNumber() : contact2.getFirstName()) + (items.size() > 2 ? " & others" : "");
                    }
                    myholder.smReceivers.setText((CharSequence)contactInfo);
                    this.contactImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
                    this.processContactImage(contactReceiver, myholder.onlineTextView, myholder.alphabeticTextView, myholder.contactImage);
                } else if (message.getGroupId() != null) {
                    if (channel != null && Channel.GroupType.GROUPOFTWO.getValue().equals(channel.getType())) {
                        Contact withUserContact;
                        this.contactImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
                        if (Channel.GroupType.GROUPOFTWO.getValue().equals(channel.getType()) && (withUserContact = this.contactService.getContactById(ChannelService.getInstance((Context)this.context).getGroupOfTwoReceiverUserId(channel.getKey()))) != null) {
                            myholder.smReceivers.setText((CharSequence)withUserContact.getDisplayName());
                            this.processContactImage(withUserContact, myholder.onlineTextView, myholder.alphabeticTextView, myholder.contactImage);
                        }
                    } else {
                        if (channel != null && Channel.GroupType.SUPPORT_GROUP.getValue().equals(channel.getType())) {
                            this.channelImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
                            myholder.contactImage.setImageResource(R.drawable.applozic_ic_contact_picture_holo_light);
                        } else {
                            this.channelImageLoader.setLoadingImage(R.drawable.applozic_group_icon);
                            myholder.contactImage.setImageResource(R.drawable.applozic_group_icon);
                        }
                        myholder.smReceivers.setText((CharSequence)ChannelUtils.getChannelTitleName((Channel)channel, (String)MobiComUserPreference.getInstance((Context)this.context).getUserId()));
                        myholder.alphabeticTextView.setVisibility(8);
                        myholder.contactImage.setVisibility(0);
                        if (channel != null && !TextUtils.isEmpty((CharSequence)channel.getImageUrl())) {
                            this.channelImageLoader.loadImage((Object)channel, (ImageView)myholder.contactImage);
                        } else if (channel != null && channel.isBroadcastMessage()) {
                            myholder.contactImage.setImageResource(R.drawable.applozic_ic_applozic_broadcast);
                        } else if (channel != null && Channel.GroupType.SUPPORT_GROUP.getValue().equals(channel.getType())) {
                            this.channelImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
                        } else {
                            this.channelImageLoader.setLoadingImage(R.drawable.applozic_group_icon);
                        }
                    }
                }
                myholder.onlineTextView.setVisibility(8);
                if (this.alCustomizationSettings.isOnlineStatusMasterList()) {
                    myholder.onlineTextView.setVisibility(contactReceiver != null && contactReceiver.isOnline() ? 0 : 8);
                }
                if (myholder.attachedFile != null) {
                    myholder.attachedFile.setText((CharSequence)"");
                    myholder.attachedFile.setVisibility(8);
                }
                if (myholder.attachmentIcon != null) {
                    myholder.attachmentIcon.setVisibility(8);
                }
                if (message.isVideoCallMessage()) {
                    this.createVideoCallView(message, myholder.attachmentIcon, myholder.messageTextView);
                } else if (message.hasAttachment() && myholder.attachmentIcon != null && message.getContentType() != Message.ContentType.TEXT_URL.getValue().shortValue()) {
                    String filePath = message.getFileMetas() == null && message.getFilePaths() != null ? ((String)message.getFilePaths().get(0)).substring(((String)message.getFilePaths().get(0)).lastIndexOf("/") + 1) : (message.getFileMetas() != null ? message.getFileMetas().getName() : "");
                    myholder.attachmentIcon.setVisibility(0);
                    myholder.attachmentIcon.setImageResource(R.drawable.applozic_ic_action_attachment);
                    myholder.messageTextView.setText((CharSequence)filePath);
                } else if (myholder.attachmentIcon != null && message.getContentType() == Message.ContentType.LOCATION.getValue().shortValue()) {
                    myholder.attachmentIcon.setVisibility(0);
                    myholder.attachmentIcon.setImageResource(R.drawable.mobicom_notification_location_icon);
                    myholder.messageTextView.setText((CharSequence)this.context.getString(R.string.Location));
                } else if (message.getContentType() == Message.ContentType.PRICE.getValue().shortValue()) {
                    myholder.messageTextView.setText((CharSequence)EmoticonUtils.getSmiledText((Context)this.context, (CharSequence)("Final agreed price " + message.getMessage()), (EmojiconHandler)this.emojiconHandler));
                } else if (message.getContentType() == Message.ContentType.TEXT_HTML.getValue().shortValue()) {
                    myholder.messageTextView.setText((CharSequence)Html.fromHtml((String)message.getMessage()));
                } else {
                    String messageSubString = !TextUtils.isEmpty((CharSequence)message.getMessage()) ? message.getMessage().substring(0, Math.min(message.getMessage().length(), 50)) : "";
                    myholder.messageTextView.setText((CharSequence)EmoticonUtils.getSmiledText((Context)this.context, (CharSequence)messageSubString, (EmojiconHandler)this.emojiconHandler));
                }
                if (myholder.sentOrReceived != null) {
                    if (message.isCall()) {
                        myholder.sentOrReceived.setImageResource(R.drawable.applozic_ic_action_call_holo_light);
                        myholder.messageTextView.setTextColor(this.context.getResources().getColor(message.isIncomingCall() ? R.color.incoming_call : R.color.outgoing_call));
                    } else if (this.getItemViewType(position) == 0) {
                        myholder.sentOrReceived.setImageResource(R.drawable.mobicom_social_forward);
                    } else {
                        myholder.sentOrReceived.setImageResource(R.drawable.mobicom_social_reply);
                    }
                }
                if (myholder.createdAtTime != null) {
                    myholder.createdAtTime.setText((CharSequence)DateUtils.getFormattedDateAndTime((Context)this.context, (Long)message.getCreatedAtTime(), (int)R.string.JUST_NOW, (int)R.plurals.MINUTES, (int)R.plurals.HOURS));
                }
                int messageUnReadCount = 0;
                if (message.getGroupId() == null && contactReceiver != null && !TextUtils.isEmpty((CharSequence)contactReceiver.getContactIds())) {
                    messageUnReadCount = this.messageDatabaseService.getUnreadMessageCountForContact(contactReceiver.getContactIds());
                } else if (channel != null && channel.getKey() != null && channel.getKey() != 0) {
                    messageUnReadCount = this.messageDatabaseService.getUnreadMessageCountForChannel(channel.getKey());
                }
                if (messageUnReadCount > 0) {
                    myholder.unReadCountTextView.setVisibility(0);
                    myholder.unReadCountTextView.setText((CharSequence)String.valueOf(messageUnReadCount));
                } else {
                    myholder.unReadCountTextView.setVisibility(8);
                }
                int startIndex = this.indexOfSearchQuery(message.getMessage());
                if (startIndex != -1) {
                    SpannableString highlightedName = new SpannableString((CharSequence)message.getMessage());
                    highlightedName.setSpan((Object)this.highlightTextSpan, startIndex, startIndex + this.searchString.toString().length(), 0);
                    myholder.messageTextView.setText((CharSequence)highlightedName);
                }
            }
        }
    }

    public Message getItem(int position) {
        return this.messageList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.messageList.size();
    }

    public int getItemViewType(int position) {
        return this.getItem(position) != null ? (this.getItem(position).isTypeOutbox() ? 1 : 0) : 2;
    }

    private int indexOfSearchQuery(String message) {
        if (!TextUtils.isEmpty((CharSequence)this.searchString)) {
            return message.toLowerCase(Locale.getDefault()).indexOf(this.searchString.toString().toLowerCase(Locale.getDefault()));
        }
        return -1;
    }

    public Filter getFilter() {
        return new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                Filter.FilterResults oReturn = new Filter.FilterResults();
                ArrayList<Message> results = new ArrayList<Message>();
                if (QuickConversationAdapter.this.originalList == null) {
                    QuickConversationAdapter.this.originalList = QuickConversationAdapter.this.messageList;
                }
                if (constraint != null) {
                    QuickConversationAdapter.this.searchString = constraint.toString();
                    if (QuickConversationAdapter.this.originalList != null && QuickConversationAdapter.this.originalList.size() > 0) {
                        for (Message message : QuickConversationAdapter.this.originalList) {
                            if (!message.getMessage().toLowerCase().contains(constraint.toString())) continue;
                            results.add(message);
                        }
                    }
                    oReturn.values = results;
                } else {
                    oReturn.values = QuickConversationAdapter.this.originalList;
                }
                return oReturn;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                QuickConversationAdapter.this.messageList = (ArrayList)results.values;
                QuickConversationAdapter.this.notifyDataSetChanged();
            }
        };
    }

    public void createVideoCallView(Message message, ImageView attachmentIcon, TextView messageTextView) {
        if ((message.getMetadata() == null || message.getMetadata().isEmpty()) && attachmentIcon != null) {
            attachmentIcon.setImageResource(R.drawable.ic_videocam_white_24px);
            attachmentIcon.setColorFilter(R.color.applozic_green_color);
            return;
        }
        if (messageTextView != null) {
            messageTextView.setText((CharSequence)VideoCallNotificationHelper.getStatus((Map)message.getMetadata()));
        }
        if (attachmentIcon != null) {
            attachmentIcon.setVisibility(0);
            if (VideoCallNotificationHelper.isMissedCall((Message)message)) {
                attachmentIcon.setImageResource(R.drawable.ic_communication_call_missed);
            } else if (VideoCallNotificationHelper.isAudioCall((Message)message)) {
                attachmentIcon.setImageResource(R.drawable.applozic_ic_action_call_holo_light);
            } else {
                attachmentIcon.setImageResource(R.drawable.ic_videocam_white_24px);
                attachmentIcon.setColorFilter(R.color.applozic_green_color);
            }
        }
    }

    private void processContactImage(Contact contact, TextView textView, TextView alphabeticTextView, CircleImageView contactImage) {
        try {
            String contactNumber = "";
            char firstLetter = '\u0000';
            contactNumber = contact.getDisplayName().toUpperCase();
            firstLetter = contact.getDisplayName().toUpperCase().charAt(0);
            if (contact != null) {
                if (firstLetter != '+') {
                    alphabeticTextView.setText((CharSequence)String.valueOf(firstLetter));
                } else if (contactNumber.length() >= 2) {
                    alphabeticTextView.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
                }
                Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
                GradientDrawable bgShape = (GradientDrawable)alphabeticTextView.getBackground();
                bgShape.setColor(this.context.getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
            }
            alphabeticTextView.setVisibility(8);
            contactImage.setVisibility(0);
            if (contact != null) {
                if (contact.isDrawableResources()) {
                    int drawableResourceId = this.context.getResources().getIdentifier(contact.getrDrawableName(), "drawable", this.context.getPackageName());
                    contactImage.setImageResource(drawableResourceId);
                } else {
                    this.contactImageLoader.loadImage((Object)contact, (ImageView)contactImage, alphabeticTextView);
                }
            }
            textView.setVisibility(contact != null && contact.isOnline() ? 0 : 8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        messageTypeColorMap.put(Message.MessageType.INBOX.getValue(), R.color.message_type_inbox);
        messageTypeColorMap.put(Message.MessageType.OUTBOX.getValue(), R.color.message_type_outbox);
        messageTypeColorMap.put(Message.MessageType.OUTBOX_SENT_FROM_DEVICE.getValue(), R.color.message_type_outbox_sent_from_device);
        messageTypeColorMap.put(Message.MessageType.MT_INBOX.getValue(), R.color.message_type_mt_inbox);
        messageTypeColorMap.put(Message.MessageType.MT_OUTBOX.getValue(), R.color.message_type_mt_outbox);
        messageTypeColorMap.put(Message.MessageType.CALL_INCOMING.getValue(), R.color.message_type_incoming_call);
        messageTypeColorMap.put(Message.MessageType.CALL_OUTGOING.getValue(), R.color.message_type_outgoing_call);
    }

    public class FooterViewHolder
    extends RecyclerView.ViewHolder {
        TextView infoBroadCast;
        ProgressBar loadMoreProgressBar;

        public FooterViewHolder(View itemView) {
            super(itemView);
            this.infoBroadCast = (TextView)itemView.findViewById(R.id.info_broadcast);
            this.loadMoreProgressBar = (ProgressBar)itemView.findViewById(R.id.load_more_progressbar);
        }
    }

    public class Myholder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener,
    View.OnCreateContextMenuListener {
        TextView smReceivers;
        TextView createdAtTime;
        TextView messageTextView;
        CircleImageView contactImage;
        TextView alphabeticTextView;
        TextView onlineTextView;
        ImageView sentOrReceived;
        TextView attachedFile;
        final ImageView attachmentIcon;
        TextView unReadCountTextView;
        TextView smTime;
        private final MenuItem.OnMenuItemClickListener onEditMenu;

        public Myholder(View itemView) {
            super(itemView);
            this.onEditMenu = new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    Message message = (Message)QuickConversationAdapter.this.messageList.get(Myholder.this.getLayoutPosition());
                    Channel channel = null;
                    Contact contact = null;
                    if (message.getGroupId() != null) {
                        channel = ChannelDatabaseService.getInstance((Context)QuickConversationAdapter.this.context).getChannelByChannelKey(message.getGroupId());
                    } else {
                        contact = QuickConversationAdapter.this.contactService.getContactById(message.getContactIds());
                    }
                    switch (item.getItemId()) {
                        case 0: {
                            if (channel != null && channel.isDeleted()) {
                                QuickConversationAdapter.this.conversationUIService.deleteGroupConversation(channel);
                                break;
                            }
                            QuickConversationAdapter.this.conversationUIService.deleteConversationThread(contact, channel);
                            break;
                        }
                        case 1: {
                            QuickConversationAdapter.this.conversationUIService.deleteGroupConversation(channel);
                            break;
                        }
                        case 2: {
                            QuickConversationAdapter.this.conversationUIService.channelLeaveProcess(channel);
                            break;
                        }
                    }
                    return true;
                }
            };
            this.smReceivers = (TextView)itemView.findViewById(R.id.smReceivers);
            this.createdAtTime = (TextView)itemView.findViewById(R.id.createdAtTime);
            this.messageTextView = (TextView)itemView.findViewById(R.id.message);
            this.contactImage = (CircleImageView)itemView.findViewById(R.id.contactImage);
            this.alphabeticTextView = (TextView)itemView.findViewById(R.id.alphabeticImage);
            this.onlineTextView = (TextView)itemView.findViewById(R.id.onlineTextView);
            this.sentOrReceived = (ImageView)itemView.findViewById(R.id.sentOrReceivedIcon);
            this.attachedFile = (TextView)itemView.findViewById(R.id.attached_file);
            this.attachmentIcon = (ImageView)itemView.findViewById(R.id.attachmentIcon);
            this.unReadCountTextView = (TextView)itemView.findViewById(R.id.unreadSmsCount);
            this.smTime = (TextView)itemView.findViewById(R.id.smTime);
            itemView.setOnClickListener((View.OnClickListener)this);
            itemView.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
        }

        public void onClick(View v) {
            Message message;
            int itemPosition = this.getLayoutPosition();
            if (itemPosition != -1 && !QuickConversationAdapter.this.messageList.isEmpty() && (message = QuickConversationAdapter.this.getItem(itemPosition)) != null) {
                Channel channel = ChannelService.getInstance((Context)QuickConversationAdapter.this.context).getChannelByChannelKey(message.getGroupId());
                Contact contact = new ContactDatabase(QuickConversationAdapter.this.context).getContactById(channel == null ? message.getContactIds() : null);
                InstructionUtil.hideInstruction(QuickConversationAdapter.this.context, R.string.instruction_open_conversation_thread);
                ((MobiComKitActivityInterface)QuickConversationAdapter.this.context).onQuickConversationFragmentItemClick(QuickConversationAdapter.this.view, contact, channel, message.getConversationId(), QuickConversationAdapter.this.searchString);
            }
        }

        public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
            int position = this.getLayoutPosition();
            if (QuickConversationAdapter.this.messageList.size() <= position) {
                return;
            }
            Message message = (Message)QuickConversationAdapter.this.messageList.get(position);
            menu2.setHeaderTitle(R.string.conversation_options);
            String[] menuItems = QuickConversationAdapter.this.context.getResources().getStringArray(R.array.conversation_options_menu);
            boolean isUserPresentInGroup = false;
            boolean isChannelDeleted = false;
            Channel channel = null;
            if (message.getGroupId() != null) {
                channel = ChannelService.getInstance((Context)QuickConversationAdapter.this.context).getChannelByChannelKey(message.getGroupId());
                if (channel != null) {
                    isChannelDeleted = channel.isDeleted();
                }
                isUserPresentInGroup = ChannelService.getInstance((Context)QuickConversationAdapter.this.context).processIsUserPresentInChannel(message.getGroupId());
            }
            for (int i = 0; i < menuItems.length; ++i) {
                if ((message.getGroupId() == null || channel != null && (Channel.GroupType.GROUPOFTWO.getValue().equals(channel.getType()) || Channel.GroupType.SUPPORT_GROUP.getValue().equals(channel.getType()))) && (menuItems[i].equals(QuickConversationAdapter.this.context.getResources().getString(R.string.delete_group)) || menuItems[i].equals(QuickConversationAdapter.this.context.getResources().getString(R.string.exit_group))) || menuItems[i].equals(QuickConversationAdapter.this.context.getResources().getString(R.string.exit_group)) && (isChannelDeleted || !isUserPresentInGroup || channel != null && Channel.GroupType.BROADCAST.getValue().equals(channel.getType())) || menuItems[i].equals(QuickConversationAdapter.this.context.getResources().getString(R.string.delete_group)) && (isUserPresentInGroup || !isChannelDeleted) || menuItems[i].equals(QuickConversationAdapter.this.context.getResources().getString(R.string.delete_conversation)) && !QuickConversationAdapter.this.alCustomizationSettings.isDeleteOption()) continue;
                MenuItem item = menu2.add(0, i, i, (CharSequence)menuItems[i]);
                item.setOnMenuItemClickListener(this.onEditMenu);
            }
        }
    }
}

