/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.async;

import android.content.Context;
import android.os.AsyncTask;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.channel.service.ChannelClientService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.feed.ChannelFeedListResponse;
import com.applozic.mobicomkit.feed.ErrorResponseFeed;
import com.applozic.mobicommons.json.GsonUtils;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;

public class AlGetMembersFromContactGroupListTask
extends AsyncTask<Void, Void, AlGetMembersModel> {
    WeakReference<Context> context;
    private String groupType;
    private List<String> groupIds;
    private List<String> groupNames;
    private GetMembersFromGroupIdListListener listener;

    public AlGetMembersFromContactGroupListTask(Context context, GetMembersFromGroupIdListListener listener, List<String> groupIds, List<String> groupNames, String groupType) {
        this.context = new WeakReference<Context>(context);
        this.listener = listener;
        this.groupIds = groupIds;
        this.groupNames = groupNames;
        this.groupType = groupType;
    }

    protected AlGetMembersModel doInBackground(Void ... voids) {
        AlGetMembersModel model = new AlGetMembersModel();
        try {
            ChannelFeedListResponse response = ChannelClientService.getInstance((Context)((Context)this.context.get())).getMemebersFromContactGroupIds(this.groupIds, this.groupNames, this.groupType);
            if (response != null) {
                if ("success".equals(response.getStatus())) {
                    HashSet contactIds = new HashSet();
                    if (!response.getResponse().isEmpty()) {
                        ChannelService.getInstance((Context)((Context)this.context.get())).processChannelFeedList(response.getResponse().toArray(new ChannelFeed[response.getResponse().size()]), false);
                        for (ChannelFeed feed : response.getResponse()) {
                            contactIds.addAll(feed.getContactGroupMembersId());
                        }
                        model.setMembers(contactIds.toArray(new String[contactIds.size()]));
                        UserService.getInstance((Context)((Context)this.context.get())).processUserDetailsByUserIds(contactIds);
                        model.setResponse("Successfully fetched");
                    }
                } else if (response.getErrorResponse() != null) {
                    model.setResponse(GsonUtils.getJsonFromObject((Object)response.getErrorResponse(), ErrorResponseFeed[].class));
                }
            } else {
                model.setResponse("Some Error occurred");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            model.setException(e);
        }
        return model;
    }

    protected void onPostExecute(AlGetMembersModel model) {
        if (model != null) {
            if (model.getMembers() != null && model.getMembers().length != 0) {
                this.listener.onSuccess((Context)this.context.get(), model.getResponse(), model.getMembers());
            } else {
                this.listener.onFailure((Context)this.context.get(), model.getResponse(), model.getException());
            }
        }
        super.onPostExecute((Object)model);
    }

    public class AlGetMembersModel {
        String[] members;
        String response;
        Exception exception;

        public String[] getMembers() {
            return this.members;
        }

        public void setMembers(String[] members) {
            this.members = members;
        }

        public String getResponse() {
            return this.response;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }
    }

    public static interface GetMembersFromGroupIdListListener {
        public void onSuccess(Context var1, String var2, String[] var3);

        public void onFailure(Context var1, String var2, Exception var3);
    }
}

