/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.people.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Toast;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SearchView;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.NavUtils;
import androidx.core.view.MenuItemCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import androidx.fragment.app.FragmentTransaction;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.AlUserSearchTask;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.people.ChannelInfo;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.listners.AlCallback;
import com.applozic.mobicomkit.listners.AttachmentFilteringListener;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComAttachmentSelectorActivity;
import com.applozic.mobicomkit.uiwidgets.people.channel.ChannelFragment;
import com.applozic.mobicomkit.uiwidgets.people.contact.AppContactFragment;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.OnContactsInteractionListener;
import com.applozic.mobicommons.people.SearchListFragment;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import com.google.android.material.tabs.TabLayout;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MobiComKitPeopleActivity
extends AppCompatActivity
implements OnContactsInteractionListener,
SearchView.OnQueryTextListener,
TabLayout.OnTabSelectedListener {
    private static final String TAG = "MobiComKitPeopleActivity";
    public static final String SHARED_TEXT = "SHARED_TEXT";
    public static final String FORWARD_MESSAGE = "forwardMessage";
    public static final String USER_ID_ARRAY = "userIdArray";
    private static final String CONTACT_ID = "contactId";
    private static final String GROUP_ID = "groupId";
    private static final String GROUP_NAME = "groupName";
    private static final String USER_ID = "userId";
    public static boolean isSearching = false;
    protected SearchView searchView;
    protected String searchTerm;
    ViewPager viewPager;
    TabLayout tabLayout;
    ActionBar actionBar;
    String[] userIdArray;
    AppContactFragment appContactFragment;
    ChannelFragment channelFragment;
    ViewPagerAdapter adapter;
    AlCustomizationSettings alCustomizationSettings;
    Intent intentExtra;
    String action;
    String type;
    OnContactsInteractionListener onContactsInteractionListener;
    private SearchListFragment searchListFragment;
    private boolean isSearchResultView = false;

    public static void addFragment(FragmentActivity fragmentActivity, Fragment fragmentToAdd, String fragmentTag) {
        FragmentManager supportFragmentManager = fragmentActivity.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction();
        fragmentTransaction.replace(R.id.layout_child_activity, fragmentToAdd, fragmentTag);
        if (supportFragmentManager.getBackStackEntryCount() > 1) {
            supportFragmentManager.popBackStack();
        }
        fragmentTransaction.addToBackStack(fragmentTag);
        fragmentTransaction.commitAllowingStateLoss();
        supportFragmentManager.executePendingTransactions();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!MobiComUserPreference.getInstance((Context)this).isLoggedIn()) {
            this.finish();
        }
        this.setContentView(R.layout.people_activity);
        String jsonString = FileUtils.loadSettingsJsonFile((Context)this.getApplicationContext());
        this.alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
        this.onContactsInteractionListener = this;
        Toolbar myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(myToolbar);
        this.actionBar = this.getSupportActionBar();
        if (!TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getThemeColorPrimary()) && !TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getThemeColorPrimaryDark())) {
            this.actionBar.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)this.alCustomizationSettings.getThemeColorPrimary())));
            if (Build.VERSION.SDK_INT >= 21) {
                this.getWindow().setStatusBarColor(Color.parseColor((String)this.alCustomizationSettings.getThemeColorPrimaryDark()));
            }
        }
        this.actionBar.setHomeButtonEnabled(true);
        this.actionBar.setDisplayHomeAsUpEnabled(true);
        this.actionBar.setDisplayShowTitleEnabled(true);
        this.intentExtra = this.getIntent();
        this.action = this.intentExtra.getAction();
        this.type = this.intentExtra.getType();
        if (this.getIntent().getExtras() != null) {
            if ("android.intent.action.SEND".equals(this.action) && this.type != null) {
                this.actionBar.setTitle((CharSequence)this.getString(R.string.send_message_to));
            } else {
                this.actionBar.setTitle((CharSequence)this.getString(R.string.search_title));
                this.userIdArray = this.getIntent().getStringArrayExtra(USER_ID_ARRAY);
            }
        } else {
            this.actionBar.setTitle((CharSequence)this.getString(R.string.search_title));
        }
        this.appContactFragment = new AppContactFragment(this.userIdArray);
        this.appContactFragment.setAlCustomizationSettings(this.alCustomizationSettings);
        this.channelFragment = new ChannelFragment();
        this.setSearchListFragment(this.appContactFragment);
        if (this.alCustomizationSettings.isGroupsSectionTabHidden() || ApplozicSetting.getInstance((Context)this).isGroupsSectionTabHidden()) {
            MobiComKitPeopleActivity.addFragment((FragmentActivity)this, (Fragment)this.appContactFragment, "AppContactFragment");
        } else {
            this.viewPager = (ViewPager)this.findViewById(R.id.viewPager);
            this.viewPager.setVisibility(0);
            this.setupViewPager(this.viewPager);
            this.tabLayout = (TabLayout)this.findViewById(R.id.tab_layout);
            this.tabLayout.setVisibility(0);
            this.tabLayout.setupWithViewPager(this.viewPager);
            this.tabLayout.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)this);
        }
        this.isSearchResultView = true;
    }

    @TargetApi(value=11)
    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_contact, menu2);
        MenuItem searchItem = menu2.findItem(R.id.menu_search);
        this.searchView = (SearchView)MenuItemCompat.getActionView((MenuItem)searchItem);
        this.searchView.setQueryHint((CharSequence)this.getResources().getString(R.string.search_hint));
        if (Utils.hasICS()) {
            searchItem.collapseActionView();
        }
        this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        this.searchView.setSubmitButtonEnabled(true);
        this.searchView.setIconified(true);
        return super.onCreateOptionsMenu(menu2);
    }

    public void onContactSelected(Uri contactUri) {
    }

    public void startNewConversation(String contactNumber) {
        Intent intent = new Intent();
        intent.putExtra(USER_ID, contactNumber);
        this.finishActivity(intent);
    }

    public void onGroupSelected(final Channel channel) {
        Intent intent = null;
        if ("android.intent.action.SEND".equals(this.action) && this.type != null) {
            Uri fileUri;
            if (!ChannelService.getInstance((Context)this).processIsUserPresentInChannel(channel.getKey())) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.unable_share_message), (int)0).show();
                return;
            }
            if ("text/plain".equals(this.type)) {
                intent = new Intent((Context)this, ConversationActivity.class);
                intent.putExtra(GROUP_ID, (Serializable)channel.getKey());
                intent.putExtra(GROUP_NAME, channel.getName());
                intent.putExtra("defaultText", this.intentExtra.getStringExtra("android.intent.extra.TEXT"));
                this.startActivity(intent);
                this.finish();
            } else if ((this.type.startsWith("image/") || this.type.startsWith("audio/") || this.type.startsWith("video/")) && (fileUri = (Uri)this.intentExtra.getParcelableExtra("android.intent.extra.STREAM")) != null) {
                long maxSize = this.alCustomizationSettings.getMaxAttachmentSizeAllowed() * 1024 * 1024;
                if (FileUtils.isMaxUploadSizeReached((Context)this, (Uri)fileUri, (long)maxSize)) {
                    Toast.makeText((Context)this, (CharSequence)this.getString(R.string.info_attachment_max_allowed_file_size), (int)1).show();
                    return;
                }
                if (this.getApplicationContext() instanceof AttachmentFilteringListener) {
                    ((AttachmentFilteringListener)this.getApplicationContext()).onAttachmentSelected((Activity)this, fileUri, new AlCallback(){

                        public void onSuccess(Object response) {
                            MobiComKitPeopleActivity.this.processAttachmentUri(fileUri, null, channel);
                        }

                        public void onError(Object error) {
                            Utils.printLog((Context)MobiComKitPeopleActivity.this.getApplicationContext(), (String)MobiComKitPeopleActivity.TAG, (String)("Error in file : " + GsonUtils.getJsonFromObject((Object)error, Object.class)));
                        }
                    });
                } else {
                    this.processAttachmentUri(fileUri, null, channel);
                }
            }
        } else {
            intent = new Intent();
            intent.putExtra(GROUP_ID, (Serializable)channel.getKey());
            intent.putExtra(GROUP_NAME, channel.getName());
            this.finishActivity(intent);
        }
    }

    public void onCustomContactSelected(final Contact contact) {
        Intent intent = null;
        if ("android.intent.action.SEND".equals(this.action) && this.type != null) {
            if (contact.isBlocked()) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.user_is_blocked), (int)0).show();
                return;
            }
            if ("text/plain".equals(this.type)) {
                intent = new Intent((Context)this, ConversationActivity.class);
                intent.putExtra(USER_ID, contact.getUserId());
                intent.putExtra("defaultText", this.intentExtra.getStringExtra("android.intent.extra.TEXT"));
                this.startActivity(intent);
                this.finish();
            } else if (this.type.startsWith("image/") || this.type.startsWith("audio/") || this.type.startsWith("video/")) {
                long maxSize;
                final Uri fileUri = (Uri)this.intentExtra.getParcelableExtra("android.intent.extra.STREAM");
                if (FileUtils.isMaxUploadSizeReached((Context)this, (Uri)fileUri, (long)(maxSize = (long)(this.alCustomizationSettings.getMaxAttachmentSizeAllowed() * 1024 * 1024)))) {
                    Toast.makeText((Context)this, (CharSequence)this.getString(R.string.info_attachment_max_allowed_file_size), (int)1).show();
                    return;
                }
                if (this.getApplicationContext() instanceof AttachmentFilteringListener) {
                    ((AttachmentFilteringListener)this.getApplicationContext()).onAttachmentSelected((Activity)this, fileUri, new AlCallback(){

                        public void onSuccess(Object response) {
                            MobiComKitPeopleActivity.this.processAttachmentUri(fileUri, contact, null);
                        }

                        public void onError(Object error) {
                            Utils.printLog((Context)MobiComKitPeopleActivity.this.getApplicationContext(), (String)MobiComKitPeopleActivity.TAG, (String)("Error in file : " + GsonUtils.getJsonFromObject((Object)error, Object.class)));
                        }
                    });
                } else {
                    this.processAttachmentUri(fileUri, contact, null);
                }
            }
        } else if (ApplozicClient.getInstance((Context)this).isStartGroupOfTwo()) {
            new ChannelCreateAsyncTask(MobiComUserPreference.getInstance((Context)this).getParentGroupKey(), contact, (Context)this).execute(new Void[]{null});
        } else {
            intent = new Intent();
            intent.putExtra(USER_ID, contact.getUserId());
            this.finishActivity(intent);
        }
    }

    private void processAttachmentUri(Uri fileUri, Contact contact, Channel channel) {
        if (FileUtils.isContentScheme((Uri)fileUri)) {
            String mimeType = FileUtils.getMimeTypeByContentUriOrOther((Context)this, (Uri)fileUri);
            if (TextUtils.isEmpty((CharSequence)mimeType)) {
                this.finish();
            } else {
                new ShareAsyncTask((Context)this, fileUri, contact, channel, mimeType).execute(new Void[0]);
            }
        } else {
            Intent intentImage = new Intent((Context)this, MobiComAttachmentSelectorActivity.class);
            intentImage.putExtra(contact != null ? MobiComAttachmentSelectorActivity.USER_ID : MobiComAttachmentSelectorActivity.GROUP_ID, (Serializable)(contact != null ? contact.getUserId() : channel.getKey()));
            intentImage.putExtra(contact != null ? MobiComAttachmentSelectorActivity.DISPLAY_NAME : MobiComAttachmentSelectorActivity.GROUP_NAME, contact != null ? contact.getDisplayName() : channel.getName());
            if (fileUri != null) {
                intentImage.putExtra("URI_LIST", (Parcelable)fileUri);
            }
            this.startActivity(intentImage);
        }
    }

    public void finishActivity(Intent intent) {
        String sharedText;
        String forwardMessage = this.getIntent().getStringExtra(FORWARD_MESSAGE);
        if (!TextUtils.isEmpty((CharSequence)forwardMessage)) {
            intent.putExtra(FORWARD_MESSAGE, forwardMessage);
        }
        if (!TextUtils.isEmpty((CharSequence)(sharedText = this.getIntent().getStringExtra(SHARED_TEXT)))) {
            intent.putExtra(SHARED_TEXT, sharedText);
        }
        this.setResult(-1, intent);
        this.finish();
    }

    public void onSelectionCleared() {
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == 16908332) {
            NavUtils.navigateUpFromSameTask((Activity)this);
            return true;
        }
        if (i == R.id.menu_search) {
            this.onSearchRequested();
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onSearchRequested() {
        return !this.isSearchResultView && super.onSearchRequested();
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public boolean onQueryTextSubmit(String query) {
        if (this.alCustomizationSettings.isCreateAnyContact()) {
            this.searchTerm = query;
            this.startNewConversation(query);
            isSearching = false;
        }
        if (this.alCustomizationSettings.isContactSearchFromServer()) {
            this.processSearchCall(query);
        }
        return false;
    }

    public boolean onQueryTextChange(String query) {
        this.searchTerm = query;
        if (this.getSearchListFragment() != null) {
            this.getSearchListFragment().onQueryTextChange(query);
            isSearching = true;
            if (query.isEmpty()) {
                isSearching = false;
            }
        }
        return true;
    }

    public void processSearchCall(String query) {
        final ProgressDialog dialog = new ProgressDialog((Context)this);
        dialog.setCancelable(false);
        dialog.setMessage((CharSequence)this.getResources().getString(R.string.applozic_contacts_loading_info));
        dialog.show();
        new AlUserSearchTask((Context)this, query, new AlUserSearchTask.AlUserSearchHandler(){

            public void onSuccess(List<Contact> contacts, Context context) {
                if (dialog != null) {
                    dialog.dismiss();
                }
                if (!contacts.isEmpty() && MobiComKitPeopleActivity.this.appContactFragment != null) {
                    MobiComKitPeopleActivity.this.appContactFragment.restartLoader();
                }
            }

            public void onFailure(Exception e, Context context) {
                if (dialog != null) {
                    dialog.dismiss();
                }
                Toast.makeText((Context)context, (int)R.string.applozic_server_error, (int)0).show();
            }
        }).execute((Object[])new Void[0]);
    }

    public SearchListFragment getSearchListFragment() {
        return this.searchListFragment;
    }

    public void setSearchListFragment(SearchListFragment searchListFragment) {
        this.searchListFragment = searchListFragment;
    }

    private void setupViewPager(ViewPager viewPager) {
        this.adapter = new ViewPagerAdapter(this.getSupportFragmentManager());
        this.adapter.addFrag((Fragment)this.appContactFragment, this.getString(R.string.Contact));
        this.adapter.addFrag((Fragment)this.channelFragment, this.getString(R.string.Group));
        viewPager.setAdapter((PagerAdapter)this.adapter);
    }

    public void onTabSelected(TabLayout.Tab tab) {
        this.viewPager.setCurrentItem(tab.getPosition(), true);
        switch (tab.getPosition()) {
            case 0: {
                this.setSearchListFragment((AppContactFragment)this.adapter.getItem(0));
                if (this.getSearchListFragment() == null) break;
                this.getSearchListFragment().onQueryTextChange(null);
                break;
            }
            case 1: {
                this.setSearchListFragment((ChannelFragment)this.adapter.getItem(1));
                if (this.getSearchListFragment() == null) break;
                this.getSearchListFragment().onQueryTextChange(null);
            }
        }
    }

    public void onTabUnselected(TabLayout.Tab tab) {
    }

    public void onTabReselected(TabLayout.Tab tab) {
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.onContactsInteractionListener != null) {
            this.onContactsInteractionListener = null;
        }
    }

    public class ChannelCreateAsyncTask
    extends AsyncTask<Void, Integer, Channel> {
        private ChannelService channelService;
        private ProgressDialog progressDialog;
        private Context context;
        Channel channel;
        String withUserId;
        AppContactService appContactService;
        String loggedInUserId;
        Contact withUserContact;
        Integer localParentGroupKey;

        public ChannelCreateAsyncTask(Integer parentGroupKey, Contact withUserContact, Context context) {
            this.context = context;
            this.channelService = ChannelService.getInstance((Context)context);
            this.withUserContact = withUserContact;
            this.localParentGroupKey = parentGroupKey;
            this.appContactService = new AppContactService(context);
            this.loggedInUserId = MobiComUserPreference.getInstance((Context)context).getUserId();
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.please_wait_creating_group_of_two), (boolean)true);
        }

        protected Channel doInBackground(Void ... params) {
            if (this.localParentGroupKey != null && this.localParentGroupKey != 0 && this.withUserContact != null) {
                ArrayList<String> userIdList = new ArrayList<String>();
                userIdList.add(this.withUserContact.getContactIds());
                int result = this.loggedInUserId.compareTo(this.withUserContact.getContactIds());
                StringBuffer stringBuffer = new StringBuffer();
                if (result == 0) {
                    stringBuffer.append(this.localParentGroupKey).append(":").append(this.loggedInUserId).append(":").append(this.withUserContact.getContactIds());
                } else if (result < 0) {
                    stringBuffer.append(this.localParentGroupKey).append(":").append(this.loggedInUserId).append(":").append(this.withUserContact.getContactIds());
                } else {
                    stringBuffer.append(this.localParentGroupKey).append(":").append(this.withUserContact.getContactIds()).append(":").append(this.loggedInUserId);
                }
                ChannelInfo channelInfo = new ChannelInfo(stringBuffer.toString(), userIdList);
                channelInfo.setClientGroupId(stringBuffer.toString());
                channelInfo.setType((int)Channel.GroupType.GROUPOFTWO.getValue().shortValue());
                channelInfo.setParentKey(this.localParentGroupKey);
                this.channel = this.channelService.createGroupOfTwo(channelInfo);
            }
            return this.channel;
        }

        protected void onPostExecute(Channel channel) {
            super.onPostExecute((Object)channel);
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (channel != null) {
                Intent intent = new Intent(this.context, ConversationActivity.class);
                intent.putExtra(MobiComKitPeopleActivity.GROUP_ID, (Serializable)channel.getKey());
                intent.putExtra(MobiComKitPeopleActivity.GROUP_NAME, channel.getName());
                MobiComKitPeopleActivity.this.startActivity(intent);
            }
        }
    }

    private class ShareAsyncTask
    extends AsyncTask<Void, Void, File> {
        WeakReference<Context> contextWeakReference;
        Uri uri;
        FileClientService fileClientService;
        Contact contact;
        Channel channel;
        String mimeType;

        public ShareAsyncTask(Context context, Uri uri, Contact contact, Channel channel, String mimType) {
            this.contextWeakReference = new WeakReference<Context>(context);
            this.uri = uri;
            this.contact = contact;
            this.channel = channel;
            this.mimeType = mimType;
            this.fileClientService = new FileClientService(context);
        }

        protected File doInBackground(Void ... voids) {
            Context context;
            if (this.contextWeakReference != null && (context = (Context)this.contextWeakReference.get()) != null && !TextUtils.isEmpty((CharSequence)this.mimeType)) {
                String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                String[] array2 = this.mimeType.split("/");
                String fileFormat = null;
                if (array2.length > 1) {
                    fileFormat = array2[1];
                }
                if (TextUtils.isEmpty(fileFormat)) {
                    return null;
                }
                String fileNameToWrite = timeStamp + "." + fileFormat;
                File mediaFile = FileClientService.getFilePath((String)fileNameToWrite, (Context)context, (String)this.mimeType);
                this.fileClientService.writeFile(this.uri, mediaFile);
                return mediaFile;
            }
            return null;
        }

        protected void onPostExecute(File file) {
            super.onPostExecute((Object)file);
            if (this.contextWeakReference != null) {
                Context context = (Context)this.contextWeakReference.get();
                if (file != null && file.exists() && context != null) {
                    Uri fileUri = Uri.parse((String)file.getAbsolutePath());
                    Intent sendAttachmentIntent = new Intent(context, MobiComAttachmentSelectorActivity.class);
                    if (this.channel != null) {
                        sendAttachmentIntent.putExtra(MobiComAttachmentSelectorActivity.GROUP_ID, (Serializable)this.channel.getKey());
                        sendAttachmentIntent.putExtra(MobiComAttachmentSelectorActivity.GROUP_NAME, this.channel.getName());
                    } else if (this.contact != null) {
                        sendAttachmentIntent.putExtra(MobiComAttachmentSelectorActivity.USER_ID, this.contact.getUserId());
                        sendAttachmentIntent.putExtra(MobiComAttachmentSelectorActivity.DISPLAY_NAME, this.contact.getDisplayName());
                    }
                    if (fileUri != null) {
                        sendAttachmentIntent.putExtra("URI_LIST", (Parcelable)fileUri);
                    }
                    context.startActivity(sendAttachmentIntent);
                }
            }
        }
    }

    class ViewPagerAdapter
    extends FragmentStatePagerAdapter {
        private final List<Fragment> fragmentList;
        private final List<String> titleList;

        public ViewPagerAdapter(FragmentManager manager) {
            super(manager);
            this.fragmentList = new ArrayList<Fragment>();
            this.titleList = new ArrayList<String>();
        }

        public Fragment getItem(int position) {
            return this.fragmentList.get(position);
        }

        public int getCount() {
            return this.fragmentList.size();
        }

        public void addFrag(Fragment fragment, String title) {
            this.fragmentList.add(fragment);
            this.titleList.add(title);
        }

        public CharSequence getPageTitle(int position) {
            return this.titleList.get(position);
        }
    }
}

