/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.fragment;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.applozic.mobicomkit.Applozic;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.listners.AlCallback;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationCallbackHandler;
import com.applozic.mobicomkit.uiwidgets.conversation.MultimediaOptionsGridView;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.MobicomMultimediaPopupAdapter;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MobiComConversationFragment;
import com.applozic.mobicommons.commons.core.utils.LocationUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.SearchListFragment;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConversationFragment
extends MobiComConversationFragment
implements SearchListFragment,
AlCallback {
    public static final int ATTCHMENT_OPTIONS = 6;
    private static final String TAG = "ConversationFragment";
    private static final String CONTACT = "CONTACT";
    private static final String CHANNEL = "CHANNEL";
    private static final String CONVERSATION_ID = "CONVERSATION_ID";
    private static final String SEARCH_STRING = "SEARCH_STRING";
    InputMethodManager inputMethodManager;
    Bundle bundle;
    private MultimediaOptionsGridView popupGrid;
    private List<String> attachmentKey = new ArrayList<String>();
    private List<String> attachmentText = new ArrayList<String>();
    private List<String> attachmentIcon = new ArrayList<String>();
    private ConversationCallbackHandler conversationCallbackHandler;

    public static ConversationFragment newInstance(Contact contact, Channel channel, Integer conversationId, String searchString) {
        ConversationFragment f = new ConversationFragment();
        Bundle args = new Bundle();
        if (contact != null) {
            args.putSerializable(CONTACT, (Serializable)contact);
        }
        if (channel != null) {
            args.putSerializable(CHANNEL, (Serializable)channel);
        }
        if (conversationId != null) {
            args.putInt(CONVERSATION_ID, conversationId.intValue());
        }
        args.putString(SEARCH_STRING, searchString);
        f.setArguments(args);
        return f;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.messageIntentClass = MessageIntentService.class;
        this.bundle = this.getArguments();
        if (this.bundle != null) {
            this.contact = (Contact)this.bundle.getSerializable(CONTACT);
            this.channel = (Channel)this.bundle.getSerializable(CHANNEL);
            this.currentConversationId = this.bundle.getInt(CONVERSATION_ID);
            this.searchString = this.bundle.getString(SEARCH_STRING);
            if (this.searchString != null) {
                SyncCallService.refreshView = true;
            }
        }
    }

    @Override
    public void attachLocation(Location mCurrentLocation) {
        String address = LocationUtils.getAddress((Context)this.getActivity(), (Location)mCurrentLocation);
        address = !TextUtils.isEmpty((CharSequence)address) ? "Address: " + address + "\n" : "";
        this.messageEditText.setText((CharSequence)(address + "http://maps.google.com/?q=" + mCurrentLocation.getLatitude() + "," + mCurrentLocation.getLongitude()));
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.title = this.getResources().getString(R.string.chats);
        this.conversationService = new MobiComConversationService((Context)this.getActivity());
        this.hideExtendedSendingOptionLayout = true;
        View view = super.onCreateView(inflater, container, savedInstanceState);
        this.populateAttachmentOptions();
        this.conversationCallbackHandler = new ConversationCallbackHandler(this.getContext(), this);
        if (this.alCustomizationSettings.isHideAttachmentButton()) {
            this.attachButton.setVisibility(8);
            this.messageEditText.setPadding(20, 0, 0, 0);
        }
        this.sendType.setSelection(1);
        this.messageEditText.setHint(R.string.enter_message_hint);
        this.multimediaPopupGrid.setVisibility(8);
        ArrayAdapter adapter = ArrayAdapter.createFromResource((Context)this.getActivity(), (int)R.array.secret_message_timer_array, (int)R.layout.mobiframework_custom_spinner);
        adapter.setDropDownViewResource(R.layout.mobiframework_custom_spinner);
        this.inputMethodManager = (InputMethodManager)this.getActivity().getSystemService("input_method");
        this.messageEditText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.multimediaPopupGrid.setVisibility(8);
            }
        });
        this.attachButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if ((ConversationFragment.this.contact != null && !ConversationFragment.this.contact.isBlocked() || ConversationFragment.this.channel != null) && ConversationFragment.this.attachmentLayout.getVisibility() == 0) {
                    Toast.makeText((Context)ConversationFragment.this.getActivity(), (int)R.string.select_file_count_limit, (int)1).show();
                    return;
                }
                if (ConversationFragment.this.channel != null) {
                    if (Channel.GroupType.GROUPOFTWO.getValue().equals(ConversationFragment.this.channel.getType())) {
                        String userId = ChannelService.getInstance((Context)ConversationFragment.this.getActivity()).getGroupOfTwoReceiverUserId(ConversationFragment.this.channel.getKey());
                        if (!TextUtils.isEmpty((CharSequence)userId)) {
                            Contact withUserContact = ConversationFragment.this.appContactService.getContactById(userId);
                            if (withUserContact.isBlocked()) {
                                ConversationFragment.this.userBlockDialog(false, withUserContact, true);
                            } else {
                                ConversationFragment.this.processAttachButtonClick(view);
                            }
                        }
                    } else {
                        ConversationFragment.this.processAttachButtonClick(view);
                    }
                } else if (ConversationFragment.this.contact != null) {
                    if (ConversationFragment.this.contact.isBlocked()) {
                        ConversationFragment.this.userBlockDialog(false, ConversationFragment.this.contact, false);
                    } else {
                        ConversationFragment.this.processAttachButtonClick(view);
                    }
                }
            }
        });
        return view;
    }

    @Override
    protected void processMobiTexterUserCheck() {
    }

    public void hideMultimediaOptionGrid() {
        if (this.multimediaPopupGrid.getVisibility() == 0) {
            this.multimediaPopupGrid.setVisibility(8);
        }
    }

    public boolean onQueryTextChange(String newText) {
        if (TextUtils.isEmpty((CharSequence)newText)) {
            this.recyclerDetailConversationAdapter.getFilter().filter(null);
        } else {
            this.recyclerDetailConversationAdapter.getFilter().filter((CharSequence)newText);
        }
        return true;
    }

    @Override
    public void onResume() {
        this.conversationCallbackHandler.registerUICallback();
        super.onResume();
    }

    @Override
    public void onPause() {
        this.conversationCallbackHandler.unregisterUICallbacks();
        super.onPause();
    }

    void processAttachButtonClick(View view) {
        MobicomMultimediaPopupAdapter mobicomMultimediaPopupAdapter = new MobicomMultimediaPopupAdapter((Context)this.getActivity(), this.attachmentIcon, this.attachmentText);
        mobicomMultimediaPopupAdapter.setAlCustomizationSettings(this.alCustomizationSettings);
        this.multimediaPopupGrid.setAdapter((ListAdapter)mobicomMultimediaPopupAdapter);
        int noOfColumn = this.attachmentKey.size() == 6 ? 3 : this.attachmentKey.size();
        this.multimediaPopupGrid.setNumColumns(noOfColumn);
        this.multimediaPopupGrid.setVisibility(0);
        if (this.inputMethodManager.isActive()) {
            this.inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        MultimediaOptionsGridView itemClickHandler = new MultimediaOptionsGridView(this.getActivity(), this.multimediaPopupGrid);
        itemClickHandler.setMultimediaClickListener(this.attachmentKey);
    }

    private void populateAttachmentOptions() {
        if (this.attachmentKey != null && this.attachmentKey.size() > 0) {
            this.attachmentKey.clear();
            this.attachmentText.clear();
            this.attachmentIcon.clear();
        }
        String[] allKeys = this.getResources().getStringArray(R.array.multimediaOptions_without_price_key);
        String[] allValues = this.getResources().getStringArray(R.array.multimediaOptions_without_price_text);
        String[] allIcons = this.getResources().getStringArray(R.array.multimediaOptionIcons_without_price);
        Map<String, Boolean> maps = ApplozicSetting.getInstance(this.getContext()).getAttachmentOptions();
        if (maps == null) {
            maps = this.alCustomizationSettings.getAttachmentOptions();
        }
        for (int index = 0; index < allKeys.length; ++index) {
            String key = allKeys[index];
            if (maps != null && maps.get(key) != null && !maps.get(key).booleanValue()) continue;
            this.attachmentKey.add(key);
            this.attachmentText.add(allValues[index]);
            this.attachmentIcon.add(allIcons[index]);
        }
    }

    public void reload() {
        try {
            Contact withUserContact;
            String userId;
            StringBuffer stringBufferTitle = new StringBuffer();
            if (this.contact != null) {
                Contact updatedInfoContact = this.appContactService.getContactById(this.contact.getContactIds());
                if (updatedInfoContact.isDeleted()) {
                    Utils.toggleSoftKeyBoard((Activity)this.getActivity(), (boolean)true);
                    this.bottomlayoutTextView.setText(R.string.user_has_been_deleted_text);
                    this.userNotAbleToChatLayout.setVisibility(0);
                    this.individualMessageSendLayout.setVisibility(8);
                    ((AppCompatActivity)this.getActivity()).getSupportActionBar().setSubtitle((CharSequence)"");
                }
                if (updatedInfoContact != null && !TextUtils.isEmpty((CharSequence)this.contact.getDisplayName()) && !this.contact.getDisplayName().equals(updatedInfoContact.getDisplayName())) {
                    stringBufferTitle.append(updatedInfoContact.getDisplayName());
                }
                this.enableOrDisableChat(updatedInfoContact);
            } else if (this.channel != null && Channel.GroupType.GROUPOFTWO.getValue().equals(this.channel.getType()) && !TextUtils.isEmpty((CharSequence)(userId = ChannelService.getInstance((Context)this.getActivity()).getGroupOfTwoReceiverUserId(this.channel.getKey()))) && (withUserContact = this.appContactService.getContactById(userId)) != null && !TextUtils.isEmpty((CharSequence)this.contact.getDisplayName()) && !this.contact.getDisplayName().equals(withUserContact.getDisplayName())) {
                stringBufferTitle.append(withUserContact.getDisplayName());
            }
            if (!TextUtils.isEmpty((CharSequence)stringBufferTitle)) {
                ((AppCompatActivity)this.getActivity()).getSupportActionBar().setTitle((CharSequence)stringBufferTitle.toString());
            }
            this.recyclerDetailConversationAdapter.refreshContactData();
            this.recyclerDetailConversationAdapter.notifyDataSetChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onSuccess(Object response) {
        ConversationCallbackHandler.CallbackEvent callbackEvent;
        if (response instanceof ConversationCallbackHandler.CallbackEvent && "EVENT_MQTT_CONNECTED".equals((callbackEvent = (ConversationCallbackHandler.CallbackEvent)((Object)response)).getAction())) {
            Applozic.subscribeToTyping((Context)this.getContext(), (Channel)this.channel, (Contact)this.contact);
        }
    }

    public void onError(Object error) {
        ConversationCallbackHandler.CallbackEvent callbackEvent;
        if (error instanceof ConversationCallbackHandler.CallbackEvent && "EVENT_MQTT_DISCONNECTED".equals((callbackEvent = (ConversationCallbackHandler.CallbackEvent)((Object)error)).getAction())) {
            Applozic.unSubscribeToTyping((Context)this.getContext(), (Channel)this.channel, (Contact)this.contact);
        }
    }
}

