/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.uikit;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.applozic.mobicomkit.api.conversation.ApplozicConversation;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.exception.ApplozicException;
import com.applozic.mobicomkit.listners.MessageListHandler;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.uikit.AlScrollListener;
import com.applozic.mobicomkit.uiwidgets.uikit.adapters.AlConversationAdapter;
import java.util.ArrayList;
import java.util.List;

public class AlConversationFragment
extends Fragment {
    RecyclerView recyclerView;
    List<Message> conversationList;
    AlConversationAdapter conversationAdapter;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.conversationList == null) {
            this.conversationList = new ArrayList<Message>();
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        inflater = (LayoutInflater)this.getContext().getApplicationContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.al_conversation_fragment, null);
        this.recyclerView = (RecyclerView)view.findViewById(R.id.conversationRecyclerView);
        this.conversationAdapter = new AlConversationAdapter((Context)this.getActivity(), this.conversationList);
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this.getActivity());
        layoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.conversationAdapter);
        ApplozicConversation.getLatestMessageList((Context)this.getContext(), null, (boolean)false, (MessageListHandler)new MessageListHandler(){

            public void onResult(List<Message> messageList, ApplozicException e) {
                AlConversationFragment.this.conversationList.addAll(messageList);
                AlConversationFragment.this.conversationAdapter.notifyDataSetChanged();
            }
        });
        this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new AlScrollListener(){

            @Override
            public void onScrollUp() {
            }

            @Override
            public void onScrollDown() {
            }

            @Override
            public void onLoadMore() {
                AlConversationFragment.this.conversationAdapter.showLoading(true);
                AlConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                ApplozicConversation.getLatestMessageList((Context)AlConversationFragment.this.getContext(), null, (boolean)true, (MessageListHandler)new MessageListHandler(){

                    public void onResult(List<Message> messageList, ApplozicException e) {
                        AlConversationFragment.this.conversationList.addAll(messageList);
                        AlConversationFragment.this.conversationAdapter.showLoading(false);
                        AlConversationFragment.this.conversationAdapter.notifyDataSetChanged();
                    }
                });
            }
        });
        return view;
    }

    public void addMessage(Message message) {
        ApplozicConversation.addLatestMessage((Message)message, this.conversationList);
        this.conversationAdapter.notifyDataSetChanged();
    }

    public void removeMessage(String userId, Integer groupId) {
        ApplozicConversation.removeLatestMessage((String)userId, (Integer)groupId, this.conversationList);
        this.conversationAdapter.notifyDataSetChanged();
    }

    public void notifyAdapter() {
        if (this.conversationAdapter != null) {
            this.conversationAdapter.notifyDataSetChanged();
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
    }
}

