/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.uikit.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import androidx.recyclerview.widget.RecyclerView;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.uiwidgets.R;
import java.util.List;

public abstract class AlFooterAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static int LOADER_VIEW = 1;
    public static int CONVERSATION_VIEW = 2;
    private boolean setLoading;
    protected List<Message> mItems;
    protected LayoutInflater mInflater;

    public AlFooterAdapter(Context context, List<Message> mItems) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mItems = mItems;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
        if (viewType == LOADER_VIEW) {
            View view = this.mInflater.inflate(R.layout.al_footer_view_layout, viewGroup, false);
            return new FooterViewHolder(view);
        }
        if (viewType == CONVERSATION_VIEW) {
            return this.getConversationViewHolder(viewGroup);
        }
        throw new IllegalArgumentException("Invalid ViewType: " + viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        if (viewHolder instanceof FooterViewHolder) {
            FooterViewHolder loaderViewHolder = (FooterViewHolder)viewHolder;
            loaderViewHolder.progressBar.setVisibility(this.setLoading ? 0 : 8);
            return;
        }
        this.bindConversationViewHolder(viewHolder, position);
    }

    public int getItemViewType(int position) {
        if (position != 0 && position == this.getItemCount() - 1) {
            return LOADER_VIEW;
        }
        return CONVERSATION_VIEW;
    }

    public int getItemCount() {
        if (this.mItems == null || this.mItems.size() == 0) {
            return 0;
        }
        return this.mItems.size() + 1;
    }

    public void showLoading(boolean status) {
        this.setLoading = status;
    }

    public abstract RecyclerView.ViewHolder getConversationViewHolder(ViewGroup var1);

    public abstract void bindConversationViewHolder(RecyclerView.ViewHolder var1, int var2);

    public class FooterViewHolder
    extends RecyclerView.ViewHolder {
        ProgressBar progressBar;

        public FooterViewHolder(View itemView) {
            super(itemView);
            this.progressBar = (ProgressBar)itemView.findViewById(R.id.loadingProgress);
        }
    }
}

