/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.uikit;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.location.LocationManager;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageBuilder;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComAttachmentSelectorActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobicomLocationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.AudioMessageFragment;
import com.applozic.mobicomkit.uiwidgets.instruction.ApplozicPermissions;
import com.applozic.mobicommons.commons.core.utils.LocationInfo;
import com.applozic.mobicommons.commons.core.utils.PermissionsUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.ALFileProvider;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.google.android.material.snackbar.Snackbar;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AlAttachmentOptions {
    public static final String GOOGLE_API_KEY_META_DATA = "com.google.android.geo.API_KEY";
    private static final String API_KYE_STRING = "YOUR_GEO_API_KEY";
    public static final int LOCATION_SERVICE_ENABLE = 1001;
    public static final int REQUEST_CODE_CONTACT_GROUP_SELECTION = 1011;
    public static final int RESULT_OK = -1;
    public static final int REQUEST_CODE_SEND_LOCATION = 10;
    public static final int REQUEST_CODE_TAKE_PHOTO = 11;
    public static final int REQUEST_CODE_ATTACH_PHOTO = 12;
    public static final int REQUEST_MULTI_ATTCAHMENT = 16;
    public static final int REQUEST_CODE_ATTACHE_AUDIO = 13;
    public static final int MEDIA_TYPE_VIDEO = 2;
    public static final int REQUEST_CODE_CAPTURE_VIDEO_ACTIVITY = 14;
    public static final int REQUEST_CODE_CONTACT_SHARE = 15;
    public static final String MULTISELECT_SELECTED_FILES = "multiselect.selectedFiles";
    public static final String MULTISELECT_MESSAGE = "multiselect.message";
    public static final String URI_LIST = "URI_LIST";
    private static Bundle bundle;

    public static void processCameraAction(Activity activity, LinearLayout layout2) {
        if (PermissionsUtils.isCameraPermissionGranted((Context)activity)) {
            AlAttachmentOptions.captureImage(activity);
        } else if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForCameraPermission((Activity)activity)) {
            new ApplozicPermissions(activity).requestCameraPermission();
        } else {
            AlAttachmentOptions.captureImage(activity);
        }
    }

    public static void processLocationAction(final Activity activity, LinearLayout layout2) {
        String geoApiKey = Utils.getMetaDataValue((Context)activity.getApplicationContext(), (String)GOOGLE_API_KEY_META_DATA);
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfPermissionForLocation((Activity)activity)) {
            new ApplozicPermissions(activity, layout2).requestLocationPermissions();
        } else if (!TextUtils.isEmpty((CharSequence)geoApiKey) && !API_KYE_STRING.equals(geoApiKey)) {
            Intent toMapActivity = new Intent((Context)activity, MobicomLocationActivity.class);
            activity.startActivityForResult(toMapActivity, 10);
        } else if (!((LocationManager)activity.getSystemService("location")).isProviderEnabled("gps")) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
            builder.setTitle(R.string.location_services_disabled_title).setMessage(R.string.location_services_disabled_message).setCancelable(false).setPositiveButton(R.string.location_service_settings, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                    activity.startActivityForResult(intent, 1001);
                }
            }).setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    dialog.cancel();
                    Toast.makeText((Context)activity, (int)R.string.location_sending_cancelled, (int)1).show();
                }
            });
            AlertDialog alert = builder.create();
            alert.show();
        }
    }

    public static void processVideoAction(Activity activity, LinearLayout layout2) {
        try {
            if (PermissionsUtils.isCameraPermissionGranted((Context)activity)) {
                AlAttachmentOptions.captureVideo(activity);
            } else if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForCameraPermission((Activity)activity)) {
                new ApplozicPermissions(activity).requestCameraPermission();
            } else {
                AlAttachmentOptions.captureVideo(activity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processAudioAction(AppCompatActivity activity, LinearLayout layout2) {
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfPermissionForAudioRecording((Activity)activity)) {
            new ApplozicPermissions((Activity)activity, layout2).requestAudio();
        } else if (PermissionsUtils.isAudioRecordingPermissionGranted((Context)activity)) {
            FragmentManager supportFragmentManager = activity.getSupportFragmentManager();
            AudioMessageFragment fragment = AudioMessageFragment.newInstance();
            FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction().add((Fragment)fragment, "AudioMessageFragment");
            fragmentTransaction.addToBackStack(null);
            fragmentTransaction.commitAllowingStateLoss();
        }
    }

    public static void processFileAction(Activity activity, LinearLayout layout2) {
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForStoragePermission((Activity)activity)) {
            new ApplozicPermissions(activity).requestStoragePermissions();
        } else {
            Intent intentPick = new Intent((Context)activity, MobiComAttachmentSelectorActivity.class);
            activity.startActivityForResult(intentPick, 16);
        }
    }

    public static void captureVideo(Activity activity) {
        try {
            Intent videoIntent = new Intent("android.media.action.VIDEO_CAPTURE");
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            String imageFileName = "VID_" + timeStamp + "_.mp4";
            File mediaFile = FileClientService.getFilePath((String)imageFileName, (Context)activity.getApplicationContext(), (String)"video/mp4");
            Uri videoFileUri = ALFileProvider.getUriForFile((Context)activity, (String)(Utils.getMetaDataValue((Context)activity, (String)"com.package.name") + ".applozic.provider"), (File)mediaFile);
            videoIntent.putExtra("output", (Parcelable)videoFileUri);
            if (Build.VERSION.SDK_INT >= 21) {
                videoIntent.addFlags(2);
                videoIntent.addFlags(1);
            } else if (Build.VERSION.SDK_INT >= 16) {
                ClipData clip = ClipData.newUri((ContentResolver)activity.getContentResolver(), (CharSequence)"a Video", (Uri)videoFileUri);
                videoIntent.setClipData(clip);
                videoIntent.addFlags(2);
                videoIntent.addFlags(1);
            } else {
                List resInfoList = activity.getPackageManager().queryIntentActivities(videoIntent, 65536);
                for (ResolveInfo resolveInfo : resInfoList) {
                    String packageName = resolveInfo.activityInfo.packageName;
                    activity.grantUriPermission(packageName, videoFileUri, 2);
                    activity.grantUriPermission(packageName, videoFileUri, 1);
                }
            }
            if (videoIntent.resolveActivity(activity.getApplicationContext().getPackageManager()) != null && mediaFile != null) {
                videoIntent.putExtra("android.intent.extra.videoQuality", 0);
                if (bundle != null) {
                    bundle = null;
                }
                bundle = new Bundle();
                bundle.putParcelable("videoUri", (Parcelable)videoFileUri);
                bundle.putString("videoPath", mediaFile.getAbsolutePath());
                activity.startActivityForResult(videoIntent, 14);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void captureImage(Activity activity) {
        try {
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            String imageFileName = "JPEG_" + timeStamp + "_.jpeg";
            File mediaFile = FileClientService.getFilePath((String)imageFileName, (Context)activity.getApplicationContext(), (String)"image/jpeg");
            Uri capturedImageUri = ALFileProvider.getUriForFile((Context)activity, (String)(Utils.getMetaDataValue((Context)activity, (String)"com.package.name") + ".applozic.provider"), (File)mediaFile);
            Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
            cameraIntent.putExtra("output", (Parcelable)capturedImageUri);
            if (Build.VERSION.SDK_INT >= 21) {
                cameraIntent.addFlags(2);
                cameraIntent.addFlags(1);
            } else if (Build.VERSION.SDK_INT >= 16) {
                ClipData clip = ClipData.newUri((ContentResolver)activity.getContentResolver(), (CharSequence)"a Photo", (Uri)capturedImageUri);
                cameraIntent.setClipData(clip);
                cameraIntent.addFlags(2);
                cameraIntent.addFlags(1);
            } else {
                List resInfoList = activity.getPackageManager().queryIntentActivities(cameraIntent, 65536);
                for (ResolveInfo resolveInfo : resInfoList) {
                    String packageName = resolveInfo.activityInfo.packageName;
                    activity.grantUriPermission(packageName, capturedImageUri, 2);
                    activity.grantUriPermission(packageName, capturedImageUri, 1);
                }
            }
            if (cameraIntent.resolveActivity(activity.getApplicationContext().getPackageManager()) != null && mediaFile != null) {
                if (bundle != null) {
                    bundle = null;
                }
                bundle = new Bundle();
                bundle.putParcelable("imageUri", (Parcelable)capturedImageUri);
                bundle.putString("imagePath", mediaFile.getAbsolutePath());
                activity.startActivityForResult(cameraIntent, 11);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void handleAttachmentOptionsResult(int requestCode, int resultCode, Intent intent, Activity activity, String userId, Integer groupId) {
        try {
            String selectedFilePath;
            MessageBuilder messageBuilder = new MessageBuilder((Context)activity);
            if (groupId == null && userId != null) {
                messageBuilder.setTo(userId);
            } else if (userId == null && groupId != null) {
                messageBuilder.setGroupId(groupId);
            }
            if ((requestCode == 12 || requestCode == 11) && resultCode == -1) {
                Uri selectedFileUri;
                Uri uri = selectedFileUri = intent == null ? null : intent.getData();
                if (selectedFileUri == null) {
                    selectedFileUri = (Uri)bundle.getParcelable("imageUri");
                    String selectedFilePath2 = bundle.getString("imagePath");
                    if (selectedFilePath2 != null) {
                        messageBuilder.setFilePath(bundle.getString("imagePath")).setContentType(Message.ContentType.ATTACHMENT.getValue().shortValue()).send();
                        bundle = null;
                    }
                }
                String absoluteFilePath = AlAttachmentOptions.getFilePath(selectedFileUri, (Context)activity);
                MediaScannerConnection.scanFile((Context)activity, (String[])new String[]{absoluteFilePath}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                    public void onScanCompleted(String path, Uri uri) {
                    }
                });
            }
            if (requestCode != 1011 || resultCode == -1) {
                // empty if block
            }
            if (requestCode == 14 && resultCode == -1 && (selectedFilePath = bundle.getString("videoPath")) != null) {
                messageBuilder.setFilePath(bundle.getString("videoPath")).setContentType(Message.ContentType.VIDEO_MSG.getValue().shortValue()).send();
                bundle = null;
            }
            if (requestCode == 16 && resultCode == -1) {
                ArrayList attachmentList = intent.getParcelableArrayListExtra(MULTISELECT_SELECTED_FILES);
                String messageText = intent.getStringExtra(MULTISELECT_MESSAGE);
                for (Uri info : attachmentList) {
                    messageBuilder.setFilePath(info.toString()).setMessage(messageText).setContentType(Message.ContentType.ATTACHMENT.getValue().shortValue()).send();
                }
            }
            if (requestCode == 10 && resultCode == -1) {
                Double latitude = intent.getDoubleExtra("latitude", 0.0);
                Double longitude = intent.getDoubleExtra("longitude", 0.0);
                LocationInfo info = new LocationInfo(latitude.doubleValue(), longitude.doubleValue());
                String locationInfo = GsonUtils.getJsonFromObject((Object)info, LocationInfo.class);
                messageBuilder.setMessage(locationInfo).setContentType(Message.ContentType.LOCATION.getValue().shortValue()).send();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults, LinearLayout snackbarLayout, Activity activity) {
        if (requestCode == 0) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.storage_permission_granted);
                AlAttachmentOptions.processFileAction(activity, snackbarLayout);
            } else {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.storage_permission_not_granted);
            }
        } else if (requestCode == 1) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.location_permission_granted);
                AlAttachmentOptions.processLocationAction(activity, snackbarLayout);
            } else {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.location_permission_not_granted);
            }
        } else if (requestCode == 2) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.phone_state_permission_granted);
            } else {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.phone_state_permission_not_granted);
            }
        } else if (requestCode == 4) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.phone_call_permission_granted);
            } else {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.phone_call_permission_not_granted);
            }
        } else if (requestCode == 3) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.record_audio_permission_granted);
                if (activity instanceof AppCompatActivity) {
                    AlAttachmentOptions.processAudioAction((AppCompatActivity)activity, snackbarLayout);
                }
            } else {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.record_audio_permission_not_granted);
            }
        } else if (requestCode == 5) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.phone_camera_permission_granted);
            } else {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.phone_camera_permission_not_granted);
            }
        } else if (requestCode == 7) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.phone_camera_permission_granted);
            } else {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.phone_camera_permission_not_granted);
            }
        } else if (requestCode == 8) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.storage_permission_granted);
            } else {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.storage_permission_not_granted);
            }
        } else if (requestCode == 9) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.phone_camera_and_audio_permission_granted);
            } else {
                AlAttachmentOptions.showSnackBar(snackbarLayout, R.string.audio_or_camera_permission_not_granted);
            }
        }
    }

    public static boolean isApplozicPermissionCode(int requestCode) {
        return requestCode >= 0 && requestCode <= 9;
    }

    public static void showSnackBar(LinearLayout layout2, int resId) {
        if (layout2 != null) {
            Snackbar.make((View)layout2, (int)resId, (int)-1).show();
        }
    }

    public static String getFilePath(Uri uri, Context context) {
        long maxFileSize;
        if (uri == null) {
            Toast.makeText((Context)context, (int)R.string.file_not_selected, (int)1).show();
            return null;
        }
        File file = FileUtils.getFile((Context)context, (Uri)uri);
        long fileSize = file.length() / 1024L;
        if (fileSize > (maxFileSize = 0x1900000L)) {
            Toast.makeText((Context)context, (int)R.string.info_attachment_max_allowed_file_size, (int)1).show();
            return null;
        }
        return Uri.parse((String)file.getAbsolutePath()).toString();
    }
}

