/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.uikit;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.widget.Toast;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.async.ApplozicChannelDeleteTask;
import com.applozic.mobicomkit.uiwidgets.async.ApplozicChannelLeaveMember;
import com.applozic.mobicomkit.uiwidgets.conversation.DeleteConversationAsyncTask;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUtils;
import com.applozic.mobicommons.people.contact.Contact;

public class AlUIService {
    private Context context;
    private BaseContactService contactService;

    public AlUIService(Context context) {
        this.context = context;
        this.contactService = new AppContactService(context);
    }

    public void deleteGroupConversation(final Channel channel) {
        if (!Utils.isInternetAvailable((Context)this.context)) {
            this.showToastMessage(this.context.getString(R.string.you_dont_have_any_network_access_info));
            return;
        }
        AlertDialog.Builder alertDialog = new AlertDialog.Builder(this.context).setPositiveButton(R.string.channel_deleting, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                final ProgressDialog progressDialog = ProgressDialog.show((Context)AlUIService.this.context, (CharSequence)"", (CharSequence)AlUIService.this.context.getString(R.string.deleting_channel_user), (boolean)true);
                ApplozicChannelDeleteTask.TaskListener channelDeleteTask = new ApplozicChannelDeleteTask.TaskListener(){

                    @Override
                    public void onSuccess(String response) {
                    }

                    @Override
                    public void onFailure(String response, Exception exception) {
                        AlUIService.this.showToastMessage(AlUIService.this.context.getString(Utils.isInternetAvailable((Context)AlUIService.this.context) ? R.string.applozic_server_error : R.string.you_dont_have_any_network_access_info));
                    }

                    @Override
                    public void onCompletion() {
                        if (progressDialog != null && progressDialog.isShowing()) {
                            progressDialog.dismiss();
                        }
                    }
                };
                ApplozicChannelDeleteTask applozicChannelDeleteTask = new ApplozicChannelDeleteTask(AlUIService.this.context, channelDeleteTask, channel);
                applozicChannelDeleteTask.execute(new Void[]{null});
            }
        });
        alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        alertDialog.setMessage((CharSequence)this.context.getString(R.string.delete_channel_messages_and_channel_info).replace(this.context.getString(R.string.group_name_info), channel.getName()).replace(this.context.getString(R.string.groupType_info), Channel.GroupType.BROADCAST.getValue().equals(channel.getType()) ? this.context.getString(R.string.broadcast_string) : this.context.getString(R.string.group_string)));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void deleteConversationThread(final Contact contact, final Channel channel) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder(this.context).setPositiveButton(R.string.delete_conversation, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new DeleteConversationAsyncTask(new MobiComConversationService(AlUIService.this.context), contact, channel, null, AlUIService.this.context).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        String name = "";
        if (channel != null) {
            if (Channel.GroupType.GROUPOFTWO.getValue().equals(channel.getType())) {
                String userId = ChannelService.getInstance((Context)this.context).getGroupOfTwoReceiverUserId(channel.getKey());
                if (!TextUtils.isEmpty((CharSequence)userId)) {
                    Contact withUserContact = this.contactService.getContactById(userId);
                    name = withUserContact.getDisplayName();
                }
            } else {
                name = ChannelUtils.getChannelTitleName((Channel)channel, (String)MobiComUserPreference.getInstance((Context)this.context).getUserId());
            }
        } else {
            name = contact.getDisplayName();
        }
        alertDialog.setTitle((CharSequence)this.context.getString(R.string.dialog_delete_conversation_title).replace("[name]", name));
        alertDialog.setMessage((CharSequence)this.context.getString(R.string.dialog_delete_conversation_confir).replace("[name]", name));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void channelLeaveProcess(final Channel channel) {
        if (!Utils.isInternetAvailable((Context)this.context)) {
            this.showToastMessage(this.context.getString(R.string.you_dont_have_any_network_access_info));
            return;
        }
        AlertDialog.Builder alertDialog = new AlertDialog.Builder(this.context).setPositiveButton(R.string.channel_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                ApplozicChannelLeaveMember.ChannelLeaveMemberListener applozicLeaveMemberListener = new ApplozicChannelLeaveMember.ChannelLeaveMemberListener(){

                    @Override
                    public void onSuccess(String response, Context context) {
                    }

                    @Override
                    public void onFailure(String response, Exception e, Context context) {
                        AlUIService.this.showToastMessage(context.getString(Utils.isInternetAvailable((Context)context) ? R.string.applozic_server_error : R.string.you_dont_have_any_network_access_info));
                    }
                };
                ApplozicChannelLeaveMember applozicChannelLeaveMember = new ApplozicChannelLeaveMember(AlUIService.this.context, channel.getKey(), MobiComUserPreference.getInstance((Context)AlUIService.this.context).getUserId(), applozicLeaveMemberListener);
                applozicChannelLeaveMember.setEnableProgressDialog(true);
                applozicChannelLeaveMember.execute(new Void[]{null});
            }
        });
        alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        alertDialog.setMessage((CharSequence)this.context.getString(R.string.exit_channel_message_info).replace(this.context.getString(R.string.group_name_info), channel.getName()).replace(this.context.getString(R.string.groupType_info), Channel.GroupType.BROADCAST.getValue().equals(channel.getType()) ? this.context.getString(R.string.broadcast_string) : this.context.getString(R.string.group_string)));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    private void showToastMessage(String messageToShow) {
        Toast toast = Toast.makeText((Context)this.context, (CharSequence)messageToShow, (int)0);
        toast.setGravity(17, 0, 0);
        toast.show();
    }
}

