/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.payment;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.payment.PaymentJsInterface;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentActivity
extends AppCompatActivity {
    WebView webView;
    Toolbar toolbar;
    private Map<String, String> txnData;
    private boolean isLinkType = false;
    private boolean isPaymentRequest = false;
    private ProgressBar loadingProgressBar;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.km_activity_payment);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(this.toolbar);
        this.webView = (WebView)this.findViewById(R.id.paymentWebView);
        this.loadingProgressBar = (ProgressBar)this.findViewById(R.id.loadingProgress);
        this.isLinkType = this.getIntent().getBooleanExtra("link", false);
        this.txnData = new HashMap<String, String>();
        this.setWebViewClient();
        if (this.isLinkType) {
            String linkUrl = this.getIntent().getStringExtra("linkUrl");
            if (!TextUtils.isEmpty((CharSequence)linkUrl)) {
                this.loadUrl(linkUrl.startsWith("http") ? linkUrl : "http://" + linkUrl);
            }
        } else {
            String formDataJson = this.getIntent().getStringExtra("formData");
            String baseUrl = this.getIntent().getStringExtra("formAction");
            if (formDataJson != null) {
                try {
                    JSONObject jsonObject = new JSONObject(formDataJson);
                    Iterator iter = jsonObject.keys();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        if (jsonObject.getString(key) == null) continue;
                        this.txnData.put(key, jsonObject.getString(key));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                this.isPaymentRequest = true;
                this.webViewClientPost(this.webView, baseUrl, this.txnData.entrySet());
            }
        }
    }

    public void webViewClientPost(WebView webView, String url, Collection<Map.Entry<String, String>> postData) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head></head>");
        sb.append("<body onload='form1.submit()'>");
        sb.append(String.format("<form id='form1' action='%s' method='%s'>", url, "post"));
        for (Map.Entry<String, String> item : postData) {
            sb.append(String.format("<input name='%s' type='hidden' value='%s' />", item.getKey(), item.getValue()));
        }
        sb.append("</form></body></html>");
        webView.loadData(sb.toString(), "text/html", "utf-8");
    }

    public void onBackPressed() {
        if (this.webView != null && this.webView.canGoBack()) {
            this.webView.goBack();
        } else {
            AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this);
            alertDialog.setTitle((CharSequence)this.getString(R.string.warning));
            alertDialog.setMessage((CharSequence)this.getString(this.isPaymentRequest ? R.string.cancel_transaction : R.string.go_back));
            alertDialog.setPositiveButton((CharSequence)this.getString(R.string.yes_alert), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PaymentActivity.this.finish();
                }
            });
            alertDialog.setNegativeButton((CharSequence)this.getString(R.string.no_alert), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            alertDialog.show();
        }
    }

    public void loadUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.webView.getSettings().setJavaScriptEnabled(true);
            this.webView.getSettings().setLoadWithOverviewMode(true);
            this.webView.getSettings().setUseWideViewPort(true);
            this.webView.setWebViewClient(new WebViewClient(){

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if (PaymentActivity.this.loadingProgressBar != null) {
                        PaymentActivity.this.loadingProgressBar.setVisibility(0);
                    }
                    view.loadUrl(url);
                    return true;
                }

                public void onPageFinished(WebView view, String url) {
                    PaymentActivity.this.webView.setVisibility(0);
                    if (PaymentActivity.this.loadingProgressBar != null) {
                        PaymentActivity.this.loadingProgressBar.setVisibility(8);
                    }
                }
            });
            this.webView.loadUrl(url);
        }
    }

    public void setWebViewClient() {
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (PaymentActivity.this.loadingProgressBar != null) {
                    PaymentActivity.this.loadingProgressBar.setVisibility(0);
                }
                return super.shouldOverrideUrlLoading(view, url);
            }

            public void onPageFinished(WebView view, String url) {
                PaymentActivity.this.webView.setVisibility(0);
                if (PaymentActivity.this.loadingProgressBar != null) {
                    PaymentActivity.this.loadingProgressBar.setVisibility(8);
                }
                if (!PaymentActivity.this.txnData.isEmpty() && PaymentActivity.this.txnData.containsKey("surl") && url.equals(PaymentActivity.this.txnData.get("surl"))) {
                    PaymentActivity.this.finish();
                } else if (!PaymentActivity.this.txnData.isEmpty() && PaymentActivity.this.txnData.containsKey("furl") && url.equals(PaymentActivity.this.txnData.get("furl"))) {
                    PaymentActivity.this.finish();
                }
                super.onPageFinished(view, url);
            }
        });
        this.webView.setVisibility(0);
        this.webView.getSettings().setBuiltInZoomControls(true);
        this.webView.getSettings().setCacheMode(2);
        this.webView.getSettings().setDomStorageEnabled(true);
        this.webView.clearHistory();
        this.webView.clearCache(true);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setSupportZoom(true);
        this.webView.getSettings().setUseWideViewPort(false);
        this.webView.getSettings().setLoadWithOverviewMode(false);
        this.webView.addJavascriptInterface((Object)new PaymentJsInterface((Context)this), "PaymentScreen");
    }
}

