/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.lists;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.ALRichMessageListener;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.ALRichMessageModel;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.AlRichMessage;
import com.bumptech.glide.Glide;
import java.util.List;
import java.util.Map;

public class AlRichListsAdapter
extends RecyclerView.Adapter {
    private Context context;
    private List<ALRichMessageModel.AlElementModel> elementList;
    private ALRichMessageListener messageListener;
    private Message message;
    private Map<String, Object> replyMetadata;

    public AlRichListsAdapter(Context context, Message message, List<ALRichMessageModel.AlElementModel> elementList, Map<String, Object> replyMetadata, ALRichMessageListener messageListener) {
        this.context = context;
        this.elementList = elementList;
        this.messageListener = messageListener;
        this.message = message;
        this.replyMetadata = replyMetadata;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.al_rich_list_item, parent, false);
        return new AlListItemViewHolder(itemView);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        this.bindView((AlListItemViewHolder)holder, this.elementList.get(position));
    }

    public void bindView(AlListItemViewHolder holder, ALRichMessageModel.AlElementModel element) {
        if (!TextUtils.isEmpty((CharSequence)element.getTitle())) {
            holder.headerTv.setVisibility(0);
            holder.headerTv.setText((CharSequence)AlRichMessage.getHtmlText(element.getTitle().trim()));
        } else {
            holder.headerTv.setVisibility(8);
        }
        if (element.getDescription() != null && !TextUtils.isEmpty((CharSequence)element.getDescription().trim())) {
            holder.detailsTv.setVisibility(0);
            holder.detailsTv.setText((CharSequence)AlRichMessage.getHtmlText(element.getDescription()));
        } else {
            holder.detailsTv.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)element.getImgSrc())) {
            holder.listImage.setVisibility(0);
            Glide.with((Context)this.context).load(element.getImgSrc()).into(holder.listImage);
        } else {
            holder.listImage.setVisibility(8);
        }
    }

    public int getItemCount() {
        return this.elementList != null ? this.elementList.size() : 0;
    }

    private class AlListItemViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private TextView headerTv;
        private TextView detailsTv;
        private RelativeLayout rootLayout;
        private ImageView listImage;

        public AlListItemViewHolder(View itemView) {
            super(itemView);
            this.headerTv = (TextView)itemView.findViewById(R.id.listItemHeaderText);
            this.detailsTv = (TextView)itemView.findViewById(R.id.listItemText);
            this.rootLayout = (RelativeLayout)itemView.findViewById(R.id.rootLayout);
            this.listImage = (ImageView)itemView.findViewById(R.id.listItemImage);
            this.rootLayout.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            int itemPosition = this.getLayoutPosition();
            if (itemPosition != -1 && AlRichListsAdapter.this.elementList != null && !AlRichListsAdapter.this.elementList.isEmpty()) {
                if (AlRichListsAdapter.this.context.getApplicationContext() instanceof ALRichMessageListener) {
                    ((ALRichMessageListener)AlRichListsAdapter.this.context.getApplicationContext()).onAction(AlRichListsAdapter.this.context, this.getAction((ALRichMessageModel.AlElementModel)((Object)AlRichListsAdapter.this.elementList.get(itemPosition))), AlRichListsAdapter.this.message, AlRichListsAdapter.this.elementList.get(itemPosition), this.getReplyMetadata((ALRichMessageModel.AlElementModel)((Object)AlRichListsAdapter.this.elementList.get(itemPosition))));
                } else if (AlRichListsAdapter.this.messageListener != null) {
                    AlRichListsAdapter.this.messageListener.onAction(AlRichListsAdapter.this.context, this.getAction((ALRichMessageModel.AlElementModel)((Object)AlRichListsAdapter.this.elementList.get(itemPosition))), AlRichListsAdapter.this.message, AlRichListsAdapter.this.elementList.get(itemPosition), this.getReplyMetadata((ALRichMessageModel.AlElementModel)((Object)AlRichListsAdapter.this.elementList.get(itemPosition))));
                }
            }
        }

        private Map<String, Object> getReplyMetadata(ALRichMessageModel.AlElementModel elementModel) {
            if (elementModel != null && elementModel.getAction() != null && elementModel.getAction().getPayload() != null && elementModel.getAction().getPayload().getReplyMetadata() != null) {
                return elementModel.getAction().getPayload().getReplyMetadata();
            }
            return AlRichListsAdapter.this.replyMetadata;
        }

        private String getAction(ALRichMessageModel.AlElementModel elementModel) {
            if (elementModel != null && elementModel.getAction() != null) {
                if (!TextUtils.isEmpty((CharSequence)elementModel.getAction().getType())) {
                    return elementModel.getAction().getType();
                }
                if (elementModel.getAction().getPayload() != null && !TextUtils.isEmpty((CharSequence)elementModel.getAction().getPayload().getType())) {
                    return elementModel.getAction().getPayload().getType();
                }
            }
            return "templateId_7";
        }
    }
}

