package com.applozic.mobicomkit.uiwidgets.conversation.richmessaging;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

public class KmCustomLayoutManager extends ViewGroup {

    private int line_height_space;

    public KmCustomLayoutManager(Context context) {
        super(context);
    }

    public KmCustomLayoutManager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public KmCustomLayoutManager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public KmCustomLayoutManager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public static class LayoutParams extends ViewGroup.LayoutParams {

        public int horizontal_spacing;
        public int vertical_spacing;

        public LayoutParams(int horizontal_spacing, int vertical_spacing) {
            super(0, 0);
            this.horizontal_spacing = horizontal_spacing;
            this.vertical_spacing = vertical_spacing;
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        final int width = MeasureSpec.getSize(widthMeasureSpec) - getPaddingLeft() - getPaddingRight();
        int height = MeasureSpec.getSize(heightMeasureSpec) - getPaddingTop() - getPaddingBottom();
        final int count = getChildCount();
        int line_height_space = 0;

        int xpos = getPaddingLeft();
        int ypos = getPaddingTop();

        int childHeightMeasureSpec;
        if (MeasureSpec.getMode(heightMeasureSpec) == MeasureSpec.AT_MOST) {
            childHeightMeasureSpec = MeasureSpec.makeMeasureSpec(height, MeasureSpec.AT_MOST);
        } else {
            childHeightMeasureSpec = MeasureSpec.makeMeasureSpec(0, MeasureSpec.UNSPECIFIED);
        }

        if (getContext().getResources().getConfiguration().getLayoutDirection() == LAYOUT_DIRECTION_RTL) {
            xpos = width - getPaddingStart();
            for (int i = 0; i < count; i++) {
                final View child = getChildAt(i);
                if (child.getVisibility() != GONE) {
                    final LayoutParams lp = (LayoutParams) child.getLayoutParams();
                    child.measure(MeasureSpec.makeMeasureSpec(width, MeasureSpec.AT_MOST), childHeightMeasureSpec);
                    final int childw = child.getMeasuredWidth();
                    line_height_space = Math.max(line_height_space, child.getMeasuredHeight() + lp.vertical_spacing);
                    if (childw > xpos) {
                        xpos = getPaddingRight();
                        ypos += line_height_space;
                    }
                    xpos = xpos - (childw + lp.horizontal_spacing);
                }
            }
        } else {
            for (int i = 0; i < count; i++) {

                final View child = getChildAt(i);

                if (child.getVisibility() != GONE) {
                    final LayoutParams lp = (LayoutParams) child.getLayoutParams();
                    child.measure(MeasureSpec.makeMeasureSpec(width, MeasureSpec.AT_MOST), childHeightMeasureSpec);
                    final int childw = child.getMeasuredWidth();
                    line_height_space = Math.max(line_height_space, child.getMeasuredHeight() + lp.vertical_spacing);
                    if (xpos + childw > width) {
                        xpos = getPaddingStart();
                        ypos += line_height_space;
                    }
                    xpos = xpos + (childw + lp.horizontal_spacing);
                }
            }
        }

        this.line_height_space = line_height_space;

        if (MeasureSpec.getMode(heightMeasureSpec) == MeasureSpec.UNSPECIFIED) {
            height = ypos + line_height_space;
        } else if (MeasureSpec.getMode(heightMeasureSpec) == MeasureSpec.AT_MOST) {
            if (ypos + line_height_space < height) {
                height = ypos + line_height_space;
            }
        }
        setMeasuredDimension(width, height);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(1, 1);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        if (p instanceof LayoutParams) {
            return true;
        }
        return false;
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        final int count = getChildCount();
        final int width = r - l;
        int xpos = getPaddingStart();
        int ypos = getPaddingTop();
        if (getContext().getResources().getConfiguration().getLayoutDirection() == LAYOUT_DIRECTION_RTL) {
            xpos = width - getPaddingStart();
            for (int i = 0; i < count; i++) {
                final View child = getChildAt(i);
                if (child.getVisibility() != GONE) {
                    final int childw = child.getMeasuredWidth();
                    final int childh = child.getMeasuredHeight();
                    final LayoutParams lp = (LayoutParams) child.getLayoutParams();
                    if (childw > xpos) {
                        //start
                        xpos = width;
                        ypos += line_height_space;
                    }
                    child.layout(xpos - childw, ypos, xpos, ypos + childh);
                    xpos -= childw - lp.horizontal_spacing;
                }
            }
        } else {
            for (int i = 0; i < count; i++) {
                final View child = getChildAt(i);
                if (child.getVisibility() != GONE) {
                    final int childw = child.getMeasuredWidth();
                    final int childh = child.getMeasuredHeight();
                    final LayoutParams lp = (LayoutParams) child.getLayoutParams();
                    if (xpos + childw > width) {
                        xpos = getPaddingStart();
                        ypos += line_height_space;
                    }
                    child.layout(xpos, ypos, xpos + childw, ypos + childh);
                    xpos += childw + lp.horizontal_spacing;
                }
            }
        }
    }
}