/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.attachmentview;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.attachmentview.ApplozicDocumentView;
import com.applozic.mobicommons.ApplozicService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ApplozicAudioManager
implements AudioManager.OnAudioFocusChangeListener {
    private static ApplozicAudioManager myObj;
    private static final int MAX_SIZE = 5;
    private ApplozicDocumentView currentView;
    private Map<String, MediaPlayer> pool = new HashMap<String, MediaPlayer>();
    private Context context;
    private AudioManager audioManager;
    private int minute;
    private int second;

    private ApplozicAudioManager(Context context) {
        this.context = ApplozicService.getContext((Context)context);
    }

    public static ApplozicAudioManager getInstance(Context context) {
        if (myObj == null) {
            myObj = new ApplozicAudioManager(ApplozicService.getContext((Context)context));
        }
        return myObj;
    }

    void play(final Uri uri, final ApplozicDocumentView view) {
        String key;
        MediaPlayer mp;
        this.audioManager = (AudioManager)this.context.getSystemService("audio");
        if (this.audioManager != null) {
            this.audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 1);
        }
        if ((mp = this.pool.get(key = view.message.getKeyString())) != null) {
            if (mp.isPlaying()) {
                mp.pause();
                return;
            }
            mp.seekTo(mp.getCurrentPosition());
            if (this.requestAudioFocus()) {
                mp.start();
            }
        } else {
            mp = new MediaPlayer();
            if (this.pool.size() >= 5) {
                Map.Entry<String, MediaPlayer> entry = this.pool.entrySet().iterator().next();
                String first = entry.getKey();
                this.pool.remove(first);
            }
            this.pool.put(key, mp);
        }
        this.pauseOthersifPlaying();
        mp.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                Toast.makeText((Context)ApplozicAudioManager.this.context, (CharSequence)ApplozicAudioManager.this.context.getString(R.string.unable_to_play_requested_audio_file), (int)1).show();
                return false;
            }
        });
        try {
            if (this.context != null) {
                mp.setDataSource(this.context, uri);
                if (this.requestAudioFocus()) {
                    mp.prepare();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mp.start();
        if (this.currentView != null) {
            this.currentView.setAudioIcons();
        }
        this.currentView = view;
        mp.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                mp.release();
                ApplozicAudioManager.this.pool.remove(key);
                ApplozicAudioManager.this.currentView.setAudioIcons();
                ApplozicAudioManager.this.updateAudioDuration(view.audio_duration_textView, uri.getPath());
            }
        });
        this.currentView.audioseekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onStopTrackingTouch(SeekBar seekBar) {
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                int duration = progress / 1000;
                int min = duration / 60;
                int seconds = duration % 60;
                if (view != null && view.audio_duration_textView != null) {
                    view.audio_duration_textView.setText((CharSequence)String.format("%02d:%02d", min, seconds));
                }
                if (fromUser && ApplozicAudioManager.this.getMediaPlayer(key) != null) {
                    ApplozicAudioManager.this.getMediaPlayer(key).seekTo(progress);
                }
            }
        });
    }

    public void pauseOthersifPlaying() {
        for (Map.Entry<String, MediaPlayer> pair : this.pool.entrySet()) {
            MediaPlayer m = pair.getValue();
            if (!m.isPlaying()) continue;
            m.pause();
        }
    }

    private void pauseIfPlaying() {
        for (Map.Entry<String, MediaPlayer> pair : this.pool.entrySet()) {
            MediaPlayer m = pair.getValue();
            if (!m.isPlaying()) continue;
            m.pause();
        }
    }

    int getAudioState(String key) {
        MediaPlayer mp = this.pool.get(key);
        if (mp != null) {
            if (mp.isPlaying()) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public MediaPlayer getMediaPlayer(String key) {
        if (key == null) {
            return null;
        }
        return this.pool.get(key);
    }

    public void audiostop() {
        if (this.pool != null) {
            for (Map.Entry<String, MediaPlayer> pair : this.pool.entrySet()) {
                MediaPlayer temp = pair.getValue();
                temp.stop();
                temp.release();
            }
            this.pool.clear();
        }
    }

    public String refreshAudioDuration(String filePath) {
        MediaPlayer mediaPlayer = new MediaPlayer();
        try {
            mediaPlayer.setDataSource(filePath);
            mediaPlayer.prepare();
            int duration = mediaPlayer.getDuration();
            this.minute = (duration /= 1000) / 60;
            this.second = duration % 60 + 1;
            mediaPlayer.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.format("%02d:%02d", this.minute, this.second);
    }

    public void updateAudioDuration(final TextView durationTextView, String filePath) {
        MediaPlayer mediaPlayer = new MediaPlayer();
        if (durationTextView == null || filePath == null) {
            return;
        }
        try {
            mediaPlayer.setDataSource(filePath);
            mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mediaPlayer) {
                    int currentProgress = mediaPlayer.getDuration() / 1000;
                    int minutes = currentProgress / 60;
                    int seconds = currentProgress % 60;
                    if (durationTextView != null) {
                        durationTextView.setText((CharSequence)String.format("%02d:%02d", minutes, seconds));
                    }
                    mediaPlayer.release();
                }
            });
            mediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onAudioFocusChange(int i) {
        switch (i) {
            case 1: {
                break;
            }
            case -3: {
                this.pauseIfPlaying();
                if (this.currentView == null) break;
                this.currentView.setAudioIcons();
                break;
            }
            case -1: {
                this.pauseIfPlaying();
                if (this.currentView == null) break;
                this.currentView.setAudioIcons();
                break;
            }
            case -2: {
                this.pauseIfPlaying();
                if (this.currentView == null) break;
                this.currentView.setAudioIcons();
            }
        }
    }

    private boolean requestAudioFocus() {
        int audioFocus = this.audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 1);
        boolean gotFocus = audioFocus == 1;
        return gotFocus;
    }
}

