/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.adapter;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.MobicomMessageTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MobicomMessageTemplateAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private MobicomMessageTemplate messageTemplate;
    private MessageTemplateDataListener listener;
    private List<String> messageList;
    private Map<String, String> messageMap;

    public MobicomMessageTemplateAdapter(MobicomMessageTemplate messageTemplate) {
        this.messageTemplate = messageTemplate;
        this.messageList = new ArrayList<String>(messageTemplate.getMessages().keySet());
        this.messageMap = messageTemplate.getMessages();
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.mobicom_message_template_item, parent, false);
        return new ViewHolder(itemView);
    }

    public void onBindViewHolder(ViewHolder holder, final int position) {
        holder.messageText.setText((CharSequence)this.messageList.get(position));
        holder.messageText.setTextColor(Color.parseColor((String)this.messageTemplate.getTextColor()));
        holder.messageText.setBackgroundDrawable((Drawable)this.getShape(holder.messageText.getContext()));
        holder.messageText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MobicomMessageTemplateAdapter.this.listener.onItemSelected((String)MobicomMessageTemplateAdapter.this.messageMap.get(MobicomMessageTemplateAdapter.this.messageList.get(position)));
            }
        });
    }

    public int getItemCount() {
        return this.messageList.size();
    }

    public void setMessageList(Map<String, String> messageList) {
        this.messageMap = messageList;
        this.messageList = new ArrayList<String>(messageList.keySet());
    }

    public GradientDrawable getShape(Context context) {
        GradientDrawable bgShape = new GradientDrawable();
        bgShape.setShape(0);
        bgShape.setColor(Color.parseColor((String)this.messageTemplate.getBackGroundColor()));
        bgShape.setCornerRadius((float)this.dpToPixels(context, this.messageTemplate.getCornerRadius()));
        bgShape.setStroke(this.dpToPixels(context, 2.0f), Color.parseColor((String)this.messageTemplate.getBorderColor()));
        return bgShape;
    }

    public int dpToPixels(Context context, float px) {
        return (int)TypedValue.applyDimension((int)1, (float)px, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public void setOnItemSelected(MessageTemplateDataListener listener) {
        this.listener = listener;
    }

    public static interface MessageTemplateDataListener {
        public void onItemSelected(String var1);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        public TextView messageText;

        public ViewHolder(View itemView) {
            super(itemView);
            this.messageText = (TextView)itemView.findViewById(R.id.messageTemplateTv);
        }
    }
}

