/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.notification;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.v4.app.JobIntentService;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.conversation.service.ConversationService;
import com.applozic.mobicomkit.api.notification.NotificationService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;

public class NotificationIntentService
extends JobIntentService {
    public static final String ACTION_AL_NOTIFICATION = "com.applozic.mobicomkit.api.notification.action.NOTIFICATION";
    AppContactService appContactService;
    MessageDatabaseService messageDatabaseService;
    static final int JOB_ID = 1011;

    public static void enqueueWork(Context context, Intent work) {
        NotificationIntentService.enqueueWork((Context)context, NotificationIntentService.class, (int)1011, (Intent)work);
    }

    public void onCreate() {
        super.onCreate();
        this.appContactService = new AppContactService((Context)this);
        this.messageDatabaseService = new MessageDatabaseService((Context)this);
    }

    protected void onHandleWork(@NonNull Intent intent) {
        String messageKey;
        Message message;
        String action;
        if (intent != null && ACTION_AL_NOTIFICATION.equals(action = intent.getAction()) && (message = this.messageDatabaseService.getMessage(messageKey = intent.getStringExtra("AL_MESSAGE_KEY"))) != null) {
            int notificationId = Utils.getLauncherIcon((Context)this.getApplicationContext());
            NotificationService notificationService = new NotificationService(notificationId == 0 ? R.drawable.mobicom_ic_launcher : notificationId, (Context)this, R.string.wearable_action_label, R.string.wearable_action_title, R.drawable.mobicom_ic_action_send);
            if (MobiComUserPreference.getInstance((Context)this).isLoggedIn()) {
                Channel channel = ChannelService.getInstance((Context)this).getChannelInfo(message.getGroupId());
                Contact contact = null;
                if (message.getConversationId() != null) {
                    ConversationService.getInstance((Context)this).getConversation(message.getConversationId());
                }
                if (message.getGroupId() == null) {
                    contact = this.appContactService.getContactById(message.getContactIds());
                }
                if (ApplozicClient.getInstance((Context)this).isNotificationStacking()) {
                    notificationService.notifyUser(contact, channel, message);
                } else {
                    notificationService.notifyUserForNormalMessage(contact, channel, message);
                }
            }
        }
    }
}

