/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.people.fragment;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.AlphabetIndexer;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.QuickContactBadge;
import android.widget.SectionIndexer;
import android.widget.TextView;
import androidx.cursoradapter.widget.CursorAdapter;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.ListFragment;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.CursorLoader;
import androidx.loader.content.Loader;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicomkit.uiwidgets.people.activity.MobiComKitPeopleActivity;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.people.OnContactsInteractionListener;
import com.applozic.mobicommons.people.SearchListFragment;
import com.applozic.mobicommons.people.contact.ContactUtils;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;

public class ContactsListFragment
extends ListFragment
implements SearchListFragment,
AdapterView.OnItemClickListener,
LoaderManager.LoaderCallbacks<Cursor> {
    private static final String TAG = "ContactsListFragment";
    private static final String STATE_PREVIOUSLY_SELECTED_KEY = "mck.mobiframework.contact.ui.SELECTED_ITEM";
    private ContactsAdapter mAdapter;
    private ImageLoader mImageLoader;
    private String mSearchTerm;
    private OnContactsInteractionListener mOnContactSelectedListener;
    private int mPreviouslySelectedSearchItem = 0;
    private Button contactButton;
    private TextView resultTextView;

    public boolean onQueryTextChange(String newText) {
        String newFilter;
        String string2 = newFilter = !TextUtils.isEmpty((CharSequence)newText) ? newText : null;
        if (this.mSearchTerm == null && newFilter == null) {
            return true;
        }
        if (this.mSearchTerm != null && this.mSearchTerm.equals(newFilter)) {
            return true;
        }
        this.mSearchTerm = newFilter;
        this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)this);
        return true;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAdapter = new ContactsAdapter((Context)this.getActivity());
        this.mSearchTerm = ((MobiComKitPeopleActivity)this.getActivity()).getSearchTerm();
        if (savedInstanceState != null) {
            this.mSearchTerm = savedInstanceState.getString("query");
            this.mPreviouslySelectedSearchItem = savedInstanceState.getInt(STATE_PREVIOUSLY_SELECTED_KEY, 0);
        }
        this.mImageLoader = new ImageLoader((Context)this.getActivity(), this.getListPreferredItemHeight()){

            protected Bitmap processBitmap(Object data) {
                return ContactUtils.loadContactPhoto((Uri)((Uri)data), (int)this.getImageSize(), (Activity)ContactsListFragment.this.getActivity());
            }
        };
        this.mImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
        this.mImageLoader.addImageCache(this.getActivity().getSupportFragmentManager(), 0.1f);
        InstructionUtil.showToast((Context)this.getActivity(), R.string.info_sample_contact_list, R.color.instruction_color);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.contact_list_fragment, container, false);
        this.resultTextView = (TextView)view.findViewById(R.id.result);
        this.contactButton = (Button)view.findViewById(R.id.actionButton);
        return view;
    }

    @SuppressLint(value={"NewApi"})
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.resultTextView.setText((CharSequence)this.getResources().getString(R.string.zero_friends_on_phone));
        this.contactButton.setText(R.string.menu_add_contact);
        this.contactButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ContactUtils.startContactAddActivity((FragmentActivity)ContactsListFragment.this.getActivity());
            }
        });
        this.setListAdapter((ListAdapter)this.mAdapter);
        this.getListView().setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.getListView().setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                if (scrollState == 2) {
                    ContactsListFragment.this.mImageLoader.setPauseWork(true);
                    Utils.toggleSoftKeyBoard((Activity)ContactsListFragment.this.getActivity(), (boolean)true);
                } else {
                    ContactsListFragment.this.mImageLoader.setPauseWork(false);
                }
            }

            public void onScroll(AbsListView absListView, int i, int i1, int i2) {
            }
        });
        if (this.mPreviouslySelectedSearchItem == 0) {
            this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mOnContactSelectedListener = (OnContactsInteractionListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement OnContactsInteractionListener");
        }
    }

    public void onPause() {
        super.onPause();
        this.mImageLoader.setPauseWork(false);
    }

    public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
        Cursor cursor = this.mAdapter.getCursor();
        cursor.moveToPosition(position);
        Uri uri = ContactsContract.Contacts.getLookupUri((long)cursor.getLong(0), (String)cursor.getString(1));
        this.mOnContactSelectedListener.onContactSelected(uri);
    }

    @SuppressLint(value={"NewApi"})
    private void onSelectionCleared() {
        this.mOnContactSelectedListener.onSelectionCleared();
        this.getListView().clearChoices();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (!TextUtils.isEmpty((CharSequence)this.mSearchTerm)) {
            outState.putString("query", this.mSearchTerm);
        }
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        if (id2 == 1) {
            Uri contentUri = this.mSearchTerm == null ? ContactsQuery.CONTENT_URI : Uri.withAppendedPath((Uri)ContactsQuery.FILTER_URI, (String)Uri.encode((String)this.mSearchTerm));
            return new CursorLoader((Context)this.getActivity(), contentUri, ContactsQuery.PROJECTION, ContactsQuery.SELECTION, null, ContactsQuery.SORT_ORDER);
        }
        Log.e((String)TAG, (String)("onCreateLoader - incorrect ID provided (" + id2 + ")"));
        return null;
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        if (loader.getId() == 1) {
            this.mAdapter.swapCursor(data);
        }
    }

    public void onLoaderReset(Loader<Cursor> loader) {
        if (loader.getId() == 1) {
            this.mAdapter.swapCursor(null);
        }
    }

    private int getListPreferredItemHeight() {
        TypedValue typedValue = new TypedValue();
        this.getActivity().getTheme().resolveAttribute(16842829, typedValue, true);
        DisplayMetrics metrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return (int)typedValue.getDimension(metrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap loadContactPhotoThumbnail(String photoData, int imageSize) {
        if (!this.isAdded() || this.getActivity() == null) {
            return null;
        }
        AssetFileDescriptor afd = null;
        try {
            Uri thumbUri;
            if (Utils.hasHoneycomb()) {
                thumbUri = Uri.parse((String)photoData);
            } else {
                Uri contactUri = Uri.withAppendedPath((Uri)ContactsContract.Contacts.CONTENT_URI, (String)photoData);
                thumbUri = Uri.withAppendedPath((Uri)contactUri, (String)"photo");
            }
            afd = this.getActivity().getContentResolver().openAssetFileDescriptor(thumbUri, "r");
            FileDescriptor fileDescriptor = afd.getFileDescriptor();
            if (fileDescriptor != null) {
                Bitmap bitmap = ImageLoader.decodeSampledBitmapFromDescriptor((FileDescriptor)fileDescriptor, (int)imageSize, (int)imageSize);
                return bitmap;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (afd != null) {
                try {
                    afd.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private class ContactsAdapter
    extends CursorAdapter
    implements SectionIndexer {
        private LayoutInflater mInflater;
        private AlphabetIndexer mAlphabetIndexer;
        private TextAppearanceSpan highlightTextSpan;

        public ContactsAdapter(Context context) {
            super(context, null, 0);
            this.mInflater = LayoutInflater.from((Context)context);
            String alphabet = context.getString(R.string.alphabet);
            this.mAlphabetIndexer = new AlphabetIndexer(null, 4, (CharSequence)alphabet);
            this.highlightTextSpan = new TextAppearanceSpan((Context)ContactsListFragment.this.getActivity(), R.style.searchTextHiglight);
        }

        private int indexOfSearchQuery(String displayName) {
            if (!TextUtils.isEmpty((CharSequence)ContactsListFragment.this.mSearchTerm)) {
                return displayName.toLowerCase(Locale.getDefault()).indexOf(ContactsListFragment.this.mSearchTerm.toLowerCase(Locale.getDefault()));
            }
            return -1;
        }

        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
            View itemLayout = this.mInflater.inflate(R.layout.contact_list_item, viewGroup, false);
            ViewHolder holder = new ViewHolder();
            holder.text1 = (TextView)itemLayout.findViewById(16908308);
            holder.text2 = (TextView)itemLayout.findViewById(16908309);
            holder.icon = (QuickContactBadge)itemLayout.findViewById(16908294);
            itemLayout.setTag((Object)holder);
            return itemLayout;
        }

        public void bindView(View view, Context context, Cursor cursor) {
            ViewHolder holder = (ViewHolder)view.getTag();
            String photoUri = cursor.getString(3);
            String displayName = cursor.getString(2);
            int startIndex = this.indexOfSearchQuery(displayName);
            if (startIndex == -1) {
                holder.text1.setText((CharSequence)displayName);
                if (TextUtils.isEmpty((CharSequence)ContactsListFragment.this.mSearchTerm)) {
                    holder.text2.setVisibility(8);
                } else {
                    holder.text2.setVisibility(0);
                }
            } else {
                SpannableString highlightedName = new SpannableString((CharSequence)displayName);
                highlightedName.setSpan((Object)this.highlightTextSpan, startIndex, startIndex + ContactsListFragment.this.mSearchTerm.length(), 0);
                holder.text1.setText((CharSequence)highlightedName);
                holder.text2.setVisibility(8);
            }
            Uri contactUri = Uri.withAppendedPath((Uri)ContactsContract.Contacts.CONTENT_URI, (String)String.valueOf(cursor.getLong(0)));
            holder.icon.assignContactUri(contactUri);
            ContactsListFragment.this.mImageLoader.loadImage((Object)contactUri, (ImageView)holder.icon);
        }

        public Cursor swapCursor(Cursor newCursor) {
            this.mAlphabetIndexer.setCursor(newCursor);
            return super.swapCursor(newCursor);
        }

        public int getCount() {
            if (this.getCursor() == null) {
                return 0;
            }
            return super.getCount();
        }

        public Object[] getSections() {
            return this.mAlphabetIndexer.getSections();
        }

        public int getPositionForSection(int i) {
            if (this.getCursor() == null) {
                return 0;
            }
            return this.mAlphabetIndexer.getPositionForSection(i);
        }

        public int getSectionForPosition(int i) {
            if (this.getCursor() == null) {
                return 0;
            }
            return this.mAlphabetIndexer.getSectionForPosition(i);
        }

        private class ViewHolder {
            TextView text1;
            TextView text2;
            QuickContactBadge icon;

            private ViewHolder() {
            }
        }
    }

    public static interface ContactsQuery {
        public static final int QUERY_ID = 1;
        public static final Uri CONTENT_URI = ContactsContract.Contacts.CONTENT_URI;
        public static final Uri FILTER_URI = ContactsContract.Contacts.CONTENT_FILTER_URI;
        @SuppressLint(value={"InlinedApi"})
        public static final String SELECTION = (Utils.hasHoneycomb() ? "display_name" : "display_name") + "<>'' AND " + "in_visible_group" + "=1";
        @SuppressLint(value={"InlinedApi"})
        public static final String SORT_ORDER = Utils.hasHoneycomb() ? "sort_key" : "display_name";
        @SuppressLint(value={"InlinedApi"})
        public static final String[] PROJECTION = new String[]{"_id", "lookup", Utils.hasHoneycomb() ? "display_name" : "display_name", Utils.hasHoneycomb() ? "photo_thumb_uri" : "_id", SORT_ORDER};
        public static final int ID = 0;
        public static final int LOOKUP_KEY = 1;
        public static final int DISPLAY_NAME = 2;
        public static final int PHOTO_THUMBNAIL_DATA = 3;
        public static final int SORT_KEY = 4;
    }
}

